/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.DisplayFormatters;

public class GlobalManagerStatsImpl
implements GlobalManagerStats {
    private long totalReceived;
    private long totalDiscarded;
    private long totalSent;
    private Average receptionSpeed = Average.getInstance(1000, 10);
    private Average sendingSpeed = Average.getInstance(1000, 5);

    protected GlobalManagerStatsImpl() {
    }

    public void discarded(int length) {
        this.totalDiscarded += (long)length;
    }

    public void received(int length) {
        this.totalReceived += (long)length;
        this.receptionSpeed.addValue(length);
    }

    public void sent(int length) {
        this.totalSent += (long)length;
        this.sendingSpeed.addValue(length);
    }

    public int getDownloadAverage() {
        return (int)this.receptionSpeed.getAverage();
    }

    public int getUploadAverage() {
        return (int)this.sendingSpeed.getAverage();
    }

    public String getTotalSent() {
        return DisplayFormatters.formatByteCountToKiBEtc(this.totalSent);
    }

    public String getTotalReceived() {
        return DisplayFormatters.formatByteCountToKiBEtc(this.totalReceived);
    }

    public String getTotalDiscarded() {
        return DisplayFormatters.formatByteCountToKiBEtc(this.totalDiscarded);
    }

    public long getTotalSentRaw() {
        return this.totalSent;
    }

    public long getTotalReceivedRaw() {
        return this.totalReceived;
    }

    public long getTotalDiscardedRaw() {
        return this.totalDiscarded;
    }
}

