/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;

public class ConfigurationChecker {
    private static boolean system_properties_set = false;
    private static boolean checked = false;
    private static AEMonitor class_mon = new AEMonitor("ConfigChecker");

    protected static void setSystemProperties() {
        try {
            class_mon.enter();
            if (system_properties_set) {
                class_mon.exit();
                return;
            }
            system_properties_set = true;
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            handlers = handlers == null ? "org.gudy.azureus2.core3.util.protocol" : String.valueOf(handlers) + "|org.gudy.azureus2.core3.util.protocol";
            System.setProperty("java.protocol.handler.pkgs", handlers);
            System.setProperty("sun.net.inetaddr.ttl", "60");
            System.setProperty("networkaddress.cache.ttl", "60");
            if (Constants.isOSX) {
                System.setProperty("java.nio.preferSelect", "true");
            }
            int connect_timeout = COConfigurationManager.getIntParameter("Tracker Client Connect Timeout");
            int read_timeout = COConfigurationManager.getIntParameter("Tracker Client Read Timeout");
            LGLogger.log("TrackerClient: connect timeout = " + connect_timeout + ", read timeout = " + read_timeout);
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(connect_timeout * 1000));
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(read_timeout * 1000));
            if (COConfigurationManager.getBooleanParameter("Enable.Proxy", false)) {
                String host = COConfigurationManager.getStringParameter("Proxy.Host");
                String port = COConfigurationManager.getStringParameter("Proxy.Port");
                String user = COConfigurationManager.getStringParameter("Proxy.Username");
                String pass = COConfigurationManager.getStringParameter("Proxy.Password");
                if (COConfigurationManager.getBooleanParameter("Enable.SOCKS", false)) {
                    System.setProperty("socksProxyHost", host);
                    System.setProperty("socksProxyPort", port);
                    if (user.length() > 0) {
                        System.setProperty("java.net.socks.username", user);
                        System.setProperty("java.net.socks.password", pass);
                    }
                } else {
                    System.setProperty("http.proxyHost", host);
                    System.setProperty("http.proxyPort", port);
                    System.setProperty("https.proxyHost", host);
                    System.setProperty("https.proxyPort", port);
                    if (user.length() > 0) {
                        System.setProperty("http.proxyUser", user);
                        System.setProperty("http.proxyPassword", pass);
                    }
                }
            }
            SESecurityManager.initialise();
        }
        finally {
            class_mon.exit();
        }
    }

    public static void checkConfiguration() {
        try {
            String uniqueId;
            int iDLMin;
            int iSeedingMin;
            int minQueueingShareRatio;
            int peersRatio;
            String this_version;
            class_mon.enter();
            if (checked) {
                class_mon.exit();
                return;
            }
            checked = true;
            boolean changed = false;
            String last_version = COConfigurationManager.getStringParameter("azureus.version", "");
            if (!last_version.equals(this_version = "2.2.0.2")) {
                COConfigurationManager.setParameter("azureus.version", this_version);
                changed = true;
            }
            if (last_version.length() == 0) {
                if (COConfigurationManager.doesParameterNonDefaultExist("diagnostics.tidy_close")) {
                    if (!COConfigurationManager.doesParameterNonDefaultExist("Use default data dir")) {
                        COConfigurationManager.setParameter("Use default data dir", true);
                        changed = true;
                    }
                    if (!COConfigurationManager.doesParameterNonDefaultExist("Tracker Port Enable")) {
                        COConfigurationManager.setParameter("Tracker Port Enable", true);
                        changed = true;
                    }
                }
                if (COConfigurationManager.getBooleanParameter("Use default data dir") && !COConfigurationManager.doesParameterNonDefaultExist("Default save path")) {
                    COConfigurationManager.setParameter("Default save path", String.valueOf(SystemProperties.getUserPath()) + "downloads");
                    changed = true;
                }
            }
            if (!COConfigurationManager.doesParameterDefaultExist("Tracker Key Enable Client")) {
                boolean old_value = COConfigurationManager.getBooleanParameter("Tracker Key Enable");
                COConfigurationManager.setParameter("Tracker Key Enable Client", old_value);
                COConfigurationManager.setParameter("Tracker Key Enable Server", old_value);
                changed = true;
            }
            int maxUpSpeed = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0);
            int maxDownSpeed = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0);
            if (maxUpSpeed > 0 && maxUpSpeed < 5 && (maxDownSpeed == 0 || maxDownSpeed > 2 * maxUpSpeed)) {
                changed = true;
                COConfigurationManager.setParameter("Max Upload Speed KBs", 5);
            }
            if ((peersRatio = COConfigurationManager.getIntParameter("Stop Peers Ratio", 0)) > 14) {
                COConfigurationManager.setParameter("Stop Peers Ratio", 14);
                changed = true;
            }
            if ((minQueueingShareRatio = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ShareRatio")) < 500) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_ShareRatio", 500);
                changed = true;
            }
            if ((iSeedingMin = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_SeedingMinutes")) < 90 && iSeedingMin != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_SeedingMinutes", 90);
                changed = true;
            }
            if ((iDLMin = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_DLMinutes")) < 180 && iDLMin != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_DLMinutes", 180);
                changed = true;
            }
            if ((uniqueId = COConfigurationManager.getStringParameter("ID", null)) == null || uniqueId.length() != 20) {
                uniqueId = ConfigurationChecker.generatePeerId();
                COConfigurationManager.setParameter("ID", uniqueId);
                changed = true;
            }
            if (Constants.isOSX) {
                boolean sound = COConfigurationManager.getBooleanParameter("Play Download Finished", true);
                boolean close = COConfigurationManager.getBooleanParameter("Close To Tray", true);
                boolean min = COConfigurationManager.getBooleanParameter("Minimize To Tray", true);
                boolean confirmExit = COConfigurationManager.getBooleanParameter("confirmationOnExit", false);
                if (sound || close || min || confirmExit) {
                    COConfigurationManager.setParameter("Play Download Finished", false);
                    COConfigurationManager.setParameter("Close To Tray", false);
                    COConfigurationManager.setParameter("Minimize To Tray", false);
                    COConfigurationManager.setParameter("confirmationOnExit", false);
                    changed = true;
                }
            }
            String[] path_params = new String[]{"Default save path", "General_sDefaultTorrent_Directory", "Watch Torrent Folder Path", "Completed Files Directory"};
            int i = 0;
            while (i < path_params.length) {
                if (path_params[i].endsWith(SystemProperties.SEP)) {
                    String new_path = path_params[i].substring(0, path_params[i].length() - 1);
                    COConfigurationManager.setParameter(path_params[i], new_path);
                    changed = true;
                }
                ++i;
            }
            if (ConfigurationManager.getInstance().doesParameterNonDefaultExist("General_bEnableLanguageUpdate")) {
                File user_dir = new File(SystemProperties.getUserPath());
                File[] files = user_dir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith("MessagesBundle") && name.endsWith(".properties");
                    }
                });
                int i2 = 0;
                while (i2 < files.length) {
                    File file = files[i2];
                    if (file.exists()) {
                        LGLogger.log("ConfigurationChecker:: removing old language file: " + file.getAbsolutePath());
                        file.renameTo(new File(file.getParentFile(), "delme" + file.getName()));
                    }
                    ++i2;
                }
                ConfigurationManager.getInstance().removeParameter("General_bEnableLanguageUpdate");
                changed = true;
            }
            if (changed) {
                COConfigurationManager.save();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static String generatePeerId() {
        String uniqueId = "";
        long currentTime = SystemTime.getCurrentTime();
        int i = 0;
        while ((long)i < currentTime % 1000L) {
            Math.random();
            ++i;
        }
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        int i2 = 0;
        while (i2 < 20) {
            int pos = (int)(Math.random() * (double)chars.length());
            uniqueId = String.valueOf(uniqueId) + chars.charAt(pos);
            ++i2;
        }
        return uniqueId;
    }

    public static void main(String[] args) {
        Integer obj = new Integer(1);
        HashMap<String, Integer> test = new HashMap<String, Integer>();
        int collisions = 0;
        int i = 0;
        while (i < 1000000) {
            String id = ConfigurationChecker.generatePeerId();
            if (test.containsKey(id)) {
                ++collisions;
            } else {
                test.put(id, obj);
            }
            if (i % 1000 == 0) {
                System.out.println(String.valueOf(i) + " : " + id + " : " + collisions);
            }
            ++i;
        }
        System.out.println("\n" + collisions);
    }
}

