/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.ssdp;

import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.impl.SSDP;
import com.aelitis.net.upnp.impl.SSDPListener;
import com.aelitis.net.upnp.impl.UPnPImpl;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class SSDPImpl
implements SSDP {
    protected static final String SSDP_GROUP_ADDRESS = "239.255.255.250";
    protected static final int SSDP_GROUP_PORT = 1900;
    protected static final int SSDP_CONTROL_PORT = 8008;
    protected static final int TTL = 4;
    protected static final int PACKET_SIZE = 8192;
    protected static final String HTTP_VERSION = "1.1";
    protected static final String NL = "\r\n";
    protected static InetSocketAddress group_address;
    protected UPnPImpl upnp;
    protected long last_explicit_search = 0L;
    protected List mc_network_interfaces = new ArrayList();
    protected List mc_socks = new ArrayList();
    protected boolean first_response = true;
    protected boolean ttl_problem_reported = false;
    protected List listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("SSDP");

    static {
        try {
            group_address = new InetSocketAddress(InetAddress.getByName(SSDP_GROUP_ADDRESS), 0);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public SSDPImpl(UPnPImpl _upnp) throws UPnPException {
        this.upnp = _upnp;
    }

    public void start() throws UPnPException {
        try {
            Enumeration<NetworkInterface> network_interfaces = NetworkInterface.getNetworkInterfaces();
            while (network_interfaces.hasMoreElements()) {
                final NetworkInterface network_interface = network_interfaces.nextElement();
                Enumeration<InetAddress> ni_addresses = network_interface.getInetAddresses();
                while (ni_addresses.hasMoreElements()) {
                    final InetAddress ni_address = ni_addresses.nextElement();
                    if (ni_address.isLoopbackAddress()) {
                        this.upnp.log("UPnP::SSDP: ignoring loopback address " + ni_address);
                        continue;
                    }
                    if (ni_address instanceof Inet6Address) {
                        this.upnp.log("UPnP::SSDP: ignoring IPv6 address " + ni_address);
                        continue;
                    }
                    if (!this.mc_network_interfaces.contains(network_interface)) {
                        this.mc_network_interfaces.add(network_interface);
                        try {
                            MulticastSocket mc_sock;
                            block14: {
                                mc_sock = new MulticastSocket(1900);
                                this.mc_socks.add(mc_sock);
                                mc_sock.setReuseAddress(true);
                                try {
                                    mc_sock.setTimeToLive(4);
                                }
                                catch (Throwable e) {
                                    if (this.ttl_problem_reported) break block14;
                                    this.ttl_problem_reported = true;
                                    Debug.printStackTrace(e);
                                }
                            }
                            String addresses_string = "";
                            Enumeration<InetAddress> it = network_interface.getInetAddresses();
                            while (it.hasMoreElements()) {
                                InetAddress addr = it.nextElement();
                                addresses_string = String.valueOf(addresses_string) + (addresses_string.length() == 0 ? "" : ",") + addr;
                            }
                            this.upnp.log("UPnP::SSDP: group = " + group_address + "/" + network_interface.getName() + ":" + network_interface.getDisplayName() + "-" + addresses_string);
                            mc_sock.joinGroup(group_address, network_interface);
                            mc_sock.setNetworkInterface(network_interface);
                            mc_sock.setLoopbackMode(true);
                            Runtime.getRuntime().addShutdownHook(new AEThread("SSDP:VMShutdown"){

                                public void runSupport() {
                                    try {
                                        mc_sock.leaveGroup(group_address, network_interface);
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                            });
                            AEThread group_thread = new AEThread("SSDP: MC listener"){

                                public void runSupport() {
                                    SSDPImpl.this.handleSocket(ni_address, mc_sock);
                                }
                            };
                            group_thread.setDaemon(true);
                            group_thread.start();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        final DatagramSocket control_socket = new DatagramSocket(null);
                        control_socket.setReuseAddress(true);
                        control_socket.bind(new InetSocketAddress(ni_address, 8008));
                        this.upnp.getPluginInterface().getUtilities().createThread("SSDP:listener", new AERunnable(){

                            public void runSupport() {
                                SSDPImpl.this.handleSocket(ni_address, control_socket);
                            }
                        });
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            this.upnp.getPluginInterface().getUtilities().createThread("SSDP:queryLoop", new AERunnable(){

                public void runSupport() {
                    SSDPImpl.this.queryLoop();
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new UPnPException("Failed to initialise SSDP", e);
        }
    }

    public void searchNow() {
        long now = SystemTime.getCurrentTime();
        if (now - this.last_explicit_search < 10000L) {
            return;
        }
        this.last_explicit_search = now;
        this.search();
    }

    protected void queryLoop() {
        while (true) {
            try {
                this.search();
                Thread.sleep(60000L);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    protected void search() {
        String str = "M-SEARCH * HTTP/1.1\r\nST: upnp:rootdevice\r\nMX: 3\r\nMAN: \"ssdp:discover\"\r\nHOST: 239.255.255.250:1900\r\n\r\n";
        byte[] data = str.getBytes();
        int i = 0;
        while (i < this.mc_network_interfaces.size()) {
            NetworkInterface network_interface = (NetworkInterface)this.mc_network_interfaces.get(i);
            try {
                MulticastSocket mc_sock;
                block5: {
                    mc_sock = new MulticastSocket(null);
                    mc_sock.setReuseAddress(true);
                    try {
                        mc_sock.setTimeToLive(4);
                    }
                    catch (Throwable e) {
                        if (this.ttl_problem_reported) break block5;
                        this.ttl_problem_reported = true;
                        Debug.printStackTrace(e);
                    }
                }
                mc_sock.bind(new InetSocketAddress(8008));
                mc_sock.setNetworkInterface(network_interface);
                DatagramPacket packet = new DatagramPacket(data, data.length, group_address.getAddress(), 1900);
                mc_sock.send(packet);
                mc_sock.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleSocket(InetAddress local_address, DatagramSocket socket) {
        long successful_accepts = 0L;
        long failed_accepts = 0L;
        int port = socket.getLocalPort();
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[8192];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    socket.receive(packet);
                    ++successful_accepts;
                    this.receivePacket(local_address, packet);
                }
            }
            catch (Throwable e) {
                LGLogger.log("SSDP: receive failed on port " + port, e);
                if (++failed_accepts <= 100L || successful_accepts != 0L) continue;
                LGLogger.logUnrepeatableAlertUsingResource(3, "Network.alert.acceptfail", new String[]{"" + port, "UDP"});
                return;
            }
            break;
        }
    }

    protected void receivePacket(InetAddress local_address, DatagramPacket packet) {
        try {
            int p1;
            this.this_mon.enter();
            String str = new String(packet.getData(), 0, packet.getLength());
            if (this.first_response) {
                this.first_response = false;
                this.upnp.log("UPnP:SSDP: first response:\n" + str);
            }
            if (str.startsWith("M-SEARCH")) {
                this.this_mon.exit();
                return;
            }
            ArrayList<String> lines = new ArrayList<String>();
            int pos = 0;
            do {
                String line;
                if ((p1 = str.indexOf(NL, pos)) == -1) {
                    line = str.substring(pos);
                } else {
                    line = str.substring(pos, p1);
                    pos = p1 + 1;
                }
                lines.add(line.trim());
            } while (p1 != -1);
            if (lines.size() == 0) {
                this.upnp.log("SSDP::receive packet - 0 line reply");
                this.this_mon.exit();
                return;
            }
            String header = (String)lines.get(0);
            URL location = null;
            String nt = null;
            String nts = null;
            int i = 1;
            while (i < lines.size()) {
                String line = (String)lines.get(i);
                int c_pos = line.indexOf(":");
                if (c_pos != -1) {
                    String key = line.substring(0, c_pos).trim();
                    String val = line.substring(c_pos + 1).trim();
                    if (key.equalsIgnoreCase("LOCATION")) {
                        try {
                            location = new URL(val);
                        }
                        catch (MalformedURLException e) {
                            this.upnp.log(e);
                        }
                    } else if (key.equalsIgnoreCase("NT")) {
                        nt = val;
                    } else if (key.equalsIgnoreCase("NTS")) {
                        nts = val;
                    }
                }
                ++i;
            }
            if (header.startsWith("NOTIFY")) {
                if (location != null && nt != null && nts != null && nt.indexOf("upnp:rootdevice") != -1) {
                    if (nts.indexOf("alive") != -1) {
                        this.gotAlive(location);
                    } else if (nts.indexOf("byebye") != -1) {
                        this.lostRoot(local_address, location);
                    }
                }
            } else if (header.startsWith("HTTP") && header.indexOf("200") != -1) {
                if (location != null) {
                    this.gotRoot(local_address, location);
                }
            } else {
                this.upnp.log("UPnP::SSDP::receive packet - bad header:" + header);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void gotRoot(InetAddress local_address, URL location) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SSDPListener)this.listeners.get(i)).rootDiscovered(local_address, location);
            ++i;
        }
    }

    protected void gotAlive(URL location) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SSDPListener)this.listeners.get(i)).rootAlive(location);
            ++i;
        }
    }

    protected void lostRoot(InetAddress local_address, URL location) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SSDPListener)this.listeners.get(i)).rootLost(local_address, location);
            ++i;
        }
    }

    public void addListener(SSDPListener l) {
        this.listeners.add(l);
    }

    public void removeListener(SSDPListener l) {
        this.listeners.remove(l);
    }
}

