/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import java.io.File;
import org.gudy.azureus2.core3.logging.ILoggerListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class Test {
    public static void main(String[] args) {
        System.setProperty("azureus.log.stdout", "1");
        LGLogger.initialise();
        LGLogger.setListener(new ILoggerListener(){

            public void log(int componentId, int event, int color, String text) {
                System.out.println(text);
            }
        });
        try {
            CacheFileManagerImpl manager = (CacheFileManagerImpl)CacheFileManagerFactory.getSingleton();
            manager.initialise(true, true, true, 0xA00000L, 1024L);
            new Test().writeTest(manager);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void writeTest(CacheFileManagerImpl manager) {
        try {
            final File f = new File("C:\\temp\\cachetest.dat");
            f.delete();
            CacheFile cf = manager.createFile(new CacheFileOwner(){

                public String getCacheFileOwnerName() {
                    return "file " + f.toString();
                }

                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }
            }, f);
            cf.setAccessMode(2);
            long start = System.currentTimeMillis();
            int loop = 10000;
            int block = 1024;
            int i = 0;
            while (i < loop) {
                DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)2, block);
                cf.writeAndHandoverBuffer(buffer, i * block);
                ++i;
            }
            cf.close();
            long now = System.currentTimeMillis();
            long total = loop * block;
            long elapsed = now - start;
            System.out.println("time = " + elapsed + ", speed = " + total / elapsed);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void manualTest(CacheFileManager manager) {
        try {
            final File f = new File("C:\\temp\\cachetest.dat");
            f.delete();
            CacheFile cf = manager.createFile(new CacheFileOwner(){

                public String getCacheFileOwnerName() {
                    return "file " + f.toString();
                }

                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }
            }, f);
            DirectByteBuffer write_buffer1 = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer write_buffer2 = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer write_buffer3 = DirectByteBufferPool.getBuffer((byte)2, 512);
            cf.writeAndHandoverBuffer(write_buffer2, 512L);
            cf.flushCache();
            cf.writeAndHandoverBuffer(write_buffer3, 1024L);
            cf.writeAndHandoverBuffer(write_buffer1, 0L);
            cf.flushCache();
            write_buffer1 = DirectByteBufferPool.getBuffer((byte)2, 512);
            cf.writeAndHandoverBuffer(write_buffer1, 0L);
            cf.flushCache();
            cf.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void randomTest(CacheFileManager manager) {
        try {
            CacheFile[] files = new CacheFile[3];
            byte[][] file_data = new byte[3][];
            int i = 0;
            while (i < files.length) {
                final int f_i = i;
                file_data[i] = new byte[Test.randomInt(200000)];
                files[i] = manager.createFile(new CacheFileOwner(){

                    public String getCacheFileOwnerName() {
                        return "file" + f_i;
                    }

                    public TOTorrentFile getCacheFileTorrentFile() {
                        return null;
                    }
                }, new File("C:\\temp\\cachetest" + i + ".dat"));
                files[i].setAccessMode(2);
                DirectByteBuffer bb = DirectByteBufferPool.getBuffer((byte)2, file_data[i].length);
                bb.put((byte)3, file_data[i]);
                bb.position((byte)3, 0);
                files[i].write(bb, 0L);
                ++i;
            }
            int quanitize_to = 100;
            int quanitize_to_max_consec_write = 1;
            int quanitize_to_max_consec_read = 3;
            int x = 0;
            while (x < 10000000) {
                int file_index = Test.randomInt(files.length);
                CacheFile cf = files[file_index];
                byte[] bytes = file_data[file_index];
                int p1 = Test.randomInt(bytes.length);
                int p2 = Test.randomInt(bytes.length);
                if ((p1 = p1 / quanitize_to * quanitize_to) != (p2 = p2 / quanitize_to * quanitize_to)) {
                    DirectByteBuffer buffer;
                    int start = Math.min(p1, p2);
                    int len = Math.max(p1, p2) - start;
                    int function = Test.randomInt(100);
                    if (function < 30) {
                        if (len > quanitize_to * quanitize_to_max_consec_read) {
                            len = quanitize_to * quanitize_to_max_consec_read;
                        }
                        buffer = DirectByteBufferPool.getBuffer((byte)2, len);
                        System.out.println("read:" + start + "/" + len);
                        cf.read(buffer, start);
                        buffer.position((byte)3, 0);
                        byte[] data_read = new byte[len];
                        buffer.get((byte)3, data_read);
                        int i2 = 0;
                        while (i2 < data_read.length) {
                            if (data_read[i2] != bytes[i2 + start]) {
                                throw new Exception("data read mismatch");
                            }
                            ++i2;
                        }
                        buffer.returnToPool();
                    } else if (function < 80) {
                        if (len > quanitize_to * quanitize_to_max_consec_write) {
                            len = quanitize_to * quanitize_to_max_consec_write;
                        }
                        System.out.println("write:" + start + "/" + len);
                        buffer = DirectByteBufferPool.getBuffer((byte)2, len);
                        int i3 = 0;
                        while (i3 < len) {
                            bytes[start + i3] = (byte)Test.randomInt(256);
                            buffer.put((byte)3, bytes[start + i3]);
                            ++i3;
                        }
                        buffer.position((byte)3, 0);
                        cf.writeAndHandoverBuffer(buffer, start);
                    } else if (function < 90) {
                        cf.flushCache();
                    } else if (function < 91) {
                        cf.clearCache();
                    }
                }
                ++x;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    static int randomInt(int num) {
        return (int)(Math.random() * (double)num);
    }
}

