/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n.test;

import java.util.Map;
import java.util.HashMap;

import org.apache.avalon.excalibur.testcase.ExcaliburTestCase;
import org.apache.avalon.excalibur.i18n.AbstractBundle;

/**
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version $Id: AbstractBundleTestCase.java,v 1.8 2001/12/11 09:53:35 jefft Exp $
 */
public class AbstractBundleTestCase extends ExcaliburTestCase {

    private TestBundle bundle = new TestBundle();
    private Map variables = new HashMap(5);

    public AbstractBundleTestCase( String name ) {
        super(name);
    }

    public void setUp() throws Exception {
        this.variables.put("nice", "not so nice");
        this.variables.put("bad", "too bad");
        this.variables.put("value", "a cat");

        this.bundle.enableLogging( getLogEnabledLogger() );
        this.bundle.put("cat", "Here is an example of {value}.");
        this.bundle.put("nice", "This is a {nice} test!");
        this.bundle.put("nice.nice", "This is a {nice}, {nice} test!");
        this.bundle.put("nice.bad", "This is a {nice} but not {bad} test!");
        this.bundle.put("test.plain", "This is a test!");
        this.bundle.put("test.empty", "");
    }

    public void tearDown() throws Exception {
        this.variables.clear();
        this.bundle.store.clear();
    }

    public void testSubstitute() {
        assertEquals("This is a not so nice test!", this.bundle.getString("nice", variables));
        assertEquals("This is a not so nice, not so nice test!", this.bundle.getString("nice.nice", variables));
        assertEquals("This is a not so nice but not too bad test!", this.bundle.getString("nice.bad", variables));
        assertEquals("This is a test!", this.bundle.getString("test.plain", variables));
        assertEquals("", this.bundle.getString("test.empty", variables));
        assertEquals("Here is an example of a cat.", this.bundle.getString("cat", this.variables));
    }

    private static class TestBundle extends AbstractBundle {
        private Map store = new HashMap();

        public void setLoadOnInit(boolean set) {
        }

        public void init(String fileName) throws Exception {
            // do nothing
        }

        void put(String key, String value) {
            this.store.put(key, value);
        }

        public String getString(String key) {
            return (String) store.get(key);
        }
    }

}
