/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.SunToolkit;

public class Dialog
extends Window {
    boolean resizable = true;
    boolean modal;
    String title;
    private static final String base = "dialog";
    private static int nameCounter;
    private static final long serialVersionUID = 5920926903803293709L;
    private Vector m_disabledWindows;
    private Dialog m_previousModalDialog;

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        super(frame);
        if (frame == null) {
            throw new IllegalArgumentException("null parent frame");
        }
        this.name = base + nameCounter++;
        this.title = string;
        this.modal = bl;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createDialog(this);
        }
        super.addNotify();
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer != null) {
            dialogPeer.setTitle(string);
        }
    }

    public void show() {
        super.show();
    }

    protected void __showDialog() {
        Object object;
        Object[] objectArray = Component.LOCK;
        synchronized (objectArray) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.addNotify();
                object = this.getMinimumSize();
                if (((Dimension)object).width > this.width || ((Dimension)object).height > this.height) {
                    this.setSize((Dimension)object);
                }
            }
            this.validate();
        }
        if (this.visible) {
            this.toFront();
            return;
        }
        this.visible = true;
        if (this.isModal()) {
            objectArray = SunToolkit.getTopLevelWindows();
            if (objectArray == null) {
                Frame frame = (Frame)this.getParent();
                int n = frame.ownedWindows.size() + 1;
                objectArray = new Window[n];
                frame.ownedWindows.copyInto(objectArray);
                objectArray[n - 1] = frame;
            }
            this.m_disabledWindows = new Vector(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                if (object != this && ((Component)object).isVisible() && ((Component)object).isEnabled()) {
                    this.m_disabledWindows.addElement(object);
                    ((Component)object).enabled = false;
                    ((Component)object).getPeer().setEnabled(false);
                }
                ++n;
            }
            this.m_previousModalDialog = SunToolkit.swapTopModalDialog(this);
        }
        this.peer.show();
    }

    void __hideDialog() {
        if (!this.visible) {
            return;
        }
        if (this.isModal()) {
            if (this.m_disabledWindows == null) {
                return;
            }
            Dialog dialog = SunToolkit.swapTopModalDialog(this.m_previousModalDialog);
            if (dialog != this) {
                System.out.println("java.awt.Dialog.__hideDialog(): self != this (self = " + dialog + "; this = " + this + ")");
            }
            if (this.m_previousModalDialog != null) {
                this.m_previousModalDialog.toFront();
            }
            Enumeration enumeration = this.m_disabledWindows.elements();
            while (enumeration.hasMoreElements()) {
                Window window = (Window)enumeration.nextElement();
                window.enabled = true;
                window.getPeer().setEnabled(true);
            }
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public synchronized void setResizable(boolean bl) {
        this.resizable = bl;
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer != null) {
            dialogPeer.setResizable(bl);
        }
    }

    protected String paramString() {
        String string = String.valueOf(super.paramString()) + (this.modal ? ",modal" : ",modeless");
        if (this.title != null) {
            string = String.valueOf(string) + ",title=" + this.title;
        }
        return string;
    }
}

