%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% arabrep.cls
% ArabTeX extension
% Arabic version of report.cls
% for use with ArabTeX Version 3.05
%
% Copyright (C) 1997 by Klaus Lagally
% 16.05.97
%
% reusing report.cls (and book.cls) of 19 Jun 1995
% reusing report.cls (and book.cls) of 26 May 1996
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat {LaTeX2e}[1996/06/01]
\ProvidesClass {arabrep}[1997/05/16 v0.02 arabic report format]

\newif\if@mainmatter \@mainmattertrue
\newif\ifa@book \a@bookfalse
\newif\ifa@article \a@articlefalse
\DeclareOption {book}{\a@booktrue \@mainmattertrue } 
\DeclareOption {article}{\a@articletrue \@mainmattertrue } 
\DeclareOption* {\PassOptionsToClass {\CurrentOption}{report}}
\ProcessOptions
\LoadClass {report}[1996/05/26] % load the LaTeX standard class 

\ifa@book \@openrighttrue \fi
%\input{bk1\@ptsize.clo} % collision on \small !!

\ifa@article \@titlepagefalse \fi

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\RequirePackage {arabtex}[1997/05/08] % load the ArabTeX processor
\ifx \a@@var \a@@LaTeXiizix 
\UsePackage {nashbf}}
\fi

\UsePackage {latexext} % load local patches for LaTeX
%\UsePackage {arabext} % load local patches for ArabTeX

%    ****************************************
%    *         PAGE STYLES                  *
%    ****************************************

\if@twoside         % If two-sided printing.
 \def \ps@headings {% for arabic mode
	\let \@mkboth \markboth \def\@oddfoot{}\def\@evenfoot{}%
	\def \@evenhead {\edef \thepage {\nxp\RL{\thepage }}% left heading
		\leftmark \hfil \thepage }%
	\def \@oddhead {\edef \thepage {\nxp\RL{\thepage }}% right heading
		\thepage \hfil \rightmark }%
	\def \chaptermark ##1{\markboth {##1%
		\ifnum \c@secnumdepth >\m@ne
		\if@mainmatter
		\hskip 1em\relax \RL{\@chapapp \space \thechapter. }%
		\fi\fi }{}}%
	\def \sectionmark ##1{\markleft {##1\ifnum \c@secnumdepth >\@ne
		\hskip 1em\relax \RL{\thesection }\fi }}%
	\ifa@article
	\def \subsectionmark ##1{\markleft {##1\ifnum \c@secnumdepth >\@ne
		\hskip 1em\relax \RL{\thesubsection }\fi }}%
	\fi }
\else               % If one-sided printing.
 \def \ps@headings {% for arabic mode
	\let \@mkboth \markboth \def \@oddfoot{}\def \@evenfoot{}%
	\def \@oddhead {\edef \thepage {\nxp \RL{\thepage }}% right heading
		\thepage \hfil \rightmark }%
	\def \chaptermark ##1{\markright {##1%
		\ifnum \c@secnumdepth >\m@ne
		\if@mainmatter
		\hskip 1em\relax \RL{\@chapapp\space \thechapter. }%
		\fi\fi }}}
\fi

\def \ps@plain {% for arabic mode
	\let \@mkboth\@gobbletwo \let\@oddhead\@empty \let\@evenhead\@empty
	\def \@oddfoot {\edef \thepage {\nxp\RL{\thepage }}% right heading
		\hfil \thepage \hfil }%
	\let \@evenfoot\@oddfoot }
 
\def \ps@myheadings {% for arabic mode
	\let\@oddfoot \@empty \let\@evenfoot \@empty
	\def \@oddhead {\edef \thepage {\nxp \RL{\thepage }}% right heading
		\thepage \hfil \rightmark }%
	\def \@evenhead {\edef \thepage {\nxp\RL{\thepage }}% left heading
		\leftmark \hfil \thepage }%
	\let\@mkboth\@gobbletwo	\let\subsectionmark\@gobble
	\let\chaptermark\@gobble \let\sectionmark\@gobble }

%    ****************************************
%    *         TITLE AND ABSTRACT           *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\if@titlepage
  \newcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \null\vfil
  \vskip 60\p@
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 3em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \let\thanks\relax\let\maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\else
 \newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\hb@xt@\z@{$\m@th^{\@thefnmark}$\hss}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{\hss\@makefnmark}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \let\thanks\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}

 \def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\fi

\else %============= arabart.cls ==================================
\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *             UNITS                    *
%    ****************************************

\ifa@book
\newcommand\frontmatter
	{\cleardoublepage \@mainmatterfalse \pagenumbering{Abjad}}
\newcommand\mainmatter
	{\cleardoublepage \@mainmattertrue \pagenumbering{arabic}}
\newcommand\backmatter
	{\if@openright \cleardoublepage \else \clearpage
	\fi \@mainmatterfalse }
\fi

\ifa@article
\renewcommand\thesection {\@arabic\c@section}
\fi
%\allowarab \@chapapp

%    ****************************************
%    *             PARTS                    *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\renewcommand\part{\cleardoublepage
                 \thispagestyle{plain}%
                 \if@twocolumn
                     \onecolumn
                     \@tempswatrue
                   \else
                     \@tempswafalse
                 \fi
                 \hbox{}\vfil
                 \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >-2\relax
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    \markboth{}{}
    {\centering
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >-2\relax
       \huge\bfseries \partname~\thepart
       \par
       \vskip 20\p@
     \fi
     \Huge \bfseries #2\par}%
    \@endpart}

\def\@spart#1{%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \Huge \bfseries #1\par}%
    \@endpart}

\def\@endpart{\vfil\newpage
              \if@twoside
                \hbox{}%
                \thispagestyle{empty}%
                \newpage
              \fi
              \if@tempswa
                \twocolumn
              \fi}

\else %============= arabart.cls ==================================

\renewcommand \thepart {\@arabic\c@part } 

\def \a@c@part {\a@@par
\ifa@article \addvspace{4ex}\@afterindentfalse
\else   \cleardoublepage \thispagestyle{plain}%
	\if@twocolumn \onecolumn \@tempswatrue
	\else \@tempswafalse
	\fi
	\hbox{}\vfil
\fi \secdef \a@part \a@spart }

\ifa@article

\def \a@part [#1]#2{% numbered part
\ifnum \c@secnumdepth > \m@ne 
	\refstepcounter {part}%
	\addcontentsline {toc}{part}{\protect\RL 
		{\protect\abjad {\thepart}\hspace {1em} #1 }}%
\else	\addcontentsline {toc}{part}{\protect\RL {#1}}%
\fi
\begingroup \let \end \a@@par \a@parindent \z@ \a@@raggedright
	\interlinepenalty \@M
\ifnum \c@secnumdepth >\m@ne
	\Large \nashbf \set@arabfont 
	\test@token \partname \abjad{\thepart } \end \nobreak
\fi
	\huge \nashbf \set@arabfont \test@token #2 \end 
	\markboth {}{}
\endgroup
\nobreak \vskip 3ex
\a@afterheading \test@token }

\def \a@spart #1{% unnumbered part
\begingroup \let \end \a@@par \a@@raggedright \a@parindent \z@ 
	\interlinepenalty \@M
	\huge \nashbf \set@arabfont \test@token #1 \end
\endgroup
\nobreak \vskip 3ex
\a@afterheading \test@token }

\else % report or book

\def \a@part [#1]#2{% numbered part
\ifnum \c@secnumdepth > \ifa@article \m@ne \else -2 \fi
	\refstepcounter {part}%
	\addcontentsline {toc}{part}{\protect\RL 
		{\protect\abjad {\thepart}\hspace {1em} #1 }}%
\else	\addcontentsline {toc}{part}{\protect\RL {#1}}%
\fi
\markboth{}{}
\begingroup \let \end \a@@par \a@@centering \interlinepenalty \@M
\ifnum \c@secnumdepth > -2\relax
	\huge \nashbf \set@arabfont 
	\test@token \partname \abjad{\thepart } \end
	\vskip 20\p@
\fi
	\Huge \nashbf \set@arabfont \test@token #2 \end 
\endgroup
\@endpart \test@token }

\def \a@spart #1{% unnumbered part
\begingroup \let \end \a@@par \a@@centering \interlinepenalty \@M
	\Huge \nashbf \set@arabfont \test@token #1 \end
\endgroup
\@endpart \test@token }

\fi

\def\@part[#1]#2{% \part outside Arabic text
\begin{arabtext}
\a@part[\LR{#1}]{\LR{#2}}
\end{arabtext}}

\def\@spart#1{%	\part* outside Arabic text
\begin{arabtext}
\a@spart {\LR{#1}}
\end{arabtext}}

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *             CHAPTERS                 *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\chapter{\if@openright\cleardoublepage\else\clearpage\fi
                    \thispagestyle{plain}%
                    \global\@topnum\z@
                    \@afterindentfalse
                    \secdef\@chapter\@schapter}

\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
                         \refstepcounter{chapter}%
                         \typeout{\@chapapp\space\thechapter.}%
                         \addcontentsline{toc}{chapter}%
                                   {\protect\numberline{\thechapter}#1}%
                    \else
                      \addcontentsline{toc}{chapter}{#1}%
                    \fi
                    \chaptermark{#1}%
                    \addtocontents{lof}{\protect\addvspace{10\p@}}%
                    \addtocontents{lot}{\protect\addvspace{10\p@}}%
                    \if@twocolumn
                      \@topnewpage[\@makechapterhead{#2}]%
                    \else
                      \@makechapterhead{#2}%
                      \@afterheading
                    \fi}

\def\@makechapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedright \normalfont
    \ifnum \c@secnumdepth >\m@ne
        \huge\bfseries \@chapapp{} \thechapter
        \par\nobreak
        \vskip 20\p@
    \fi
    \interlinepenalty\@M
    \Huge \bfseries #1\par\nobreak
    \vskip 40\p@
  }}

\def\@schapter#1{\if@twocolumn
                   \@topnewpage[\@makeschapterhead{#1}]%
                 \else
                   \@makeschapterhead{#1}%
                   \@afterheading
                 \fi}

\def\@makeschapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedright
    \normalfont
    \interlinepenalty\@M
    \Huge \bfseries  #1\par\nobreak
    \vskip 40\p@
  }}

\else %============= arabrep.cls ==================================

\ifa@article \else  % report or book
\allowarab \thechapter

\newcommand \a@c@chapter {\a@@par
%\tracingmacros 1
	\if@openright \cleardoublepage \else \clearpage \fi
	\thispagestyle {plain}%
	\global\@topnum \z@ \@afterindentfalse
	\secdef \a@chapter \a@schapter }

\def \a@chapter [#1]#2{% numbered chapter
\ifnum \c@secnumdepth >\m@ne
\if@mainmatter
	\refstepcounter {chapter}%
	\typeout {\@chapapp \space \thechapter.}%
	\addcontentsline {toc}{chapter}%
	{\protect\numberline {\thechapter }\protect\RL {#1}}%
\else \addcontentsline {toc}{chapter}{\protect\RL {#1}}%
\fi
\else \addcontentsline {toc}{chapter}{\protect\RL {#1}}%
\fi
\chaptermark{\RL {#1}}%
\addtocontents {lof}{\protect\addvspace {10\p@}}%
\addtocontents {lot}{\protect\addvspace {10\p@}}%
\if@twocolumn \@topnewpage [\a@makechapterhead {#2}]%
\else \a@makechapterhead {#2}\a@afterheading
\fi 
\tracingmacros 0
\test@token }

\def\a@makechapterhead #1{% make heading with number
\null \vskip 50\p@ 
\begingroup \let \end \a@@par \a@@raggedright \interlinepenalty\@M
\ifnum \c@secnumdepth >\m@ne
\if@mainmatter
%	\edef \thechapter {\@chapapp \space \thechapter }%
%	\edef \thechapter {\@chapapp \space \thechapter \space }%
	\edef \thechapter {\@chapapp \space \thechapter . }%
%	\huge \nashbf \set@arabfont \test@token \thechapter \end 
	\huge \nashbf \set@arabfont \test@token {\thechapter } \end 
	\nobreak \vskip 20\p@
\fi\fi
	\Huge \nashbf \set@arabfont \test@token #1 \end 
	\nobreak \vskip 40\p@
\endgroup }

\def\a@schapter #1{% unnumbered chapter
\if@twocolumn \@topnewpage [\a@makeschapterhead {#1}]%
\else \a@makeschapterhead {#1}\a@afterheading
\fi 
\tracingmacros 0
\test@token }

\def\a@makeschapterhead #1{%
\null \vskip 50\p@ 
\begingroup \let \end \a@@par \a@@raggedright \interlinepenalty\@M
	\Huge \nashbf \set@arabfont \test@token #1 \end
\endgroup
\nobreak \vskip 40\p@ }

\fi % report or book

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%*********************************************************************
%*********************************************************************
%*********************************************** rest not yet adapted **********************
%*********************************************************************
%*********************************************************************

%    ****************************************
%    *             SECTIONS                 *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\else %============= arabart.cls ==================================

\def \a@c@section {\a@startsection 
{section}{1}{\z@}{-3.5ex plus-1ex minus -.2ex}{2.3ex plus.2ex}%
{\reset@font \Large\setnashbf }}

\def \a@c@subsection {\a@startsection
{subsection}{2}{\z@}{-3.25ex plus-1ex minus-.2ex}{1.5ex plus.2ex}%
{\reset@font \large\setnashbf }}

\def \a@c@subsubsection {\a@startsection
{subsubsection}{3}{\z@}{-3.25ex plus -1ex minus-.2ex}{1.5ex plus.2ex}%
{\reset@font \normalsize\setnashbf }}

\def \a@c@paragraph {\a@startsection
{paragraph}{4}{\z@}{3.25ex plus1ex minus.2ex}{-1em}%
{\reset@font \normalsize\setnashbf }}

\def\a@c@subparagraph {\a@startsection 
{subparagraph}{5}{\parindent}{3.25ex plus1ex minus .2ex}{-1em}%
{\reset@font \normalsize\setnashbf }}
 
\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *                LISTS                 *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi

\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}

\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi

\setlength\leftmargin    {\leftmargini}

\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}

\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty

\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}

\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}

\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}

\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}

\else %============= arabart.cls ==================================

\at@arabtext {% switch to Arabic terms
	\def\theenumii{\arabic{enumii}}
	\def\theenumiii{\arabic{enumiii}}
	\def\theenumiv{\arabic{enumiv}} 
%
	\def\labelenumi{\theenumi\space-} 
%	\def\labelenumi{\theenumi-} 
	\def\labelenumii{\abj@d{\theenumii}-}
	\def\labelenumiii{\theenumiii\nospace(}
	\def\labelenumiv{\abj@d{\theenumiv}\nospace)}
%
	\def\labelitemi{$\circ$}
	\def\labelitemii{$-$}
	\def\labelitemiii{$\star$}
	\def\labelitemiv{$+$}
}

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *         OTHER ENVIRONMENTS           *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

% DESCRIPTION

\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}

\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

\else %============= arabart.cls ==================================

\def \descriptionlabel #1{\setnashbf \RL{#1}\hskip \labelsep }

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% THEOREM
%%%%%%%%%%%%% NOT IMPLEMENTED 

% EQUATION and EQNARRAY
%%%%%%%%%%%%% NOT IMPLEMENTED 

% TITLEPAGE
%%%%%%%%%%%%% NOT IMPLEMENTED 

% TABBING
%%%%%%%%%%%%% NOT IMPLEMENTED 

% MINIPAGE
%%%%%%%%%%%%% NOT IMPLEMENTED 

% FRAMEBOX
%%%%%%%%%%%%% NOT IMPLEMENTED 

%    ****************************************
%    *             ABSTRACT                 *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\ifa@book
\else
\if@titlepage
  \newenvironment{abstract}{%
      \titlepage
      \null\vfil
      \begin{center}%
        \bfseries \abstractname
        \@endparpenalty\@M
      \end{center}}%
     {\par\vfil\null\endtitlepage}
\else
  \newenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \begin{center}%
          {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
        \end{center}%
        \quotation
      \fi}
      {\if@twocolumn\else\endquotation\fi}
\fi
\fi

\else %============= arabart.cls ==================================
\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *         OTHER ENVIRONMENTS           *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item[]}
               {\endlist}

\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item[]}
               {\endlist}

\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item[]}
               {\endlist}

\else %============= arabart.cls ==================================

\def \a@c@verse
{%
\tracingmacros 1
%{\let \a@short@line \last@line % \@centercr
%{\def \a@last@line {\last@line \a@@par \a@spacefalse }% \@centercr
%{\let\\=\@centercr
%{\let \a@last@line \short@line
\let \endverse \a@@endtrivlist
%{%
  \a@@list{}{\itemsep\z@ \itemindent -1.5em \listparindent \itemindent
          \rightmargin\leftmargin \advance\leftmargin 1.5em}\a@@item[]}

%\iffalse
\def \a@c@quotation
{%
\tracingmacros 1
%\let \endquotation \a@@endtrivlist
\a@@list{}{\listparindent 1.5em \itemindent\listparindent
    \rightmargin\leftmargin \parsep \z@ plus\p@}\a@@item[]}

\def \a@c@quote
{%
\tracingmacros 1
\let \endquote \a@@endtrivlist
\a@@list{}{\rightmargin\leftmargin}\a@@item[]}
%\fi

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *              TITLE PAGE              *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{titlepage}
{% \titlepage
	\ifa@book
      \cleardoublepage
	\fi
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \if@compatibility
        \setcounter{page}{0}
      \else
	\ifa@book \else
        \setcounter{page}{1}%
	\fi
      \fi }%
{% \endtitlepage
	\if@restonecol\twocolumn \else \newpage \fi
	\ifa@book \else
        \setcounter{page}{1}%
	\fi }

\else %============= arabart.cls ==================================
\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *              APPENDIX                *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\@Alph\c@section}}

\newcommand\appendix{\par
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \renewcommand\@chapapp{\appendixname}%
  \renewcommand\thechapter{\@Alph\c@chapter}}

\else %============= arabart.cls ==================================

\def\a@c@appendix{%\par
	\setcounter{section}{0}%
	\renewcommand\@chapapp {\appendixname }%
\ifa@article \renewcommand\thesection {\@Abjad \c@section }%
	\setcounter{subsection}{0}%
\else \renewcommand\thechapter {\@Abjad \c@chapter }%
	\setcounter{chapter}{0}%
\fi \test@token }

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *         FIGURES AND TABLES           *
%    ****************************************
%
\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\@addtoreset{equation}{chapter}
\renewcommand\theequation{\thechapter.\@arabic\c@equation}
\newcounter{figure}[chapter]
\renewcommand\thefigure{\thechapter.\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}

\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}[chapter]
\renewcommand\thetable{\thechapter.\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}

\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}

\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\else %============= arabart.cls ==================================

\ifa@article
\renewcommand\theequation{\@arabic\c@equation}
\renewcommand\thefigure{\@arabic\c@figure}
\renewcommand\thetable{\@arabic\c@table}
\fi

\def\fnum@figure {\figurename \space \thefigure }

\def\fnum@table {\tablename \space \thetable }

\long\def \a@makecaption #1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#2 : #1}%
  \ifdim \wd\@tempboxa >\hsize
    #2 : #1\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip }

\let \@makecaption \a@makecaption

\long\def \a@caption #1[#2]#3{\par 
	\addcontentsline {\csname ext@#1\endcsname}{#1}
%	{\protect\numberline {\csname the#1\endcsname}\protect\RL {#2}}%
	{\protect\numberline {\csname the#1\endcsname}\protect #2}%
\begingroup \@parboxrestore \normalsize
	\edef \reserved@a {\csname fnum@#1\endcsname }%
%	\@makecaption {\xpa \RL \xpa {\reserved@a }}{\RL {#3}}\par
	\@makecaption {\xpa \RL \xpa {\reserved@a }}{#3}\par
\endgroup}

\let \@caption \a@caption 

\long\def \a@@caption #1[#2]#3{\par 
	\addcontentsline {\csname ext@#1\endcsname}{#1}
	{\protect\numberline {\csname the#1\endcsname}\protect\RL {#2}}%
\begingroup \@parboxrestore \normalsize
	\edef \reserved@a {\csname fnum@#1\endcsname }%
	\@makecaption {\xpa \RL \xpa {\reserved@a }}{\RL {#3}}\par
\endgroup \test@token }

\at@arabtext {\let \@caption \a@@caption }

\let \a@c@caption \caption

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *         TABLE OF CONTENTS, ETC.      *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{2}

\newcommand\tableofcontents{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\contentsname
        \@mkboth{\MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    \if@restonecol\twocolumn\fi
    }

\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}
    \endgroup
  \fi}

\newcommand*\a@l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}
    \endgroup
  \fi}

\newcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}

\newcommand*\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand*\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{10em}{5em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{12em}{6em}}

\newcommand\listoffigures{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}}%
    \@starttoc{lof}%
    \if@restonecol\twocolumn\fi
    }

\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}

\newcommand\listoftables{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listtablename
      \@mkboth{\MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
    \@starttoc{lot}%
    \if@restonecol\twocolumn\fi
    }

\let\l@table\l@figure

\else %============= arabart.cls ==================================

\ifa@article \setcounter{tocdepth}{3}
\else \setcounter{tocdepth}{2}
\fi

\setcounter{tocdepth}{5} % for test only

\def \a@c@tableofcontents {\a@t@ble {\contentsname }{toc}}
% 	\a@t@ble, \a@@lsection etc. in "asect.sty"

\def \a@c@tableofcontents {%
\ifa@article
\a@t@ble {\contentsname }{toc}%
\else
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
\a@t@ble {\contentsname }{toc}% !!! \chapter*
\fi}
% 	\a@t@ble, \a@@lsection etc. in "asect.sty"

\def \a@c@tableofcontents {\a@t@ble {\contentsname }{toc}}
% 	\a@t@ble, \a@@lsection etc. in "asect.sty"

\def \a@c@starttoc #1{\endarabtext 
\the\arabtext@hook \@starttoc {#1}\arabtext }
 
\def \a@t@ble #1#2{% \tableofcontents etc.
\a@c@section *{#1}\@mkboth {#1}{#1}\starttoc {#2}}

\def \a@c@@mkboth #1#2{\@mkboth {\<#1>}{\<#2>}\test@token }
\def \a@c@@mkboth #1#2{\@mkboth {\RL{#1}}{\RL{#2}}\test@token }



\def \a@l@section #1#2{% for arabic mode
\ifnum \c@tocdepth >\z@
	\addpenalty {\@secpenalty }\addvspace {1.0em plus\p@ }
	\if@twocolumn \@tempdima 1.0em \else \@tempdima 1.5em \fi 
	\a@@lsection {#1}{#2}{\setnashbf }\fi }

\def \a@l@part #1#2{% for arabic mode
\ifnum \c@tocdepth >-2\relax
	\addpenalty {-\@highpenalty }\addvspace {2.25em plus\p@ }
	\if@twocolumn \@tempdima 2.0em \else \@tempdima 3.0em \fi 
	\a@@lsection {#1}{#2}{\large \setnashbf }\fi }

\def \a@l@chapter #1#2{% for arabic mode
\ifnum \c@tocdepth >\m@ne
	\addpenalty {-\@highpenalty }\addvspace {1.0em plus\p@ }
	\if@twocolumn \@tempdima 1.0em \else \@tempdima 1.5em \fi 
	\a@@lsection {#1}{#2}{\setnashbf }%
      	\penalty\@highpenalty
\fi }

\at@arabtext {% switch to Arabic terms
	\let \l@part \a@l@part
	\let \l@section \a@l@section
	\let \l@chapter \a@l@chapter
}

\if@twocolumn
	\def\l@subsection{\@dottedtocline{2}{1.0em}{1.5em}}
	\def\l@subsubsection{\@dottedtocline{3}{2.5em}{2.3em}}
	\def\l@paragraph{\@dottedtocline{4}{4.8em}{3.1em}}
	\def\l@subparagraph{\@dottedtocline{5}{7.9em}{3.9em}}
	\def\@tocrmarg {1.55em}
\fi

\def \a@c@listoffigures {\a@t@ble {\listfigurename }{lof}}

\def \a@c@listoftables {\a@t@ble {\listtablename }{lot}}

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *             BIBLIOGRAPHY             *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newdimen\bibindent
\bibindent=1.5em

\newenvironment{thebibliography}[1]
%     {\chapter*{\bibname
     {\section*{\bibname
        \@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.=\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
%\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
%\let\@openbib@code\@empty

\else %============= arabart.cls ==================================
\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *              THE INDEX               *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\newblock{}

\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\@makeschapterhead{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}

\newcommand\@idxitem{\hangindent 40\p@}
\newcommand\subitem{\par\hangindent 40\p@ \hspace*{20\p@}}
\newcommand\subsubitem{\par\hangindent 40\p@ \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}

\else %============= arabart.cls ==================================
\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *             FOOTNOTES                *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}

\@addtoreset{footnote}{chapter}

\long\def\@makefntext#1{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}

\else %============= arabart.cls ==================================

% Default definition
\def\@makefnmark{\hbox{$^{\@thefnmark}\m@th$}}

% see also "alatex.sty"

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *      LANGUAGE DEPENDENT NAMES        *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\bibname{Bibliography}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}

\else %============= arabart.cls ==================================

% tableofcontents = al-mu.htawayAtu
% listoffigures = qA'imaTu al-.suwaru
% listoftables = qA'imaTu al-^gadAwilu
% listofpictures = qA'imaTu al-rusUmu
% bibliography = al-marA^gi`u
% references = al-ma.sAdiru
% index = al-fihrisu (al-fihristu)
% chapter = al-fa.slu
% appendix = al-mul.haqu
% abstract = al-mula_h_ha.su
% attachments = al-murfaqAtu
% number = al-raqmu

%\at@arabtext {% switch to Arabic terms
	\def\contentsname   {al-mu.htawayAtu}
	\def\listfigurename {qA'imaTu a.s-.suwari}
	\def\listtablename  {qA'imaTu al-^gadAwili}
	\def\bibname        {al-marA^gi`u}
	\def\refname        {al-ma.sAdiru}
	\def\indexname      {al-fihristu}
	\def\figurename     {.sUraTuN}
	\def\tablename      {^gadwaluN}
	\def\partname       {al-^guz'u}
	\def\chaptername    {al-fa.slu}
	\def\appendixname   {al-mul.haqu}
	\def\abstractname   {al-mula_h_ha.su}
%}

\allowarab \contentsname	\allowarab \listfigurename 
\allowarab \listtablename  	\allowarab \partname  
\allowarab \chaptername		%\allowarab \partname  

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *            MISCELLANEOUS             *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}

\else %============= arabart.cls ==================================

\iffalse
\edef \a@@today {\number\day \space \ifcase\month\or
yanAyir \or febrAyir \or mAris \or 'abrIl \or 
mAyU \or yUniyU \or yUliyU \or 'a.gus.tus \or 
sibtambar \or 'uktUbar \or nUfambar \or disambar \fi ,
\number\year}

\def \a@c@today {\expandafter \a@c@mbox \expandafter {\a@@today }}
\fi
% 	see "acmd.sty"

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    ****************************************
%    *           INITIALIZATION             *
%    ****************************************

\iffalse %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\ifa@book
\pagestyle{headings}
\else
\pagestyle{plain}
\fi
\pagenumbering{arabic}

\if@twoside
\else \raggedbottom
\fi

\if@twocolumn \twocolumn \sloppy \flushbottom
\else \onecolumn
\fi

\else %============= arabart.cls ==================================

% Default initializations

\iffalse
\columnsep 20pt
\columnseprule .4pt
\headheight 18pt
\fi
%	see "asizex.clo"

\ifa@book \pagestyle{headings}
\else \pagestyle{plain}
\fi
%\ps@plain                   % 'plain' page style
\pagenumbering{arabic}      % Arabic page numbers

%    ****************************************
%    *       SIZE DEPENDENT PATCHES         *
%    ****************************************

\input {asize1\@ptsize.clo}

\fi %%%%%%%%%%%%%%%% article.cls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\UsePackage {arabext} % load local patches for ArabTeX

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% end of file arabrep.cls
\endinput
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\arabic #1->\expandafter \@arabic \csname c@#1\endcsname 
#1<-chapter

\@arabic #1->\number #1
#1<-\c@chapter 

\def \Abjad #1{\xpa \@Abjad \csname c@#1\endcsname }

\let \@Abjad \abj@d
