/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                    Copyright (c) 1994,1995,1996                       */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/* functions which mimic unix system calls                               */

#include <stdlib.h>
#include <stdio.h>
#include "EST_unix.h"
#include "EST_socket.h"

int unix_access(const char *file, int mode)
{
  DWORD flags = GetFileAttributes(file);

  if (flags == 0xffffffff)
    return 1;

  if (mode==F_OK)
    return 0;

  if (mode==R_OK)
    return 0;

  if (mode==W_OK)
    return (flags|FILE_ATTRIBUTE_READONLY) != 0;

  return 1;
}


int unix_read(HANDLE fd, char *buffer, int n)
{
  int howmany;

  if (ReadFile(fd, buffer, n, &howmany, NULL))
    return howmany;

  return -1;
}

char *unix_getcwd(char *buffer, int maxlength)
{
  static char lbuffer[1024];

  if (buffer==NULL)
    {
    buffer = lbuffer;
    maxlength=1023;
    }

  if (GetCurrentDirectory(maxlength, buffer) >=0)
    return buffer;
  return NULL;
}

int unix_waitpid(int pid, int *statusp, int flags)
{
  fprintf(stderr, "waitpid not yet implemented\n");
  return 0;
}

int unix_fork(void)
{
  fprintf(stderr," FORK NOT YET IMPLEMENTED\n");
  return -1;
}

static int sockets_initialised =0;

int socket_initialise(void)
{
  WORD wVersionRequested;
  WSADATA wsaData;
  int err;

  if (sockets_initialised)
    return 1;
  
  wVersionRequested = MAKEWORD( 2, 0 );
 
  err = WSAStartup( wVersionRequested, &wsaData );
  if ( err != 0 ) 
    {
      printf("Socket Initialisation failed\n");
      return 0;
    }

  sockets_initialised=1;
  return 1;
}
