#include "cs.h"         /*                                      SPECTRA.C       */
#include <math.h>
#include "window.h"
#include "spectra.h"

#define FZERO   (0.0f)

extern  long    kcounter;
             
static void SPECset(SPECDAT *specdp, long npts)
{
    long nbytes = npts * sizeof(float);
    
    if (specdp->auxch.auxp == NULL
        || nbytes != specdp->auxch.size)
      auxalloc(nbytes, &specdp->auxch);
    specdp->npts = npts;
}
             
static char *getstrdbout(int dbcode)
{
static char *outstring[] = {"mag", "db", "mag sqrd", "root mag"};
        switch (dbcode) {
        case 0:
        case 1:
        case 2:
        case 3:  return(outstring[dbcode]);
        default: return("unknown dbcode");
        }
}

#ifdef never
void nocdfset(NOCTDFT *p)
    /* noctdft - calcs disc Fourier transform of oct-downsampled data */
    /* outputs coefs (mag, db or mag2) of log freq within each octave */
{
        int     nfreqs, hanning, nocts, ncoefs;
        float   Q, *fltp;
        DOWNDAT *downp = p->dsig;
        SPECDAT *specp = p->wsig;

        p->timcount = ekr * *p->iprd;
        nfreqs = *p->ifrqs;
        Q = *p->iq;
        hanning = (*p->ihann) ? 1 : 0;
        if ((p->dbout = *p->idbout) && p->dbout != 1 && p->dbout != 2) {
            sprintf(errmsg, "noctdft: unknown dbout code of %d", p->dbout);
            initerror(errmsg);
        }
        nocts = downp->nocts;
        ncoefs = nocts * nfreqs;
        if (nfreqs != p->nfreqs || Q != p->curq             /* if anything changed */
             || p->timcount <= 0 || Q <= 0.
             || hanning != p->hanning
             || ncoefs != p->ncoefs) {                      /*     make new tables */
            double      basfrq, curfrq, frqmlt, Qfactor;
            double      theta, a, windamp, onedws, pidws;
            float       *sinp, *cosp;
            int         n, k, sumk, windsiz, *wsizp, nsamps;
            long        auxsiz;

            err_printf("noctdft: %s window, %s out, making tables ...\n",
                    (hanning) ? "hanning":"hamming", getstrdbout(p->dbout));
            if (p->timcount <= 0)                initerror("illegal iprd");
            if (nfreqs <= 0 || nfreqs > MAXFRQS) initerror("illegal ifrqs");
            if (Q <= FZERO)                      initerror("illegal Q value");
            if (inerrcnt)     return;
            nsamps = downp->nsamps;
            p->nfreqs = nfreqs;
            p->curq = Q;
            p->hanning = hanning;
            p->ncoefs = ncoefs;
            basfrq = downp->hifrq/2.0 * twopi/downp->srate; /* oct below retuned top */
            frqmlt = pow((double)2.0,(double)1./nfreqs);    /* nfreq interval mult */
            Qfactor = 6.2831854 * Q;
            curfrq = basfrq;
            for (sumk=0,wsizp=p->winlen,n=nfreqs; n--; ) {
                *wsizp++ = k = Qfactor/curfrq + 0.5;         /* calc window sizes  */
                sumk += k;                                   /*   and find total   */
        /*      printf("frq %f, k = %d\n",curfrq,k);  */
                curfrq *= frqmlt;
            }
            if ((windsiz = *(p->winlen)) > nsamps) {        /* chk longest windsiz */
                sprintf(errmsg,"Q %4.1f needs %d samples, octdown has just %d",
                        Q, windsiz, nsamps);
                initerror(errmsg);
                return;
            }
            else printf("noctdft: Q %4.1f uses %d of %d samps per octdown\n",
                        Q, windsiz, nsamps);
            auxsiz = (nsamps + 2*sumk) * sizeof(float);    /* calc local space reqd */
            auxalloc((long)auxsiz, &p->auxch);             /*     & alloc auxspace  */
            fltp = (float *) p->auxch.auxp;
            p->linbufp = fltp;          fltp += nsamps; /* linbuf must handle nsamps */
            p->sinp = sinp = fltp;      fltp += sumk;
            p->cosp = cosp = fltp;                         /* cos gets rem sumk  */
            wsizp = p->winlen;
            for (curfrq=basfrq,n=nfreqs; n--; ) {           /* now fill tables */
                windsiz = *wsizp++;
                onedws = 1.0 / windsiz;
                pidws = 3.1415927 / windsiz;
                for (k=0; k<windsiz; k++) {                 /*   with sines    */
                    a = sin(k * pidws);
                    windamp = a * a;                        /*   times hanning */
                    if (!hanning)
                        windamp = 0.08 + 0.92 * windamp;    /*   or hamming    */
                    windamp *= onedws;                      /*   scaled        */
                    theta = k * curfrq;
                    *sinp++ = windamp * sin(theta);
                    *cosp++ = windamp * cos(theta);
                }
                curfrq *= frqmlt;                           /*   step by log freq  */
            }
            if (*p->idsines != 0.0) {    /* if reqd, display windowed sines immediately */
                dispset(&p->dwindow,p->sinp,(long)sumk,"octdft windowed sines:",
                        0,"octdft");
                display(&p->dwindow);
            }
            SPECset(specp, (long)ncoefs);                /* prep the spec dspace */
            specp->downsrcp = downp;                     /*  & record its source */
        }
        specp->nfreqs = p->nfreqs;                 /* save the spec descriptors */
        specp->dbout = p->dbout;
        specp->ktimstamp = 0;                      /* init specdata to not new  */
        specp->ktimprd = p->timcount;
        p->countdown = p->timcount;                /*     & prime the countdown */
}

void noctdft(NOCTDFT *p)
{
        DOWNDAT *downp;
        SPECDAT *specp;
        OCTDAT  *octp;
        float   *dftp;
        int     nocts, wrap;
        float   a, b;
        double  c;

        if ((--p->countdown))  return;         /* if not yet time for new spec, return */
        if (p->auxch.auxp==NULL) { /* RWD fix */
          initerror("noctdft: not initialised");
          return;
        }
        p->countdown = p->timcount;            /* else reset counter & proceed:        */
        downp = p->dsig;
        specp = p->wsig;
        nocts = downp->nocts;
        octp = downp->octdata + nocts;
        dftp = (float *) specp->auxch.auxp;
        while (nocts--) {
            float  *bufp, *sinp, *cosp;
            int    len, *lenp, nfreqs;
            float   *begp, *curp, *endp;
            octp--;                              /* for each octave (low to high)   */
            begp = octp->begp;
            curp = octp->curp;
            endp = octp->endp;
            wrap = curp - begp;
            bufp = p->linbufp;
            while (curp < endp)                    /*   copy circbuf to linbuf   */
                *bufp++ = *curp++;
            for (curp=begp,len=wrap; len--; )
                *bufp++ = *curp++;
            cosp = p->cosp;                        /*   get start windowed sines */
            sinp = p->sinp;
            lenp = p->winlen;
            for (nfreqs=p->nfreqs; nfreqs--; ) {   /*   now for each freq this oct: */
                a = 0.0;
                b = 0.0;
                bufp = p->linbufp;
                for (len = *lenp++; len--; bufp++) {    /*  apply windowed sine seg */
                    a += *bufp * *cosp++;
                    b += *bufp * *sinp++;
                }
                c = a*a + b*b;                          /*  get magnitude squared   */
                if (!(p->dbout))                        /*    & optionally convert  */
                    c = sqrt(c);                        /*    to  mag or db         */
                else if (p->dbout == 1) {
                    if (c < .001) c = .001;
                    c = 10. * log10(c);
                }
                *dftp++ = c;                          /* store in out spectrum   */
            }
        }
        specp->ktimstamp = kcounter;                  /* time-stamp the output   */
}
#endif

void spdspset(SPECDISP *p)
{
        
    /* RWD is this enough? */
    if (p->wsig->auxch.auxp==NULL) {
      initerror("specdisp: not initialized");
      return;
    }
    if ((p->timcount = (int)(ekr * *p->iprd)) <= 0)
      initerror("illegal iperiod");
    if (!(p->dwindow.windid)) {
      SPECDAT *specp = p->wsig;
      DOWNDAT *downp = specp->downsrcp;
      if (downp->lofrq > 5.) {
        sprintf(strmsg,"instr %d %s, dft (%s), %ld octaves (%d - %d Hz):",
                p->h.insdshead->insno, p->STRARG, getstrdbout(specp->dbout),
                downp->nocts, (int)downp->lofrq, (int)downp->hifrq);
      }
      else {                      /* more detail if low frequency  */
        sprintf(strmsg,
                "instr %d %s, dft (%s), %ld octaves (%3.1f - %3.1f Hz):",
                p->h.insdshead->insno, p->STRARG, getstrdbout(specp->dbout),
                downp->nocts, downp->lofrq, downp->hifrq);
      }
      dispset(&p->dwindow, (float *)specp->auxch.auxp,
              (long)specp->npts, strmsg, (int)*p->iwtflg, "specdisp");
    }
    p->countdown = p->timcount;          /* prime the countdown */
}

void specdisp(SPECDISP *p)
{
    /* RWD is this enough? */
    if (p->wsig->auxch.auxp==NULL) {
      initerror("specdisp: not initialised");
      return;
    }
    if (!(--p->countdown)) {               /* on countdown     */
      display(&p->dwindow);            /*    display spect */
      p->countdown = p->timcount;        /*    & reset count */
    }
}

static float logtwo = 0.693147f;

void sptrkset(SPECPTRK *p)
{
        SPECDAT *inspecp = p->wsig;
        long    npts, nptls, nn, lobin;
        int     *dstp;
        float   nfreqs, rolloff;


        if ((npts = inspecp->npts) != p->winpts) {          /* if size has changed */
            SPECset(&p->wfund, (long)npts);                 /*   realloc for wfund */
            p->wfund.downsrcp = inspecp->downsrcp;
            p->fundp = (float *) p->wfund.auxch.auxp;
            p->winpts = npts;
        }
        if ((p->ftimcnt = (int)(ekr * *p->ifprd)) > 0) {     /* if displaying wfund   */
            SPECDISP *fdp = &p->fdisplay;
            fdp->h = p->h;
            fdp->wsig = &p->wfund;                        /*  pass the param pntrs */
            fdp->iprd = p->ifprd;
            fdp->iwtflg = p->iwtflg;
            spdspset(fdp);                                /*  & call specdisp init */ 
        }
        else p->ftimcnt = 0;
        if ((nptls = (long)*p->inptls) <= 0 || nptls > MAXPTL) {
            initerror("illegal no of partials");
            return;
        }
        p->nptls = nptls;
        dstp = p->pdist;
        nfreqs = (float)inspecp->nfreqs;
        for (nn = 1; nn <= nptls; nn++)
             *dstp++ = (int) ((log((double) nn) / logtwo) * nfreqs);
        if ((rolloff = *p->irolloff) == 0. || rolloff == 1. || nptls == 1)
            p->rolloff = 0;
        else {
            float *fltp = p->pmult;
            float octdrop = (1.0f - rolloff) / nfreqs;
            dstp = p->pdist;
            nn = nptls;
            do  *fltp++ = 1.0f - octdrop * *dstp++; /* rolloff * octdistance */
            while (--nn);
            if (*--fltp < FZERO)
                initerror("per oct rolloff too steep");
            p->rolloff = 1;
        }
        lobin = (long)(inspecp->downsrcp->looct * nfreqs);
        p->oct0p = p->fundp - lobin;  /* virtual loc of oct 0 */
        p->octfreqs = nfreqs;

        printf("nfreqs: %d, dist array:", (int)nfreqs);
        for (nn = 0; nn < nptls; nn++)
            printf(" %d", p->pdist[nn]);
        if (p->rolloff) {
            printf("\n\troll array:");
            for (nn = 0; nn < nptls; nn++)
                printf(" %4.2f", p->pmult[nn]);
        }
        printf("\n");

        p->kinterp = (*p->interp == FZERO) ? 0 : 1;
        p->kval = FZERO;
        p->kinc = FZERO;
}

void specptrk(SPECPTRK *p)
{
        SPECDAT *inspecp = p->wsig;

        if (inspecp->ktimstamp == kcounter) {          /* if inspectrum is new:      */
            float *inp2, sum;
            float *inp = (float *) inspecp->auxch.auxp;
            float *endp = inp + inspecp->npts;
            float *fundp = p->fundp;
            long  nn;
            int   *pdist;
            float fmax, *fmaxp, kval;
            if (inp==NULL) {            /* RWD fix */
              initerror("specptrk: not initialised");
              return;
            }
            if (p->rolloff) {
                float *pmult;
                do {
                    sum = *inp;
                    pdist = p->pdist + 1;
                    pmult = p->pmult + 1;
                    for (nn = p->nptls; --nn; ) {
                        if ((inp2 = inp + *pdist++) >= endp)
                            break;
                        sum += *inp2 * *pmult++;
                    }
                    *fundp++ = sum;
                } while (++inp < endp);
            }
            else {
                do {
                    sum = *inp;
                    pdist = p->pdist + 1;
                    for (nn = p->nptls; --nn; ) {
                        if ((inp2 = inp + *pdist++) >= endp)
                            break;
                        sum += *inp2;
                    }
                    *fundp++ = sum;
                } while (++inp < endp);
            }
            p->wfund.ktimstamp = kcounter;             /* mark the fundspec as new */
            fundp = p->fundp;
            for (fmaxp=fundp,fmax=FZERO,nn=inspecp->npts; --nn; fundp++) {
                if (*fundp > fmax) {
                    fmax = *fundp;
                    fmaxp = fundp;
                }
            }
            kval = (fmaxp - p->oct0p) / p->octfreqs;   /* cvt binno to true decoct */
            if (p->kinterp)                                /*   new kinc if interp */
                p->kinc = (kval - p->kval) / inspecp->ktimprd;
            else p->kval = kval;
        }
        *p->koct = p->kval;                   /* output true decoct */
        if (p->kinterp)                       /*   & interp if reqd */
            p->kval += p->kinc;
        if (p->ftimcnt)
            specdisp(&p->fdisplay);
}

void spsumset(SPECSUM *p)
{
        p->kinterp = (*p->interp == FZERO) ? 0 : 1;
        p->kval = FZERO;
        p->kinc = FZERO;
}

void specsum(SPECSUM *p)        /* sum all vals of a spectrum and put as ksig */
                                /*         optionally interpolate the output  */
{
        SPECDAT *specp = p->wsig;
        if (specp->auxch.auxp==NULL) { /* RWD fix */
          initerror("specsum: not initialised");
          return;
        }
        if (specp->ktimstamp == kcounter) {                  /* if spectrum is new   */
            float *valp = (float *) specp->auxch.auxp;
            float sum = 0.0f;
            long npts = specp->npts;                /*   sum all the values */
            do  sum += *valp++;
            while (--npts);
            if (p->kinterp)                                  /*   new kinc if interp */
                p->kinc = (sum - p->kval) / specp->ktimprd;
            else p->kval = sum;
        }
        *p->ksum = p->kval;       /* output current kval */
        if (p->kinterp)           /*   & interp if reqd  */
            p->kval += p->kinc;
}

void spadmset(SPECADDM *p)
{
        SPECDAT *inspec1p = p->wsig1;
        SPECDAT *inspec2p = p->wsig2;
        int   npts;

        if ((npts = inspec1p->npts) != inspec2p->npts)
            initerror("inputs have different sizes");    /* inspecs must agree in size */
        if (inspec1p->ktimprd != inspec2p->ktimprd)
            initerror("inputs have diff. time periods"); /*                time period */
        if (inspec1p->nfreqs != inspec2p->nfreqs)        /*                frq resoltn */
            initerror("inputs have different freq resolution");
        if (inspec1p->dbout != inspec2p->dbout)
            initerror("inputs have different amptypes"); /*                and db type */
        if (inerrcnt)
            return;
        if (npts != p->waddm->npts) {                    /* if out doesn't match ins */
            SPECset(p->waddm, (long)npts);               /*     reinit the out spec */
            p->waddm->downsrcp = inspec1p->downsrcp;
        }
        p->waddm->ktimprd = inspec1p->ktimprd;           /* pass the other specinfo */
        p->waddm->nfreqs = inspec1p->nfreqs;
        p->waddm->dbout = inspec1p->dbout;
        p->waddm->ktimstamp = 0;                         /* mark the outspec not new */
}

void specaddm(SPECADDM *p)
{
    if ((p->wsig1->auxch.auxp==NULL) || /* RWD fix */
        (p->wsig2->auxch.auxp==NULL) ||
        (p->waddm->auxch.auxp==NULL)) {
      initerror("specaddm: not initialised");
      return;
    }
    if (p->wsig1->ktimstamp == kcounter) {             /* if inspec1 is new:     */
      float *in1p = (float *) p->wsig1->auxch.auxp;
      float *in2p = (float *) p->wsig2->auxch.auxp;
      float *outp = (float *) p->waddm->auxch.auxp;
      float mul2 = p->mul2;
      int   npts = p->wsig1->npts;

      do *outp++ = *in1p++ + *in2p++ * mul2;         /* out = in1 + in2 * mul2 */
      while (--npts);
      p->waddm->ktimstamp = kcounter;           /* mark the output spec as new */
    }
}

void spdifset(SPECDIFF *p)
{
        SPECDAT *inspecp = p->wsig;
        float *lclp;
        float *outp;
        int   npts;

        if ((npts = inspecp->npts) != p->specsave.npts) {  /* if inspec not matched  */
            SPECset(&p->specsave, (long)npts);             /*   reinit the save spec */
            SPECset(p->wdiff, (long)npts);                 /*   & the out diff spec  */
            p->wdiff->downsrcp = inspecp->downsrcp;
        }
        p->wdiff->ktimprd = inspecp->ktimprd;             /* pass the other specinfo */
        p->wdiff->nfreqs = inspecp->nfreqs;
        p->wdiff->dbout = inspecp->dbout;
        lclp = (float *) p->specsave.auxch.auxp;
        outp = (float *) p->wdiff->auxch.auxp;
        if (lclp==NULL || outp==NULL) { /* RWD  */
          initerror("specdiff: local buffers not initialised");
          return;
        }
        do {
            *lclp++ = 0.0f;                    /* clr local & out spec bufs */
            *outp++ = 0.0f;
        } while (--npts);
        p->wdiff->ktimstamp = 0;             /* mark the out spec not new */
}

void specdiff(SPECDIFF *p)
{
        SPECDAT *inspecp = p->wsig;

        if ((inspecp->auxch.auxp==NULL) /* RWD fix */
                ||
                (p->specsave.auxch.auxp==NULL)
                ||
                (p->wdiff->auxch.auxp==NULL)) {
          initerror("specdiff: not initialised");
          return;
        }
        if (inspecp->ktimstamp == kcounter) {     /* if inspectrum is new:     */
          float *newp = (float *) inspecp->auxch.auxp;
          float *prvp = (float *) p->specsave.auxch.auxp;
          float *difp = (float *) p->wdiff->auxch.auxp;
          float newval, prvval, diff, possum = 0.0f;
          int   npts = inspecp->npts;

          do {
            newval = *newp++;                   /* compare new & old coefs */
            prvval = *prvp;
            if ((diff = newval-prvval) > 0.0f) {  /* if new coef > prv coef  */
              *difp++ = diff;
              possum += diff;                 /*   enter & accum diff    */
            }
            else *difp++ = 0.0f;                /* else enter zero         */
            *prvp++ = newval;                   /* sav newval for nxt time */
          } while (--npts);
          p->wdiff->ktimstamp = kcounter;     /* mark the output spec as new */
        }
}

void spsclset(SPECSCAL *p)
{
        SPECDAT *inspecp = p->wsig;
        SPECDAT *outspecp = p->wscaled;
        FUNC    *ftp;
        long    npts;

        if ((npts = inspecp->npts) != outspecp->npts) {  /* if size has changed,   */
            SPECset(outspecp, (long)npts);               /*    realloc             */
            outspecp->downsrcp = inspecp->downsrcp;
            auxalloc((long)npts * 2 * sizeof(float), &p->auxch);
        }
        outspecp->ktimprd = inspecp->ktimprd;      /* pass the source spec info     */
        outspecp->nfreqs = inspecp->nfreqs;
        outspecp->dbout = inspecp->dbout;
        p->fscale = (float *) p->auxch.auxp;       /* setup scale & thresh fn areas */
        if (p->fscale==NULL) {  /* RWD fix */
          initerror("specscal: local buffer not initialised");
          return;
        }
        p->fthresh = p->fscale + npts;
        if ((ftp=ftfind(p->ifscale)) == NULL)      /* if fscale given,        */
            initerror("missing fscale table");
        else {
            long nn = npts;
            long phs = 0;         
            long inc = (long)PMASK / npts;
            long lobits = ftp->lobits;
            float *ftable = ftp->ftable;
            float *flp = p->fscale;
            do {
                *flp++ = *(ftable + (phs >> lobits));    /*  sample into scale area */
                phs += inc;
            } while (--nn);
        }
        if ((p->thresh = (int)*p->ifthresh)
         && (ftp=ftfind(p->ifthresh)) != NULL) {         /* if fthresh given,       */
            long nn = npts;
            long phs = 0;         
            long inc = (long)PMASK / npts;
            long lobits = ftp->lobits;
            float *ftable = ftp->ftable;
            float *flp = p->fthresh;
            do {
                *flp++ = *(ftable + (phs >> lobits));    /*  sample into thresh area */
                phs += inc;
            } while (--nn);
        }
        else p->thresh = 0;
        outspecp->ktimstamp = 0;                        /* mark the out spec not new */
}

void specscal(SPECSCAL *p)
{
        SPECDAT *inspecp = p->wsig;
        if ((inspecp->auxch.auxp==NULL) /* RWD fix */
                ||
                (p->wscaled->auxch.auxp==NULL)
                ||
                (p->fscale==NULL)) {
          initerror("specscal: not intiialised");
          return;
        }
        if (inspecp->ktimstamp == kcounter) {          /* if inspectrum is new:      */
            SPECDAT *outspecp = p->wscaled;
            float *inp = (float *) inspecp->auxch.auxp;
            float *outp = (float *) outspecp->auxch.auxp;
            float *sclp = p->fscale;
            long npts = inspecp->npts;

            if (p->thresh) {                              /* if thresh requested,    */
                float *threshp = p->fthresh;
                float val;
                do {
                    if ((val = *inp++ - *threshp++) > 0.0f) /*   for vals above thresh */
                        *outp++ = val * *sclp;    /*     scale & write out   */
                    else *outp++ = 0.0f;          /*   else output is 0.     */
                    sclp++;
                } while (--npts);
            }
            else {
                do *outp++ = *inp++ * *sclp++;            /* no thresh: rescale only */
                while (--npts);
            }
            outspecp->ktimstamp = kcounter;               /* mark the outspec as new */
        }
}

void sphstset(SPECHIST *p)
{
        SPECDAT *inspecp = p->wsig;
        float *lclp;
        float *outp;
        int   npts;

        if ((npts = inspecp->npts) != p->accumer.npts) { /* if inspec not matched   */
            SPECset(&p->accumer, (long)npts);            /*   reinit the accum spec */
            SPECset(p->wacout, (long)npts);              /*    & the output spec    */
            p->wacout->downsrcp = inspecp->downsrcp;
        }
        p->wacout->ktimprd = inspecp->ktimprd;           /* pass the other specinfo */
        p->wacout->nfreqs = inspecp->nfreqs;
        p->wacout->dbout = inspecp->dbout;
        lclp = (float *) p->accumer.auxch.auxp;
        outp = (float *) p->wacout->auxch.auxp;
        if (lclp==NULL || outp==NULL) { /* RWD fix */
          initerror("spechist: local buffers not intiialised");
          return;
        }
        do {
            *lclp++ = 0.0f;                    /* clr local & out spec bufs */
            *outp++ = 0.0f;
        } while (--npts);
        p->wacout->ktimstamp = 0;             /* mark the out spec not new */
}

void spechist(SPECHIST *p)
{
        SPECDAT *inspecp = p->wsig;
        if ((inspecp->auxch.auxp==NULL) /* RWD fix */
                ||
                (p->accumer.auxch.auxp==NULL)
                ||
                (p->wacout->auxch.auxp==NULL)) {
          initerror("spechist: not initialised");
          return;
        }
        if (inspecp->ktimstamp == kcounter) {     /* if inspectrum is new:     */
          float *newp = (float *) inspecp->auxch.auxp;
          float *acup = (float *) p->accumer.auxch.auxp;
          float *outp = (float *) p->wacout->auxch.auxp;
          float newval;
          int   npts = inspecp->npts;

          do {
            newval = *acup + *newp++;           /* add new to old coefs */
            *acup++ = newval;                   /* sav in accumulator   */
            *outp++ = newval;                   /* & copy to output     */
          } while (--npts);
          p->wacout->ktimstamp = kcounter;     /* mark the output spec as new */
        }
}

void spfilset(SPECFILT *p)
{
        SPECDAT *inspecp = p->wsig;
        SPECDAT *outspecp = p->wfil;
        FUNC    *ftp;
        long    npts;

        if ((npts = inspecp->npts) != outspecp->npts) {    /* if inspec not matched */
            SPECset(outspecp, (long)npts);                 /*   reinit the out spec */
            auxalloc((long)npts*2* sizeof(float), &p->auxch);/*   & local auxspace  */
            p->coefs = (float *) p->auxch.auxp;            /*   reassign filt tbls  */
            p->states = p->coefs + npts;
        }
        if (p->coefs==NULL || p->states==NULL) { /* RWD fix */
          initerror("specfilt: local buffers not initialised");
          return;
        }
        outspecp->ktimprd = inspecp->ktimprd;              /* pass other spect info */
        outspecp->nfreqs = inspecp->nfreqs;
        outspecp->dbout = inspecp->dbout;
        outspecp->downsrcp = inspecp->downsrcp;
        if ((ftp=ftfind(p->ifhtim)) == NULL) {          /* if fhtim table given,    */
            initerror("missing htim ftable");
            return;
        }
        {
            long nn = npts;
            long phs = 0;         
            long inc = (long)PMASK / npts;
            long lobits = ftp->lobits;
            float *ftable = ftp->ftable;
            float *flp = p->coefs;
            do {
                *flp++ = *(ftable + (phs >> lobits));    /*  sample into coefs area */
                phs += inc;
            } while (--nn);
        }
        {
            long  nn = npts;
            float *flp = p->coefs;
            double halftim, reittim = inspecp->ktimprd * onedkr;
            do {
                if ((halftim = *flp) > 0.)
                    *flp++ = (float)pow(0.5, reittim/halftim);
                else initerror("htim ftable must be all-positive");
            } while (--nn);
        }
  printf("coef range: %6.3f - %6.3f\n", *p->coefs, *(p->coefs+npts-1));
        {
            float *flp = (float *) p->states;
            do  *flp++ = 0.0f;                       /* clr the persist buf state mem */
            while (--npts);
        }
        outspecp->ktimstamp = 0;                 /* mark the output spec as not new */
}

void specfilt(SPECFILT *p)
{
        if (p->wsig->ktimstamp == kcounter) {          /* if input spec is new,  */
            SPECDAT *inspecp = p->wsig;
            SPECDAT *outspecp = p->wfil;
            float *newp = (float *) inspecp->auxch.auxp;
            float *outp = (float *) outspecp->auxch.auxp;
            float curval, *coefp = p->coefs;
            float *persp = p->states;
            int   npts = inspecp->npts;

            if (newp==NULL || outp==NULL || coefp==NULL || persp==NULL) { /* RWD */
              initerror("specfilt: not initialized");
              return;
            }
            do {                                         /* for npts of inspec:     */
                *outp++ = curval = *persp;               /*   output current point  */
                *persp++ = *coefp++ * curval + *newp++;  /*   decay & addin newval  */
            } while (--npts);
            outspecp->ktimstamp = kcounter;              /* mark output spec as new */
        }
}
