/*
 * $Id: version.h,v 1.9 1998/08/18 19:01:22 nicb Exp $
 *
 * Csound Linux source version.h replacement
 *
 * Since quite a lot of things (including configuration processes, etc.)
 * rely on the format of this file to run properly, we have replaced
 * the standard version.h (which was sitting in the canonical directory)
 * with this one (future patches should be easy, anyway, and we will have
 * better control on what happens in this file)
 * 					[nicb@axnet.it]
 */
#if !defined(_new_src_version_h_)
#	define _new_src_version_h_

/*
 * Please do *not* put parenthesis around the numbers (yes, I know it's
 * common practice to avoid unwanted precedence assignements on mathematical
 * operators, but here it breaks the delicate stringing mechanism of the
 * version numbering	
 * 					[nicb@axnet.it]
 */

/*
 * the first two numbers are defined by the canonical source version
 * numbering
 */

# define VERSION 3
# define SUBVER  484

/*
 * the third value (*MUST* be a string) is the current Linux patchlevel for
 * the canonical version. At the moment, this is unique to this distribution.
 */

# define LINUX_PATCHLEVEL "0d"

/*
 * Do not touch the preprocessor code below here unless you know what you're
 * doing - it's a fairly delicate piece of hack (which probably means it's
 * also fairly ugly, but I have no other ideas) and it breaks easily. Mind
 * you, it respects cpp ansi standards (including collating adjacent strings
 * in C code) - if it does not work for you, it means you don't have an
 * ansi-compliant C compiler (would'nt you give gcc a try?)...
 * 					[nicb@axnet.it]
 */

# define VERSION_STRINGED_VARIABLE(a)	#a
# define VERSIONSTRING_COLLATE(M,m,lp) \
	" v" ## VERSION_STRINGED_VARIABLE(M) ## "." ## VERSION_STRINGED_VARIABLE(m) ## "." ## lp
# define VERSIONSTRING   VERSIONSTRING_COLLATE(VERSION,SUBVER,LINUX_PATCHLEVEL)

#endif /* !defined(_new_src_version_h_) */
/*
 * $Log: version.h,v $
 * Revision 1.9  1998/08/18 19:01:22  nicb
 * [changes by nicb@axnet.it]
 *
 * - added missing aifc.c file (AIFF floating point support)
 * - re-included AIFC calls into sfheader.c
 * - added excute() utility function to run sub-programs
 * - cleaned up sub-programs main code to avoid link problems
 * - re-organized linux code portion of Make files
 * - corrected bug in midi opcodes (referencing to NULL m_chnbp's)
 * - excluded ustub.h (not needed in linux code)
 *
 * Revision 1.8  1998/08/17 13:38:33  nicb
 * [changes by nicb@axnet.it]
 *
 * - removed Glibc.patch from Make.Variables source distribution (Glibc.patch
 *   should no longer be required and has been put in the repository's attic)
 * - corrected bug in Make.Targets which avoided removing libraries in
 *   'make clean'
 *
 * Revision 1.7  1998/08/11 01:49:52  nicb
 * [changes by nicb@axnet.it]
 *
 * - added perror() calls to track down system call failures (not everywhere,
 *   just the termios bit in the midi receive code)
 * - fixed bug in rdscor() which was crashing cscore executables
 * - fixed an already fixed (but disappeared) problem with version display
 * - fixed an already fixed (but disappeared) problem with sortex and sndinfo
 *   utilities (duplicate symbols at linking)
 *
 * Revision 1.6  1998/08/10 16:03:38  nicb
 * [changes by nicb@axnet.it]
 *
 * - first merge of canonical 3.484 code - all modified files BUT the ones
 *   listed in README.NO_LINUX_UPDATE contain changes made by canonical
 *   developers
 *
 * - additions in canonical sources: Maldonado's flanger
 *
 * - corrected midirecv.c and otran.c for better midi behaviour, and missing
 *   aifc source references were commented out in order to compile
 *
 * Revision 1.5  1998/07/20 13:08:50  nicb
 * [changes by nicb@axnet.it]
 *
 * Prepared distribution of release 3.482.1a
 *
 * - updated the README.Linux file
 * - removed the new-src/config.h file which got in the repository by mistake
 *   (it is the config.h.in that should be in the repository, and configure
 *   builds config.h out of it)
 *
 * Revision 1.4  1998/07/17 18:11:18  nicb
 * [changes and additions by nicb@axnet.it]
 *
 * - configure process:
 * 	- added canonical host detection and install detection
 * 	- modified Makefiles to suit the install macro better
 * 	- static linking does not imply -static anymore (not standalone,
 * 	  just with csound library integration)
 *
 * - sources:
 * 	- integrated back some changes made to suit the dynamical
 * 	  main/library linking that somehow got lost in the original
 * 	  sources (wonder how it did work up to now, but anyway it
 * 	  was not working for static linking)
 *
 * Revision 1.3  1998/07/13 15:21:32  nicb
 * [changes by nicb@axnet.it]
 *
 * - better conformance of the configure.in script to autoconf standards
 *
 * Revision 1.2  1998/07/13 12:45:29  nicb
 * [changes by nicb@axnet.it, suggested by dmiller@ilogic.com.au]
 *
 * - corrected bug in configure.in which would not handle /usr/bin/test
 *   programs correctely in configure scripts
 * - added symbol table stripping for static linking when no debug nor
 *   profiling is required
 *
 * Revision 1.1  1998/07/12 18:21:18  nicb
 * [additions by nicb@axnet.it]
 *
 * These additions fit the new repository structure handled by autoconf
 * and the configure script. This directory will host all the new sources
 * developed by the csound unix development group.
 *
 * - added Makefile for directory handling
 * - added config.h.in to be handled by the 'configure' process
 * - added version.h which replaces the canonical version.h and adds
 *   linux patchlevel functionality
 *
 */
