/********************************************************************************
 * Copyright (c) Erik Kunze 1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: io.c,v 4.5 1998/02/07 17:28:52 erik Rel $";
#endif

#include <stdio.h>
#include <string.h>
#include "config.h"
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#include "emul.h"
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef JOY
#include "joystick.h"
#endif
#include "loadsave.h"
#ifdef PRINTER
#include "printer.h"
#endif
#include "screen.h"
#include "tables.h"
#include "io.h"


static inline void outBankm128(uns8);
#ifdef XZX_PLUS3
static inline void outBankmPl3(uns8);
#ifdef REGISTERED
static inline void outBank678(uns8);
#endif
#endif


uns8 Last0x7FFD;
#ifdef XZX_PLUS3
uns8 Last0x1FFD;
#endif
uns8 Last0xFFFD;
int ScreenSelect;
uns8 KeyPorts[9];
uns8 InPorts[256];
uns8 LastBorderColor = 255;
uns8 PSG[16];

static uns8 outPorts[256];
#ifdef XZX_MF128
static int mf128on;
#endif

void
IoReset(void)
{
	int i;
	InitPages();
	Last0x7FFD = 0;
#ifdef XZX_PLUS3
	Last0x1FFD = 0;
#endif
	Last0xFFFD = 0;
	ScreenSelect = RAM5;
#ifdef XZX_MF128
	mf128on = 0;
#endif

	(void)memset(KeyPorts, 0xff, sizeof(KeyPorts));
	(void)memset(InPorts, 0x00, sizeof(InPorts));
	(void)memset(outPorts, 0x00, sizeof(outPorts));

	for (i = 0; i < sizeof(PSG); i++)
	{
		OutByte(P_SNDCONTROL, (uns8)i);
		OutByte(P_SNDDATA, 0);
	}
#if defined(XZX_PLUS3) && defined(REGISTERED)
	if (GETCFG(machine) == SP_3)
	{
		FdcReset();
	}
#endif
}



static inline void
outBankm128(uns8 val)
{
#ifdef DEBUG
	if (GETCFG(debug) & D_IO)
	{
		Msg(M_DEBUG,
			"bankm: RAM select %d, ROM select %d, screen %d, paging %sabled",
			val & B_SELRAM, (val & B_SELROM) >> 4, (val & B_SELSCREEN) >> 3,
			PAGING_DISABLED(Last0x7FFD) ? "dis" : "en");
	}
#endif
	if (Last0x7FFD == val || PAGING_DISABLED(Last0x7FFD))
	{
		return;
	}

	ScreenSelect = val & B_SELSCREEN ? RAM7 : RAM5;
	if ((val & B_SELSCREEN) != (Last0x7FFD & B_SELSCREEN))
	{
		ForceScreenRefresh();
	}

	Last0x7FFD = val;

	PageIn(3, RAM0 + (val & B_SELRAM));
#ifdef XZX_MF128

	if (!mf128on)
#endif
	{

		PageIn(0, SP128ROM0 + ((val & B_SELROM) >> 4));
	}
}


#ifdef XZX_PLUS3
static inline void
outBankmPl3(uns8 val)
{
#ifdef DEBUG
	if (GETCFG(debug) & D_IO)
	{
		Msg(M_DEBUG,
			"bankm: RAM select %d, ROM select %d, screen %d, paging %sabled",
			val & B_SELRAM, (val & B_SELROM) >> 4, (val & B_SELSCREEN) >> 3,
			PAGING_DISABLED(Last0x7FFD) ? "dis" : "en");
	}
#endif
	if (Last0x7FFD == val || PAGING_DISABLED(Last0x7FFD))
	{
		return;
	}

	ScreenSelect = val & B_SELSCREEN ? RAM7 : RAM5;
	if ((val & B_SELSCREEN) != (Last0x7FFD & B_SELSCREEN))
	{
		ForceScreenRefresh();
	}

	Last0x7FFD = val;

	if (!EXTENDED_RAM(Last0x1FFD))
	{

		PageIn(3, RAM0 + (val & B_SELRAM));

		PageIn(0, SP3ROM0 +
				   (((Last0x1FFD & B_SELROM3) >> 1) | ((val & B_SELROM) >> 4)));
#ifdef DEBUG
		if (GETCFG(debug) & D_IO)
		{
			Msg(M_DEBUG, "bankm: horizontal ROM switch");
		}
#endif
	}
}
#endif

#ifdef XZX_PLUS3
#ifdef REGISTERED
static inline void
outBank678(uns8 val)
#else
void
OutBank678(uns8 val)
#endif
{
#ifdef DEBUG
	if (GETCFG(debug) & D_IO)
	{
		Msg(M_DEBUG, "bank678: %s", EXTENDED_RAM(Last0x1FFD) ?
			"extended RAM enabled" : "vertical ROM switch");
	}
#endif
	if (Last0x1FFD == val || PAGING_DISABLED(Last0x7FFD))
	{
		return;
	}
	if (!EXTENDED_RAM(val))
	{
		PageIn(0, SP3ROM0 +
				   (((Last0x7FFD & B_SELROM) >> 4) | ((val & B_SELROM3) >> 1)));
	}
	else
	{
		switch ((val & B_SELRAM3) >> 1)
		{
			case 0:
				PageIn(0, RAM0);
				PageIn(1, RAM1);
				PageIn(2, RAM2);
				PageIn(3, RAM3);
#ifdef DEBUG
				if (GETCFG(debug) & D_IO)
				{
					Msg(M_DEBUG, "bank678: 0,1,2,3");
				}
#endif
				break;
			case 1:
				PageIn(0, RAM4);
				PageIn(1, RAM5);
				PageIn(2, RAM6);
				PageIn(3, RAM7);
#ifdef DEBUG
				if (GETCFG(debug) & D_IO)
				{
					Msg(M_DEBUG, "bank678: 4,5,6,7");
				}
#endif
				break;
			case 2:
				PageIn(0, RAM4);
				PageIn(1, RAM5);
				PageIn(2, RAM6);
				PageIn(3, RAM3);
#ifdef DEBUG
				if (GETCFG(debug) & D_IO)
				{
					Msg(M_DEBUG, "bank678: 4,5,6,3");
				}
#endif
				break;
			case 3:
				PageIn(0, RAM4);
				PageIn(1, RAM7);
				PageIn(2, RAM6);
				PageIn(3, RAM3);
#ifdef DEBUG
				if (GETCFG(debug) & D_IO)
				{
					Msg(M_DEBUG, "bank678: 4,7,6,3");
				}
#endif
				break;
		}
	}
#ifdef PLUS3_PRINTER
	if ((val ^ Last0x1FFD) & B_STROBE)
	{
		Plus3PrinterStrobe(val);
	}
#endif
	Last0x1FFD = val;
}
#endif

void
OutByte(uns16 port, uns8 val)
{
#ifdef DEBUG
	if (GETCFG(debug) & D_IO && LOWBYTE(port) != P_ULA)
	{
		Msg(M_DEBUG, "writing <%02x> to port <%04x>", val, port);
	}
#endif

	if (!(port & B_ULA))
	{


		if (LastBorderColor != (val & B_BORDER))
		{
			LastBorderColor = val & B_BORDER;
#ifndef REGISTERED
			if (GETCFG(border))
#endif
			{
				SetBorderColor(LastBorderColor);
			}
		}
#if defined(SUN_AUDIO) || defined(PCSPKR_AUDIO)

		SpeakerOutByte(val);
#endif
#ifdef EMULATE_ULA_DELAY

		if (Vline >= TOP_BORDER
			&& Vline < (TOP_BORDER + SCR_LINES)
			&& Tstates < 128)
		{
			Tstates += 4;
		}
#endif
	}

	if (LOWBYTE(port) == P_128)
	{

		if ((port & B_SNDCHIP) == (P_SNDCONTROL & B_SNDCHIP))
		{

			if (port & B_SNDCONTROL)
			{
				Last0xFFFD = val;
			}
			else
			{

				PSG[Last0xFFFD] = val;

				if (Last0xFFFD == 14)
				{
#ifdef DEBUG
					if (GETCFG(debug) & D_IO)
					{
						Msg(M_DEBUG, "writing AY register 14");
					}
#endif

				}
#ifdef AYCHIP_AUDIO
				else if (Last0xFFFD < 14)
				{
					AyOutByte(Last0xFFFD, val);
				}
#endif
			}
		}
		else
		{
			switch(GETCFG(machine))
			{
#ifdef PEDANTIC
				case SP_48_2:
				case SP_48_3:
					Msg(M_WARN, "output to 128K/+3 port <%04x> in 48K mode",
						port);
					break;
#endif
				case SP_128:
					if ((port & B_BANK128) == (P_BANK128 & B_BANK128))
					{

						outBankm128(val);
					}
					break;
#ifdef XZX_PLUS3
				case SP_3:
					switch(port)
					{
						case P_BANK128:

							outBankmPl3(val);
							break;
						case P_BANK3:

#ifdef REGISTERED
							outBank678(val);
#else
							OutBank678(val);
#endif
							break;
#ifdef REGISTERED
#ifdef PLUS3_PRINTER
						case P_CENTRONICS:
							Plus3PrinterOutByte(val);
							break;
#endif
						case P_FDCDATA:
							FdcDataOutByte(val);
							break;
#endif
					}
					break;
#endif
			}
		}
	}
#ifdef ZX_PRINTER

	if (!(port & B_PRINTER))
	{
		ZxPrinterOutByte(val);
	}
#endif
#ifdef XZX_IF1

	if (GETCFG(if1_active))
	{
		if (LOWBYTE(port) == P_MDCONTROL)
		{
			If1ControlOutByte(val);
		}
		else if (LOWBYTE(port) == P_MDDATA)
		{
			If1DataOutByte(val);
		}
	}
#endif
#ifdef PSEUDO_IO
	if (port == PSEUDO_STDOUT)
	{
		(void)putc((int)val, stdout);
	}
	else if (port == PSEUDO_STDERR)
	{
		(void)putc((int)val, stderr);
	}
#endif
	outPorts[LOWBYTE(port)] = val;
}

uns8
InByte(uns16 port)
{
#ifdef DEBUG
	if (GETCFG(debug) & D_IO && LOWBYTE(port) != P_ULA)
	{
		Msg(M_DEBUG, "reading from port <%04x>", port);
	}
#endif


	if (!(port & B_KEMPSTON))
	{
#ifdef JOY
		if (GETCFG(useJoy))
		{
			InPorts[P_KEMPSTON] = (uns8)JoyRead();
		}
#endif

		return (InPorts[P_KEMPSTON] &
				(B_RIGHT | B_LEFT | B_DOWN | B_UP | B_FIRE));
	}

	if (!(port & B_ULA))
	{

		uns8 res = Machine->ula;

		if (!(port & 0x8000))
		{
			res &= KeyPorts[7];
		}
		if (!(port & 0x4000))
		{
			res &= KeyPorts[6];
		}
		if (!(port & 0x2000))
		{
			res &= KeyPorts[5];
		}
		if (!(port & 0x1000))
		{
			res &= KeyPorts[4];
		}
		if (!(port & 0x0800))
		{
			res &= KeyPorts[3];
		}
		if (!(port & 0x0400))
		{
			res &= KeyPorts[2];
		}
		if (!(port & 0x0200))
		{
			res &= KeyPorts[1];
		}
		if (!(port & 0x0100))
		{
			res &= KeyPorts[0];
		}
		res ^= TpGetNextBit();
#ifdef EMULATE_ULA_DELAY

		Tstates += 1;
#endif
		return res;
	}

	if (LOWBYTE(port) == P_128)
	{

		if ((port & (B_SNDCHIP | B_SNDDATA)) ==
			(P_SNDCONTROL & (B_SNDCHIP | B_SNDCONTROL)))
		{

			if (Last0xFFFD == 14)
			{
#ifdef DEBUG
				if (GETCFG(debug) & D_IO)
				{
					Msg(M_DEBUG, "reading AY register 14");
				}
#endif

				return 0xff;
			}
			else
			{
				return (PSG[Last0xFFFD]);
			}
		}
		switch (GETCFG(machine))
		{
#ifdef PEDANTIC
			case SP_48_2:
			case SP_48_3:
				Msg(M_WARN, "input from 128K/+3 port <%04x> in 48K mode", port);
				break;
#endif
			case SP_128:
				break;
#ifdef XZX_PLUS3
			case SP_3:
				switch(port)
				{
#ifdef REGISTERED
#ifdef PLUS3_PRINTER
					case P_CENTRONICS:
						return (Plus3PrinterInByte());
#endif
					case P_FDCCONTROL:
						return (FdcControlInByte());
					case P_FDCDATA:
						return (FdcDataInByte());
#endif
				}
				break;
#endif
		}
	}
#ifdef ZX_PRINTER

	if (!(port & B_PRINTER))
	{
		return (ZxPrinterInByte());
	}
#endif
#ifdef XZX_IF1

	if (GETCFG(if1_active))
	{
		if (LOWBYTE(port) == P_MDCONTROL)
		{
			return (If1ControlInByte());
		}
		else if (LOWBYTE(port) == P_MDDATA)
		{
			return (If1DataInByte());
		}
	}
#endif
#ifdef XZX_MF128

	if (GETCFG(mf128_active))
	{
		if (LOWBYTE(port) == P_MF128OUT && mf128on)
		{

			mf128on = 0;
			PageIn(0, GETCFG(machine) <= SP_48_3 ?
								SP48ROM :
								SP128ROM0 + ((Last0x7FFD & B_SELROM) >> 4));

			return 0xff;
		}
		else if (LOWBYTE(port) == P_MF128IN)
		{

			PageIn(0, MF128ROM);
			mf128on = 1;

			return (Last0x7FFD & B_SELSCREEN ? 0xff : 0x7f);
		}
	}
#endif
#ifdef PSEUDO_IO
	if (port == PSEUDO_STDIN)
	{
		return ((uns8)getchar());
	}
#endif

	if (ULA_DRAWS_SCREEN)
	{
		return (RealMemory[ScreenSelect][(Tstates & 0x02 ?
										  Line2Attr[Vline - TOP_BORDER] :
										  Line2Pix[Vline - TOP_BORDER]) +
										(Tstates >> 2)]);
	}
	return 0xff;
}

