/* This file is Copyright 1993 by Clifford A. Adams */
/* svdata.h
 *
 * Data structures and functions for virtual scan
 */

/* sv-groupdata has a bit of a different 
/* per-newsgroup data */
typedef struct sv_groupdata {
    char *name;
    long lastart;	/* last article considered for adding */
    long flags;
    /* flags:
     * 1	group was added as a whole.
     * 2	group was deleted (with !group, maybe -group)
     * 4	group has individual articles to be added
     */
    /* later add all kinds of nifty extra data for each newsgroup involved
     * in the virtual group
     */
} SV_GROUPDATA;

EXT int sv_num_groups		INIT(0);
EXT int sv_groups_alloc		INIT(0);
EXT SV_GROUPDATA *sv_groups	INIT((SV_GROUPDATA*)NULL);

/* per-article data */
/* could be a union, but why bother? */
typedef struct sv_entrydata {
    int  type;
    /* 1: normal article
     */  
    long flags;
    char *msgid;
    int group;		/* index into sv_groups */
    ART_NUM artnum;	/* article number within group */
    /* redo descriptions later */
    char *desc;		/* what to display for the description */
    char *author;	/* author text */
    char *subject;	/* subject text */
    long score;
} SV_ENTRYDATA;

/* note: the 0th entry of sv_ents is unused (scan compatibility) */
EXT int sv_num_ents		INIT(0);
EXT int sv_ents_alloc		INIT(0);
EXT SV_ENTRYDATA *sv_ents	INIT((SV_ENTRYDATA*)NULL);

/* virtual scan entry flags:
 *  0: If set, the article is "marked" for later actions.
 */
#define sv_mark(e) sv_ents[e].flags |= 1
#define sv_clearmark(e) sv_ents[e].flags &= 0xfe
#define sv_marked(e) (sv_ents[e].flags & 1)

/* this structure might be reordered for more efficient packing. */
typedef struct sv_context {
    int  cnum;			/* context number */
    int  num_ents;		/* number of entries */
    int  ents_alloc;		/* number of allocated entries */
    int  num_groups;		/* number of groups */
    int  groups_alloc;		/* number of allocated groups */
    char *title;		/* for this context */
    char *filename;
    SV_ENTRYDATA *ents;		/* entries */
    SV_GROUPDATA *groups;	/* groups */
    /* flags follow */
    bool follow;
    bool e_unread;		/* eligibility */
    bool e_minused;
    long e_minscore;
    bool e_maxused;
    long e_maxscore;
    bool score_order;
    bool show_author;
    bool show_subjects_only;
    bool show_groups;
} SV_CONTEXT;

EXT int sv_num_contexts		INIT(0);
EXT int sv_max_contexts		INIT(0);
EXT SV_CONTEXT *sv_contexts	INIT((SV_CONTEXT*)NULL);

/* currently open newsgroup for individual articles */
EXT char *sv_cur_group INIT(Nullch);
EXT int sv_cur_gnum INIT(-1);	/* group number, for faster access */

/* are we refreshing the virtual newsgroup? */
EXT bool sv_refreshing INIT(FALSE);

void	sv_init_context	_((void));
void	sv_save_context	_((void));
void	sv_restore_context _((void));
void	sv_new_context	_((void));
void	sv_old_context	_((void));
void	sv_cleanup	_((void));

bool	sv_init_ents	_((void));
int	sv_add_ent	_((int));
void	sv_free_ents	_((void));

void	sv_init_groups	_((void));
void	sv_free_groups	_((void));
int	sv_add_group	_((char *));
void	sv_go_group	_((char *));
bool	sv_add_article	_((ART_NUM,char *));
void	sv_sub_id	_((char *));
ART_NUM	sv_msgid_to_num	_((char *));

void	sv_close_current _((void));
/* junks (marks-as-read) an entry */
void	sv_junk_ent	_((long));
void	sv_unjunk_ent	_((long));
long	sv_first_marked_elig _((void));

int	sv_go_art	_((int,ART_NUM));
void	sv_refresh	_((void));
void	sv_use_group	_((char *,bool_int));
void	sv_close_group	_((bool_int));
