
/*
 * DREADART [-v] 'messageid'
 * DREADART [-v] < file
 */

#include "defs.h"

int LookupHash(hash_t hv, const char *msgid);

int VerifyOnly = 0;
FILE *LogFo;

int
main(int ac, char **av)
{
    int r = 0;
    int i;
    char *arg = NULL;
    char *file = NULL;

    LogFo = stderr;

    LoadDiabloConfig();

    for (i = 1; i < ac; ++i) {
	char *ptr = av[i];

	if (*ptr != '-') {
	    arg = ptr;
	    continue;
	}
	ptr += 2;
	switch(ptr[-1]) {
	case 'v':
	    VerifyOnly = 1;
	    LogFo = stdout;
	    break;
	case 'f':
	    file = (*ptr) ? ptr : av[++i];
	    break;
	default:
	    fprintf(stderr, "dreadart: Illegal option: %s\n", ptr - 2);
	    exit(1);
	}
    }

    if (arg == NULL && file == NULL) {
	printf("dreadart <message-id>\n");
	printf("dreadart hv1.hv2\n");
	printf("dreadart -f -/file\n");
	exit(0);
    }

    HistoryOpen(NULL, 0);

    if (arg == NULL) {
	char buf[1024];
	FILE *fi = (strcmp(file, "-") == 0) ? stdin : fopen(file, "r");

	if (fi) {
	    while (fgets(buf, sizeof(buf), fi) != NULL) {
		hash_t hv;
		char path[256];
		char msgid[256];

		path[0] = 0;

		if (strncmp(buf, "DUMP ", 5) == 0) {
		    hv.h1 = 0;
		    hv.h2 = 0;
		    if (sscanf(buf + 5, "%s", msgid) == 1) {
			char *p;

			hv.h1 = (int32)strtoul(msgid, &p, 16);
			if (*p == '.') {
			    hv.h2 = (int32)strtoul(p + 1, NULL, 16);
			}
			LookupHash(hv, NULL);
		    }
		} else if (sscanf(buf, "%s %s", path, msgid) == 2) {
		    hv = hhash(msgid);
		    LookupHash(hv, msgid);
		}
	    }
	    if (fi != stdin)
		fclose(fi);
	} else {
	    fprintf(stderr, "Unable to open %s\n", file);
	}
    } else {
	hash_t hv;
	char *msgid = NULL;

	if (arg[0] == '<') {
	    msgid = arg;
	    hv = hhash(arg);
	} else if (arg[0] == 'D' && arg[1] == '.') {
	    int32 dummy;

	    if (sscanf(arg + 2, "%x/%x.%x", &dummy, &hv.h1, &hv.h2) != 3) {
		fprintf(stderr, "argument error\n");
		exit(1);
	    }
	} else if (sscanf(arg, "%x.%x", &hv.h1, &hv.h2) != 2) {
	    fprintf(stderr, "argument error\n");
	    exit(1);
	}
	LookupHash(hv, msgid);
    }
    exit(r);
}

int
LookupHash(hash_t hv, const char *msgid)
{
    History h;
    int rv = 0;

    if (msgid)
	fprintf(LogFo, "%60s\t", msgid);
    else
	fprintf(LogFo, "%08x.%08x\t", hv.h1, hv.h2);

    if (HistoryLookupByHash(hv, &h) == 0) {
	char buf[8192];

	if (h.exp != (unsigned short)-1) {
	    int fd;

	    sprintf(buf, "%s/D.%08x/B.%04x", 
		SpoolHome, 
		h.gmt - h.gmt % 10,
		h.iter
	    );


	    if ((fd = open(buf, O_RDONLY)) >= 0) {
		const char *base;
		const char *ptr;
		int extra = (h.boffset == 0) ? 0 : 1;

		errno = 0;

		base = xmap(
		    NULL, 
		    h.bsize + extra + 1, 
		    PROT_READ,
		    MAP_SHARED, 
		    fd, 
		    h.boffset - extra
		);

		if (base == NULL) {
		    fprintf(LogFo, "Unable to map file %s: %s\n", buf, strerror(errno));
		    rv = 1;
		}

		/*
		 * check for prior terminating zero, article body does not 
		 * begin with a null, and post terminating zero
		 */

		ptr = base;

		if (rv == 0 && extra) {
		    if (*ptr != 0) {
			fprintf(LogFo, " missingPreNul");
			rv = 1;
		    }
		    ++ptr;
		}
		if (rv == 0 && ptr[0] == 0) {
		    fprintf(LogFo, " nullArtBody");
		    rv = 1;
		}

		if (rv == 0 && ptr[h.bsize] != 0) {
		    fprintf(LogFo, " missingPostNul");
		    rv = 1;
		}

		/*
		 * Locate Message-ID header and test
		 */

		if (rv == 0 && msgid) {
		    const char *l;
		    int haveMsgId = 0;

		    for (l = ptr - 1; l; l = strchr(l, '\n')) {
			++l;
			if (strncasecmp(l, "Message-ID:", 11) == 0) {
			    int i;

			    haveMsgId = 1;

			    l += 11;
			    while (*l && *l != '<' && *l != '\n')
				++l;
			    for (i = 0; l[i] && l[i] != '>' && l[i] != '\n'; ++i) {
				if (msgid[i] != l[i])
				    rv = 1;
			    }
			    if (msgid[i] != l[i])
				rv = 1;
			}
			if (l[0] == '\n')	/* end of headers */
			    break;
		    }
		    if (rv) {
			fprintf(LogFo, " messageID-MisMatch");
		    } else if (haveMsgId == 0) {
			fprintf(LogFo, " missing-MessageID");
			rv = 1;
		    }
		}
		if (rv == 0)
		    fprintf(LogFo, "OK");
		fprintf(LogFo, "\n");
		if (rv == 0 && VerifyOnly == 0) {
		    fflush(LogFo);
		    write(1, ptr, h.bsize);
		    fflush(stdout);
		}
		xunmap((void *)base, h.bsize + extra + 1);
		close(fd);
	    } else {
		fprintf(LogFo, "Unable to open %s\n", buf);
		rv = 1;
	    }
	} else {
	    fprintf(LogFo, "Article expired\n");
	    rv = 1;
	}
    } else {
	fprintf(LogFo, "Article not found in history\n");
	rv = 1;
    }
    return(rv);
}

