
/*
 * LIB/CONFIG.C	- Scan configuration file
 *
 */

#include "defs.h"

Prototype void LoadDiabloConfig(void);

Prototype int DiabloExpire;
Prototype int DiabloHashMethod;
Prototype int DiabloCompatHashMethod;
Prototype int DiabloHashSize;
Prototype char *DiabloActive;
Prototype int DiabloRememberDays;
Prototype int MaxPerRemote;
Prototype int DiabloXRefSlave;
Prototype int DiabloReaderForks;
Prototype int DiabloReaderThreads;

int SetHashMethod(const char *opt, int *pmethod);

int DiabloExpire;
int DiabloHashMethod;
int DiabloCompatHashMethod = -1;
int DiabloHashSize;
int DiabloXRefSlave;
int DiabloReaderForks = 10;
int DiabloReaderThreads = 20;
char *DiabloActive;
int DiabloRememberDays = REMEMBERDAYS;
int MaxPerRemote;

void
LoadDiabloConfig(void)
{
    FILE *fi;
    char buf[256];
    int versOk = 0;
    int exitMe = 0;

    if ((fi = xfopen("r", "%s/diablo.config", NewsHome)) != NULL) {

	if (DiabloActive) {
	    free(DiabloActive);
	    DiabloActive = NULL;
	}

	while (fgets(buf, sizeof(buf), fi) != NULL) {
	    char *cmd;
	    char *opt = NULL;
	    int cmdErr = 1;

	    if (buf[0] == '\n' || buf[0] == '#')
		continue;
	    if ((cmd = strtok(buf, " \t\n")) != NULL &&
		(opt = strtok(NULL, " \t\n")) != NULL
	    ) {
		int optErr = 1;

		cmdErr = 0;
		if (strcasecmp(cmd, "version") == 0) {
		    optErr = 0;
		    if (strtod(opt, NULL) > VERS)
			versOk = 0;
		    else
			versOk = 1;
		} else if (versOk == 0) {
		    optErr = 0;
		} else if (strcasecmp(cmd, "expire") == 0) {
		    if (opt) {
			if (strcasecmp(opt, "feeder") == 0) {
			    DiabloExpire = EXPIRE_FEEDER;
			    optErr = 0;
			} else if (strcasecmp(opt, "reader") == 0) {
			    DiabloExpire = EXPIRE_READER;
			    optErr = 0;
			}
		    } 
		} else if (strcasecmp(cmd, "hash") == 0) {
		    if (opt) {
			char *p2;
			if ((p2 = strchr(opt, '/')) != NULL)
			    *p2++ = 0;
			optErr = SetHashMethod(opt, &DiabloHashMethod);
			if (p2)
			    optErr = SetHashMethod(p2, &DiabloCompatHashMethod);
		    }
		} else if (strcasecmp(cmd, "remember") == 0) {
		    if (opt) {
			DiabloRememberDays = strtol(opt, NULL, 0);
			optErr = 0;
		    }
		} else if (strcasecmp(cmd, "maxconnect") == 0) {
		    if (opt) {
			MaxPerRemote = strtol(opt, NULL, 0);
			optErr = 0;
		    }
		} else if (strcasecmp(cmd, "hsize") == 0) {
		    if (opt) {
			int n = strtol(opt, &opt, 0);

			switch(*opt) {
			case 'm':
			case 'M':
			    n *= 1024;
			    /* fall through */
			case 'k':
			case 'K':
			    n *= 1024;
			    optErr = 0;
			    break;
			default:
			    break;
			}
			if (n < 256 * 1024 || n > 128 * 1024 * 1024) {
			    optErr = 1;
			    syslog(LOG_CRIT, "Illegal Hash size: %d", n);
			}
			if ((n ^ (n - 1)) != (n << 1) - 1) {
			    syslog(LOG_CRIT, "Hash size not a power of 2: %d", n);
			    optErr = 1;
			}
			if (optErr == 0)
			    DiabloHashSize = n;
		    }
		} else if (strcasecmp(cmd, "active") == 0) {
		    if (opt) {
			if (strcasecmp(opt, "on") == 0) {
			    optErr = 0;
			    DiabloActive = malloc(strlen(NewsHome) + 32);
			    sprintf(DiabloActive, "%s/dactive.kp", NewsHome);
			} else if (strcasecmp(opt, "off") == 0) {
			    optErr = 0;
			    DiabloActive = NULL;
			} else if (opt[0] == '/') {
			    optErr = 0;
			    DiabloActive = strdup(opt);
			}
		    }
		} else if (strcasecmp(cmd, "slave") == 0) {
		    if (opt) {
			if (strcasecmp(opt, "on") == 0) {
			    optErr = 0;
			    DiabloXRefSlave = 1;
			} else if (strcasecmp(opt, "off") == 0) {
			    optErr = 0;
			    DiabloXRefSlave = 0;
			}
		    }
		} else if (strcasecmp(cmd, "readerforks") == 0) {
		    if (opt) {
			DiabloReaderForks = strtol(opt, NULL, 0);
			optErr = 0;
		    }
		} else if (strcasecmp(cmd, "readerthreads") == 0) {
		    if (opt) {
			DiabloReaderThreads = strtol(opt, NULL, 0);
			optErr = 0;
		    }
		} else {
		    cmdErr = 1;
		    optErr = 0;
		}
		if (optErr) {
		    exitMe = 1;
		    syslog(LOG_CRIT, "Unknown diablo.config command: %s %s",
			cmd, ((opt) ? opt : "")
		    );
		}
	    }
	    if (cmdErr && cmd) {
		exitMe = 1;
		syslog(LOG_CRIT, "Unknown diablo.config command: %s %s",
		    cmd, ((opt) ? opt : "")
		);
	    }
	}
	fclose(fi);
    } else {
	syslog(LOG_CRIT, "Unable to open diablo.config");
	exitMe = 1;
    }
    if (exitMe) {
	fprintf(stderr, "critical error parsing diablo.config, exiting.  See syslog\n");
	exit(1);
    }
}

int
SetHashMethod(const char *opt, int *pmethod)
{
    int optErr = 0;

    if (strcasecmp(opt, "prime") == 0) {
	*pmethod = HASH_PRIME;
    } else if (strcasecmp(opt, "crc") == 0) {
	*pmethod = HASH_CRC;
    } else if (strcasecmp(opt, "ocrc") == 0) {
	*pmethod = HASH_OCRC;
    } else {
	optErr = 1;
    }
    return(optErr);
}

