
/*
 * DREADERD/MASTER.C	- accept new connections, maintain children.
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 */

#include "defs.h"

Prototype void RunMaster(int lfd);

int MaxFds;
fd_set RFds;

typedef struct DRDConfig {

} DRDConfig;

void 
RunMaster(int lfd)
{
    time_t tlast = 0;
    int dt = 0;

    /*
     * load dreaderd.conf, setup shared
     * memory segment, and so on.
     */

    InitDRDShm();
    LoadDRDConfig(1);

    /*
     * master loop
     */

    MaxFds = lfd + 1;
    FD_SET(lfd, &RFds);

    for (;;) {
	time_t t = time(NULL);
	struct timeval tv = { 5, 0 };
	fd_set rfds = RFds;

	select(MaxFds, &rfds, NULL, NULL, &tv);
	dt += t - tlast;

	/*
	 * check for config changes
	 */

	if (dt < 0 || dt > 60) {
	    LoadDRDConfig(0);
	    dt = 0;
	}

	/*
	 * check for descriptor activity, accept connections.
	 */

	/*
	 * check for dead processes & update DRDConfig
	 * as appropriate.
	 */

	/*
	 * startup new processes as required
	 */

	/*
	 * setup for next loop
	 */

	tlast = t;
    } /* for */
}

