.TH "ScilabEval" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
ScilabEval - tcl instruction : Evaluate a string with scilab interpreter
.sp
Author: Bertrand Guiheneuf
.sp
This routine is used inside tcl/tk script executed from scilab. It allows to evaluate any string from the scilab interpreter.
It's mainly used to execute callbacks from tk widgets.
.sp
.sp
.SH Usage
ScilabEval str
.SH Input parameter
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fB\fPstr : tcl string character
Contains the string to evaluate with the current scilab interpreter. 
.if \n(ll>1 .RE
.nr ll -1
.SH Output parameters
None
.SH Description
This function must be called in a tcl/tk script executed from scilab.
It allows to associate scilab actions to tcl/tk widgets (graphic
objects).  The string str is put in the scilab interpreter buffer
which then evaluates it.  This has in general no border effect in the
tcl/tk interpreter.
.SH Example (tcl/tk script)
.nf
# this text must be saved into a file, for instance 
#  '/tmp/test.tcl'
# then launch scilab and type TK_EvalFile('/tmp/test.tcl');
toplevel .w1
button .w1.b -text "Click here to see a new Scilab Graphic Window"\
  -command {ScilabEval "xselect()"}
pack .w1.b 
.fi 
.ec
.ft P
.sp
.SH See also
TK_EvalFile, TK_EvalStr, TK_GetVar, TK_Setvar
