/*
 * Copyright(c) 1995-1998 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: sort.c,v 2.6 1998/03/12 14:41:34 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

static FD_config_display *sort_obj = NULL;
static FD_Folder *fold_obj = NULL;
static FD_Message *msg_obj = NULL;
static int ready = 0;

void Sort_Call(FL_OBJECT *obj, long param)
{
}

void Fld_Color_Call(FL_OBJECT *obj, long param)
{
 color_fld[param] = fl_show_colormap(color_fld[param]);
 fl_set_object_color(obj, color_fld[param], FL_BLACK);
}

void Msg_Color_Call(FL_OBJECT *obj, long param)
{
 color_msg[param] = fl_show_colormap(color_msg[param]);
 fl_set_object_color(obj, color_msg[param], FL_BLACK);
}

void Folder_Call(FL_OBJECT *obj, long param)
{
}

void Message_Call(FL_OBJECT *obj, long param)
{
}

void
sort_conf(int set_default, FD_config_display *form) 
{
 sort_obj = form;

 sort_type = b_getcfg_int_default(conf_name, "sort", BY_SNT_TIME|MSG_DESCEND|MSG_THREAD, set_default);
 folder_sort = b_getcfg_int_default(conf_name, "fsort", BY_NAME|MSG_ASCEND, set_default);

 switch (sort_type & 0x0f) {
   case NO_SORT:
	fl_set_button(sort_obj->Sort_None, 1);
   break;

   case BY_SNT_TIME:
	fl_set_button(sort_obj->Sort_Snd_Time, 1);
   break;

   case BY_RCV_TIME:
	fl_set_button(sort_obj->Sort_Rcv_Time, 1);
   break;

   case BY_SUBJECT:
	fl_set_button(sort_obj->Sort_Subj, 1);
   break;

   case BY_AUTHOR:
	fl_set_button(sort_obj->Sort_Author, 1);
   break;

   case BY_RECIPIENT:
	fl_set_button(sort_obj->Sort_Recp, 1);
   break;

   case BY_FLAGS:
	fl_set_button(sort_obj->Sort_Prior, 1);
   break;

   case BY_SIZE:
	fl_set_button(sort_obj->Sort_Size, 1);
   break;

   default:
	fl_set_button(sort_obj->Sort_None, 1);
   break;
			   }

   if (sort_type & MSG_DESCEND)
	fl_set_button(sort_obj->Sort_Desc, 1);
   else
	fl_set_button(sort_obj->Sort_Asc, 1);

   if (sort_type & MSG_THREAD)
	fl_set_button(sort_obj->Sort_Thread, 1);
   else
	fl_set_button(sort_obj->Sort_Thread, 0);

 switch (folder_sort & 0x0f) {
   case NO_SORT:
	fl_set_button(sort_obj->Fold_Nosort, 1);
   break;

   case BY_NAME:
	fl_set_button(sort_obj->Fold_Name, 1);
   break;

   case BY_MSGNUM:
	fl_set_button(sort_obj->Fold_Msg, 1);
   break;

   case BY_UNREAD:
	fl_set_button(sort_obj->Fold_Unread, 1);
   break;

   default:
	fl_set_button(sort_obj->Fold_Nosort, 1);
   break;
			   }

   if (folder_sort & MSG_DESCEND)
	fl_set_button(sort_obj->Fold_Desc, 1);
   else
	fl_set_button(sort_obj->Fold_Asc, 1);

 fl_set_counter_bounds(sort_obj->Sort_DStat, 0, 2);
 fl_set_counter_precision(sort_obj->Sort_DStat, 0);
 fl_set_counter_step(sort_obj->Sort_DStat, 1, 1);
 fl_set_counter_value(sort_obj->Sort_DStat, (double)b_getcfg_int_default(conf_name, "statlen", 2, set_default));

 fl_set_counter_bounds(sort_obj->Sort_DDate, 0, 16);
 fl_set_counter_precision(sort_obj->Sort_DDate, 0);
 fl_set_counter_step(sort_obj->Sort_DDate, 1, 1);
 fl_set_counter_value(sort_obj->Sort_DDate, (double)b_getcfg_int_default(conf_name, "datelen", 13, set_default));

 fl_set_counter_bounds(sort_obj->Sort_DSize, 0, 6);
 fl_set_counter_precision(sort_obj->Sort_DSize, 0);
 fl_set_counter_step(sort_obj->Sort_DSize, 1, 1);
 fl_set_counter_value(sort_obj->Sort_DSize, (double)b_getcfg_int_default(conf_name, "sizelen", 5, set_default));

 fl_set_counter_bounds(sort_obj->Sort_DFrom, 0, 24);
 fl_set_counter_precision(sort_obj->Sort_DFrom, 0);
 fl_set_counter_step(sort_obj->Sort_DFrom, 1, 1);
 fl_set_counter_value(sort_obj->Sort_DFrom, (double)b_getcfg_int_default(conf_name, "fromlen", 18, set_default));

 fl_set_counter_bounds(sort_obj->Sort_DSubj, 0, 100);
 fl_set_counter_precision(sort_obj->Sort_DSubj, 0);
 fl_set_counter_step(sort_obj->Sort_DSubj, 1, 1);
 fl_set_counter_value(sort_obj->Sort_DSubj, (double)b_getcfg_int_default(conf_name, "subjlen", 100, set_default));


 fl_set_counter_bounds(sort_obj->Sort_FName, 0, 100);
 fl_set_counter_precision(sort_obj->Sort_FName, 0);
 fl_set_counter_step(sort_obj->Sort_FName, 1, 1);
 fl_set_counter_value(sort_obj->Sort_FName, (double)b_getcfg_int_default(conf_name, "foldlen", 11, set_default));

 fl_set_counter_bounds(sort_obj->Sort_FTotal, 0, 100);
 fl_set_counter_precision(sort_obj->Sort_FTotal, 0);
 fl_set_counter_step(sort_obj->Sort_FTotal, 1, 1);
 fl_set_counter_value(sort_obj->Sort_FTotal, (double)b_getcfg_int_default(conf_name, "numlen", 4, set_default));

 fl_set_counter_bounds(sort_obj->Sort_FUnread, 0, 100);
 fl_set_counter_precision(sort_obj->Sort_FUnread, 0);
 fl_set_counter_step(sort_obj->Sort_FUnread, 1, 1);
 fl_set_counter_value(sort_obj->Sort_FUnread, (double)b_getcfg_int_default(conf_name, "funrlen", 4, set_default));

 fl_set_object_color(sort_obj->Fld_Dummy_Clr,color_fld[FLD_DUMMY_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_Search_Clr,color_fld[FLD_SEARCH_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_Marked_Clr,color_fld[FLD_MARK_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_Recent_Clr,color_fld[FLD_RECENT_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_System_Clr,color_fld[FLD_SYSTEM_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_IMAP_Clr,color_fld[FLD_IMAP_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_NEWS_Clr,color_fld[FLD_NEWS_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_Current_Clr,color_fld[FLD_CURR_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Fld_Normal_Clr,color_fld[FLD_NORMAL_CLR],FL_BLACK);

 fl_set_object_color(sort_obj->Msg_Current_Clr,color_msg[MSG_CURR_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Msg_Unread_Clr,color_msg[MSG_UNREAD_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Msg_Marked_Clr,color_msg[MSG_MARK_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Msg_Normal_Clr,color_msg[MSG_NORMAL_CLR],FL_BLACK);
 fl_set_object_color(sort_obj->Msg_Deleted_Clr,color_msg[MSG_DELETED_CLR],FL_BLACK);
}

void
handle_sort_input(FD_config_display *form)
{
char buf[127];
u_int new_sort = 0;
int i;

 sort_obj = form;
 show_msg[STAT_LEN] = (int)fl_get_counter_value(sort_obj->Sort_DStat);
 b_putcfg_int(conf_name, "statlen", (int)fl_get_counter_value(sort_obj->Sort_DStat));
 show_msg[DATE_LEN] = (int)fl_get_counter_value(sort_obj->Sort_DDate);
 b_putcfg_int(conf_name, "datelen", (int)fl_get_counter_value(sort_obj->Sort_DDate));
 show_msg[SIZE_LEN] = (int)fl_get_counter_value(sort_obj->Sort_DSize);
 b_putcfg_int(conf_name, "sizelen", (int)fl_get_counter_value(sort_obj->Sort_DSize));
 show_msg[FROM_LEN] = (int)fl_get_counter_value(sort_obj->Sort_DFrom);
 b_putcfg_int(conf_name, "fromlen", (int)fl_get_counter_value(sort_obj->Sort_DFrom));
 show_msg[SUBJ_LEN] = (int)fl_get_counter_value(sort_obj->Sort_DSubj);
 b_putcfg_int(conf_name, "subjlen", (int)fl_get_counter_value(sort_obj->Sort_DSubj));


 show_fld[FOLD_LEN] = (int)fl_get_counter_value(sort_obj->Sort_FName);
 b_putcfg_int(conf_name, "foldlen", (int)fl_get_counter_value(sort_obj->Sort_FName));

 show_fld[FNUM_LEN] = (int)fl_get_counter_value(sort_obj->Sort_FTotal);
 b_putcfg_int(conf_name, "fnumlen", (int)fl_get_counter_value(sort_obj->Sort_FTotal));

 show_fld[FUNR_LEN] = (int)fl_get_counter_value(sort_obj->Sort_FUnread);
 b_putcfg_int(conf_name, "funrlen", (int)fl_get_counter_value(sort_obj->Sort_FUnread));

 if (fl_get_button(sort_obj->Sort_None))
	new_sort = NO_SORT;
 else
 if (fl_get_button(sort_obj->Sort_Rcv_Time))
	new_sort = BY_RCV_TIME;
 else
 if (fl_get_button(sort_obj->Sort_Snd_Time))
	new_sort = BY_SNT_TIME;
 else
 if (fl_get_button(sort_obj->Sort_Subj))
	new_sort = BY_SUBJECT;
 else
 if (fl_get_button(sort_obj->Sort_Author))
	new_sort = BY_AUTHOR;
 else
 if (fl_get_button(sort_obj->Sort_Recp))
	new_sort = BY_RECIPIENT;
 else
 if (fl_get_button(sort_obj->Sort_Prior))
	new_sort = BY_FLAGS;
 else
 if (fl_get_button(sort_obj->Sort_Size))
	new_sort = BY_SIZE;
 else
	new_sort = NO_SORT;

 if (fl_get_button(sort_obj->Sort_Asc))
	new_sort |= MSG_ASCEND;
 else
 if (fl_get_button(sort_obj->Sort_Desc))
	new_sort |= MSG_DESCEND;
 else
	new_sort |= MSG_ASCEND;

 if (fl_get_button(sort_obj->Sort_Thread))
	new_sort |= MSG_THREAD;

 if (new_sort != sort_type) {
	b_putcfg_int(conf_name, "sort", new_sort);
	sort_type = new_sort;
	for (i = 0; i< folders_num;i++) {
	 if (mailbox[i]->sort == new_sort)
		mailbox[i]->sort = -1;  }

	sort_folder(current_folder);
			    }

 if (fl_get_button(sort_obj->Fold_Nosort))
	new_sort = NO_SORT;
 else
 if (fl_get_button(sort_obj->Fold_Name))
	new_sort = BY_NAME;
 else
 if (fl_get_button(sort_obj->Fold_Msg))
	new_sort = BY_MSGNUM;
 else
 if (fl_get_button(sort_obj->Fold_Unread))
	new_sort = BY_UNREAD;
 else
	new_sort = NO_SORT;

 if (fl_get_button(sort_obj->Fold_Asc))
	new_sort |= MSG_ASCEND;
 else
 if (fl_get_button(sort_obj->Fold_Desc))
	new_sort |= MSG_DESCEND;
 else
	new_sort |= MSG_ASCEND;

 if (new_sort != folder_sort) {
	b_putcfg_int(conf_name, "fsort", new_sort);
	folder_sort = new_sort;
	sort_folders();
			    }

 sprintf(buf, "%d %d %d %d %d %d %d %d", color_fld[FLD_DUMMY_CLR],
  color_fld[FLD_SEARCH_CLR], color_fld[FLD_MARK_CLR], color_fld[FLD_RECENT_CLR],
  color_fld[FLD_SYSTEM_CLR], color_fld[FLD_IMAP_CLR], color_fld[FLD_CURR_CLR],
  color_fld[FLD_NORMAL_CLR]);
 b_putcfg_str(conf_name, "fldcolors", buf);

 sprintf(buf, "%d %d %d %d", color_msg[MSG_CURR_CLR], color_msg[MSG_UNREAD_CLR],
  color_msg[MSG_MARK_CLR], color_msg[MSG_NORMAL_CLR]);
 b_putcfg_str(conf_name, "msgcolors", buf);

 redraw_folders();

 return;         
}

void
set_fld_sname(fld)
struct _mail_folder *fld;
{
 fld->status &= ~FALIAS;
 if (fld->sname)
	return;
 free(fld->sname);

 switch (fld->type) {
  default:
  case F_MH:
  case F_MBOX:
   fld->sname = strdup(get_folder_short_name(fld));
  break;

  case F_IMAP:
   fld->sname = strdup(get_imap_folder_short_name(NULL, fld));
  break;
		    }
 return;
}

void
set_fld_values(fld)
struct _mail_folder *fld;
{
int srt_type;

 if (fld->sort != -1)
	srt_type = fld->sort;
 else
	srt_type = sort_type;

 switch (srt_type & 0x0f) {
   case NO_SORT:
	fl_set_button(fold_obj->Sort_None, 1);
   break;

   case BY_SNT_TIME:
	fl_set_button(fold_obj->Sort_Snd_Time, 1);
   break;

   case BY_RCV_TIME:
	fl_set_button(fold_obj->Sort_Rcv_Time, 1);
   break;

   case BY_SUBJECT:
	fl_set_button(fold_obj->Sort_Subj, 1);
   break;

   case BY_AUTHOR:
	fl_set_button(fold_obj->Sort_Author, 1);
   break;

   case BY_RECIPIENT:
	fl_set_button(fold_obj->Sort_Recp, 1);
   break;

   case BY_FLAGS:
	fl_set_button(fold_obj->Sort_Prior, 1);
   break;

   case BY_SIZE:
	fl_set_button(fold_obj->Sort_Size, 1);
   break;

   default:
	fl_set_button(fold_obj->Sort_None, 1);
   break;
			   }

 if (srt_type & MSG_DESCEND)
	fl_set_button(fold_obj->Sort_Desc, 1);
 else
	fl_set_button(fold_obj->Sort_Asc, 1);

 if (srt_type & MSG_THREAD)
	fl_set_button(fold_obj->Sort_Thread, 1);
 else
	fl_set_button(fold_obj->Sort_Thread, 0);

 fl_set_object_color(fold_obj->Folder_Color, get_fld_color(fld), FL_BLACK);

 if (fld->sname && (fld->status & FALIAS))
	fl_set_input(fold_obj->Folder_Alias, fld->sname);
 else
	fl_set_input(fold_obj->Folder_Alias, "");

 if (fld->From)
	fl_set_input(fold_obj->Folder_From, get_full_addr_line(fld->From));
 else
	fl_set_input(fold_obj->Folder_From, "");

 return;
}

void Folder_Color_Call(FL_OBJECT *obj, long param)
{
 fl_set_object_color(obj, fl_show_colormap(obj->col1), FL_BLACK);
}

void Folder_Default_Call(FL_OBJECT *obj, long param)
{
struct _mail_folder *fld = (struct _mail_folder *)obj->u_vdata;

 fld->color = -1;
 fld->sort = -1;

 if (fld->sname)
	free(fld->sname);
 fld->sname = NULL;

 set_fld_sname(fld);
 set_fld_values(fld);
}

void Folder_Cache_Call(FL_OBJECT *obj, long param)
{
struct _mail_folder *fld = (struct _mail_folder *)obj->u_vdata;

 if (!fl_get_button(obj))  {
   if ((fld->flags & CACHED) &&
	!display_msg(MSG_QUEST|MSG_DEFNO, "cache", "All cache information will be deleted\nAre you sure?")) {
	fl_set_button(obj, 1);
	return;   }
   delete_cache(fld);
   fld->flags &= ~CACHED;
			   }
}

void
folder_conf(fld)
struct _mail_folder *fld;
{
int new_sort;
char ftitle[127], *p;

 if (ready || !fld)
        return;

 ready = 1;

 fold_obj = create_form_Folder();
 fold_obj->Folder_Default->u_vdata = fld;
 fold_obj->Folder_Cache->u_vdata = fld;

 set_fld_values(fld);

 fl_set_input(fold_obj->Folder_Descr, fld->descr ? fld->descr : "");
 sprintf(ftitle, "%d", fld->expire);
 fl_set_input(fold_obj->Folder_Expire, ftitle);
 fl_set_button(fold_obj->Folder_Unread, (fld->flags & FNCOUNT) ? 1 : 0);
 fl_set_button(fold_obj->Folder_Trash, (fld->flags & FNTRASH) ? 1 : 0);
 fl_set_button(fold_obj->Folder_Cache, (fld->flags & CACHED) ? 1 : 0);
 fl_set_button(fold_obj->Folder_Recp, (fld->flags & FSHRECP) ? 1 : 0);
 fl_set_button(fold_obj->Folder_Check, (fld->flags & FCHECK) ? 1 : 0);
 fl_set_button(fold_obj->Folder_RKeep, (fld->flags & FRKEEP) ? 1 : 0);
 fl_set_button(fold_obj->Folder_DValidate, (fld->flags & FNVALD) ? 1 : 0);

 snprintf(ftitle, sizeof(ftitle), "Edit options for '%s'", fld->sname);
 fl_set_object_label(fold_obj->Folder_Text, ftitle);

 fl_show_form(fold_obj->Folder, FL_PLACE_CENTER, FL_TRANSIENT, ftitle);
 fl_do_only_forms();

 if (fl_get_button(fold_obj->Sort_None))
	new_sort = NO_SORT;
 else
 if (fl_get_button(fold_obj->Sort_Rcv_Time))
	new_sort = BY_RCV_TIME;
 else
 if (fl_get_button(fold_obj->Sort_Snd_Time))
	new_sort = BY_SNT_TIME;
 else
 if (fl_get_button(fold_obj->Sort_Subj))
	new_sort = BY_SUBJECT;
 else
 if (fl_get_button(fold_obj->Sort_Author))
	new_sort = BY_AUTHOR;
 else
 if (fl_get_button(fold_obj->Sort_Recp))
	new_sort = BY_RECIPIENT;
 else
 if (fl_get_button(fold_obj->Sort_Prior))
	new_sort = BY_FLAGS;
 else
 if (fl_get_button(fold_obj->Sort_Size))
	new_sort = BY_SIZE;
 else
	new_sort = NO_SORT;

 if (fl_get_button(fold_obj->Sort_Asc))
	new_sort |= MSG_ASCEND;
 else
 if (fl_get_button(fold_obj->Sort_Desc))
	new_sort |= MSG_DESCEND;
 else
	new_sort |= MSG_ASCEND;

 if (fl_get_button(fold_obj->Sort_Thread))
	new_sort |= MSG_THREAD;

 fld->sort = (new_sort == sort_type) ? -1 : new_sort;
 fld->color = -1;
 if (get_fld_color(fld) != fold_obj->Folder_Color->col1)
	fld->color = fold_obj->Folder_Color->col1;

 if (fld->descr)
	free(fld->descr);
 fld->descr = NULL;
 p = (char *)fl_get_input(fold_obj->Folder_Descr);
 if (p && *p)
	fld->descr = strdup(p);

 p = (char *)fl_get_input(fold_obj->Folder_Alias);
 if (p && *p &&
    ((fld->sname && strcmp(fld->sname, p)) || (fld->status & FALIAS)))	{
  free(fld->sname);
  fld->status |= FALIAS;
  strncpy(ftitle, p, MAX_FOLDER_ALIAS_NAME);
  ftitle[MAX_FOLDER_ALIAS_NAME] = '\0';
  fld->sname = strdup(ftitle);						}
 else
  set_fld_sname(fld);

 p = (char *)fl_get_input(fold_obj->Folder_Expire);
 if (p && *p)
	fld->expire = atoi(p);
 else
	fld->expire = -1;

 if (fl_get_button(fold_obj->Folder_Unread))
	fld->flags |= FNCOUNT;
 else
	fld->flags &= ~FNCOUNT;

 if (fl_get_button(fold_obj->Folder_Trash))
	fld->flags |= FNTRASH;
 else
	fld->flags &= ~FNTRASH;

 if (fl_get_button(fold_obj->Folder_Cache))
	fld->flags |= CACHED;
 else
	fld->flags &= ~CACHED;

 if (fl_get_button(fold_obj->Folder_Recp))
	fld->flags |= FSHRECP;
 else
	fld->flags &= ~FSHRECP;

 if (fl_get_button(fold_obj->Folder_Check))
	fld->flags |= FCHECK;
 else
	fld->flags &= ~FCHECK;

 if (fl_get_button(fold_obj->Folder_RKeep))
	fld->flags |= FRKEEP;
 else
	fld->flags &= ~FRKEEP;

 if (fl_get_button(fold_obj->Folder_DValidate))
	fld->flags |= FNVALD;
 else
	fld->flags &= ~FNVALD;

 discard_address(fld->From);
 p = (char *)fl_get_input(fold_obj->Folder_From);
 if (p && *p)
	fld->From = get_address(p, ADDR_GET_FIRST);
 else
	fld->From = NULL;

 fl_hide_form(fold_obj->Folder);
 fl_free_form(fold_obj->Folder);
 fl_free(fold_obj);
 fold_obj = NULL;

 sort_folder(fld);
 redraw_fld(fld);
 update_title();
 save_folders_conf(NULL, F_MH|F_MBOX);

 ready = 0;
 return;         
}

void
message_conf(msg)
struct _mail_msg *msg;
{
char ftitle[64];

 if (ready || !msg)
        return;

 ready = 1;

 msg_obj = create_form_Message();

 fl_set_button(msg_obj->Message_Unread, (msg->flags & UNREAD));
 fl_set_button(msg_obj->Message_Marked, (msg->flags & MARKED));
 fl_set_button(msg_obj->Message_Signed, (msg->flags & SIGNED));
 fl_set_button(msg_obj->Message_Replied, (msg->flags & ANSWERED));
 fl_set_button(msg_obj->Message_Forwarded, (msg->flags & FORWARDED));
 fl_set_button(msg_obj->Message_Expire, (msg->flags & M_DONTEXPIRE));

 snprintf(ftitle, sizeof(ftitle), "%-.16s/%-.16s", msg->folder ? msg->folder->sname : "nofolder", msg->header->Subject ? msg->header->Subject : "nosubject");
 fl_show_form(msg_obj->Message, FL_PLACE_CENTER, FL_TRANSIENT, ftitle);
 fl_do_only_forms();

 if (fl_get_button(msg_obj->Message_Unread))
	msg->flags |= UNREAD;
 else
	msg->flags &= ~UNREAD;

 if (fl_get_button(msg_obj->Message_Marked))
	msg->flags |= MARKED;
 else
	msg->flags &= ~MARKED;

 if (fl_get_button(msg_obj->Message_Signed))
	msg->flags |= SIGNED;
 else
	msg->flags &= ~SIGNED;

 if (fl_get_button(msg_obj->Message_Replied))
	msg->flags |= ANSWERED;
 else
	msg->flags &= ~ANSWERED;

 if (fl_get_button(msg_obj->Message_Forwarded))
	msg->flags |= FORWARDED;
 else
	msg->flags &= ~FORWARDED;

 if (fl_get_button(msg_obj->Message_Expire))
	msg->flags |= M_DONTEXPIRE;
 else
	msg->flags &= ~M_DONTEXPIRE;

 msg->update(msg);
 fl_hide_form(msg_obj->Message);
 fl_free_form(msg_obj->Message);
 fl_free(msg_obj);
 msg_obj = NULL;

 redraw_msg(msg);
 update_title();

 ready = 0;
 return;         
}

