/*
 * Copyright(c) 1995-1998 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: pop.c,v 2.13 1998/03/17 16:09:50 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include "md5.h"

#define	MAX_CONNECTIONS	20	/* connection number limit */
#define	CONN_BUF	128	/* connection buffer       */

struct _xf_conn {
int sock;			/* socket file descriptor */
char lbuf[CONN_BUF];		/* socket buffer 	  */
char host[MAX_HOST];		/* host name (IP addr)    */
} xf_conn;

static struct _xf_conn *connections[MAX_CONNECTIONS] = { NULL };

#define inaddr_copy(hp,sin) \
    memcpy((char *)&((sin)->sin_addr), (hp)->h_addr, (hp)->h_length)

struct _uidl *get_popmsg_by_uidl(struct _pop_src *pop, char *uidl);
int get_popmsg_num(struct _pop_src *pop);
void free_uidlist(struct _pop_src *pop);
void save_uidlist(struct _pop_src *pop);
void compare_uidlist(struct _pop_src *pop);
int check_uidlist(struct _pop_src *pop, char *uidstr);
void delete_uidlist(struct _pop_src *pop, char *uidstr);

void
init_cinfo()
{
int i;

 for (i = 0; i < MAX_CONNECTIONS;i++)
	connections[i] = NULL;
}

struct _xf_conn *
get_conn(sock)
int sock;
{
int i;

 for (i = 0; i < MAX_CONNECTIONS;i++)
  if (connections[i] && (connections[i]->sock == sock))
	return connections[i];

 return NULL;
}

struct _xf_conn *
new_cinfo(sock, host)
int sock;
char *host;
{
struct _xf_conn *conn;
int i;

 if ((conn = get_conn(sock)) != NULL)
	return conn;

 for (i = 0; i < MAX_CONNECTIONS;i++)
  if (!connections[i])
	break;

 if (connections[i]) {
	display_msg(MSG_WARN, "connect", "Can not have more then %d connections", MAX_CONNECTIONS);
	return NULL; }


 if ((connections[i] = (struct _xf_conn *)malloc(sizeof(struct _xf_conn)))
	== NULL) 	{
	display_msg(MSG_FATAL, "connect", "Malloc failed");
	return NULL; 	}

 conn = connections[i];
 conn->sock = sock;
 conn->lbuf[0] = '\0';
 strncpy(conn->host, host, MAX_HOST - 1);
 conn->host[MAX_HOST - 1] = '\0';

 return conn;
}

void
del_cinfo(sock)
int sock;
{
int i;

 for (i = 0; i < MAX_CONNECTIONS;i++)	{
  if (connections[i] && (connections[i]->sock == sock)) {
	free(connections[i]);
	connections[i] = NULL;
	return;
							}
					}

 return;
}

int
get_ipc_sock(sin)
struct sockaddr_in *sin;
{
        int             sock;
#ifdef	_linuxalpha_
        long            sinlen;
#else
        int             sinlen;
#endif
 
        if ((sock = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
        {
		display_msg(MSG_WARN, "ipc", "can not get socket");
                return -1;
        }

        sinlen = sizeof (struct sockaddr_in);
        bzero((char *)sin, sinlen);
 
        sin->sin_port = htons(0);
 
        sin->sin_family = AF_INET;
        sin->sin_addr.s_addr = INADDR_ANY;
        if (bind (sock, (struct sockaddr *) sin,
                sizeof (struct sockaddr_in)) < 0)
        {
		display_msg(MSG_WARN, "ipc", "bind failed");
                return -1;
        }

        if (getsockname (sock, (struct sockaddr *) sin, &sinlen) < 0)
        {
		display_msg(MSG_WARN, "ipc", "getsockname failed");
                return -1;
        }
        return sock;
}

struct hostent *
async_gethostbyname(s)
char *s;
{
static struct hostent hp;
static long iaddr;
static char *haddr[1];
static int dnspid = 0;
static char hname[127];

struct sockaddr_in dnsin;
struct hostent *hp1;
int ipcsock, i;
#ifdef	_linuxalpha_
long len;
#else
int len;
#endif

   if (!s || (dnspid != 0))
	return NULL;

   if ((ipcsock = get_ipc_sock(&dnsin)) == -1)
	return NULL;

   signal(SIGCHLD, handler);

   if ((dnspid = (int)fork()) < 0) {
	close(ipcsock);
	display_msg(MSG_WARN, "async_gethostbyname", "can not fork");
	return NULL;
				   }

   if (dnspid != 0) 	{
	display_msg(MSG_STAT, NULL, "Resolving %s ...", s);
	if (logging & LOG_NET)
	 display_msg(MSG_LOG, "async_gethostbyname", "Resolving %s ...", s);

	if (my_check_io_forms(ipcsock, 0, RESOLV_TIMEOUT) < 0)  {
	  close(ipcsock);
	  display_msg(MSG_STAT, NULL, "");
	  kill(dnspid, SIGKILL);
	  dnspid = 0;
	  return NULL;
						}

	if (recvfrom(ipcsock, (char *)&iaddr, (int)sizeof(iaddr), (int)0,
		NULL, &len) != sizeof(iaddr)) {
		display_msg(MSG_WARN, "async_gethostbyname", "error reading from socket");
		close(ipcsock);
	  	display_msg(MSG_STAT, NULL, "");
		kill(dnspid, SIGKILL);
		dnspid = 0;
		return NULL;
					      }

	iaddr = ntohl(iaddr);

	if ((iaddr == -1) || (my_check_io_forms(ipcsock, 0, RESOLV_TIMEOUT) < 0))  {
	  close(ipcsock);
	  display_msg(MSG_STAT, NULL, "");
	  kill(dnspid, SIGKILL);
	  dnspid = 0;
	  return NULL;
						}

	if ((i = recvfrom(ipcsock, hname, (int)sizeof(hname), (int)0,
		NULL, &len)) == -1) {
		display_msg(MSG_WARN, "async_gethostbyname", "error reading from socket");
		close(ipcsock);
	  	display_msg(MSG_STAT, NULL, "");
		kill(dnspid, SIGKILL);
		dnspid = 0;
		return NULL;
				    }
        hname[i] = '\0';

	dnspid = 0;
	close(ipcsock);

	hp.h_addr_list = haddr;
	hp.h_addr = (char *)&iaddr;
	hp.h_length = sizeof(iaddr);
	hp.h_addrtype = AF_INET;
	hp.h_aliases = NULL;
	hp.h_name = hname;

	display_msg(MSG_STAT, NULL, "");
	return &hp;
			}

   if ((hp1 = gethostbyname(s)) != NULL)
	memcpy((char *)&iaddr, hp1->h_addr, hp1->h_length);
   else
	iaddr = -1;

   iaddr = htonl(iaddr);

   if (sendto(ipcsock,(char *)&iaddr,sizeof(iaddr),(int)0,(struct sockaddr *)&dnsin,sizeof(dnsin)) != sizeof(iaddr)) {
	close(ipcsock);
	_exit(1);
				     }

   if (iaddr == -1) {
	close(ipcsock);
	_exit(0);
   }

   if (sendto(ipcsock,hp1->h_name,strlen(hp1->h_name),(int)0,(struct sockaddr *)&dnsin,sizeof(dnsin)) != sizeof(strlen(hp1->h_name))) 	{
	close(ipcsock);
	_exit(1);
				        		}

   close(ipcsock);
   _exit(0);
}

struct hostent *
gethostbystring(s)
char   *s;
{
static struct hostent hp;
static char *haddr[1];
#ifdef __osf__
static in_addr_t iaddr;
#else
static long iaddr;
#endif

    iaddr = inet_addr(s);
    if ((iaddr == -1) && strcmp(s, "255.255.255.255"))
        return async_gethostbyname(s);

    hp.h_addr_list = haddr;
    hp.h_addr = (char *)&iaddr;
    hp.h_length = sizeof(iaddr);
    hp.h_addrtype = AF_INET;

    return &hp;
}

void
host_disconnect(sock)
int *sock;
{
struct _xf_conn *conn;

 if (!sock || (*sock == -1))
	return;

 if ((conn = get_conn(*sock)) != NULL)  {
  if (logging & LOG_NET)
   display_msg(MSG_LOG, "connect", "Disconnected from %s", conn->host);
  del_cinfo(*sock);
					}
 close(*sock);
 *sock = -1;
}

int
host_connect(hostname, service, protocol)
char hostname[MAX_HOST];
char *service;
char *protocol;
{
static int coninprogress = 0;
int sock;
struct  servent *srv;
struct hostent *hp;
struct sockaddr_in  in_socket;
struct sockaddr_in *isock = &in_socket;

char c_host[MAX_HOST];
char c_service[10];
char c_prot[6];
char *p;
int pport, res;

 if (coninprogress) {
	display_msg(MSG_WARN, "connect", "Can not make new connection during connection attempt in progress");
	return -1;  }

 if (!hostname)
	strcpy(c_host, "127.0.0.1");
 else
	strncpy(c_host, hostname, MAX_HOST);

 if (!service)
	strcpy(c_service, "110");
 else
	strncpy(c_service, service, 10);

 if (!protocol)
	strcpy(c_prot, "tcp");
 else
	strncpy(c_prot, protocol, 6);

 p = c_service;
 while( *p && isdigit(*p))
	p++;

 if (*p) {
   srv = getservbyname(c_service, c_prot);
   if (srv == NULL) {
	display_msg(MSG_WARN, "connect", "Unknown service %s/%s", c_service, c_prot);
	return -1;
	  }
   pport = srv->s_port;
 } else {
   pport = atoi(c_service);
   pport = htons(pport);
	}

 if ((hp = gethostbystring(c_host)) == NULL) {
	display_msg(MSG_WARN, "connect", "Unknown host %s", c_host);
	return -1;
	 }

 if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
	display_msg(MSG_WARN, "connect", "Can not open socket");
	return -1;
	}

 if ((new_cinfo(sock, c_host)) == NULL)	{
	close(sock);
	sock = -1;
	return -1;			}

 if ((res = fcntl(sock, F_GETFL)) == -1) {
	display_msg(MSG_WARN, "connect", "fcntl F_GETFL failed");
	close(sock);
	sock = -1;
	return -1;
	}

 if (fcntl(sock, F_SETFL, res | O_NONBLOCK) == -1) {
	display_msg(MSG_WARN, "connect", "fcntl F_SETFL, O_NONBLOCK failed");
	close(sock);
	sock = -1;
	return -1;
	}

 bzero((char *)isock, sizeof *isock);

 isock->sin_family = hp->h_addrtype;
 inaddr_copy(hp, isock);
 isock->sin_port = pport;

 display_msg(MSG_STAT, NULL, "Connecting to %s ...", c_host);
 if (logging & LOG_NET)
  display_msg(MSG_LOG, "connect", "Connecting to %s", c_host);

 if (connect(sock, (struct sockaddr *)isock, sizeof *isock) == -1) {
	if (errno != EINPROGRESS) {
	display_msg(MSG_WARN, "connect", "Connect to %s failed", c_host);
	if (logging & LOG_NET)
	 display_msg(MSG_LOG, "connect", "Connect to %s failed", c_host);
 	display_msg(MSG_STAT, NULL, "");
	close(sock);
	sock = -1;
	return -1;
				  }
	}

conwait:
 coninprogress = 1;
 if ((res = my_check_io_forms(sock, 1, SOCKET_TIMEOUT)) < 0) {
    if (res == -2)
	display_msg(MSG_LOG,"connect", "Connect to %s aborted by user", c_host);
    else {
	display_msg(MSG_WARN, "connect", "Connect to %s failed", c_host);
	if (logging & LOG_NET)
	 display_msg(MSG_LOG, "connect", "Connect to %s failed", c_host);
	 }
 	display_msg(MSG_STAT, NULL, "");
	close(sock);
	coninprogress = 0;
	sock = -1;
	return -1;
					    }
 coninprogress = 0;

 if (connect(sock, (struct sockaddr *)isock, sizeof *isock) == -1)  {
  switch (errno) {
    case EISCONN:
    break;

    case EINPROGRESS:
    case EALREADY:
	goto conwait;
    break;

    default:
	display_msg(MSG_WARN, "connect", "Connect to %s failed", c_host);
	if (logging & LOG_NET)
	 display_msg(MSG_LOG, "connect", "Connect to %s failed", c_host);
 	display_msg(MSG_STAT, NULL, "");
	close(sock);
	sock = -1;
	return -1;
    break;
		}
								    }

 if (logging & LOG_NET)
  display_msg(MSG_LOG, "connect", "Connected to %s", c_host);
 display_msg(MSG_STAT, NULL, "");

 return sock;
}

int
getdata (s, n, iop, ofile)
char   *s;
long     n;
FILE *iop, *ofile;
{
struct _xf_conn *conn;
char buf[128], *p, *p1, *lbuf;
long rdone, res;

 if ((conn = get_conn(fileno(iop))) == NULL)
	return -1;
 lbuf = conn->lbuf;

 if (n == 0)
	return 0;

 rdone = 0;

 if (ofile)
	p = buf;
 else
	p = s;

 if ((res = (long)strlen(lbuf)) > 0) 	{
  if (res >= n) {
    if (ofile) {
	if (fwrite(lbuf, (size_t)n, 1, ofile) == EOF) 	{
		display_msg(MSG_WARN, "getdata", "Write failed");
		return -1;			}
	       }	
    else {
	strncpy(s, lbuf, (int)n);
	s[n] = '\0';
	 }

    strcpy(buf, lbuf + n);
    strcpy(lbuf, buf);
    return 0;
		}

  if (ofile) {
	if (fputs(lbuf, ofile) == EOF) {
	  display_msg(MSG_WARN, "recv", "Write failed!");
	  return -1;
				       }
	     }
  else 	{
	strcpy(s, lbuf);
	p += res;
	}

  lbuf[0] = '\0';
  rdone = res;
				}

 if ((res = my_check_io_forms(fileno(iop), 0, SOCKET_TIMEOUT)) < 0) {
	lbuf[0] = '\0';
	return res;				    }

 while (rdone < n) {
     if ((res = read(fileno(iop), p, (int)(n - rdone) > 127 ? 127 : (int)(n - rdone))) == -1) 	{
	if ((errno == EAGAIN) ||
		(errno == EWOULDBLOCK)) {
	  if ((res = my_check_io_forms(fileno(iop), 0, SOCKET_TIMEOUT)) < 0) 	{
		lbuf[0] = '\0';
		return res;					}

	  continue;
			     }
	display_msg(MSG_WARN, "recv: getdata", "connection error");
	lbuf[0] = '\0';
        return -1;
	}
     if (res == 0)  {
	display_msg(MSG_WARN, "recv: getdata", "connection closed by foreign host");
	lbuf[0] = '\0';
        return -1;
		    }

     p[res] = '\0';
     rdone += res;

     p1 = p;
     while ((p1 = strchr(p1, '\r')) != NULL)
	memmove(p1, p1 + 1, strlen(p1));

     if (ofile) {
	if (fputs(p, ofile) == EOF) {
	  display_msg(MSG_WARN, "recv: getdata", "Write failed!");
	  return -1;
				    }
		}
     else
	p += strlen(p);
		    }

 return 0;
}

char *
getline (s, n, iop)
char   *s;
int     n;
FILE *iop;
{
struct _xf_conn *conn;
char   tbuf[128], *p, *p1, *lbuf;
int len, res, allocbuf, len1;

    if ((conn = get_conn(fileno(iop))) == NULL)
	return NULL;
    lbuf = conn->lbuf;

    if (n < 0) {
	n = abs(n);
	allocbuf = 1;
	       }
    else
	allocbuf = 0;

    if ((len = strlen(lbuf)) > 0) {
	if ((p = strchr(lbuf, '\n')) != NULL) 	{
		p1 = p + 1;
		*p = '\0';
		p--;
		if (*p == '\r')
			*p = '\0';
		if (allocbuf)
			s = (char *)malloc(strlen(lbuf) + 1);
		strcpy(s, lbuf);
		strcpy(tbuf, p1);
		strcpy(lbuf, tbuf);

		return s;
						}
	if (allocbuf) 			      {
		s = (char *)malloc(strlen(lbuf) + 1);
		allocbuf = strlen(lbuf) + 1; }

	strcpy(s, lbuf);
	p = s + len;
	lbuf[0] = '\0';
				  }
    else {
	if (allocbuf) 		{
		s = (char *)malloc(1);
		allocbuf = 1;	}
	s[0] = '\0';
	p = s;
	len = 0;
	}

    if ((res = my_check_io_forms(fileno(iop), 0, SOCKET_TIMEOUT)) < 0) 	{
	lbuf[0] = '\0';
	if (allocbuf)
		free(s);
	return ((res == -2) && allocbuf) ? strdup("") : NULL;	}

    while (len < n) {
     len1 = (n - len) > 127 ? 127 : (n - len);
     if (allocbuf) 				{
	allocbuf += (len1 + 1);
	s = (char *)realloc(s, allocbuf);
	p = s + strlen(s);			}

     if ((res = read(fileno(iop), p, len1)) == -1) {
	if ((errno == EAGAIN) ||
		(errno == EWOULDBLOCK)) {
	  if ((res = my_check_io_forms(fileno(iop), 0, SOCKET_TIMEOUT)) < 0) 		{
		lbuf[0] = '\0';
		if (allocbuf)
			free(s);
		return ((res == -2) && allocbuf) ? strdup("") : NULL;	}

	  continue;
			     }
	display_msg(MSG_WARN, "recv: getline", "connection error");
	if (allocbuf)
		free(s);
	lbuf[0] = '\0';
        return NULL;
    				         }
     if (res == 0)
		break;

     p[res] = '\0';
     if ((p1 = strchr(p, '\n')) != NULL) {
	*p1 = '\0';
	strcpy(lbuf, p1 + 1);
	len += (p1 - p);
	p1--;
	if (*p1 == '\r')
		*p1 = '\0';

	break;
					 }
     p += res;
     len += res;
		    }

    s[len] = '\0';

    if (len >= n) {
	if (logging & LOG_NET)
	 display_msg(MSG_LOG, "recv: getline", "string is too long, splitting");
	return s; }

    if ((len == 0) && (*lbuf == '\0'))	{
	display_msg(MSG_WARN, "recv: getline", "connection closed by foreign host");
	if (allocbuf)
		free(s);
        return NULL;			}

    return s;
}

int
putdata (s, n, iop, ifile)
char   *s;
int     n;
FILE *iop, *ifile;
{
struct _xf_conn *conn;
char sbuf[512], lastchar, *lbuf;
int sent, chunk, res;

 if ((conn = get_conn(fileno(iop))) == NULL)
	return -1;
 lbuf = conn->lbuf;

 if (s) {
chwrite1:
    if ((res = my_check_io_forms(fileno(iop), 1, SOCKET_TIMEOUT)) < 0) 	{
	lbuf[0] = '\0';
	return res;					}

    if (write(fileno(iop), s, n) == -1) {
	if ((errno == EAGAIN) || (errno == EWOULDBLOCK))
		goto chwrite1;

	display_msg(MSG_WARN, "send", "connection lost");
	lbuf[0] = '\0';
        return -1;
					 }       

	}
 else   {
  sent = 0;
  lastchar = '\0';

  while (sent < n) {
   if (fgets(sbuf, 511, ifile) == NULL)	{
     if (ferror(ifile))
	return -1;
     if (feof(ifile))
	break;				}

   chunk = strlen(sbuf);
   if (chunk && (sbuf[chunk - 1] == '\n')) {
    if (chunk > 1)
        lastchar = sbuf[chunk - 2];
  
    if (lastchar != '\r')   {
	sbuf[chunk - 1] = '\r';
        chunk++;
	sbuf[chunk - 1] = '\n';
	sbuf[chunk] = '\0'; }

    lastchar = '\n';
                                           }
   else
    lastchar = chunk ? sbuf[chunk - 1] : '\0';

   if ((res = my_check_io_forms(fileno(iop), 1, SOCKET_TIMEOUT)) < 0) 	{
	lbuf[0] = '\0';
	return res;					}

   if (write(fileno(iop), sbuf, chunk) == -1) {
    if ((errno == EAGAIN) || (errno == EWOULDBLOCK))
	continue;

    display_msg(MSG_WARN, "send", "connection lost");
    lbuf[0] = '\0';
    return -1;				     }	

   sent += chunk;
		  }
      }

chwrite2:
  if ((res = my_check_io_forms(fileno(iop), 1, SOCKET_TIMEOUT)) < 0) 	{
	lbuf[0] = '\0';
	return res;					}

  if (write(fileno(iop), "\r\n", 2) == -1) {
    if ((errno == EAGAIN) || (errno == EWOULDBLOCK))
	goto chwrite2;

    display_msg(MSG_WARN, "send", "connection lost");
    lbuf[0] = '\0';
    return -1;				  }	

 return 0;
}

int putline(s, iop)
char   *s;
FILE * iop;
{
struct _xf_conn *conn;
char sbuf[512], *lbuf;
int res;

    if ((conn = get_conn(fileno(iop))) == NULL)
	return -1;
    lbuf = conn->lbuf;

    if (strlen(s) >= 510) {
	display_msg(MSG_WARN, "send", "line too long");
	return -1;
			  }

    snprintf(sbuf, sizeof(sbuf), "%s\r\n", s);
chwrite:
    if ((res = my_check_io_forms(fileno(iop), 1, SOCKET_TIMEOUT)) < 0)
	return res;

    if (write(fileno(iop), sbuf, strlen(sbuf)) == -1) {
	if ((errno == EAGAIN) || (errno == EWOULDBLOCK))
		goto chwrite;

	display_msg(MSG_WARN, "send", "connection lost");
	lbuf[0] = '\0';
        return -1;
					 }       

    return 0;
}

char *
pop_command(pop, fmt, a, b, c, d)
struct _pop_src *pop;
char   *fmt,
       *a,
       *b,
       *c,
       *d;
{
static char commandln[514];

    snprintf(commandln, sizeof(commandln), fmt, a, b, c, d);

    if (pop->flags & PSRC_LOGSESSION)	{
     if (strncasecmp(commandln, "pass ", 5))
	display_msg(MSG_LOG, "pop", "-> %-.127s", commandln);
     else
	display_msg(MSG_LOG, "pop", "-> PASS *******");
					}

    if (putline(commandln, pop->pop_out) == -1)
        return NULL;

    pop->response[0] = '\0';

    if (getline(pop->response, 513, pop->pop_in) == NULL)
	return NULL;

    if (pop->flags & PSRC_LOGSESSION)
     display_msg(MSG_LOG, "pop", "<- %-.127s", pop->response);

    if (pop->response[0] == '+')
	return pop->response;

    if (strncasecmp(fmt, "UIDL", 4) && !strncasecmp(pop->response, "-ERR ", 4))
    	display_msg(MSG_WARN, "pop", "%-.127s", pop->response + 4);

    return NULL;
}

void
pop_close(pop)
struct _pop_src *pop;
{
struct _uidl *ucache;

 host_disconnect(&pop->popsock);

 while (pop->uidlcache)	{
  ucache = pop->uidlcache;
  pop->uidlcache = pop->uidlcache->next;
  free(ucache);		}

 if ((pop->pop_in != NULL) || (pop->pop_out != NULL))
	fclose(pop->pop_in);

 pop->pop_in = NULL;
 pop->pop_out = NULL;
 pop->popsock = -1;

 return;
}

void
pop_end(pop)
struct _pop_src *pop;
{
pop_command(pop, "QUIT");
pop_close(pop);
save_uidlist(pop);
free_uidlist(pop);
}

int
pop_init(pop)
struct _pop_src *pop;
{
char buf[514], apoptstamp[512], apopdigest[40], *p, *p1;
int logattempts = 2, i;
unsigned char digest[16];
MD5_CTX ctx;

 if (pop->popsock != -1) {
	display_msg(MSG_WARN, "pop", "POP busy");
	return -1;	 }

 pop->nouidl = 0;
 pop->popsock = host_connect(pop->hostname, pop->service, NULL);

 if (pop->popsock == -1)
	return -2;

 if ((pop->pop_in = fdopen(pop->popsock, "r+")) == NULL) {
	display_msg(MSG_WARN, "pop", "fdopen failed");
	pop_close(pop);
	return -1;					 }

 pop->pop_out = pop->pop_in;
 
 if (getline(buf, 513, pop->pop_in) == NULL)	{
	pop_close(pop);
	return -1;				}

 if (buf[0] != '+') {
	display_msg(MSG_WARN, "pop", "Invalid response from pop server");
	pop_close(pop);
	return -1;  }

 if (pop->flags & PSRC_APOP)	{
 apoptstamp[0] = '\0';
 if (((p = strchr(buf, '<')) != NULL) &&
	((p1 = strchr(p, '>')) != NULL))	{
	i = p1 - p + 1;
	strncpy(apoptstamp, p, i);
	apoptstamp[i] = '\0';			}
 else
	display_msg(MSG_LOG, pop->source->name, "APOP is not supported on this server");
				}

 if (supress_errors != 1)	{
  if ((strlen(pop->password) <= 1) &&
		!(pop->flags & PSRC_STOREPWD))
	pop_account(pop);
				}

 while (logattempts > 0)	{
  if ((pop->flags & PSRC_APOP) &&
	*apoptstamp)	{
   MD5Init(&ctx);
   MD5Update(&ctx, (unsigned char *)apoptstamp, strlen(apoptstamp));
   MD5Update(&ctx, (unsigned char *)pop->password, strlen(pop->password));
   MD5Final(digest, &ctx);

   for (p = apopdigest, i = 0; i < 16; i++, p+= 2)
	sprintf(p, "%02x", digest[i] & 0xff);
   apopdigest[32] = '\0';

   if (pop_command(pop, "APOP %s %s", pop->username, apopdigest))
	return 0;
			}
  else	{
   if (pop_command(pop, "USER %s", pop->username) == NULL)	{
	pop_close(pop);
	return -1;						}

   if (pop_command(pop, "PASS %s", pop->password))
	return 0;
	}

  if (strncasecmp(pop->response, "-ERR ", 4)) {
	pop_close(pop);
	return -1;			      }

  logattempts--;
  pop_account(pop);
				}

 pop_close(pop);
 return -1;
}

int
multiline(pop) 
struct _pop_src *pop;
{
char buffer[514];
 
    if (getline(buffer, 513, pop->pop_in) == NULL)
        return -1;

    if (buffer[0] == '.') {
        if (buffer[1] == '\0')
            return 0;
        else
            (void)strcpy(pop->response, buffer + 1);
    }
    else
        (void)strcpy(pop->response, buffer);

    return 1;
}    

int
get_pop_msg(pop, num, only_header, realen)
struct _pop_src *pop;
int num;
int only_header;
long *realen;
{
int mnum, resplen;
char buf[255];
char *p, *p1;
FILE *mfd;
int st, pbuf;
long rlen, acclen, tdiff;
struct timeval tv1, tv2;
struct _uidl *ucache;

 if ((mnum = get_new_name(ftemp)) == -1) {
	display_msg(MSG_WARN, "pop", "No space in %s", FTEMP);
	return -1; }

 snprintf(buf, sizeof(buf), "%s/%d", ftemp->fold_path, mnum);

 if ((mfd = fopen(buf, "w")) == NULL) {
        display_msg(MSG_WARN, "pop", "Can not open file %s", buf);
        return -1; }

 if (only_header == 1)	{
  if ((p = pop_command(pop, "TOP %d 0", num)) == NULL)	{
	display_msg(MSG_WARN, "pop", "Failed to retrieve header of message %d from server", num);
	fclose(mfd);
	unlink(buf);
	return -1;					}
			}
 else
 if (only_header == 2) {
  if ((p = pop_command(pop, "TOP %d 999999", num)) == NULL){
	display_msg(MSG_WARN, "pop", "Failed to retrieve message %d from server", num);
	fclose(mfd);
	unlink(buf);
	return -1;					   }
 } else	{
 if ((p = pop_command(pop, "RETR %d", num)) == NULL)	{
	display_msg(MSG_WARN, "pop", "Failed to retrieve message %d from server", num);
	fclose(mfd);
	unlink(buf);
	return -1;					}
	}

 rlen = -1;
 if ((p = strchr(p, ' ')) != NULL) {
	while (*p == ' ')
		p++;

	rlen = strtoul(p, &p1, 10);
	if (*p1 && (*p1 != ' '))
		rlen = -1;
				   }

 if (rlen <= 0) {
  ucache = pop->uidlcache;
  while (ucache && (ucache->mnum != num))
		ucache = ucache->next;

  if (ucache && (ucache->flags & POP_LENGTH))
	rlen = ucache->mlen;
		}

 if ((rlen >= MAX_MSG_LEN) && (only_header != 1))	{
	display_msg(MSG_WARN, "pop", "Message is too big (%lu), can not retrieve it", rlen);
	fclose(mfd);
	unlink(buf);
	return -1;					}

 if (realen)	{
	if ((*realen = rlen) <= 0)
		*realen = 1;
		}

 rlen = 0;
 acclen = 0;
 pbuf = 0;
 gettimeofday(&tv1, NULL);

 while ((st = multiline(pop)) == 1) {
	resplen = strlen(pop->response);
	rlen += resplen + 2;
	acclen += resplen + 2;
	if ((only_header != 1) && realen && (*realen > 8192)) 	{
	  if (acclen > (*realen * 0.05)) {
	    acclen = 0;
	    gettimeofday(&tv2, NULL);
	    tdiff = (tv2.tv_sec - tv1.tv_sec) * 1000000 - tv1.tv_usec + tv2.tv_usec + 1;
 	    display_msg(MSG_STAT, NULL, "POP: retrieving message %d of %d (%d %% - %.2f kb/sec)", num, pop->num_msgs, rlen * 100 / *realen,
		(double)(((double)rlen * 1000000)/ (double)tdiff / 1024) );
					}
								}

	if (resplen < 1) 
		pbuf++;
	else {
	  while (pbuf) {
		fputc('\n', mfd);
		pbuf--;
			}

	  if (fputs(pop->response, mfd) == EOF) {
		if (errno == ENOSPC)
			display_msg(MSG_WARN, "pop", "DISK FULL!");
		else
			display_msg(MSG_WARN, "pop", "Error writing %s", buf);
		fclose(mfd);
		unlink(buf);
		errno = 0;
		return -1;
					   }
	  fputc('\n', mfd);
	    }
				}

 if (fclose(mfd) == EOF) {
	if (errno == ENOSPC)
		display_msg(MSG_WARN, "pop", "DISK FULL!");
	else
		display_msg(MSG_WARN, "pop", "Error writing %s", buf);
	fclose(mfd);
	unlink(buf);
	errno = 0;
	return -1;
			 }

 if (st == -1) {
	display_msg(MSG_WARN, "pop", "Error when retrieving message from server");
	unlink(buf);
	return -1;
		}

 return mnum;
}

int
pop_send_message(pop, msg)
struct _pop_src *pop;
struct _mail_msg *msg;
{
char *p;

 if (!msg)
	return -1;

 switch (pop_init(pop))	{
   case -1:
	return -1;
   break;

   case -2:
	return -1;
   break;
			}

 if ((p = pop_command(pop, "XTND XMIT")) == NULL) {
	display_msg(MSG_WARN, "Transmit command failed!", "Probably it's not supported on this POP server");
	pop_end(pop);
	return -1;				  }

 if (smtp_message(msg, pop->pop_out) == -1) {
	pop_end(pop);
	return -1;			    }

 if ((p = pop_command(pop, ".")) == NULL) {
	display_msg(MSG_WARN, "POP Send", "Failed to send message");
	pop_end(pop);
	return -1;			  }

 pop_end(pop);
 return 0;
}

long
get_popmsg_len(pop, num)
struct _pop_src *pop;
int num;
{
int st;
struct _uidl *ucache;
u_long msg_len;
u_int mnum;

 if ((pop->uidlcache == NULL) ||
	!(pop->uidlcache->flags & POP_LENGTH))
					{
  get_popmsg_by_uidl(pop, "");
  if (pop->uidlcache == NULL) {
    if (!pop->nouidl)
	return -2;

    if (pop_command(pop, "LIST %d", num) == NULL) {
	display_msg(MSG_WARN, "pop", "Can not determine message length!");
	return -2;				  }

	mnum = -1;
	msg_len = 0L;
	sscanf(pop->response, "%d %lu", &mnum, &msg_len);
	if ((mnum != num) || (msg_len == -1))
		return -2;

	return msg_len;

			 }

  if (pop_command(pop, "LIST") == NULL) {
	display_msg(MSG_WARN, "pop", "Can not determine message length!");
	return -2;			}

  ucache = pop->uidlcache;

  while ((st = multiline(pop)) == 1)  {
   mnum = -1;
   msg_len = 0L;
   sscanf(pop->response, "%d %lu", &mnum, &msg_len);

   if ((mnum == -1) || (msg_len == 0L))
	continue;

   while (ucache && (ucache->mnum != mnum))
	ucache = ucache->next;

   if (!ucache) {
	ucache = pop->uidlcache;
	while (ucache && (ucache->mnum != mnum))
		ucache = ucache->next;
		}

   if (!ucache)
	continue;

   ucache->mlen = msg_len;
   ucache->flags |= POP_LENGTH;
   ucache = ucache->next;
				   }
					}

  ucache = pop->uidlcache;
  while (ucache && (ucache->mnum != num))
		ucache = ucache->next;

  if (!ucache || !(ucache->flags & POP_LENGTH)) {
	display_msg(MSG_WARN, "pop", "Can not determine message length (%d)!", num);
	return -2; }

  return ucache->mlen;
}

char *
get_popmsg_uidl(pop, num)
struct _pop_src *pop;
int num;
{
struct _uidl *ucache;

 if (pop->uidlcache == NULL)
	get_popmsg_by_uidl(pop,"");

 if (pop->nouidl)
	return NULL;

 ucache = pop->uidlcache;

 while (ucache) {
	if (ucache->mnum == num)
		return ucache->uidlstr;

	ucache = ucache->next;
		}

 return NULL;
}

struct _uidl *
get_popmsg_by_uidl(pop, uidl)
struct _pop_src *pop;
char *uidl;
{
int st;
char muidl[MAX_UIDL];
struct _uidl *ucache, *uidl1, *uidl2;

 if (pop->uidlcache == NULL) {
	if (pop->nouidl)
		return NULL;

  if (pop_command(pop, "UIDL") == NULL) {
	pop->nouidl = 1;
	return NULL;		        }

			}
 else	{
  ucache = pop->uidlcache;
  while (ucache) {
   if (!strcmp(ucache->uidlstr, uidl))
	return ucache;

   ucache = ucache->next;
		 }

   return NULL;
	}

 uidl2 = NULL;

 while ((st = multiline(pop)) == 1)  {
  muidl[0] = '\0';
  st = 0;
  sscanf(pop->response, "%d %70s", &st, muidl);
  ucache = (struct _uidl *)malloc(sizeof(struct _uidl));
  ucache->mnum = st;
  ucache->mlen = 0;
  ucache->flags = 0;
  strcpy(ucache->uidlstr, muidl);
  ucache->next = NULL;

  if (!strcmp(muidl, uidl))
	uidl2 = ucache;

  if (pop->uidlcache == NULL)
	pop->uidlcache = ucache;
  else 	{
   uidl1 = pop->uidlcache;
   while (uidl1->next)
	uidl1 = uidl1->next;

   uidl1->next = ucache;
	}
				  }

 compare_uidlist(pop);
 return uidl2;
}

int
get_popmsg_num(pop)
struct _pop_src *pop;
{
char *p;
char dumb[5];
int msgs_len = 0;

 if ((p = pop_command(pop, "STAT")) == NULL)
	return -1;

 sscanf(p, "%s %d %d", dumb, &pop->num_msgs, &msgs_len);

 if (pop->num_msgs == -1) {
	display_msg(MSG_WARN, "pop", "STAT failed");
        return -1;	  }

 return pop->num_msgs;
}

int
pop_delmsg_by_uidl(pop, msg)
struct _pop_src *pop;
struct _mail_msg *msg;
{
int mnum;
struct _head_field *fld;
struct _uidl *uidl;
int init;

 if (pop == NULL)
	return -1;

 init = (pop->popsock == -1) ? 1 : 0;

 if (!msg)
	return -1;

 if ((fld = find_field(msg, XUIDL)) == NULL)	{
	display_msg(MSG_WARN, "pop", "This message does not have POP %s identifier", XUIDL);
	return -1;				}

 if (init) {
   if (pop_init(pop) != 0)
	return -1;
	   }

 if ((uidl = get_popmsg_by_uidl(pop, fld->f_line)) == NULL)	{
	if (pop->nouidl)
		display_msg(MSG_WARN, "pop", "You can not use this feature\nsince your POP server does not support UIDL command");
	if (init)
	 pop_end(pop);
	return -1;					}

 mnum = uidl->mnum;

 if (mnum == 0)		{
	if (init)
	 pop_end(pop);
	return -1;	}

 if (!(uidl->flags & POP_DELETED)) {
	display_msg(MSG_STAT, NULL, "POP: deleting message %d", mnum);
	pop_command(pop, "DELE %d", mnum);
	uidl->flags |= POP_DELETED;
				   }

 if (init)
	pop_end(pop);

 msg->flags &= ~H_ONLY;
 delete_uidlist(pop, fld->f_line);

 return 0;
}

int
pop_getfull_msg(pop, msg)
struct _pop_src *pop;
struct _mail_msg *msg;
{
struct _head_field *fld;
struct _uidl *uidl;
int mnum, nnum, st;
FILE *mfd, *bfd;
char buf[255];
char msgf[255];
long realen;

 if (!msg || !pop)
	return -1;

 if (!(msg->flags & H_ONLY))
	return -1;

 if ((fld = find_field(msg, XUIDL)) == NULL)	{
	display_msg(MSG_WARN, "pop", "Message does not have %s identifier", XUIDL);
	return -1;				}

 if (pop_init(pop) != 0)
	return -1;

 if ((uidl = get_popmsg_by_uidl(pop, fld->f_line)) == NULL)	{
	if (pop->nouidl)
	  display_msg(MSG_WARN, "pop", "You can not use thise feature\nsince your POP server does not support UIDL command");
	else
	  display_msg(MSG_WARN, "pop", "Failed to find message");
	pop_end(pop);
	return -1;						}

 mnum = uidl->mnum;

 if (mnum == 0)		{
	display_msg(MSG_WARN, "pop", "Can not find message, probably it's no longer on the server");
	pop_end(pop);
	return -1;	}

 if ((nnum = get_pop_msg(pop, mnum, 0, &realen)) == -1)	{
	pop_end(pop);
	return -1;					}

 if (pop->flags & PSRC_DELETE)
	pop_command(pop, "DELE %d", mnum);

 snprintf(msgf, sizeof(msgf), "%s/%d", ftemp->fold_path, nnum);

 if ((bfd = fopen(msgf, "r")) == NULL)	{
	display_msg(MSG_WARN, "pop", "Can not open retrieved message");
	unlink(msgf);
	pop_end(pop);
	return -1;			}

 if ((mfd = fopen(msg->get_file(msg), "a")) == NULL)	{
	display_msg(MSG_WARN, "pop", "Can not open message %s", msg->get_file(msg));
	fclose(bfd);
	unlink(msgf);
	pop_end(pop);
	return -1;					}

 st = 0;
 while (fgets(buf, 255, bfd))	{
  if (!st && ((buf[0] == '\n') || (buf[0] == '\r')))	{
	st = 1;
	continue;					}

  if (st)
	fputs(buf, mfd);
				}
 
 fflush(mfd);
 msg->msg_len = ftell(mfd);
 fclose(mfd);
 fclose(bfd);
 unlink(msgf);

 msg->flags &= ~H_ONLY;
 replace_field(msg, XUIDL, uidl->uidlstr);
 pop_end(pop);

 return 0;
}

int
if_popmsg_retr(pop, num)
struct _pop_src *pop;
int num;
{
char *p;
int ml, st;

 if (pop->flags & PSRC_STATXLST)
	p = pop_command(pop, "XTND XLST Status %d", num);
 else
	p = pop_command(pop, "TOP %d 0", num);

 if (!p) {
	display_msg(MSG_WARN, "pop", "Can not determine message status");
	return 0;
	}

 st = 0;
 while ((ml = multiline(pop)) == 1)  {
   if ((p = strstr(pop->response, "Status:")) != NULL) {
	p += 7;
	if (strchr(p, 'R'))
		st = 1;
						  }
				  }

 return st;
}

void
free_uidlist(pop)
struct _pop_src *pop;
{
int i;

 if (pop->uidfirst == -2)	{
  for (i = 0; i < MAX_POP_UIDS; i++)
   pop->pop_uids[i] = NULL;
				}
 else	{
  for (i = 0; i < MAX_POP_UIDS; i++)	{
   if (pop->pop_uids[i] != NULL)
	free(pop->pop_uids[i]);
   pop->pop_uids[i] = NULL;
					}
	}
 pop->uidfirst = -1;

 return;
}

void
load_uidlist(pop)
struct _pop_src *pop;
{
char uidfname[255];
char uidstr[MAX_UIDL + 2];
FILE *ufd;
int i = 0;

 free_uidlist(pop);

 snprintf(uidfname, sizeof(uidfname), "%s/.xfmpopuid-%s", configdir, pop->source->name);
 if ((ufd = fopen(uidfname, "r")) == NULL)	{
	pop->uidfirst = 0;
	return; 
						}

 while (fgets(uidstr, MAX_UIDL - 1, ufd)) {
  strip_newline(uidstr);
  pop->pop_uids[i] = strdup(uidstr);
  if (++i >= MAX_POP_UIDS)
	break;
				          }
 fclose(ufd);
 pop->uidfirst = 0;

 return;
}

void
save_uidlist(pop)
struct _pop_src *pop;
{
FILE *ufd;
char uidfname[255];
int i = pop->uidfirst;

 if (pop->uidfirst < 0)
	return;

 snprintf(uidfname, sizeof(uidfname), "%s/.xfmpopuid-%s", configdir, pop->source->name);
 if ((ufd = fopen(uidfname, "w")) == NULL)	{
	display_msg(MSG_WARN, "Message uids will not be stored", "Can not open %s", uidfname);
	pop->uidfirst = -3;
	return; 
						}

 do {
  if (pop->pop_uids[i])    {
    fputs(pop->pop_uids[i], ufd);
    fputc('\n', ufd); }

  i++;
  if (i >= MAX_POP_UIDS)
	i = 0;
 } while (i != pop->uidfirst);
 fclose(ufd);

 return;
}

void
append_uidlist(pop, uidstr)
struct _pop_src *pop;
char *uidstr;
{
 if (!uidstr || !*uidstr || (strlen(uidstr) >= MAX_UIDL))
	return;

 if (pop->uidfirst == -3)
	return;

 if (pop->uidfirst < 0)
	load_uidlist(pop);

 if (check_uidlist(pop, uidstr) != 0)
	return;

 pop->uidfirst--;
 if (pop->uidfirst < 0)
	pop->uidfirst = MAX_POP_UIDS - 1;
 if (pop->pop_uids[pop->uidfirst])
	free(pop->pop_uids[pop->uidfirst]);
 pop->pop_uids[pop->uidfirst] = strdup(uidstr);

 return;
}

int
check_uidlist(pop, uidstr)
struct _pop_src *pop;
char *uidstr;
{
int i = 0;

 if (!uidstr || !*uidstr ||
	(strlen(uidstr) >= MAX_UIDL))
	return 0;

 if (pop->uidfirst == -3)
	return 0;

 if (pop->uidfirst < 0)
	load_uidlist(pop);

 for (i = 0; i < MAX_POP_UIDS; i++) {
  if (pop->pop_uids[i] && !strcmp(pop->pop_uids[i], uidstr))
	return 1;
				    }

 return 0;
}

void
delete_uidlist(pop, uidstr)
struct _pop_src *pop;
char *uidstr;
{
int i;

 if (!uidstr || !*uidstr || (strlen(uidstr) >= MAX_UIDL))
	return;

 if (pop->uidfirst < 0)
	load_uidlist(pop);

 if (pop->uidfirst == -3)
	return;

 for (i = 0; i < MAX_POP_UIDS; i++) {
  if (pop->pop_uids[i] && !strcmp(pop->pop_uids[i], uidstr)) {
	free(pop->pop_uids[i]);
	pop->pop_uids[i] = NULL;
	break;					   }
				    }

 return;
}

void
compare_uidlist(pop)
struct _pop_src *pop;
{
int i;

 if (pop->uidlcache == NULL)
	return;

 if (pop->uidfirst < 0)
	load_uidlist(pop);

 if (pop->uidfirst == -3)
	return;

 for (i = 0; i < MAX_POP_UIDS; i++)	{
  if (pop->pop_uids[i] &&
	(get_popmsg_by_uidl(pop, pop->pop_uids[i]) == NULL))	{
	free(pop->pop_uids[i]);
	pop->pop_uids[i] = NULL;				}
					}

 return;
}

int
if_popmsg_uid_cached(pop, msg)
struct _pop_src *pop;
int msg;
{
char *uid;

 if (pop->uidfirst < 0)
	load_uidlist(pop);

 if (pop->uidfirst < 0)
	return -1;

  if ((uid = get_popmsg_uidl(pop, msg)) == NULL)
	return -1;

  return check_uidlist(pop, uid);
}

int
pop_inc(source, notify)
struct _retrieve_src *source;
int *notify;
{
struct _pop_src *pop;
struct _mail_msg *msg;
int i, honly, uidcached;
int num_msgs, retr_num;
long popmaxmsg;
char mclen[16], *muidl;
long realen;
int nnum = -1;

 if (source->flags & RSRC_DISABLED)
        return 0;

 pop = (struct _pop_src *)source->spec;

 if (pop->maxmsg >= 0)
	popmaxmsg = pop->maxmsg * 1024;
 else
	popmaxmsg = MAX_MSG_LEN;

 if (popmaxmsg > MAX_MSG_LEN)
	popmaxmsg = MAX_MSG_LEN;

 if (pop_init(pop) != 0)
	return -1;

 if ((num_msgs = get_popmsg_num(pop)) == -1)	{
	pop_end(pop);
	return -1;				}

 if (num_msgs == 0) {
	free_uidlist(pop);
	pop->uidfirst = 0;
	save_uidlist(pop);
	pop_end(pop);
	return 0;   }

 retr_num = 0;

 for (i = 1; i <= num_msgs; i++) {

	honly = 0;
	uidcached = -1;
	realen = 0;

	if (abortpressed())
		break;

	if (!(pop->flags & PSRC_POP2) &&
		((pop->flags & PSRC_CHECKUID) ||
		(pop->flags & PSRC_CHECKSTAT)))	{
	  if ((pop->flags & PSRC_CHECKSTAT) &&
		(if_popmsg_retr(pop, i) > 0) )
		continue;

	  if ((pop->flags & PSRC_CHECKUID) &&
		((uidcached = if_popmsg_uid_cached(pop, i)) == 1))
		continue;
						}

	if (!(pop->flags & PSRC_POP2) &&
		(popmaxmsg >= 0) && 
		((realen = get_popmsg_len(pop, i)) >= popmaxmsg)) {
	  if (pop->flags & PSRC_SKIPBIG)
		continue;

	  if (pop->nouidl)	{
		display_msg(MSG_WARN, "Can not retrieve message header, skipping", "Your POP server does not support UIDL command\nIt will be impossible to match header and message left on the server later");
		continue;	}

 	  display_msg(MSG_STAT, NULL, "POP: retrieving header of message %d of %d", i, num_msgs);
	  if ((nnum = get_pop_msg(pop, i, 1, &realen)) == -1)	{
		pop_end(pop);
		return -1;					}

	  if ((msg = get_message(nnum, ftemp)) == NULL) {
		pop_end(pop);
		return -1;				}

	  msg->flags |= H_ONLY;

	  if (realen > 0) {
		snprintf(mclen, sizeof(mclen), "%lu", realen);
	  	replace_field(msg, MIME_C_LENGTH, mclen);
			  }

	  honly = 1;
	} else {

 	display_msg(MSG_STAT, NULL, "POP: retrieving message %d of %d", i, num_msgs);
	if ((nnum = get_pop_msg(pop, i,
		(pop->flags & PSRC_DMARK) ? 2 : 0, &realen)) == -1) {
		pop_end(pop);
		return -1;					    }

	if ((msg = get_message(nnum, ftemp)) == NULL)	{
		pop_end(pop);
		return -1;				}

		}

	if (!(pop->flags & PSRC_POP2))	{
	 if ((muidl = get_popmsg_uidl(pop, i)) != NULL) {
	  replace_field(msg, XUIDL, muidl);
	  if ((pop->flags & PSRC_CHECKUID) &&
		(uidcached == 0) && (!(pop->flags & PSRC_DELETE) || honly))
		append_uidlist(pop, muidl);
						   }
			}

	set_flags_by_status(msg);
	convert_fields(msg);
	msg->folder = ftemp;
	msg->status |= (CHANGED | RECENT);
	if (source->flags & RSRC_MARKREAD)
		msg->flags &= ~UNREAD;
	replace_field(msg, "X-RDate", get_arpa_date(time(NULL)));
	replace_field(msg, SOURCE_FIELD, source->name);
	msg->header->rcv_time = time(NULL);

#ifdef FACES
	update_faces(msg);
#endif

	switch(apply_rule(msg, 0))	{
	   case 0:
		if (!(source->flags & RSRC_NONOTIFY))
			(*notify)++;
	   break;

	   case -1:
		pop_end(pop);
		unlink(msg->get_file(msg));
		discard_message(msg);
		return -1;
	  break;
					}

	retr_num++;

	if ((pop->flags & PSRC_DELETE) && !honly)
		pop_command(pop, "DELE %d", i);

						}

 pop_end(pop);
 return retr_num;
}

void
init_pop_source(source)
struct _retrieve_src *source;
{ 
struct _pop_src *pop;
struct _uidl *ucache;
int i;
 
 if (source->spec == NULL)      {
  source->spec = (struct _pop_src *)malloc(sizeof(struct _pop_src));
  pop = (struct _pop_src *)source->spec;
  pop->source = source;
  strcpy(pop->hostname, "127.0.0.1");
  strcpy(pop->service, "110");
  strcpy(pop->username, user_n);
  *pop->password = '\0';
  pop->maxmsg = -1;
  pop->flags = PSRC_DELETE;
				}
 else	{
  pop = (struct _pop_src *)source->spec;
  if (pop->popsock > 0)
	close(pop->popsock);
  if (pop->pop_in)
	fclose(pop->pop_in);
  if (pop->pop_out)
	fclose(pop->pop_out);

  while (pop->uidlcache) 	{
   ucache = pop->uidlcache;
   pop->uidlcache = pop->uidlcache->next;
   free(ucache);		}

  for (i = 0; i < MAX_POP_UIDS; i++)	{
   if (pop->pop_uids[i])
	free(pop->pop_uids[i]);
   pop->pop_uids[i] = NULL;		}
	}

 pop->popsock = -1;
 pop->pop_in = NULL;
 pop->pop_out = NULL;
 pop->uidlcache = NULL;
 pop->nouidl = 0;
 pop->num_msgs = -1;
 pop->uidfirst = -2;
 *pop->response = '\0';

 return;
}

void
free_pop_source(source)
struct _retrieve_src *source;
{
 if (source->spec)      {
  init_pop_source(source);
  free(source->spec);
  source->spec = NULL;  }

 return;
}

int
load_pop_source(source, fd)
struct _retrieve_src *source;
FILE *fd;
{
struct _pop_src *pop;
char buf[255], *p, *p1;

 pop = (struct _pop_src *)source->spec;
 if (!fgets(buf, 255, fd))
	return -1;
 strip_newline(buf);
 if (sscanf(buf, "%s %15s", pop->hostname, pop->service) != 2)
	return -1;

 if (!fgets(buf, 255, fd))
	return -1;
 strip_newline(buf);

 p1 = buf;
 if ((p = get_quoted_str(&p1)) == NULL)
	return -1;
 strncpy(pop->username, p, 31);
 pop->username[31] = '\0';
 *pop->password = '\0';
 if ((p = get_quoted_str(&p1)) != NULL)	{
	strncpy(pop->password, p, 31);
	pop->password[31] = '\0';	}

 if (!fgets(buf, 255, fd))
	return -1;
 strip_newline(buf);
 if (sscanf(buf, "%ld %d", &pop->maxmsg, &pop->flags) != 2)
	return -1;

 return 0;
}
  
int
save_pop_source(source, fd)
struct _retrieve_src *source;
FILE *fd;
{
struct _pop_src *pop;

 pop = (struct _pop_src *)source->spec;
 fprintf(fd, "%s %s\n", pop->hostname, pop->service);

 if (strchr(pop->username, ' '))
	fprintf(fd, "\"%s\"", pop->username);
 else
	fprintf(fd, "%s", pop->username);

 if (pop->flags & PSRC_STOREPWD)	{
  if (strchr(pop->password, ' '))
	fprintf(fd, " \"%s\"\n", pop->password);
  else
	fprintf(fd, " %s\n", pop->password);
					}
 else
	fprintf(fd, "\n");

 fprintf(fd, "%ld %d\n", pop->maxmsg, pop->flags);
 return 0;
}

void
pop_source(source)
struct _retrieve_src *source;
{
 init_pop_source(source);
 source->type = RSRC_POP;
 source->retrieve = pop_inc;
 source->free = free_pop_source;
 source->init = init_pop_source;
 source->load = load_pop_source;
 source->save = save_pop_source;

 return;
}

