\section{The Architecture of Haskore}

Figure \ref{haskore} shows the overall structure of Haskore.  Note the
degree of independence of high level structures from the ``music
platform''---it is desirable for Haskore compositions to run equally
well as conventional midi-files \cite{midi}, NeXT MusicKit score files
\cite{musickit}, and csound score files \cite{csound}, and to print
Haskore compositions in traditional notation using the CMN (Common
Music Notation) subsystem.  This independence is accomplished by
having abstract notions of musical object, player, instrument, and
performance that are eventually mapped down to a particular music
platform.  In this paper I will provide only the details of the
mapping to Midi, since it is likely to be the most popular platform
for users.  In any case, of most interest is the box labeled
``Haskore'' in the diagram.

\begin{figure*}
\centerline{
\epsfysize=4.0in 
\epsfbox{Pics/haskore.eps}
}
\caption{Overall System Diagram}
\label{haskore}
\end{figure*}

At the module level, Haskore is organized as follows:
\begin{verbatim} 

> module HaskoreLoader (module HaskoreLoader, module Basics,
>                       module Performance, 
>                       -- module Players,
>                       module HaskToMidi, module TestHaskore)
>        where
>
> import Basics         -- described in Section 3
> import Performance    -- described in Section 4
> -- import Players     -- described in Section 5
> import HaskToMidi     -- described in Section 6
> import TestHaskore

\end{verbatim} 

As I present various musical ideas in Haskell, I urge the reader to
question, at every step, the decisions that I make.  There is no
supreme theory of music that dictates my decisions, and what I present
is actually one of several versions that we have developed (this
version is much richer than the one described in \cite{haskore}; it is
the ``Haskore in practice'' version alluded to in Section 6 of that
paper).  I believe this version is suitable for many practical
purposes, but the reader may wish to modify it to better satisfy her
intuitions and/or application.

This document was written in the {\em literate programming style}, and
thus the \LaTeX\ manuscript file from which it was generated is an
{\em executable Haskell program}.  It can be compiled under \LaTeX\ in
two ways: a basic mode provides all of the functionality that most
users will need, and an extended mode in which various pieces of
lower-level code are provided and documented as well (see file header
for details).  This version was compiled in
\basic{basic}\extended{extended} mode.  The document can be retrieved
via WWW from {\tt
ftp://nebula.systemsz.cs.yale.edu/pub/yale-fp/papers/haskore} (consult
the README file for details).  It is also delivered with the standard
joint Nottingham/Yale Hugs release.

The code conforms to Haskell 1.4, although it does not adequately use
any of the newer features in Haskell, since most of it was written
when Haskell 1.2 was the latest release.  Parts of the code should
clearly be rewritten to take advantage of some Haskell 1.4 features,
in particular ``named fields'' in datatype declarations.  Haskore has
been tested under the February, 1997 Nottingham/Yale release of Hugs
1.4, which unfortunately does not yet support mutually recursive
modules.  For this reason all references to the module {\tt Players}
in this document are commented out, which in effect makes it part of
module {\tt Performance} (with which it is mutually recursive).
