module Game (main) where
import Board
import Input
import Output
import Solver
import Graphics

data PlayGameResult = PG_Exit | PG_Restart
  deriving (Show, Eq)

main :: IO ()
main = do 
  putStr "Please enter the game file name: "
  filename <- getLine
  runGraphics (gameLoop filename)
  

gameLoop :: String -> IO ()
gameLoop fn = do
  newboard <- readBoard fn
  case newboard of
    Nothing  -> return ()
    (Just board) -> do
      w <- initializeOutput board fn
      display board w
      result <- playGame board w
      closeWindow w
      if result == PG_Exit
        then return () 
        else gameLoop fn


playGame :: Board -> Window -> IO PlayGameResult
playGame b w = do 
  (b',(p, ua)) <- getUserAction b w 
  case ua of
   UA_Exit    -> return PG_Exit
   UA_Restart -> return PG_Restart
   _          -> if (boardDone b') then return PG_Restart
                                   else playGame b' w
  
