module Wrapper where

{-
Hide the CGI protocol from the programmer (last modified: Friday, March 07, 1997)

Erik Meijer (erik@cs.ruu.nl)
-}

import Common
import System
import CgiOut
import UrlEncoded
import Monad
import Prelude

simpleWrapper f
 = wrapper (\env -> do{ return (f env) })

wrapper f
 = do{ qs <- getQueryString
     ; cgiVars <- getCgiVars
     ; a <- f (cgiVars ++ urlDecode qs)
     ; putStr (show a)
     }


try       :: IO a -> IO (Either IOError a)
try p      = catch (p >>= (return . Right)) (return . Left)

myGetEnv v
 = do{ r <- try (getEnv v)
     ; return (either (const "") id r)
     }

getQueryString
 = do{ method <- myGetEnv "REQUEST_METHOD"
     ; case method of
        "POST" -> do{ length <- myGetEnv "CONTENT_LENGTH"
                    ; stdin <- getContents
                    ; return (take (string2int length) stdin)
                    }
        _     -> myGetEnv "QUERY_STRING"
     }

string2int
 = foldl (\n d -> n*10 + ord d - ord '0') 0

getCgiVars :: IO [(Name,Value)]
getCgiVars
 = do{ vals <- mapM myGetEnv cgiVars
     ; return (zipWith (,) cgiVars vals)
     }

cgiVars
 =  [ "DOCUMENT_ROOT"
    , "AUTH_TYPE"
    , "GATEWAY_INTERFACE"
    , "SERVER_SOFTWARE"
    , "SERVER_NAME"
    , "REQUEST_METHOD"
    , "SERVER_ADMIN"
    , "SERVER_PORT"
    , "QUERY_STRING"
    , "CONTENT_LENGTH"
    , "CONTENT_TYPE"
    , "REMOTE_USER"
    , "REMOTE_IDENT"
    , "REMOTE_ADDR"
    , "REMOTE_HOST"
    , "TZ"
    , "PATH"
    , "PATH_INFO"
    , "PATH_TRANSLATED"
    , "SCRIPT_NAME"
    , "SCRIPT_FILENAME"
    , "HTTP_CONNECTION"
    , "HTTP_ACCEPT_LANGUAGE"
    , "HTTP_ACCEPT"
    , "HTTP_HOST"
    , "HTTP_UA_COLOR"
    , "HTTP_UA_CPU"
    , "HTTP_UA_OS"
    , "HTTP_UA_PIXELS"
    , "HTTP_USER_AGENT"
    ]
