;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/control5.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Feb 27 14:11:26 1998                          */
;*    Last change :  Fri Mar 13 18:27:03 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    An implementation of the R5RS multiple values.                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r5_control_features_6_4
    
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (export  (values           . args)
	    (call-with-values ::procedure ::procedure)
	    *res-number*
	    *res1*
	    *res2*
	    *res3*))

;*---------------------------------------------------------------------*/
;*    *values* ...                                                     */
;*---------------------------------------------------------------------*/
(define *res-number* 1)
(define *res1* #unspecified)
(define *res2* #unspecified)
(define *res3* #unspecified)

;*---------------------------------------------------------------------*/
;*    values ...                                                       */
;*    -------------------------------------------------------------    */
;*    Values with exactly one argument are not boxed.                  */
;*---------------------------------------------------------------------*/
(define (values . args)
   (let ((all-args args))
      (if (null? args)
	  (set! *res-number* 0)
	  (if (null? (cdr args))
		  (begin
		     (set! *res-number* 1)
		     (car args))
		  (let ((res0 (car args)))
		     (set! args (cdr args))
		     (set! *res1* (car args))
		     (set! args (cdr args))
		     (if (pair? args)
			 (begin
			    (set! *res2* (car args))
			    (set! args (cdr args))
			    (if (pair? args)
				(if (pair? (cdr args))
				    (begin
				       (set! *res-number* -1)
				       all-args)
				    (begin
				       (set! *res3* (car args))
				       (set! *res-number* 4)
				       res0))
				(begin
				   (set! *res-number* 3)
				   res0)))
			 (begin
			    (set! *res-number* 2)
			    res0)))))))
	      
;*---------------------------------------------------------------------*/
;*    call-with-values ...                                             */
;*---------------------------------------------------------------------*/
(define (call-with-values producer consumer)
   (set! *res-number* 1)
   (let ((res0 (producer)))
      (case *res-number*
	 ((-1)
	  (apply consumer res0))
	 ((0)
	  (consumer))
	 ((1)
	  (consumer res0))
	 ((2)
	  (consumer res0 *res1*))
	 ((3)
	  (consumer res0 *res1* *res2*))
	 ((4)
	  (consumer res0 *res1* *res2* *res3*))
	 (else
	  (apply consumer res0)))))


