/*===========================================================================*/
/*   (Ieee/string.scm)                                                       */
/*   Bigloo (1.9)                                                            */
/*   Manuel Serrano (c)       Sat Mar 21 19:53:37 MET 1998                   */
/*    --------------------------------------------------------------------   */
/*       Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.     */
/*                                                                           */
/*                                        ,--^,                              */
/*                                  _ ___/ /|/                               */
/*                              ,;'( )__, ) '                                */
/*                             ;;  //   L__.                                 */
/*                             '   \   /  '                                  */
/*                                  ^   ^                                    */
/*                                                                           */
/*                                                                           */
/*       This program is distributed in the hope that it will be useful.     */
/*       Use and copying of this software and preparation of derivative      */
/*       works based upon this software are permitted, so long as the        */
/*       following conditions are met:                                       */
/*              o credit to the authors is acknowledged following            */
/*                current academic behaviour                                 */
/*              o no fees or compensation are charged for use, copies,       */
/*                or access to this software                                 */
/*              o this copyright notice is included intact.                  */
/*         This software is made available AS IS, and no warranty is made    */
/*         about the software or its performance.                            */
/*                                                                           */
/*         Bug descriptions, use reports, comments or suggestions are        */
/*         welcome. Send them to                                             */
/*           Manuel Serrano -- Manuel.Serrano@unice.fr                       */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo1.9c.h>
#include <signal.h>

extern obj_t _string___127___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t _string___255___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t _string_capitalize__130___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_cigt(obj_t, obj_t);
extern obj_t _string_append_156___r4_strings_6_7(obj_t, obj_t);
extern obj_t _string_ci___81___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t _string_upcase_57___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_for_read(obj_t);
extern obj_t blit_string_ur__74___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t list__string_78___r4_strings_6_7(obj_t);
extern bool_t string___248___r4_strings_6_7(obj_t, obj_t);
extern bool_t string___146___r4_strings_6_7(obj_t, obj_t);
extern obj_t make_string_124___r4_strings_6_7(int, obj_t);
extern obj_t _substring_ur_108___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern obj_t _string_capitalize_167___r4_strings_6_7(obj_t, obj_t);
extern obj_t reverse__39___r4_pairs_and_lists_6_3(obj_t);
extern bool_t bigloo_strcmp(obj_t, obj_t);
extern bool_t strcicmp(obj_t, obj_t);
extern unsigned char string_ref_ur_85___r4_strings_6_7(obj_t, long);
extern obj_t _string_for_read_188___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_to_bstring(char *);
extern obj_t _string_ci___142___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t _string__list_157___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_lt(obj_t, obj_t);
extern obj_t _string_set_ur__229___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern obj_t _string_ci____205___r4_strings_6_7(obj_t, obj_t, obj_t);
extern bool_t string_cige(obj_t, obj_t);
extern obj_t _list__string_5___r4_strings_6_7(obj_t, obj_t);
extern obj_t _string_set__77___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern obj_t _string____82___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_capitalize_230___r4_strings_6_7(obj_t);
extern long string_length_125___r4_strings_6_7(obj_t);
extern obj_t _string_fill__171___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t _string___r4_strings_6_7(obj_t, obj_t);
static obj_t loop___r4_strings_6_7(obj_t);
extern obj_t blit_string__141___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t _string____206___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t make_string(long, unsigned char);
extern obj_t _string_ref_ur_173___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_downcase__42___r4_strings_6_7(obj_t);
extern bool_t string_ge(obj_t, obj_t);
extern obj_t string__list_125___r4_strings_6_7(obj_t);
extern obj_t _make_string_205___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t imported_modules_init_94___r4_strings_6_7();
extern obj_t _string_downcase_136___r4_strings_6_7(obj_t, obj_t);
extern obj_t module_initialization_70___r4_strings_6_7(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t blit_string(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t substring_ur_202___r4_strings_6_7(obj_t, long, long);
extern bool_t string__76___r4_strings_6_7(obj_t);
extern bool_t string____135___r4_strings_6_7(obj_t, obj_t);
extern bool_t string___83___r4_strings_6_7(obj_t, obj_t);
extern obj_t _string_downcase__151___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_upcase_71___r4_strings_6_7(obj_t);
extern bool_t string_ci____210___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_ci____43___r4_strings_6_7(obj_t, obj_t);
extern unsigned char string_ref_239___r4_strings_6_7(obj_t, long);
extern obj_t _substring___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern obj_t _blit_string__194___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t string_set__176___r4_strings_6_7(obj_t, long, unsigned char);
extern bool_t string_le(obj_t, obj_t);
extern obj_t _string_ref_61___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t _string___169___r4_strings_6_7(obj_t, obj_t, obj_t);
extern long list_length(obj_t);
extern obj_t string_upcase__158___r4_strings_6_7(obj_t);
extern bool_t string_cile(obj_t, obj_t);
extern bool_t string_gt(obj_t, obj_t);
extern bool_t string____33___r4_strings_6_7(obj_t, obj_t);
extern obj_t _string_ci___143___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_capitalize__136___r4_strings_6_7(obj_t);
extern obj_t string_downcase_77___r4_strings_6_7(obj_t);
extern obj_t string_fill__51___r4_strings_6_7(obj_t, unsigned char);
extern obj_t _string__159___r4_strings_6_7(obj_t, obj_t);
static obj_t require_initialization_114___r4_strings_6_7 = BUNSPEC;
extern obj_t string_append_106___r4_strings_6_7(obj_t);
extern bool_t string_cilt(obj_t, obj_t);
extern obj_t _string_ci____133___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_append(obj_t, obj_t);
extern obj_t string_for_read_25___r4_strings_6_7(obj_t);
extern obj_t string_set_ur__94___r4_strings_6_7(obj_t, long, unsigned char);
extern bool_t string_ci___247___r4_strings_6_7(obj_t, obj_t);
extern obj_t string___r4_strings_6_7(obj_t);
extern obj_t c_substring(obj_t, long, long);
extern obj_t substring___r4_strings_6_7(obj_t, long, long);
extern obj_t _blit_string_ur__119___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern bool_t string_ci___92___r4_strings_6_7(obj_t, obj_t);
extern obj_t _string_copy_145___r4_strings_6_7(obj_t, obj_t);
extern obj_t _string_length_141___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_ci___60___r4_strings_6_7(obj_t, obj_t);
extern obj_t _string_upcase__30___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_copy_207___r4_strings_6_7(obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( string_capitalize_env_253___r4_strings_6_7, _string_capitalize_167___r4_strings_6_71212, _string_capitalize_167___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( list__string_env_249___r4_strings_6_7, _list__string_5___r4_strings_6_71213, _list__string_5___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_string_env_55___r4_strings_6_7, _make_string_205___r4_strings_6_71214, va_generic_entry, _make_string_205___r4_strings_6_7, -2 );
DEFINE_EXPORT_PROCEDURE( blit_string_ur__env_52___r4_strings_6_7, _blit_string_ur__119___r4_strings_6_71215, _blit_string_ur__119___r4_strings_6_7, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( string_downcase__env_73___r4_strings_6_7, _string_downcase__151___r4_strings_6_71216, _string_downcase__151___r4_strings_6_7, 0L, 1 );
DEFINE_STRING( string1210___r4_strings_6_7, string1210___r4_strings_6_71217, "Index and length out of range", 29 );
DEFINE_EXPORT_PROCEDURE( string__env_22___r4_strings_6_7, _string__159___r4_strings_6_71218, _string__159___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_29___r4_strings_6_7, _string_ci___142___r4_strings_6_71219, _string_ci___142___r4_strings_6_7, 0L, 2 );
DEFINE_STRING( string1208___r4_strings_6_7, string1208___r4_strings_6_71220, "", 0 );
DEFINE_EXPORT_PROCEDURE( substring_ur_env_69___r4_strings_6_7, _substring_ur_108___r4_strings_6_71221, _substring_ur_108___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( blit_string__env_232___r4_strings_6_7, _blit_string__194___r4_strings_6_71222, _blit_string__194___r4_strings_6_7, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( string___env_245___r4_strings_6_7, _string___127___r4_strings_6_71223, _string___127___r4_strings_6_7, 0L, 2 );
DEFINE_STRING( string1207___r4_strings_6_7, string1207___r4_strings_6_71224, "Illegal index", 13 );
DEFINE_EXPORT_PROCEDURE( string___env_211___r4_strings_6_7, _string___169___r4_strings_6_71225, _string___169___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__list_env_217___r4_strings_6_7, _string__list_157___r4_strings_6_71226, _string__list_157___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_ur_env_171___r4_strings_6_7, _string_ref_ur_173___r4_strings_6_71227, _string_ref_ur_173___r4_strings_6_7, 0L, 2 );
DEFINE_STRING( string1209___r4_strings_6_7, string1209___r4_strings_6_71228, "blit-string!", 12 );
DEFINE_EXPORT_PROCEDURE( string_ci____env_37___r4_strings_6_7, _string_ci____133___r4_strings_6_71229, _string_ci____133___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_set_ur__env_0___r4_strings_6_7, _string_set_ur__229___r4_strings_6_71230, _string_set_ur__229___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_copy_env_8___r4_strings_6_7, _string_copy_145___r4_strings_6_71231, _string_copy_145___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string____env_63___r4_strings_6_7, _string____82___r4_strings_6_71232, _string____82___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_62___r4_strings_6_7, _string_ci___81___r4_strings_6_71233, _string_ci___81___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_env_246___r4_strings_6_7, _string___r4_strings_6_71234, va_generic_entry, _string___r4_strings_6_7, -1 );
DEFINE_STRING( string1205___r4_strings_6_7, string1205___r4_strings_6_71235, "string-set!", 11 );
DEFINE_EXPORT_PROCEDURE( substring_env_248___r4_strings_6_7, _substring___r4_strings_6_71236, _substring___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_upcase__env_48___r4_strings_6_7, _string_upcase__30___r4_strings_6_71237, _string_upcase__30___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_env_251___r4_strings_6_7, _string_ref_61___r4_strings_6_71238, _string_ref_61___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_set__env_239___r4_strings_6_7, _string_set__77___r4_strings_6_71239, _string_set__77___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_fill__env_181___r4_strings_6_7, _string_fill__171___r4_strings_6_71240, _string_fill__171___r4_strings_6_7, 0L, 2 );
DEFINE_STRING( string1203___r4_strings_6_7, string1203___r4_strings_6_71241, "string-ref", 10 );
DEFINE_EXPORT_PROCEDURE( string_upcase_env_136___r4_strings_6_7, _string_upcase_57___r4_strings_6_71242, _string_upcase_57___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_46___r4_strings_6_7, _string_ci___143___r4_strings_6_71243, _string_ci___143___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_capitalize__env_137___r4_strings_6_7, _string_capitalize__130___r4_strings_6_71244, _string_capitalize__130___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_downcase_env_169___r4_strings_6_7, _string_downcase_136___r4_strings_6_71245, _string_downcase_136___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_length_env_217___r4_strings_6_7, _string_length_141___r4_strings_6_71246, _string_length_141___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_for_read_env_47___r4_strings_6_7, _string_for_read_188___r4_strings_6_71247, _string_for_read_188___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_append_env_17___r4_strings_6_7, _string_append_156___r4_strings_6_71248, va_generic_entry, _string_append_156___r4_strings_6_7, -1 );
DEFINE_STRING( string1206___r4_strings_6_7, string1206___r4_strings_6_71249, "substring", 9 );
DEFINE_EXPORT_PROCEDURE( string____env_18___r4_strings_6_7, _string____206___r4_strings_6_71250, _string____206___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci____env_38___r4_strings_6_7, _string_ci____205___r4_strings_6_71251, _string_ci____205___r4_strings_6_7, 0L, 2 );
DEFINE_STRING( string1204___r4_strings_6_7, string1204___r4_strings_6_71252, "index out of range", 18 );
DEFINE_EXPORT_PROCEDURE( string___env_124___r4_strings_6_7, _string___255___r4_strings_6_71253, _string___255___r4_strings_6_7, 0L, 2 );

obj_t module_initialization_70___r4_strings_6_7(long checksum_874, char * from_875)
{
if(CBOOL(require_initialization_114___r4_strings_6_7)){
require_initialization_114___r4_strings_6_7 = BBOOL(((bool_t)0));
imported_modules_init_94___r4_strings_6_7();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


bool_t string__76___r4_strings_6_7(obj_t obj_1)
{
return STRINGP(obj_1);
}


obj_t _string__159___r4_strings_6_7(obj_t env_726, obj_t obj_727)
{
{
bool_t aux_881;
{
obj_t obj_824;
obj_824 = obj_727;
aux_881 = STRINGP(obj_824);
}
return BBOOL(aux_881);
}
}


obj_t make_string_124___r4_strings_6_7(int k_2, obj_t char_166_3)
{
if(NULLP(char_166_3)){
long aux_886;
aux_886 = (long)(k_2);
return make_string(aux_886, ((unsigned char)' '));
}
 else {
unsigned char aux_891;
long aux_889;
{
obj_t aux_892;
aux_892 = CAR(char_166_3);
aux_891 = (unsigned char)CCHAR(aux_892);
}
aux_889 = (long)(k_2);
return make_string(aux_889, aux_891);
}
}


obj_t _make_string_205___r4_strings_6_7(obj_t env_728, obj_t k_729, obj_t char_166_730)
{
{
int k_825;
obj_t char_166_826;
k_825 = CINT(k_729);
char_166_826 = char_166_730;
if(NULLP(char_166_826)){
long aux_899;
aux_899 = (long)(k_825);
return make_string(aux_899, ((unsigned char)' '));
}
 else {
unsigned char aux_904;
long aux_902;
{
obj_t aux_905;
aux_905 = CAR(char_166_826);
aux_904 = (unsigned char)CCHAR(aux_905);
}
aux_902 = (long)(k_825);
return make_string(aux_902, aux_904);
}
}
}


obj_t string___r4_strings_6_7(obj_t chars_4)
{
return list__string_78___r4_strings_6_7(chars_4);
}


obj_t _string___r4_strings_6_7(obj_t env_731, obj_t chars_732)
{
{
obj_t chars_827;
chars_827 = chars_732;
return list__string_78___r4_strings_6_7(chars_827);
}
}


long string_length_125___r4_strings_6_7(obj_t string_5)
{
return STRING_LENGTH(string_5);
}


obj_t _string_length_141___r4_strings_6_7(obj_t env_733, obj_t string_734)
{
{
long aux_912;
{
obj_t string_828;
string_828 = string_734;
aux_912 = STRING_LENGTH(string_828);
}
return BINT(aux_912);
}
}


unsigned char string_ref_239___r4_strings_6_7(obj_t string_6, long k_7)
{
{
bool_t test_915;
{
long aux_916;
aux_916 = STRING_LENGTH(string_6);
test_915 = BOUND_CHECK(k_7, aux_916);
}
if(test_915){
return STRING_REF(string_6, k_7);
}
 else {
FAILURE(string1203___r4_strings_6_7,string1204___r4_strings_6_7,BINT(k_7));}
}
}


obj_t _string_ref_61___r4_strings_6_7(obj_t env_735, obj_t string_736, obj_t k_737)
{
{
unsigned char aux_922;
{
obj_t string_829;
long k_830;
string_829 = string_736;
k_830 = (long)CINT(k_737);
{
bool_t test_924;
{
long aux_925;
aux_925 = STRING_LENGTH(string_829);
test_924 = BOUND_CHECK(k_830, aux_925);
}
if(test_924){
aux_922 = STRING_REF(string_829, k_830);
}
 else {
FAILURE(string1203___r4_strings_6_7,string1204___r4_strings_6_7,BINT(k_830));}
}
}
return BCHAR(aux_922);
}
}


obj_t string_set__176___r4_strings_6_7(obj_t string_8, long k_9, unsigned char char_166_10)
{
{
bool_t test_932;
{
long aux_933;
aux_933 = STRING_LENGTH(string_8);
test_932 = BOUND_CHECK(k_9, aux_933);
}
if(test_932){
return STRING_SET(string_8, k_9, char_166_10);
}
 else {
FAILURE(string1205___r4_strings_6_7,string1204___r4_strings_6_7,BINT(k_9));}
}
}


obj_t _string_set__77___r4_strings_6_7(obj_t env_738, obj_t string_739, obj_t k_740, obj_t char_166_741)
{
{
obj_t string_831;
long k_832;
unsigned char char_166_833;
string_831 = string_739;
k_832 = (long)CINT(k_740);
char_166_833 = (unsigned char)CCHAR(char_166_741);
{
bool_t test_941;
{
long aux_942;
aux_942 = STRING_LENGTH(string_831);
test_941 = BOUND_CHECK(k_832, aux_942);
}
if(test_941){
return STRING_SET(string_831, k_832, char_166_833);
}
 else {
FAILURE(string1205___r4_strings_6_7,string1204___r4_strings_6_7,BINT(k_832));}
}
}
}


unsigned char string_ref_ur_85___r4_strings_6_7(obj_t string_11, long k_12)
{
return STRING_REF(string_11, k_12);
}


obj_t _string_ref_ur_173___r4_strings_6_7(obj_t env_742, obj_t string_743, obj_t k_744)
{
{
unsigned char aux_949;
{
obj_t string_834;
long k_835;
string_834 = string_743;
k_835 = (long)CINT(k_744);
aux_949 = STRING_REF(string_834, k_835);
}
return BCHAR(aux_949);
}
}


obj_t string_set_ur__94___r4_strings_6_7(obj_t string_13, long k_14, unsigned char char_166_15)
{
return STRING_SET(string_13, k_14, char_166_15);
}


obj_t _string_set_ur__229___r4_strings_6_7(obj_t env_745, obj_t string_746, obj_t k_747, obj_t char_166_748)
{
{
obj_t string_836;
long k_837;
unsigned char char_166_838;
string_836 = string_746;
k_837 = (long)CINT(k_747);
char_166_838 = (unsigned char)CCHAR(char_166_748);
return STRING_SET(string_836, k_837, char_166_838);
}
}


bool_t string___146___r4_strings_6_7(obj_t string1_16, obj_t string2_17)
{
return bigloo_strcmp(string1_16, string2_17);
}


obj_t _string___169___r4_strings_6_7(obj_t env_749, obj_t string1_750, obj_t string2_751)
{
{
bool_t aux_958;
{
obj_t string1_839;
obj_t string2_840;
string1_839 = string1_750;
string2_840 = string2_751;
aux_958 = bigloo_strcmp(string1_839, string2_840);
}
return BBOOL(aux_958);
}
}


bool_t string_ci___247___r4_strings_6_7(obj_t string1_18, obj_t string2_19)
{
return strcicmp(string1_18, string2_19);
}


obj_t _string_ci___81___r4_strings_6_7(obj_t env_752, obj_t string1_753, obj_t string2_754)
{
{
bool_t aux_962;
{
obj_t string1_841;
obj_t string2_842;
string1_841 = string1_753;
string2_842 = string2_754;
aux_962 = strcicmp(string1_841, string2_842);
}
return BBOOL(aux_962);
}
}


bool_t string___83___r4_strings_6_7(obj_t string1_20, obj_t string2_21)
{
return string_lt(string1_20, string2_21);
}


obj_t _string___127___r4_strings_6_7(obj_t env_755, obj_t string1_756, obj_t string2_757)
{
{
bool_t aux_966;
{
obj_t string1_843;
obj_t string2_844;
string1_843 = string1_756;
string2_844 = string2_757;
aux_966 = string_lt(string1_843, string2_844);
}
return BBOOL(aux_966);
}
}


bool_t string___248___r4_strings_6_7(obj_t string1_22, obj_t string2_23)
{
return string_gt(string1_22, string2_23);
}


obj_t _string___255___r4_strings_6_7(obj_t env_758, obj_t string1_759, obj_t string2_760)
{
{
bool_t aux_970;
{
obj_t string1_845;
obj_t string2_846;
string1_845 = string1_759;
string2_846 = string2_760;
aux_970 = string_gt(string1_845, string2_846);
}
return BBOOL(aux_970);
}
}


bool_t string____33___r4_strings_6_7(obj_t string1_24, obj_t string2_25)
{
return string_le(string1_24, string2_25);
}


obj_t _string____82___r4_strings_6_7(obj_t env_761, obj_t string1_762, obj_t string2_763)
{
{
bool_t aux_974;
{
obj_t string1_847;
obj_t string2_848;
string1_847 = string1_762;
string2_848 = string2_763;
aux_974 = string_le(string1_847, string2_848);
}
return BBOOL(aux_974);
}
}


bool_t string____135___r4_strings_6_7(obj_t string1_26, obj_t string2_27)
{
return string_ge(string1_26, string2_27);
}


obj_t _string____206___r4_strings_6_7(obj_t env_764, obj_t string1_765, obj_t string2_766)
{
{
bool_t aux_978;
{
obj_t string1_849;
obj_t string2_850;
string1_849 = string1_765;
string2_850 = string2_766;
aux_978 = string_ge(string1_849, string2_850);
}
return BBOOL(aux_978);
}
}


bool_t string_ci___92___r4_strings_6_7(obj_t string1_28, obj_t string2_29)
{
return string_cilt(string1_28, string2_29);
}


obj_t _string_ci___142___r4_strings_6_7(obj_t env_767, obj_t string1_768, obj_t string2_769)
{
{
bool_t aux_982;
{
obj_t string1_851;
obj_t string2_852;
string1_851 = string1_768;
string2_852 = string2_769;
aux_982 = string_cilt(string1_851, string2_852);
}
return BBOOL(aux_982);
}
}


bool_t string_ci___60___r4_strings_6_7(obj_t string1_30, obj_t string2_31)
{
return string_cigt(string1_30, string2_31);
}


obj_t _string_ci___143___r4_strings_6_7(obj_t env_770, obj_t string1_771, obj_t string2_772)
{
{
bool_t aux_986;
{
obj_t string1_853;
obj_t string2_854;
string1_853 = string1_771;
string2_854 = string2_772;
aux_986 = string_cigt(string1_853, string2_854);
}
return BBOOL(aux_986);
}
}


bool_t string_ci____210___r4_strings_6_7(obj_t string1_32, obj_t string2_33)
{
return string_cile(string1_32, string2_33);
}


obj_t _string_ci____205___r4_strings_6_7(obj_t env_773, obj_t string1_774, obj_t string2_775)
{
{
bool_t aux_990;
{
obj_t string1_855;
obj_t string2_856;
string1_855 = string1_774;
string2_856 = string2_775;
aux_990 = string_cile(string1_855, string2_856);
}
return BBOOL(aux_990);
}
}


bool_t string_ci____43___r4_strings_6_7(obj_t string1_34, obj_t string2_35)
{
return string_cige(string1_34, string2_35);
}


obj_t _string_ci____133___r4_strings_6_7(obj_t env_776, obj_t string1_777, obj_t string2_778)
{
{
bool_t aux_994;
{
obj_t string1_857;
obj_t string2_858;
string1_857 = string1_777;
string2_858 = string2_778;
aux_994 = string_cige(string1_857, string2_858);
}
return BBOOL(aux_994);
}
}


obj_t substring___r4_strings_6_7(obj_t string_36, long start_37, long end_38)
{
{
bool_t test_997;
if((end_38>=start_37)){
bool_t test_1000;
{
long aux_1001;
{
long aux_1002;
aux_1002 = STRING_LENGTH(string_36);
aux_1001 = (aux_1002+((long)1));
}
test_1000 = BOUND_CHECK(start_37, aux_1001);
}
if(test_1000){
long aux_1006;
{
long aux_1007;
aux_1007 = STRING_LENGTH(string_36);
aux_1006 = (aux_1007+((long)1));
}
test_997 = BOUND_CHECK(end_38, aux_1006);
}
 else {
test_997 = ((bool_t)0);
}
}
 else {
test_997 = ((bool_t)0);
}
if(test_997){
return c_substring(string_36, start_37, end_38);
}
 else {
obj_t arg1019_859;
{
obj_t aux_1014;
obj_t aux_1012;
aux_1014 = BINT(end_38);
aux_1012 = BINT(start_37);
arg1019_859 = MAKE_PAIR(aux_1012, aux_1014);
}
FAILURE(string1206___r4_strings_6_7,string1207___r4_strings_6_7,arg1019_859);}
}
}


obj_t _substring___r4_strings_6_7(obj_t env_779, obj_t string_780, obj_t start_781, obj_t end_782)
{
{
obj_t string_860;
long start_861;
long end_862;
string_860 = string_780;
start_861 = (long)CINT(start_781);
end_862 = (long)CINT(end_782);
{
bool_t test_1020;
if((end_862>=start_861)){
bool_t test_1023;
{
long aux_1024;
{
long aux_1025;
aux_1025 = STRING_LENGTH(string_860);
aux_1024 = (aux_1025+((long)1));
}
test_1023 = BOUND_CHECK(start_861, aux_1024);
}
if(test_1023){
long aux_1029;
{
long aux_1030;
aux_1030 = STRING_LENGTH(string_860);
aux_1029 = (aux_1030+((long)1));
}
test_1020 = BOUND_CHECK(end_862, aux_1029);
}
 else {
test_1020 = ((bool_t)0);
}
}
 else {
test_1020 = ((bool_t)0);
}
if(test_1020){
return c_substring(string_860, start_861, end_862);
}
 else {
obj_t arg1019_863;
{
obj_t aux_1037;
obj_t aux_1035;
aux_1037 = BINT(end_862);
aux_1035 = BINT(start_861);
arg1019_863 = MAKE_PAIR(aux_1035, aux_1037);
}
FAILURE(string1206___r4_strings_6_7,string1207___r4_strings_6_7,arg1019_863);}
}
}
}


obj_t substring_ur_202___r4_strings_6_7(obj_t string_39, long start_40, long end_41)
{
return c_substring(string_39, start_40, end_41);
}


obj_t _substring_ur_108___r4_strings_6_7(obj_t env_783, obj_t string_784, obj_t start_785, obj_t end_786)
{
{
obj_t string_864;
long start_865;
long end_866;
string_864 = string_784;
start_865 = (long)CINT(start_785);
end_866 = (long)CINT(end_786);
return c_substring(string_864, start_865, end_866);
}
}


obj_t string_append_106___r4_strings_6_7(obj_t list_42)
{
if(NULLP(list_42)){
return string1208___r4_strings_6_7;
}
 else {
return loop___r4_strings_6_7(list_42);
}
}


obj_t loop___r4_strings_6_7(obj_t list_235)
{
{
bool_t test_1048;
{
obj_t aux_1049;
aux_1049 = CDR(list_235);
test_1048 = NULLP(aux_1049);
}
if(test_1048){
return CAR(list_235);
}
 else {
obj_t arg1031_238;
obj_t arg1032_239;
arg1031_238 = CAR(list_235);
arg1032_239 = loop___r4_strings_6_7(CDR(list_235));
return string_append(arg1031_238, arg1032_239);
}
}
}


obj_t _string_append_156___r4_strings_6_7(obj_t env_787, obj_t list_788)
{
return string_append_106___r4_strings_6_7(list_788);
}


obj_t list__string_78___r4_strings_6_7(obj_t list_43)
{
{
long len_242;
len_242 = list_length(list_43);
{
obj_t string_243;
{
obj_t res1199_486;
{
long aux_1059;
{
int aux_1060;
aux_1060 = (int)(len_242);
aux_1059 = (long)(aux_1060);
}
res1199_486 = make_string(aux_1059, ((unsigned char)' '));
}
string_243 = res1199_486;
}
{
{
long i_488;
obj_t l_489;
i_488 = ((long)0);
l_489 = list_43;
loop_487:
if((i_488==len_242)){
return string_243;
}
 else {
{
unsigned char aux_1066;
{
obj_t aux_1067;
aux_1067 = CAR(l_489);
aux_1066 = (unsigned char)CCHAR(aux_1067);
}
STRING_SET(string_243, i_488, aux_1066);
}
{
obj_t l_1073;
long i_1071;
i_1071 = (i_488+((long)1));
l_1073 = CDR(l_489);
l_489 = l_1073;
i_488 = i_1071;
goto loop_487;
}
}
}
}
}
}
}


obj_t _list__string_5___r4_strings_6_7(obj_t env_789, obj_t list_790)
{
return list__string_78___r4_strings_6_7(list_790);
}


obj_t string__list_125___r4_strings_6_7(obj_t string_44)
{
{
long len_252;
len_252 = STRING_LENGTH(string_44);
{
long i_537;
obj_t acc_538;
i_537 = ((long)0);
acc_538 = BNIL;
loop_536:
if((i_537==len_252)){
return reverse__39___r4_pairs_and_lists_6_3(acc_538);
}
 else {
long arg1045_544;
obj_t arg1046_545;
arg1045_544 = (i_537+((long)1));
{
obj_t aux_1081;
{
unsigned char aux_1082;
aux_1082 = STRING_REF(string_44, i_537);
aux_1081 = BCHAR(aux_1082);
}
arg1046_545 = MAKE_PAIR(aux_1081, acc_538);
}
{
obj_t acc_1087;
long i_1086;
i_1086 = arg1045_544;
acc_1087 = arg1046_545;
acc_538 = acc_1087;
i_537 = i_1086;
goto loop_536;
}
}
}
}
}


obj_t _string__list_157___r4_strings_6_7(obj_t env_791, obj_t string_792)
{
return string__list_125___r4_strings_6_7(string_792);
}


obj_t string_copy_207___r4_strings_6_7(obj_t string_45)
{
{
char * aux_1089;
aux_1089 = BSTRING_TO_STRING(string_45);
return string_to_bstring(aux_1089);
}
}


obj_t _string_copy_145___r4_strings_6_7(obj_t env_793, obj_t string_794)
{
{
obj_t string_867;
string_867 = string_794;
{
char * aux_1092;
aux_1092 = BSTRING_TO_STRING(string_867);
return string_to_bstring(aux_1092);
}
}
}


obj_t string_fill__51___r4_strings_6_7(obj_t string_46, unsigned char char_166_47)
{
{
long len_581;
len_581 = STRING_LENGTH(string_46);
{
long i_588;
i_588 = ((long)0);
loop_587:
if((i_588==len_581)){
return string_46;
}
 else {
STRING_SET(string_46, i_588, char_166_47);
{
long i_1099;
i_1099 = (i_588+((long)1));
i_588 = i_1099;
goto loop_587;
}
}
}
}
}


obj_t _string_fill__171___r4_strings_6_7(obj_t env_795, obj_t string_796, obj_t char_166_797)
{
return string_fill__51___r4_strings_6_7(string_796, (unsigned char)CCHAR(char_166_797));
}


obj_t string_upcase_71___r4_strings_6_7(obj_t string_48)
{
{
long len_267;
len_267 = STRING_LENGTH(string_48);
{
obj_t res_268;
{
obj_t res1200_626;
{
long aux_1104;
{
int aux_1105;
aux_1105 = (int)(len_267);
aux_1104 = (long)(aux_1105);
}
res1200_626 = make_string(aux_1104, ((unsigned char)' '));
}
res_268 = res1200_626;
}
{
{
long i_269;
i_269 = ((long)0);
loop_270:
if((i_269==len_267)){
return res_268;
}
 else {
{
unsigned char aux_1111;
{
unsigned char aux_1112;
aux_1112 = STRING_REF(string_48, i_269);
aux_1111 = toupper(aux_1112);
}
STRING_SET(res_268, i_269, aux_1111);
}
{
long i_1116;
i_1116 = (i_269+((long)1));
i_269 = i_1116;
goto loop_270;
}
}
}
}
}
}
}


obj_t _string_upcase_57___r4_strings_6_7(obj_t env_798, obj_t string_799)
{
return string_upcase_71___r4_strings_6_7(string_799);
}


obj_t string_downcase_77___r4_strings_6_7(obj_t string_49)
{
{
long len_276;
len_276 = STRING_LENGTH(string_49);
{
obj_t res_277;
{
obj_t res1201_644;
{
long aux_1120;
{
int aux_1121;
aux_1121 = (int)(len_276);
aux_1120 = (long)(aux_1121);
}
res1201_644 = make_string(aux_1120, ((unsigned char)' '));
}
res_277 = res1201_644;
}
{
{
long i_278;
i_278 = ((long)0);
loop_279:
if((i_278==len_276)){
return res_277;
}
 else {
{
unsigned char aux_1127;
{
unsigned char aux_1128;
aux_1128 = STRING_REF(string_49, i_278);
aux_1127 = tolower(aux_1128);
}
STRING_SET(res_277, i_278, aux_1127);
}
{
long i_1132;
i_1132 = (i_278+((long)1));
i_278 = i_1132;
goto loop_279;
}
}
}
}
}
}
}


obj_t _string_downcase_136___r4_strings_6_7(obj_t env_800, obj_t string_801)
{
return string_downcase_77___r4_strings_6_7(string_801);
}


obj_t string_upcase__158___r4_strings_6_7(obj_t string_50)
{
{
long len_285;
len_285 = STRING_LENGTH(string_50);
{
{
long i_287;
i_287 = ((long)0);
loop_288:
if((i_287==len_285)){
return string_50;
}
 else {
{
unsigned char aux_1138;
{
unsigned char aux_1139;
aux_1139 = STRING_REF(string_50, i_287);
aux_1138 = toupper(aux_1139);
}
STRING_SET(string_50, i_287, aux_1138);
}
{
long i_1143;
i_1143 = (i_287+((long)1));
i_287 = i_1143;
goto loop_288;
}
}
}
}
}
}


obj_t _string_upcase__30___r4_strings_6_7(obj_t env_802, obj_t string_803)
{
return string_upcase__158___r4_strings_6_7(string_803);
}


obj_t string_downcase__42___r4_strings_6_7(obj_t string_51)
{
{
long len_293;
len_293 = STRING_LENGTH(string_51);
{
{
long i_295;
i_295 = ((long)0);
loop_296:
if((i_295==len_293)){
return string_51;
}
 else {
{
unsigned char aux_1149;
{
unsigned char aux_1150;
aux_1150 = STRING_REF(string_51, i_295);
aux_1149 = tolower(aux_1150);
}
STRING_SET(string_51, i_295, aux_1149);
}
{
long i_1154;
i_1154 = (i_295+((long)1));
i_295 = i_1154;
goto loop_296;
}
}
}
}
}
}


obj_t _string_downcase__151___r4_strings_6_7(obj_t env_804, obj_t string_805)
{
return string_downcase__42___r4_strings_6_7(string_805);
}


obj_t string_capitalize__136___r4_strings_6_7(obj_t string_52)
{
{
bool_t non_first_alpha_60_301;
long string_len_173_302;
non_first_alpha_60_301 = ((bool_t)0);
string_len_173_302 = STRING_LENGTH(string_52);
{
long i_304;
i_304 = ((long)0);
do_loop__1003_20_312:
if((i_304==string_len_173_302)){
return string_52;
}
 else {
{
unsigned char c_307;
c_307 = STRING_REF(string_52, i_304);
{
bool_t test_1161;
{
unsigned char c_683;
c_683 = toupper(c_307);
if((c_683>=((unsigned char)'A'))){
test_1161 = (c_683<=((unsigned char)'Z'));
}
 else {
test_1161 = ((bool_t)0);
}
}
if(test_1161){
if(non_first_alpha_60_301){
unsigned char aux_1167;
aux_1167 = tolower(c_307);
STRING_SET(string_52, i_304, aux_1167);
}
 else {
non_first_alpha_60_301 = ((bool_t)1);
{
unsigned char aux_1170;
aux_1170 = toupper(c_307);
STRING_SET(string_52, i_304, aux_1170);
}
}
}
 else {
non_first_alpha_60_301 = ((bool_t)0);
}
}
}
{
long i_1173;
i_1173 = (i_304+((long)1));
i_304 = i_1173;
goto do_loop__1003_20_312;
}
}
}
}
}


obj_t _string_capitalize__130___r4_strings_6_7(obj_t env_806, obj_t string_807)
{
return string_capitalize__136___r4_strings_6_7(string_807);
}


obj_t string_capitalize_230___r4_strings_6_7(obj_t string_53)
{
{
obj_t arg1078_701;
{
char * aux_1176;
aux_1176 = BSTRING_TO_STRING(string_53);
arg1078_701 = string_to_bstring(aux_1176);
}
return string_capitalize__136___r4_strings_6_7(arg1078_701);
}
}


obj_t _string_capitalize_167___r4_strings_6_7(obj_t env_808, obj_t string_809)
{
return string_capitalize_230___r4_strings_6_7(string_809);
}


obj_t string_for_read_25___r4_strings_6_7(obj_t string_54)
{
return string_for_read(string_54);
}


obj_t _string_for_read_188___r4_strings_6_7(obj_t env_810, obj_t string_811)
{
{
obj_t string_868;
string_868 = string_811;
return string_for_read(string_868);
}
}


obj_t blit_string_ur__74___r4_strings_6_7(obj_t s1_55, obj_t o1_56, obj_t s2_57, obj_t o2_58, obj_t l_59)
{
return blit_string(s1_55, o1_56, s2_57, o2_58, l_59);
}


obj_t _blit_string_ur__119___r4_strings_6_7(obj_t env_812, obj_t s1_813, obj_t o1_814, obj_t s2_815, obj_t o2_816, obj_t l_817)
{
{
obj_t s1_869;
obj_t o1_870;
obj_t s2_871;
obj_t o2_872;
obj_t l_873;
s1_869 = s1_813;
o1_870 = o1_814;
s2_871 = s2_815;
o2_872 = o2_816;
l_873 = l_817;
return blit_string(s1_869, o1_870, s2_871, o2_872, l_873);
}
}


obj_t blit_string__141___r4_strings_6_7(obj_t s1_60, obj_t o1_61, obj_t s2_62, obj_t o2_63, obj_t l_64)
{
{
bool_t test_1185;
{
bool_t test_1186;
{
long aux_1193;
long aux_1187;
{
long aux_1194;
aux_1194 = STRING_LENGTH(s1_60);
aux_1193 = (aux_1194+((long)1));
}
{
long aux_1190;
long aux_1188;
aux_1190 = (long)CINT(o1_61);
aux_1188 = (long)CINT(l_64);
aux_1187 = (aux_1188+aux_1190);
}
test_1186 = BOUND_CHECK(aux_1187, aux_1193);
}
if(test_1186){
long aux_1204;
long aux_1198;
{
long aux_1205;
aux_1205 = STRING_LENGTH(s2_62);
aux_1204 = (aux_1205+((long)1));
}
{
long aux_1201;
long aux_1199;
aux_1201 = (long)CINT(o2_63);
aux_1199 = (long)CINT(l_64);
aux_1198 = (aux_1199+aux_1201);
}
test_1185 = BOUND_CHECK(aux_1198, aux_1204);
}
 else {
test_1185 = ((bool_t)0);
}
}
if(test_1185){
return blit_string(s1_60, o1_61, s2_62, o2_63, l_64);
}
 else {
obj_t arg1082_317;
{
long arg1083_318;
long arg1084_319;
arg1083_318 = STRING_LENGTH(s1_60);
arg1084_319 = STRING_LENGTH(s2_62);
{
obj_t list1085_320;
{
obj_t arg1086_321;
{
obj_t arg1087_322;
{
obj_t arg1088_323;
{
obj_t arg1089_324;
arg1089_324 = MAKE_PAIR(l_64, BNIL);
arg1088_323 = MAKE_PAIR(o2_63, arg1089_324);
}
{
obj_t aux_1214;
aux_1214 = BINT(arg1084_319);
arg1087_322 = MAKE_PAIR(aux_1214, arg1088_323);
}
}
arg1086_321 = MAKE_PAIR(o1_61, arg1087_322);
}
{
obj_t aux_1218;
aux_1218 = BINT(arg1083_318);
list1085_320 = MAKE_PAIR(aux_1218, arg1086_321);
}
}
arg1082_317 = list1085_320;
}
}
FAILURE(string1209___r4_strings_6_7,string1210___r4_strings_6_7,arg1082_317);}
}
}


obj_t _blit_string__194___r4_strings_6_7(obj_t env_818, obj_t s1_819, obj_t o1_820, obj_t s2_821, obj_t o2_822, obj_t l_823)
{
return blit_string__141___r4_strings_6_7(s1_819, o1_820, s2_821, o2_822, l_823);
}


obj_t imported_modules_init_94___r4_strings_6_7()
{
return module_initialization_70___error(((long)0), "__R4_STRINGS_6_7");
}


