;*=====================================================================*/
;*    serrano/prgm/project/bigloo/contrib/rx.scm                       */
;*    -------------------------------------------------------------    */
;*    Author      :  John Gerard Malecki                               */
;*    Creation    :  Mon Jul  8 08:31:56 1996                          */
;*    Last change :  Mon Jul  8 08:35:46 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A gnu rx package connection which implements an `apropos'        */
;*    facility as in:                                                  */
;*     1:=> (pp (apropos "-length$"))                                  */
;*		(THE-LENGTH                                            */
;*		  MARKED-PAIR-LENGTH                                   */
;*		  STRUCT-LENGTH                                        */
;*		  _struct-length                                       */
;*		  _tvector-length                                      */
;*		  _vector-length                                       */
;*		  STRING-LENGTH                                        */
;*		...                                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module apropos
   (main main)

   (C (obj c_symtab "c_symtab")

      (include "rxposix.h")

      (type regex_t (struct) "regex_t")
      (type regex_t* (pointer regex_t) "regex_t*")

      (macro int reg-icase "REG_ICASE")

      (macro int c-regcomp (regex_t* string int) "regcomp")
      (macro int c-regexec (regex_t* string int) "c_regexec")))

;*---------------------------------------------------------------------*/
;*    c_regexec                                                        */
;*---------------------------------------------------------------------*/
(pragma "#define c_regexec(c,s,e) regexec(c,s,0,0,e)")

;*---------------------------------------------------------------------*/
;*    regcomp ...                                                      */
;*---------------------------------------------------------------------*/
(define (regcomp pattern cflags)
   (let ((compiled (make-regex_t*)))
      
      (let ((rc (c-regcomp compiled pattern cflags)))

	 (if (zero? rc) compiled
	     (error 'regcomp "" rc)))))

;*---------------------------------------------------------------------*/
;*    regexec ...                                                      */
;*---------------------------------------------------------------------*/
(define (regexec compiled string eflags)
  (if (zero? (c-regexec compiled string eflags)) #t
      #f))

;*---------------------------------------------------------------------*/
;*    remove-if-not ...                                                */
;*---------------------------------------------------------------------*/
(define (remove-if-not p l)
  (cond ((null? l) l)
        ((p (car l)) (cons (car l) (remove-if-not p (cdr l))))
        (else (remove-if-not p (cdr l)))))

;*---------------------------------------------------------------------*/
;*    symtab ...                                                       */
;*---------------------------------------------------------------------*/
(define (symtab)
  c_symtab)

;*---------------------------------------------------------------------*/
;*    *oblist* ...                                                     */
;*---------------------------------------------------------------------*/
(define *oblist*
  (apply append (vector->list c_symtab)))

;*---------------------------------------------------------------------*/
;*    apropos ...                                                      */
;*---------------------------------------------------------------------*/
(define (apropos pattern)
   (if (symbol? pattern) (set! pattern (symbol->string pattern)))

   (let ((compiled (regcomp pattern reg-icase)))

      (define (apropos symbol)
	 (regexec compiled (symbol->string symbol) 0))

      (remove-if-not apropos *oblist*)))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main args)
  (repl))
