/*
  K R B T E L . H - "Kerberos functionality for C-Kermit"

  Copyright (C) 1998, Trustees of Columbia University in the City of New
  York.  The C-Kermit software may not be, in whole or in part, licensed or
  sold for profit as a software product itself, nor may it be included in or
  distributed with commercial products or otherwise distributed by commercial
  concerns to their clients or customers without written permission of the
  Office of Kermit Development and Distribution, Columbia University.  This
  copyright notice must not be removed, altered, or obscured.

  Author:
  Jeffrey E Altman (jaltman@columbia.edu) -- Kerberos IV and V intergration.
*/
/*
 * Based on a concatenation of all necessary include files distributed with
 * the Kerberos 5 NT Alpha 2 Telnet package from MIT.  
 */

#ifndef KRB5_TELNET_H
#define KRB5_TELNET_H
/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)telnet.h	8.1 (Berkeley) 6/2/93
 */

#ifndef _TELNET_H_
#define	_TELNET_H_

/*
 * Definitions for the TELNET protocol.
 */
#define	IAC	255		/* interpret as command: */
#define	DONT	254		/* you are not to use option */
#define	DO	253		/* please, you use option */
#define	WONT	252		/* I won't use option */
#define	WILL	251		/* I will use option */
#define	SB	250		/* interpret as subnegotiation */
#define	GA	249		/* you may reverse the line */
#define	EL	248		/* erase the current line */
#define	EC	247		/* erase the current character */
#define	AYT	246		/* are you there */
#define	AO	245		/* abort output--but let prog finish */
#define	IP	244		/* interrupt process--permanently */
#define	BREAK	243		/* break */
#define	DM	242		/* data mark--for connect. cleaning */
#define	NOP	241		/* nop */
#define	SE	240		/* end sub negotiation */
#define xEOR    239             /* end of record (transparent mode) */
#define	ABORT	238		/* Abort process */
#define	SUSP	237		/* Suspend process */
#define	xEOF	236		/* End of file: EOF is already used... */

#define SYNCH	242		/* for telfunc calls */

#ifdef TELCMDS
char *telcmds[] = {
	"EOF", "SUSP", "ABORT", "EOR",
	"SE", "NOP", "DMARK", "BRK", "IP", "AO", "AYT", "EC",
	"EL", "GA", "SB", "WILL", "WONT", "DO", "DONT", "IAC", 0,
};
#else
extern char *telcmds[];
#endif

#define	TELCMD_FIRST	xEOF
#define	TELCMD_LAST	IAC
#define	TELCMD_OK(x)	((unsigned int)(x) <= TELCMD_LAST && \
			 (unsigned int)(x) >= TELCMD_FIRST)
#define	TELCMD(x)	telcmds[(x)-TELCMD_FIRST]

/* telnet options */
#define TELOPT_BINARY	0	/* 8-bit data path */
#define TELOPT_ECHO	1	/* echo */
#define	TELOPT_RCP	2	/* prepare to reconnect */
#define	TELOPT_SGA	3	/* suppress go ahead */
#define	TELOPT_NAMS	4	/* approximate message size */
#define	TELOPT_STATUS	5	/* give status */
#define	TELOPT_TM	6	/* timing mark */
#define	TELOPT_RCTE	7	/* remote controlled transmission and echo */
#define TELOPT_NAOL 	8	/* negotiate about output line width */
#define TELOPT_NAOP 	9	/* negotiate about output page size */
#define TELOPT_NAOCRD	10	/* negotiate about CR disposition */
#define TELOPT_NAOHTS	11	/* negotiate about horizontal tabstops */
#define TELOPT_NAOHTD	12	/* negotiate about horizontal tab disposition */
#define TELOPT_NAOFFD	13	/* negotiate about formfeed disposition */
#define TELOPT_NAOVTS	14	/* negotiate about vertical tab stops */
#define TELOPT_NAOVTD	15	/* negotiate about vertical tab disposition */
#define TELOPT_NAOLFD	16	/* negotiate about output LF disposition */
#define TELOPT_XASCII	17	/* extended ascic character set */
#define	TELOPT_LOGOUT	18	/* force logout */
#define	TELOPT_BM	19	/* byte macro */
#define	TELOPT_DET	20	/* data entry terminal */
#define	TELOPT_SUPDUP	21	/* supdup protocol */
#define	TELOPT_SUPDUPOUTPUT 22	/* supdup output */
#define	TELOPT_SNDLOC	23	/* send location */
#define	TELOPT_TTYPE	24	/* terminal type */
#define	TELOPT_EOR	25	/* end or record */
#define	TELOPT_TUID	26	/* TACACS user identification */
#define	TELOPT_OUTMRK	27	/* output marking */
#define	TELOPT_TTYLOC	28	/* terminal location number */
#define	TELOPT_3270REGIME 29	/* 3270 regime */
#define	TELOPT_X3PAD	30	/* X.3 PAD */
#define	TELOPT_NAWS	31	/* window size */
#define	TELOPT_TSPEED	32	/* terminal speed */
#define	TELOPT_LFLOW	33	/* remote flow control */
#define TELOPT_LINEMODE	34	/* Linemode option */
#define TELOPT_XDISPLOC	35	/* X Display Location */
#define TELOPT_OLD_ENVIRON 36	/* Old - Environment variables */
#define	TELOPT_AUTHENTICATION 37/* Authenticate */
#define	TELOPT_ENCRYPT	38	/* Encryption option */
#define TELOPT_NEW_ENVIRON 39	/* New - Environment variables */
#define TELOPT_3270E    40
#define TELOPT_XAUTH    41
#define TELOPT_CHARSET  42
#define TELOPT_COM_PORT 44
#define TELOPT_NAKS     45
#define	TELOPT_EXOPL	255	/* extended-options-list */

#ifndef NTELOPTS
#define	NTELOPTS	45
#endif /* NTELOPTS */
#ifdef TELOPTS
char *telopts[NTELOPTS+1] = {
	"BINARY", "ECHO", "RCP", "SUPPRESS GO AHEAD", "NAME",
	"STATUS", "TIMING MARK", "RCTE", "NAOL", "NAOP",
	"NAOCRD", "NAOHTS", "NAOHTD", "NAOFFD", "NAOVTS",
	"NAOVTD", "NAOLFD", "EXTEND ASCII", "LOGOUT", "BYTE MACRO",
	"DATA ENTRY TERMINAL", "SUPDUP", "SUPDUP OUTPUT",
	"SEND LOCATION", "TERMINAL TYPE", "END OF RECORD",
	"TACACS UID", "OUTPUT MARKING", "TTYLOC",
	"3270 REGIME", "X.3 PAD", "NAWS", "TSPEED", "LFLOW",
	"LINEMODE", "XDISPLOC", "OLD-ENVIRON", "AUTHENTICATION",
	"ENCRYPT", "NEW-ENVIRON","TN3270E","XAUTH","CHARSET",
        "UNKNOWN","COM-PORT-CONTROL","NAKS",
	0,
};
#define	TELOPT_FIRST	TELOPT_BINARY
#define	TELOPT_LAST	TELOPT_NAKS
#define	TELOPT_OK(x)	((unsigned int)(x) <= TELOPT_LAST)
#define	TELOPT(x)	telopts[(x)-TELOPT_FIRST]
#endif

/* sub-option qualifiers */
#define	TELQUAL_IS	0	/* option is... */
#define	TELQUAL_SEND	1	/* send option */
#define	TELQUAL_INFO	2	/* ENVIRON: informational version of IS */
#define	TELQUAL_REPLY	2	/* AUTHENTICATION: client version of IS */
#define	TELQUAL_NAME	3	/* AUTHENTICATION: client version of IS */

#define	LFLOW_OFF		0	/* Disable remote flow control */
#define	LFLOW_ON		1	/* Enable remote flow control */
#define	LFLOW_RESTART_ANY	2	/* Restart output on any char */
#define	LFLOW_RESTART_XON	3	/* Restart output only on XON */

/*
 * LINEMODE suboptions
 */

#define	LM_MODE		1
#define	LM_FORWARDMASK	2
#define	LM_SLC		3

#define	MODE_EDIT	0x01
#define	MODE_TRAPSIG	0x02
#define	MODE_ACK	0x04
#define MODE_SOFT_TAB	0x08
#define MODE_LIT_ECHO	0x10

#define	MODE_MASK	0x1f

/* Not part of protocol, but needed to simplify things... */
#define MODE_FLOW		0x0100
#define MODE_ECHO		0x0200
#define MODE_INBIN		0x0400
#define MODE_OUTBIN		0x0800
#define MODE_FORCE		0x1000

#define	SLC_SYNCH	1
#define	SLC_BRK		2
#define	SLC_IP		3
#define	SLC_AO		4
#define	SLC_AYT		5
#define	SLC_EOR		6
#define	SLC_ABORT	7
#define	SLC_EOF		8
#define	SLC_SUSP	9
#define	SLC_EC		10
#define	SLC_EL		11
#define	SLC_EW		12
#define	SLC_RP		13
#define	SLC_LNEXT	14
#define	SLC_XON		15
#define	SLC_XOFF	16
#define	SLC_FORW1	17
#define	SLC_FORW2	18

#define	NSLC		18

/*
 * For backwards compatability, we define SLC_NAMES to be the
 * list of names if SLC_NAMES is not defined.
 */
#define	SLC_NAMELIST	"0", "SYNCH", "BRK", "IP", "AO", "AYT", "EOR", \
			"ABORT", "EOF", "SUSP", "EC", "EL", "EW", "RP", \
			"LNEXT", "XON", "XOFF", "FORW1", "FORW2", 0,
#ifdef	SLC_NAMES
char *slc_names[] = {
	SLC_NAMELIST
};
#else
extern char *slc_names[];
#define	SLC_NAMES SLC_NAMELIST
#endif

#define	SLC_NAME_OK(x)	((unsigned int)(x) <= NSLC)
#define SLC_NAME(x)	slc_names[x]

#define	SLC_NOSUPPORT	0
#define	SLC_CANTCHANGE	1
#define	SLC_VARIABLE	2
#define	SLC_DEFAULT	3
#define	SLC_LEVELBITS	0x03

#define	SLC_FUNC	0
#define	SLC_FLAGS	1
#define	SLC_VALUE	2

#define	SLC_ACK		0x80
#define	SLC_FLUSHIN	0x40
#define	SLC_FLUSHOUT	0x20

#define	OLD_ENV_VAR	1
#define	OLD_ENV_VALUE	0
#define	NEW_ENV_VAR	0
#define	NEW_ENV_VALUE	1
#define	ENV_ESC		2
#define ENV_USERVAR	3

/*
 * AUTHENTICATION suboptions
 */

/*
 * Who is authenticating who ...
 */
#define	AUTH_WHO_CLIENT		0	/* Client authenticating server */
#define	AUTH_WHO_SERVER		1	/* Server authenticating client */
#define	AUTH_WHO_MASK		1

/*
 * amount of authentication done
 */
#define	AUTH_HOW_ONE_WAY	0
#define	AUTH_HOW_MUTUAL		2
#define	AUTH_HOW_MASK		2

/*
 * should we be encrypting? (not yet formally standardized)
 */
#define AUTH_ENCRYPT_OFF	0
#define AUTH_ENCRYPT_ON		4
#define AUTH_ENCRYPT_MASK	4

/*
 * will we be forwarding? (not yet formally standardized)
 */
#define INI_CRED_FWD_OFF	0
#define INI_CRED_FWD_ON		8
#define INI_CRED_FWD_MASK	8

#endif /* !_TELNET_H_ */

/*
 *    telopts.h
 *  Used for telnet options
 ****************************************************************************
 *                                                                          *
 *                                                                          *
 *      NCSA Telnet                                                         *
 *      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
 *	Additions by Kurt Mahan, Heeren Pathak, & Quincey Koziol            *
 *                                                                          *
 *      National Center for Supercomputing Applications                     *
 *      152 Computing Applications Building                                 *
 *      605 E. Springfield Ave.                                             *
 *      Champaign, IL  61820                                                *
 *                                                                          *
 ****************************************************************************
 *	Quincey Koziol
 *   Defines for telnet options and related things
 */

#ifndef TELOPTS_H
#define TELOPTS_H

#define NUMLMODEOPTIONS 30

/* Definitions for telnet protocol */

#define STNORM      0

/* Definition of the lowest telnet byte following an IAC byte */
#define LOW_TEL_OPT 236

#define TEL_EOF     236
#define SUSP        237
#define ABORT       238

#define SE			240
#define NOP			241
#define DM			242
#define BREAK			243
#define IP			244
#define AO			245
#define AYT			246
#define EC			247
#define EL			248
#define GOAHEAD 		249
#define SB			250
#define WILLTEL 		251
#define WONTTEL 		252
#define DOTEL	 		253
#define DONTTEL 		254
#define IAC		 	255

/* Assigned Telnet Options */
#define BINARY	 			0
#define ECHO				1
#define RECONNECT			2
#define SGA 				3
#define AMSN				4
#define STATUS				5
#define TIMING				6
#define RCTAN				7
#define OLW				8
#define OPS				9
#define OCRD				10
#define OHTS				11
#define OHTD				12
#define OFFD				13
#define OVTS				14
#define OVTD				15
#define OLFD				16
#define XASCII				17
#define LOGOUT				18
#define BYTEM				19
#define DET				20
#define SUPDUP				21
#define SUPDUPOUT			22
#define SENDLOC				23
#define TERMTYPE 			24
#define EOR				25
#define TACACSUID			26
#define OUTPUTMARK			27
#define TERMLOCNUM			28
#define REGIME3270			29
#define X3PAD				30
#define NAWS				31
#define TERMSPEED			32
#define TFLOWCNTRL			33
#define LINEMODE 			34

#define MODE 1
#ifndef MODE_EDIT
#define MODE_EDIT       1
#define MODE_TRAPSIG    2
#define MODE_ACK        4
#define MODE_SOFT_TAB   8
#define MODE_LIT_ECHO   16
#endif /* MODE_EDIT */

#define FORWARDMASK 2

#define SLC 3 
#define SLC_DEFAULT     3
#define SLC_VALUE       2
#define SLC_CANTCHANGE  1
#define SLC_NOSUPPORT   0
#ifndef SLC_LEVELBITS
#define SLC_LEVELBITS   3
#endif

#ifndef SLC_ACK
#define SLC_ACK         128
#define SLC_FLUSHIN     64
#define SLC_FLUSHOUT    32
#endif /* SLC_ACK */

#define SLC_SYNCH		1
#define SLC_BRK			2
#define SLC_IP			3
#define SLC_AO			4
#define SLC_AYT			5
#define SLC_EOR			6
#define SLC_ABORT		7
#define SLC_EOF			8
#define SLC_SUSP		9
#define SLC_EC			10
#define SLC_EL   		11
#define SLC_EW   		12
#define SLC_RP			13
#define SLC_LNEXT		14
#define SLC_XON			15
#define SLC_XOFF		16
#define SLC_FORW1		17
#define SLC_FORW2		18
#define SLC_MCL         19
#define SLC_MCR         20
#define SLC_MCWL        21
#define SLC_MCWR        22
#define SLC_MCBOL       23
#define SLC_MCEOL       24
#define SLC_INSRT       25
#define SLC_OVER        26
#define SLC_ECR         27
#define SLC_EWR         28
#define SLC_EBOL        29
#define SLC_EEOL        30

#define XDISPLOC		35
#define ENVIRONMENT		36
#define AUTHENTICATION	 	37
#define DATA_ENCRYPTION		38
#define XOPTIONS		255

#define LINEMODE_MODES_SUPPORTED    0x1B
/* 
 * set this flag for linemode special functions which are supported by
 * Telnet, even though they are not currently active.  This is to allow
 * the other side to negotiate to a "No Support" state for an option
 * and then change later to supporting it, so we know it's ok to change
 * our "No Support" state to something else ("Can't Change", "Value",
 * whatever)
 */
#define SLC_SUPPORTED       0x10    
	
#define ESCFOUND 5
#define IACFOUND 6
#define NEGOTIATE 1

#endif  /* telopts.h */

/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)encrypt.h	8.1 (Berkeley) 6/4/93
 */

/*
 * Copyright (C) 1990 by the Massachusetts Institute of Technology
 *
 * Export of this software from the United States of America may
 * require a specific license from the United States Government.
 * It is the responsibility of any person or organization contemplating
 * export to obtain such a license before exporting.
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 */

#ifdef	ENCRYPTION

#ifndef __ENCRYPTION__
#define __ENCRYPTION__

#define	DIR_DECRYPT		1
#define	DIR_ENCRYPT		2

typedef	unsigned char Block[8];
typedef unsigned char *BlockT;
#ifndef KRB4    /* already defined in kerberosiv/des.h */
typedef struct des_ks_struct { Block _; } Schedule[16];
#endif /* KRB4 */

#define	VALIDKEY(key)	( key[0] | key[1] | key[2] | key[3] | key[4] | key[5] | key[6] | key[7])

#define	SAMEKEY(k1, k2)	(!memcmp((void *)k1, (void *)k2, sizeof(Block)))

typedef	struct {
  short		type;
  int		length;
  unsigned char	*data;
} Session_Key;

#if !defined(P)
#ifdef __STDC__
#define P(x)	x
#else
#define P(x)	()
#endif
#endif

#ifdef DEBUG
int printsub(char, unsigned char *, size_t);
#endif

void encrypt_parse(unsigned char *, int);

typedef struct {
  char	*name;
  int	type;
  void	(*output) P((unsigned char *, int));
  int	(*input) P((int));
  void	(*init) P((int));
  int	(*start) P((int, int));
  int	(*is) P((unsigned char *, int));
  int	(*reply) P((unsigned char *, int));
  void	(*session) P((Session_Key *, int));
  int	(*keyid) P((int, unsigned char *, int *));
  void	(*printsub) P((unsigned char *, int, unsigned char *, int));
} Encryptions;

#define SK_GENERIC      0       /* Just a string of bits */
#define	SK_DES		1	/* Matched Kerberos v5 ENCTYPE_DES */

void encrypt_init P((kstream,int));
Encryptions *findencryption P((int));
void encrypt_send_support P((void));
void encrypt_auto P((int));
void decrypt_auto P((int));
void encrypt_is P((unsigned char *, int));
void encrypt_reply P((unsigned char *, int));
void encrypt_start_input P((int));
void encrypt_session_key P((Session_Key *, int));
void encrypt_end_input P((void));
void encrypt_start_output P((int));
void encrypt_end_output P((void));
void encrypt_send_request_start P((void));
void encrypt_send_request_end P((void));
void encrypt_send_end P((void));
void encrypt_wait P((void));
int encrypt_is_encrypting P((void));
void encrypt_send_support P((void));
void encrypt_send_keyid P((int, unsigned char *, int, int));

int encrypt_cmd P((int, char **));
void encrypt_display P((void));

#ifdef CK_KERBEROS
void krbdes_encrypt P((unsigned char *, int));
int krbdes_decrypt P((int));
int krbdes_is P((unsigned char *, int));
int krbdes_reply P((unsigned char *, int));
void krbdes_init P((int));
int krbdes_start P((int, int));
void krbdes_session P((Session_Key *, int));
void krbdes_printsub P((unsigned char *, int, unsigned char *, int));
#endif /* CK_KERBEROS */

void cfb64_encrypt P((unsigned char *, int));
int cfb64_decrypt P((int));
void cfb64_init P((int));
int cfb64_start P((int, int));
int cfb64_is P((unsigned char *, int));
int cfb64_reply P((unsigned char *, int));
void cfb64_session P((Session_Key *, int));
int cfb64_keyid P((int, unsigned char *, int *));
void cfb64_printsub P((unsigned char *, int, unsigned char *, int));

void ofb64_encrypt P((unsigned char *, int));
int ofb64_decrypt P((int));
void ofb64_init P((int));
int ofb64_start P((int, int));
int ofb64_is P((unsigned char *, int));
int ofb64_reply P((unsigned char *, int));
void ofb64_session P((Session_Key *, int));
int ofb64_keyid P((int, unsigned char *, int *));
void ofb64_printsub P((unsigned char *, int, unsigned char *, int));

#ifdef CAST_ENCRYPTION
void cast_cfb64_encrypt P((unsigned char *, int));
int  cast_cfb64_decrypt P((int));
void cast_cfb64_init P((int));
int  cast_cfb64_start P((int, int));
int  cast_cfb64_is P((unsigned char *, int));
int  cast_cfb64_reply P((unsigned char *, int));
void cast_cfb64_session P((Session_Key *, int));
int  cast_cfb64_keyid P((int, unsigned char *, int *));
void cast_cfb64_printsub P((unsigned char *, int, unsigned char *, int));

void cast_ofb64_encrypt P((unsigned char *, int));
int  cast_ofb64_decrypt P((int));
void cast_ofb64_init P((int));
int  cast_ofb64_start P((int, int));
int  cast_ofb64_is P((unsigned char *, int));
int  cast_ofb64_reply P((unsigned char *, int));
void cast_ofb64_session P((Session_Key *, int));
int  cast_ofb64_keyid P((int, unsigned char *, int *));
void cast_ofb64_printsub P((unsigned char *, int, unsigned char *, int));

void castexp_cfb64_encrypt P((unsigned char *, int));
int  castexp_cfb64_decrypt P((int));
void castexp_cfb64_init P((int));
int  castexp_cfb64_start P((int, int));
int  castexp_cfb64_is P((unsigned char *, int));
int  castexp_cfb64_reply P((unsigned char *, int));
void castexp_cfb64_session P((Session_Key *, int));
int  castexp_cfb64_keyid P((int, unsigned char *, int *));
void castexp_cfb64_printsub P((unsigned char *, int, unsigned char *, int));

void castexp_ofb64_encrypt P((unsigned char *, int));
int  castexp_ofb64_decrypt P((int));
void castexp_ofb64_init P((int));
int  castexp_ofb64_start P((int, int));
int  castexp_ofb64_is P((unsigned char *, int));
int  castexp_ofb64_reply P((unsigned char *, int));
void castexp_ofb64_session P((Session_Key *, int));
int  castexp_ofb64_keyid P((int, unsigned char *, int *));
void castexp_ofb64_printsub P((unsigned char *, int, unsigned char *, int));
#endif /* CAST_ENCRYPTION */

/* int	des_string_to_key P((char *, Block)); */


#ifdef DEBUG
extern int encrypt_debug_mode;
#endif

#ifndef CRYPT_DLL
extern int (*decrypt_input) P((int));
extern void (*encrypt_output) P((unsigned char *, int));
#endif /* CRYPT_DLL */

int decrypt_ks_hack(unsigned char *, int);

#endif /* __ENCRYPTION__ */

#endif /* ENCRYPTION */

#ifdef COMMENT 
/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)enc-proto.h	8.1 (Berkeley) 6/4/93
 */

/*
 * Copyright (C) 1990 by the Massachusetts Institute of Technology
 *
 * Export of this software from the United States of America may
 * require a specific license from the United States Government.
 * It is the responsibility of any person or organization contemplating
 * export to obtain such a license before exporting.
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 */
#if	!defined(P)
#ifdef	__STDC__
#define	P(x)	x
#else
#define	P(x)	()
#endif
#endif

#ifdef	ENCRYPTION
void encrypt_init P((kstream));
Encryptions *findencryption P((int));
void encrypt_send_supprt P((void));
void encrypt_auto P((int));
void decrypt_auto P((int));
void encrypt_is P((unsigned char *, int));
void encrypt_reply P((unsigned char *, int));
void encrypt_start_input P((int));
void encrypt_session_key P((Session_Key *, int));
void encrypt_end_input P((void));
void encrypt_start_output P((int));
void encrypt_end_output P((void));
void encrypt_send_request_start P((void));
void encrypt_send_request_end P((void));
void encrypt_send_end P((void));
void encrypt_wait P((void));
int encrypt_is_encrypting P((void));
void encrypt_send_support P((void));
void encrypt_send_keyid P((int, unsigned char *, int, int));
int net_write P((unsigned char *, int));

#ifdef	TELENTD
void encrypt_wait P((void));
#else
int encrypt_cmd P((int, char **));
void encrypt_display P((void));
#endif

#ifdef CK_KERBEROS
void krbdes_encrypt P((unsigned char *, int));
int krbdes_decrypt P((int));
int krbdes_is P((unsigned char *, int));
int krbdes_reply P((unsigned char *, int));
void krbdes_init P((int));
int krbdes_start P((int, int));
void krbdes_session P((Session_Key *, int));
void krbdes_printsub P((unsigned char *, int, unsigned char *, int));
#endif /* CK_KERBEROS */

void cfb64_encrypt P((unsigned char *, int));
int cfb64_decrypt P((int));
void cfb64_init P((int));
int cfb64_start P((int, int));
int cfb64_is P((unsigned char *, int));
int cfb64_reply P((unsigned char *, int));
void cfb64_session P((Session_Key *, int));
int cfb64_keyid P((int, unsigned char *, int *));
void cfb64_printsub P((unsigned char *, int, unsigned char *, int));

void ofb64_encrypt P((unsigned char *, int));
int ofb64_decrypt P((int));
void ofb64_init P((int));
int ofb64_start P((int, int));
int ofb64_is P((unsigned char *, int));
int ofb64_reply P((unsigned char *, int));
void ofb64_session P((Session_Key *, int));
int ofb64_keyid P((int, unsigned char *, int *));
void ofb64_printsub P((unsigned char *, int, unsigned char *, int));

int  des_new_random_key P((Block));
void des_set_random_generator_seed P((Block));
void des_ecb_encrypt P((Block *, Block *, Schedule, int));
#ifndef KRB4    /* already defined in kerberosiv/des.h */
void des_key_sched P((Block, Schedule));
int  des_string_to_key P((char *, Block));
#endif /* KRB4 */
#endif	/* ENCRYPTION */
#endif /* COMMENT */

#define FORWARD
/* allow forwarding of credentials */

#ifdef CRYPT_DLL
struct _crypt_dll_init {
    int version;

    /* Version 1 variables */
    int (*p_ttol)(char *,int);
    void (*p_dodebug)(int,char *,char *,long);
    void (*p_dohexdump)(char *,char *,int);
    void (*p_tn_debug)(char *);
    int (*p_vscrnprintf)(char *, ...);
};
#endif /* CRYPT_DLL */
#endif /* KRB5_TELNET_H */
