#!/bin/csh
# LAPLACE.CSB.YALE.EDU
# Paul Adams - LAPLACE.CSB.YALE.EDU created a quick shell
# script, "ssub", that allows users to submit jobs by
# specifying the groupname and jobfile.
#        ssub high my-job-script


if ($#argv < 1) goto usage
#
set group="$argv[1]"
if ($#argv == 2) then
  set job="$argv[2]"
else
  set job="dqs.$$"
  cat < /dev/tty >! dqs.$$
endif
#
set QSUB = '/usr/local/DQS/bin/qsub3'
#
set efile=$PWD'/'$job'.err'
set ofile=$PWD'/'$job'.out'
#
set jobtmp=$job.tmp.$$
# make the job file
echo '#\!/bin/csh' >> $jobtmp
echo '#$ -S /bin/csh' >> $jobtmp
echo '#$ -hard -l qty.eq.1,group.eq.'$group >> $jobtmp
echo '#$ -e' $efile >> $jobtmp
echo '#$ -o' $ofile >> $jobtmp
cat $job | grep -v '#' >> $jobtmp
#
$QSUB $jobtmp
#
if (-e $jobtmp) then
  rm $jobtmp
endif
#
if (-e dqs.$$) then
  rm dqs.$$
endif
#
goto exit
#
usage:
echo 'Usage: ssub group-name [job-script]'
#
exit:
