// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: debadmin.cc,v 1.6 1998/07/16 06:45:40 jgg Exp $
/* ######################################################################

   Debian Admin - Debian Administration directory.

   POSIX doesn't define a shared locking scheme, ie readlocking, so we
   simply ingore the difference between read and write locks. Clients
   should assume that there -IS- a differnce between read/write locks
   because someday we might switch over to flock which does support
   shared locks.
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#include <pkglib/debadmin.h>
#include <pkglib/error.h>
#include <fileutl.h>
#include <options.h>
#include <system.h>

#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <dirent.h>
									/*}}}*/

// DebAdmin::pkgDebAdmin - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
pkgDebAdmin::pkgDebAdmin()
{
   AdminDir = DPKG_STATE;
   
   LockIsWrite = false;
   LockCount = 0;
   LockFD = -1;
}
									/*}}}*/
// DebAdmin::~pkgDebAdmin - Destructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
pkgDebAdmin::~pkgDebAdmin()
{
   Close();
}
									/*}}}*/
// DebAdmin::Open - Creates the lock file				/*{{{*/
// ---------------------------------------------------------------------
/* This locks the admin dir and then checks that it is not dirty. */
bool pkgDebAdmin::Open()
{
   if (LockFD != -1)
      return false;

   // Create the lockfile
   LockFD = GetLock( AdminDir + "lock");
   if (LockFD == -1)
      return _error->Errno("Open","Unable to lock the administration directory "
			   "%s, are you root?",AdminDir.c_str());
   
   // Check for updates.. (dirty)
   string File = AdminDir + "updates/";
   DIR *DirP = opendir(File.c_str());
   if (DirP != 0)
   {
      /* We ignore any files that are not all digits, this skips .,.. and 
         some tmp files dpkg will leave behind.. */
      bool Damaged = false;
      for (struct dirent *Ent = readdir(DirP); Ent != 0; Ent = readdir(DirP))
      {
	 Damaged = true;
	 for (unsigned int I = 0; I < _count(Ent->d_name) && 
	      Ent->d_name[I] != 0; I++)
	 {
	    // Check if its not a digit..
	    if (isdigit(Ent->d_name[I]) == 0)
	    {
	       Damaged = false;
	       break;
	    }
	 }
	 if (Damaged == true)
	    break;
      }
      closedir(DirP);
       	 
      // Woops, we have to run dpkg to rewrite the status file
      if (Damaged == true)
      {
	 Close();
	 return _error->Error("dpkg was interrupted, you must manually "
			      "run 'dpkg --configure -a' to correct the problem. ");
      }
   }
   
   return true;
}
									/*}}}*/
// DebAdmin::Close - Remove the lock 					/*{{{*/
// ---------------------------------------------------------------------
/* We cannot unlink the lock file because that will create a race condition
   with the open routine. */
bool pkgDebAdmin::Close()
{
   close(LockFD);
   LockFD = -1;
   LockCount = 0;
   return true;
}
									/*}}}*/
// DebAdmin::ReadLock - Aquire a read lock				/*{{{*/
// ---------------------------------------------------------------------
/* */
bool pkgDebAdmin::ReadLock()
{
   if (LockIsWrite == true && LockCount != 0)
      return false;
   LockCount++;
   return true;
}
									/*}}}*/
// DebAdmin::WriteLock - Aquire a write lock				/*{{{*/
// ---------------------------------------------------------------------
/* */
bool pkgDebAdmin::WriteLock()
{
   if (LockIsWrite == false && LockCount != 0)
      return false;
   LockCount++;
   return true;
}
									/*}}}*/
// DebAdmin::UnLock - Decrease the lock count by one			/*{{{*/
// ---------------------------------------------------------------------
/* */
bool pkgDebAdmin::UnLock()
{
   if (LockCount != 0)
      LockCount--;
   else
      return false;
   return true;
}
									/*}}}*/
