// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: gpmdev.h,v 1.5 1997/08/18 20:49:35 tom Exp $
/* ######################################################################

   GPMDev - GPM based mouse input handler
   
   The GPM mouse handler accepts mouse input from the Linux GPM driver
   and translates it into our internal event structure. This is 
   automatically initialized by the various linux text interfaces if they 
   feel it is appropriate.

   ###################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_GPMDEV_H
#define DEITY_GPMDEV_H

#include <deity/selectloop.h>

class Widget;
class GPMFd : public SelectLoop::Fd
{
   protected:
   
   // Widget to use as the top of the widget tree
   Widget *Root;
   Widget *LastHit;
   unsigned long OldButtons;
   
   virtual bool Read(SelectLoop &Owner);

   public:
   
   GPMFd(Widget *Root);
   virtual ~GPMFd();
};

#endif
