/*
 *  icons.c:		Some nice XPM icons
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 1998 Ullrich Hafner <hafner@informatik.uni-wuerzburg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1998/07/28 17:09:47 $
 *  $Author: hafner $
 *  $Revision: 1.13 $
 *  $State: Exp $
 */

#include <stdio.h>

#include "config.h"

#include "misc.h"
#include "icons.h"

#include "error.h"

/*******************************************************************************

		     global variables (from window.c)
  
*******************************************************************************/

extern GtkWidget *main_window;

/*******************************************************************************

			     local variables
  
*******************************************************************************/


/* XPM */
static char * folder_cap_up_xpm[] = {
"33 33 63 1",
" 	c #8E8E8A8A9E9E",
".	c #8E8E9A9A8E8E",
"X	c #9E9E8A8A9E9E",
"o	c #8E8E9A9A9E9E",
"O	c #B6B692929E9E",
"+	c #9E9EAAAA9E9E",
"@	c #FFFFFBFBFFFF",
"#	c #9E9E9A9AAEAE",
"$	c #AEAE9A9AAEAE",
"%	c #A6A6AAAAA6A6",
"&	c #AEAEAAAAAEAE",
"*	c #8E8E92927171",
"=	c #9E9E9A9A8E8E",
"-	c #BEBE9A9A9696",
";	c #000000000000",
":	c #616141413838",
">	c #414130304141",
",	c #EFEFDBDBCFCF",
"<	c #696961616161",
"1	c #AEAEAAAABEBE",
"2	c #8E8E7D7D8E8E",
"3	c #303038382020",
"4	c #494941413030",
"5	c #C7C751514949",
"6	c #616161615151",
"7	c #BEBEAAAAAEAE",
"8	c #A6A682825959",
"9	c #8E8E8A8A7171",
"0	c #414120202020",
"q	c #AEAEBABAAEAE",
"w	c #515159594141",
"e	c #383818181010",
"r	c #30308A8A3030",
"t	c #BEBEAAAABEBE",
"y	c #383841414141",
"u	c #30308E8E3838",
"i	c #303038385959",
"p	c #202020202020",
"a	c #9E9EE3E39E9E",
"s	c #000030300000",
"d	c #BEBEBABABEBE",
"f	c #101018180000",
"g	c #CFCFB2B2B6B6",
"h	c #BEBEBABAAEAE",
"j	c #20208A8A3030",
"k	c #080834341010",
"l	c #080818181010",
"z	c #000010100000",
"x	c #303069693030",
"c	c #181818181818",
"v	c #AEAEDBDBB6B6",
"b	c #69697D7D6969",
"n	c #AEAEBABABEBE",
"m	c #101000000000",
"M	c #BEBEBABACFCF",
"N	c #414161614141",
"B	c #51517D7D5151",
"V	c #414169694949",
"C	c #383851513030",
"Z	c #CFCFBABACFCF",
"A	c #414171715151",
"S	c #9696AAAA8E8E",
"D	c #C7C7CBCBC7C7",
" . .X.XoOoOoOoO+@+#+$+#+$+$%&%&&&",
".*.X.X=X=X=O=-O@;:O$+-+$+$%$%$&&&",
" .X.XoOoOOOO#O@;>;:+#+@@,@<%&&&&1",
"2X.X=X=XOOOOO@;34>;:+$@56O;$&&&7&",
"X.XoOoOoOoO+@;>689>;:+@5-0;&&&1q&",
".X=X=X=O=-O@;3w88883;:-<5<;&&7&7q",
"XoOoOOOO#O@;>68o@O89>;:5O5;&1q1q1",
"=X=XOOOOO@;3;;;050;;;>;:5e;7&&&7&",
"OoOoroO+@;>6;;0;8;0;;9>;:0;q&q1qt",
"=X=Oy-O@;3wO;0305030;883;:;7q7&tq",
"OOOOui@;>pOo:;0;5;0;:O8p>;;q1qtqt",
"OOOasi;3wp=@:;3;5;3;:@9p*>;:&tqtq",
"OoOars>6O9i@855585558@i989>;:qtqd",
"=-O@rfwO=@yg4@@@@@@@4gy@=883;:htq",
"#O@jkikj@@ty:@@@@@@@:yt@@O89>;:qd",
"O@;arlzx@@@y:@@@@@@@:y@@@@=8*>;:h",
"O;urkilsplpcplpcplpcplpcplpc;;;4d",
"Oxaisxsz4:::ccccccccc:::4::;qthdh",
"#arjvszs-bbq:;:4:4:;:Obb1b<;dndnd",
"Orairlym%@6@:;4eee4;:,,<@a6ihthtd",
"$jkakslsu,7%:;:303:;:,7@a6,;dnddd",
"afaryryzs@6@4;:e3e:;4,6<@-6ihdddd",
"#aurvsusu,7@:;:803:;:@,@7<,;ddddM",
"+rslrismsl,-:;4eee4;:a%<%<%idddgd",
"asuakzlszr<,:;:303:;:6,6<@<iddMvM",
"srarsryzsf@a4;:e3e:;4usuyuy;uudgv",
"ususkszskzizkskskskskzkiisizliMvM",
"rlzmzzzmzNNNNNNtqtNNslsmszslzl*gd",
"&BVVezVxk3yxCx7b2V7%aVVVNVVVNV<vZ",
"%wNC3fsksfsCxCCC%w%NNwBwBwBwBwB2v",
"bAwVczCk3kBAw%dq7VNnd%<B<B<B<B<BZ",
".2*2.2.2...=.O.=bbbO.bSO=OSOSOSO+",
"&&1q&q1qtqtqdqdndnddddMvMvMvZvZDD"};

/* XPM */
static char * latex_xpm[] = {
"33 33 215 2",
"  	c #9C9C9A9A9C9C",
". 	c #94949A9A8C8C",
"X 	c #949496969C9C",
"o 	c #9C9C9A9A9494",
"O 	c #9C9C96969494",
"+ 	c #9C9C9E9E9C9C",
"@ 	c #A4A49E9E9C9C",
"# 	c #A4A4A2A29C9C",
"$ 	c #ACACA6A6A4A4",
"% 	c #ACACAAAAA4A4",
"& 	c #B4B4AAAAACAC",
"* 	c #B4B4AAAAA4A4",
"= 	c #ACACAAAAACAC",
"- 	c #B4B4B2B2ACAC",
"; 	c #B4B4AEAEB4B4",
": 	c #B4B4B2B2B4B4",
"> 	c #B4B4B6B6B4B4",
", 	c #BCBCBABABCBC",
"< 	c #BCBCBEBEBCBC",
"1 	c #C4C4C2C2C4C4",
"2 	c #949492929494",
"3 	c #9C9C96969C9C",
"4 	c #B4B4AEAEACAC",
"5 	c #9C9C92928C8C",
"6 	c #C4C4BEBEBCBC",
"7 	c #94948E8E8C8C",
"8 	c #CCCCC6C6C4C4",
"9 	c #84847E7E7C7C",
"0 	c #D4D4D2D2CCCC",
"q 	c #BCBCBABAB4B4",
"w 	c #A4A4A6A6A4A4",
"e 	c #B4B4BABAB4B4",
"r 	c #BCBCB6B6BCBC",
"t 	c #BCBCBEBEC4C4",
"y 	c #949496969494",
"u 	c #BCBCB6B6B4B4",
"i 	c #6C6C66666464",
"p 	c #6C6C6A6A6464",
"a 	c #D4D4CACAC4C4",
"s 	c #7C7C76766C6C",
"d 	c #ACACA2A2A4A4",
"f 	c #CCCCCACAC4C4",
"g 	c #8C8C86867C7C",
"h 	c #646462626464",
"j 	c #E4E4E2E2DCDC",
"k 	c #ACACAEAEB4B4",
"l 	c #A4A49A9A9494",
"z 	c #ACACA6A69C9C",
"x 	c #8C8C8A8A8484",
"c 	c #CCCCC6C6BCBC",
"v 	c #74746E6E6C6C",
"b 	c #6C6C66665C5C",
"n 	c #8C8C82827C7C",
"m 	c #74746A6A6464",
"M 	c #BCBCB2B2ACAC",
"N 	c #7C7C76767474",
"B 	c #74747A7A7474",
"V 	c #949492928C8C",
"C 	c #C4C4BABAB4B4",
"Z 	c #7C7C72726C6C",
"A 	c #84847A7A7474",
"S 	c #94948A8A8484",
"D 	c #CCCCCECECCCC",
"F 	c #A4A4A2A2A4A4",
"G 	c #ACACAEAEACAC",
"H 	c #74746A6A5C5C",
"J 	c #6C6C62625C5C",
"K 	c #84847E7E7474",
"L 	c #8C8C7E7E7474",
"P 	c #7C7C7E7E7C7C",
"I 	c #8C8C8A8A8C8C",
"U 	c #CCCCCECED4D4",
"Y 	c #84848A8A7C7C",
"T 	c #A4A49E9EA4A4",
"R 	c #C4C4BEBEC4C4",
"E 	c #747466666464",
"W 	c #94948E8E8484",
"Q 	c #74746E6E6464",
"! 	c #84847A7A6C6C",
"~ 	c #7C7C7A7A7474",
"^ 	c #848482828484",
"/ 	c #848486868484",
"( 	c #6C6C6A6A6C6C",
") 	c #CCCCCACACCCC",
"_ 	c #C4C4C6C6C4C4",
"` 	c #BCBCC2C2BCBC",
"' 	c #848476766C6C",
"] 	c #B4B4B6B6ACAC",
"[ 	c #ACAC9E9E9C9C",
"{ 	c #64645A5A5454",
"} 	c #9C9C8E8E8C8C",
"| 	c #BCBCB6B6ACAC",
" .	c #A4A49E9E9494",
"..	c #848482827474",
"X.	c #8C8C8E8E8C8C",
"o.	c #8C8C8E8E8484",
"O.	c #64645E5E6464",
"+.	c #8C8C7E7E7C7C",
"@.	c #6C6C5E5E6464",
"#.	c #646456565C5C",
"$.	c #BCBCB2B2B4B4",
"%.	c #CCCCCECEC4C4",
"&.	c #8C8C92928484",
"*.	c #848486867C7C",
"=.	c #949496968C8C",
"-.	c #8C8C8E8E7C7C",
";.	c #6C6C72726464",
":.	c #C4C4C2C2BCBC",
">.	c #74746E6E7474",
",.	c #A4A49A9A9C9C",
"<.	c #A4A4A6A69C9C",
"1.	c #BCBCC2C2B4B4",
"2.	c #C4C4C2C2B4B4",
"3.	c #C4C4C6C6BCBC",
"4.	c #ACACB2B2A4A4",
"5.	c #949496968484",
"6.	c #949492927C7C",
"7.	c #94949A9A8484",
"8.	c #848486867474",
"9.	c #7C7C7A7A6C6C",
"0.	c #949492928484",
"q.	c #BCBCBEBEB4B4",
"w.	c #A4A4A2A29494",
"e.	c #848476767C7C",
"r.	c #64645A5A6464",
"t.	c #A4A49A9AA4A4",
"y.	c #DCDCD6D6CCCC",
"u.	c #BCBCBABAACAC",
"i.	c #CCCCD2D2C4C4",
"p.	c #A4A4AAAA9C9C",
"a.	c #8C8C92927C7C",
"s.	c #8C8C8A8A7C7C",
"d.	c #9C9C9E9E8C8C",
"f.	c #9C9C9E9E9494",
"g.	c #A4A4A6A69494",
"h.	c #DCDCDEDEDCDC",
"j.	c #ACACAEAE9C9C",
"k.	c #ACACA6A6ACAC",
"l.	c #9C9C92929494",
"z.	c #747472726464",
"x.	c #747472726C6C",
"c.	c #74746A6A6C6C",
"v.	c #8C8C82828484",
"b.	c #ACACAAAA9C9C",
"n.	c #9C9C9A9A8C8C",
"m.	c #8C8C92927474",
"M.	c #84848A8A7474",
"N.	c #7C7C82827474",
"B.	c #ACACAEAEA4A4",
"V.	c #848482827C7C",
"C.	c #6C6C6A6A5C5C",
"Z.	c #6C6C62626464",
"A.	c #B4B4AEAEA4A4",
"S.	c #7C7C82826C6C",
"D.	c #8C8C8E8E7474",
"F.	c #8C8C86867474",
"G.	c #9C9CA2A29494",
"H.	c #ACACA2A2ACAC",
"J.	c #7C7C6E6E6C6C",
"K.	c #D4D4CECEC4C4",
"L.	c #7C7C7E7E6C6C",
"P.	c #8C8C8A8A7474",
"I.	c #848486866C6C",
"U.	c #64646A6A5454",
"Y.	c #BCBCBEBEACAC",
"T.	c #D4D4D6D6D4D4",
"R.	c #7C7C72726464",
"E.	c #CCCCC2C2BCBC",
"W.	c #7C7C76766464",
"Q.	c #747476765C5C",
"!.	c #D4D4D6D6CCCC",
"~.	c #E4E4DADACCCC",
"^.	c #CCCCCACABCBC",
"/.	c #B4B4AAAA9C9C",
"(.	c #C4C4C2C2ACAC",
").	c #D4D4DADACCCC",
"_.	c #747476766C6C",
"`.	c #ACACA2A29494",
"'.	c #94948E8E7C7C",
"].	c #B4B4BABAACAC",
"[.	c #94948A8A7474",
"{.	c #9C9C96968484",
"}.	c #7C7C7E7E7474",
"|.	c #6C6C6E6E6464",
" X	c #9C9CA2A29C9C",
".X	c #BCBCB2B2BCBC",
"XX	c #8C8C82826C6C",
"oX	c #84847E7E6464",
"OX	c #84847A7A7C7C",
"+X	c #84847E7E6C6C",
"@X	c #6C6C66665454",
"#X	c #9C9C96968C8C",
"$X	c #CCCCD2D2CCCC",
"%X	c #747476767474",
"&X	c #7C7C82827C7C",
"*X	c #8C8C82827474",
"=X	c #C4C4C2C2CCCC",
"-X	c #C4C4CACAC4C4",
";X	c #D4D4D2D2D4D4",
":X	c #C4C4BABABCBC",
">X	c #ACACA2A29C9C",
",X	c #CCCCCACAD4D4",
"<X	c #CCCCC6C6CCCC",
"1X	c #A4A4AAAAA4A4",
"2X	c #D4D4CECECCCC",
"3X	c #C4C4C6C6CCCC",
"4X	c #DCDCDADADCDC",
"5X	c #747472727474",
"6X	c #8C8C92928C8C",
"7X	c #D4D4D6D6DCDC",
"8X	c #646466666464",
"9X	c #D4D4DADAD4D4",
"0X	c #7C7C7A7A7C7C",
"qX	c #BCBCBABAC4C4",
"wX	c #DCDCD6D6DCDC",
"  .     X o O O o + @ # # $ % & % & * = * = - ; : > > , < < > : 1 ",
"2 3   + + # + o 4 5 * 6 7 4 8 % 9 o 0 q 7 % w = e : r , - t - e , ",
"  X y y   y $ $ u o u q i p a o s d f g h $ j = = > < < k , : , , ",
"y y y 3 o + l z * x 4 c v b u n m l M N s 0 1 B 7 < , > > > > , < ",
"V 2 y + w = > C * v g z Z Z g s p A x N S f 9 h w D = = > ; > < < ",
"2 2   F = G z M $ H b A J Z v A A A K L n 7 P I U 1 Y T < : , t R ",
"  + + F w % E s W Z E Q J Z J b Q Z N A ! ~ ^ o : / ( F ) _ < 1 ` ",
"F F w w = = ~ J A s J J J Q m J H ' s Z ' N 9 / P ( / e < R < 1 1 ",
"+ w = - : ] [ E J E { E ! } M * | C z  .5 ..X.o.^ o.1 D o o ` 1 _ ",
"3   V K Q v O.+.@.#.v W $.4 % 6 q | - ] %.c &.*.Y =.-.;.;.*.> :.%.",
"; u -  ...m >.E #.N ,.d $.$ - - <.4 1.2.3.4.5.6.7.5.8.9.0.q.q.%.0 ",
"T 4 8 8 w.Z e.r.@.t.r ; q $.y.8 u.3.i.q.p.-.a.s.7.d.f.g.q.h.j.1.%.",
"k.l.9 z.x.s c.@.v.& * & 8 :.- b.g.j.j.n.m.M.7.M.&.5.n.. N.9.=.B._ ",
"k.,.V.C.b z.Z.c.t.& @ u 8 A.W ..S.8.D.M.m.7.F.s.G.n.=.&.z.C.. ] %.",
"H.q 8 - x Q i J.[ & M K.q ..F.L.8.P.D.a.I.S.U.Y Y.p.=.z 4.i.G 8 T.",
": 4 @ g s R.v J.$ E.E.c  .W.z.L.5.6.M.M.Q.;...G.%.g.*.o f.q + q.!.",
"3 9 p Q ~ ..R.R.| ~.^./.8.s.F.w.(.g.I.L.S.a.u.2.).b.=.G.~ x._.+ _ ",
"F d $ w.s.R.s `.(./.'.....9.L.0.G.5...N.d.].1.i.!.<.V o Y   < 0 D ",
": 8 8 A.o.! F.[.S P.[.{.6.s...W 0.}.|._.f.3.B.3.3.w G.w  XG - D U ",
".X$ S ~ s ! P.XXoXXXP.F.9.R.8.~ x._.*.# < D %.!.q <.@ o.x V   < ) ",
"= OXp K 0.F.+XXXP.F.R.@XC.z.#Xs./ O > D $X_ !.0 w . V %X&X/   , ) ",
"[   : K.] *X+XF.F.W.H s #X% | u :.1 1 1 =X-Xf _ o + % + u -X, U ;X",
"k.:X8 - s.Q *XL A K 0./.:.f 6 1 R < t 1 D ;X, ] =.V +   = _ ) T.U ",
"; , # Z Q *X5 g *X} >X- q 6 :., u t ) $X,X1 <.+ X.&XV.^ P X ) ) <X",
"$.6 $ V # f z W V.S X.S >X3.8 0 j j T., 1X+ + + B.F G < G D 2XU 3X",
"k : q < :.3._.s 0.&.s.=.o.=.=.&.f.<.. =.# <. Xx.= F / :.4XT.;X;XT.",
"q , > 4.= % |.. ] =.-.G.d.f.n.w.<.j.B.<.d.f.w 5X  6X5X= _ ) T.;X7X",
"> , > : k.w f.f 1.}...w =.-.. f.V =.b.=.}.=.% / , _ G ) ;XD ;X$X7X",
"k > , , e q < 3.o 8Xy 2.X.x.> # P 6X] X.~ > . ^ R h.D 4X;X_ 7X;Xy.",
"> : > , t 1 > q # X.:.1 P i -Xy v y 6 I P 2X= y > ) _ D ;X0 T.T.9X",
"> > : , < 1 t 1 3X, 3X> X.X 1 2 0X= -XX I $XT.1 ) ;X0 7Xh.7X4X;X4X",
"> : > , < 1 , 1 ,X< r t qX;XU : k ,XwX_ R 7XU ;X$X7XT.4X4X_ 4XT.9X",
"> r > > > > 1 t ,X, t wXU 1 3X=X) U ,X7X9X<XU T.D 2X;Xh.h.0 7XT.4X"};

/* XPM */
static char * undo_cap_up_xpm[] = {
"33 33 88 1",
" 	c #888888888888",
".	c #777788888888",
"X	c #888899998888",
"o	c #888888889999",
"O	c #999988889999",
"+	c #888899999999",
"@	c #999999999999",
"#	c #99999999AAAA",
"$	c #9999AAAA9999",
"%	c #AAAAAAAAAAAA",
"&	c #9999AAAAAAAA",
"*	c #AAAABBBBAAAA",
"=	c #888888887777",
"-	c #9D9D83838F8F",
";	c #9F9F99997E7E",
":	c #AAAA99999898",
">	c #AAAA9999AAAA",
",	c #AAAAAAAA9494",
"<	c #BBBBCCCCBBBB",
"1	c #E9E9DDDDE4E4",
"2	c #EEEEEEEEEEEE",
"3	c #AAAAAAAABBBB",
"4	c #DDDDCCCCD8D8",
"5	c #FFFFFFFFFFFF",
"6	c #888877779999",
"7	c #111111111111",
"8	c #111100001111",
"9	c #444444444444",
"0	c #444444444E4E",
"q	c #44444D4D3C3C",
"w	c #555555555555",
"e	c #444455555858",
"r	c #CCCCCCCCCCCC",
"t	c #666666668888",
"y	c #444444446666",
"u	c #111111112222",
"i	c #000000001111",
"p	c #666677777777",
"a	c #DDDDDDDDDDDD",
"s	c #F3F3D7D7D9D9",
"d	c #444433336666",
"f	c #1A1A22221818",
"g	c #000000000000",
"h	c #888877778888",
"j	c #777788887777",
"k	c #CCCCDDDDC9C9",
"l	c #AAAA9999BBBB",
"z	c #44444C4C8686",
"x	c #212133334343",
"c	c #333333333333",
"v	c #666666666666",
"b	c #626277775E5E",
"n	c #777766667777",
"m	c #BBBBAAAABBBB",
"M	c #CCCCBBBBCCCC",
"N	c #313139395555",
"B	c #111100000000",
"V	c #555555556666",
"C	c #666666667777",
"Z	c #25250D0D1919",
"A	c #A3A3B6B6C3C3",
"S	c #1B1B1A1A4343",
"D	c #222222223333",
"F	c #BBBBBBBBBBBB",
"G	c #777777777777",
"H	c #000011111111",
"J	c #C8C8D9D9C5C5",
"K	c #9C9C6E6E6F6F",
"L	c #222233333333",
"P	c #D9D9EEEEE0E0",
"I	c #BBBBBBBBCCCC",
"U	c #FFFFF6F6F6F6",
"Y	c #CCCCBBBBBBBB",
"T	c #555543435555",
"R	c #333333334444",
"E	c #99998888AAAA",
"W	c #333344444444",
"Q	c #222222222222",
"!	c #777777778888",
"~	c #555555557777",
"^	c #000011110000",
"/	c #333322224444",
"(	c #333322223333",
")	c #CDCDCDCDCBCB",
"_	c #BBBBCCCCCCCC",
"`	c #BBBBAAAAAAAA",
"'	c #666655556666",
"]	c #BABABBBBA9A9",
" . X XoXOXO+@+@@@@#$#$#$%$%&%&%*%",
"=- - - OXO;O;O@@@:@:$:$>$>,%,%%%%",
"oXoXoXOXO+@+@@@@#$>$#$>$>&%<121%3",
"   - OXO;O;O@@@:@>$:$>$>,4513678%",
" XoX99999999990q0q0qwqwer2tyyuipO",
" - O94a4a4a4asasasasasa15oydfgwhj",
"oXOX9k@+@@@@#$>$#$>$>&r5lyzxgcvbn",
" OXO94;O@@@:@>$:$>$>,m5MydNB7vvn ",
"OXO+9k@@@@#$#$#$%$%&%21yyyu7Vvv %",
"XO;O94@@@:@:$:$>$>,%<5CdyZgVvv=O,",
"O+@+9k@@#$>$#$>$>&%A5AzySgDjvp@&F",
";O;O94@:@>$:$>$>,%%1adyNguchGO,mF",
"@+@@9k#$#$#$%$%&%&M5tydH7wcX &%FF",
";O@@9sr2JK$>$>,%,m5mydu8qwc>,>FFF",
"@@@@@5a+yLh$>&%%%P1yzxgLwv9r%FFFI",
"@@@mU4ydyDbO,%%%<5CdNi7vvnw4FFFYF",
"@@#kryzyyyu.@&%A5Azy7HVvG wPFFI<I",
"@:@4VdydydDT=@%1adyDgTvv=Ow1FYFY<",
"#$>$R&zyzyN7G M5tydgDvvp@%wPI<I<I",
"@>$: 4ydydyZ9O5myd78vvG %Fw1FYFYF",
"#$#$waEyyyzxcP1yyDgWvv @FFVPI<I<M",
"$:$>q4rdydyde5tdNBQvvn@%FYw1<Y<M<",
"#$>$TPM!zyzyz~zyu^VvG %FI<VPI<M<M",
"$>$>w1%rydydydy/g(vv %FYFYw1FM<M)",
"%$%&wP%atyzyyyd^uvvG@%I<I<VPM<r_r",
"$>,%w1%`FdydydD8wvG %`FY<Yw1<M)r)",
">&%%wGwwFtzyzNg7Qc9wVwVwVw'PM_r_r",
",%%%%1a123ydNu^h O)4a1a1a1P1)M)Mr",
"%&%*%*3*m igg^Rwv 3*I<I<M<r_r_rrr",
",%%%%`%m*>,hGvvv :FY<Y<M<M)r)rrrr",
"%%%%3*m*mA%+ GG o*I<I<M<M_r_rrrrr",
"%%%`%m*m]m]>%@@:%`FYFM<M)M)Mrrr4r",
"%*3*m*mAFAFFF%3*I<I<M<r_r_rrrkrkr"};

/* XPM */
static char * help_xpm[] = {
"33 33 56 1",
" 	c #888899998888",
".	c #888888889999",
"X	c #999988889999",
"o	c #888899999999",
"O	c #999999999999",
"+	c #9999AAAA9999",
"@	c #99999999AAAA",
"#	c #AAAA9999AAAA",
"$	c #9999AAAAAAAA",
"%	c #AAAAAAAAAAAA",
"&	c #9D9D83838F8F",
"*	c #9F9F99997E7E",
"=	c #AAAA99999898",
"-	c #AAAAAAAA9494",
";	c #BBBBAAAAAAAA",
":	c #AAAAAAAABBBB",
">	c #AAAABBBBAAAA",
",	c #666677777777",
"<	c #555555557777",
"1	c #444444444E4E",
"2	c #555543435555",
"3	c #777788888888",
"4	c #444455555858",
"5	c #222222223333",
"6	c #111111112222",
"7	c #333322225555",
"8	c #333333335555",
"9	c #444433336666",
"0	c #333322224444",
"q	c #444444448888",
"w	c #555555556666",
"e	c #777777778888",
"r	c #424260608D8D",
"t	c #DDDDDDDDDDDD",
"y	c #D9D9EEEEE0E0",
"u	c #EEEEDDDDEEEE",
"i	c #BBBBAAAABBBB",
"p	c #DDDDCCCCDDDD",
"a	c #DDDDBBBBCCCC",
"s	c #BBBBBBBBBBBB",
"d	c #88888888AAAA",
"f	c #BBBBCCCCBBBB",
"g	c #CCCCCCCCCCCC",
"h	c #222222224444",
"j	c #666666668888",
"k	c #AAAABBBBBBBB",
"l	c #666655556666",
"z	c #AAAA9999BBBB",
"x	c #EEEEEEEEEEEE",
"c	c #ECECF8F8FBFB",
"v	c #BBBBBBBBAAAA",
"b	c #888877778888",
"n	c #777766667777",
"m	c #BBBBBBBBCCCC",
"M	c #FFFFF6F6F6F6",
"N	c #99998888AAAA",
" . X XoOoOoOoO+O+@+#+@+#+#$%$%%%%",
"& X X*X*X*O*=OOO=O#+=+#+#-#-#%%%;",
" X XoOoOOOO@OOO@+#+@+#+#$%$%%%%:>",
"X X*X*XOOOOOOO=O#+=+#+#-#-#%%%;%%",
" XoOoOoOoO+O,<121<,#+#$%$%%%%:>%>",
"X*X*X*O*=345657898704 #-#%%%;%;>;",
"oOoOOOO@1559qqqqqqqqq9w%%%%:>:>:>",
"X*XOOOe068qqqrtyurqqqqq<.%;%%%;%i",
"oOoOoe559qqqqptasdqqqqqq<@>%>:>i>",
"X*O*=069qqqqqyafgfhqqqqqqj;>;%i>i",
"OOO@w69qqqqqqpfaf.5qqqqqqq@:>i>ik",
"OOOO68qqqqqqqr@fdhhqqqqqqq<ki>i>i",
"oO+w6qqqqqqqqqqh6hqqqqqlqqqz>i>s>",
"=OO07qqqqqqxxyxcxxqqqqqqqqqdavi>i",
"OOO69qqqqqrq5ggagp5qqqqlq<q<gs>sk",
"OOb5qqqqqqqqqxggpt6qqqqqqqlqg>ivi",
"=Onhqqqqqqqqqxpttt6qqqqqlqqrm>svs",
"+#3hqqqqqqqqqMtttt5lq<qlqlqlgikss",
"#+=5qqqqqqqqqcttuy5qqqlqlrlrg>iss",
"+@+5qqqqqqqqqMtttu5lqlqlqlqntssss",
"=+#4qqqqqqqqqcuyuy6qlqqrlrlkgsssv",
"+#+X8qqqqqqqqMtuyu5lqlqlql<pfssmf",
"#+#-4qqqqqqqqcuyxx5qlrlrlrNg:svsv",
"+#$%39qqqqqlqMyuxx5lqlql<lgasmfmf",
"#-#-#3qqqqqcMcxxxccclrlrlfpkvsvfv",
"$%$%%%eqqqql555555555l<<spsmfmfmf",
"#-#%%%;$qqqqqqlqlrlrlr<fpfvsvsvsa",
"$%%%%:>%>@qlqlqlqlql<:tpsmfmfmfaf",
"#%%%;%;>;%mkddjrjddkggasvsvfvsafa",
"%%%:>:>:>i>isvfatagasssmfmfmfafaf",
"%%;%%%;%i>i>i>ivivisssvsvsvsafafa",
"%:>%>:>i>i>s>skskssssmfmfmfafafgf",
";%;>;%i>ivi>ivsvssssvsvfvsafafafa"};

/* XPM */
static char *disk_cap_up_xpm[] = {
"33 33 166 2",
"  	c #7C7C7C7C7C7C",
". 	c #7D7D7D7D7D7D",
"X 	c #7E7E7E7E7E7E",
"o 	c #808080808080",
"O 	c #828282828282",
"+ 	c #838383838383",
"@ 	c #848484848484",
"# 	c #858585858585",
"$ 	c #868686868686",
"% 	c #878787878787",
"& 	c #888888888888",
"* 	c #8A8A8A8A8A8A",
"= 	c #8B8B8B8B8B8B",
"- 	c #8C8C8C8C8C8C",
"; 	c #8D8D8D8D8D8D",
": 	c #8E8E8E8E8E8E",
"> 	c #8F8F8F8F8F8F",
", 	c #909090909090",
"< 	c #919191919191",
"1 	c #939393939393",
"2 	c #959595959595",
"3 	c #969696969696",
"4 	c #979797979797",
"5 	c #989898989898",
"6 	c #9A9A9A9A9A9A",
"7 	c #9C9C9C9C9C9C",
"8 	c #9D9D9D9D9D9D",
"9 	c #9E9E9E9E9E9E",
"0 	c #9F9F9F9F9F9F",
"q 	c #A1A1A1A1A1A1",
"w 	c #818181818181",
"e 	c #949494949494",
"r 	c #9B9B9B9B9B9B",
"t 	c #A2A2A2A2A2A2",
"y 	c #7F7F7F7F7F7F",
"u 	c #000000000000",
"i 	c #A0A0A0A0A0A0",
"p 	c #A3A3A3A3A3A3",
"a 	c #EFEFEFEFEFEF",
"s 	c #A4A4A4A4A4A4",
"d 	c #000051519E9E",
"f 	c #000020206161",
"g 	c #000030306161",
"h 	c #A5A5A5A5A5A5",
"j 	c #898989898989",
"k 	c #000030305151",
"l 	c #A6A6A6A6A6A6",
"z 	c #000051519696",
"x 	c #A7A7A7A7A7A7",
"c 	c #A9A9A9A9A9A9",
"v 	c #A8A8A8A8A8A8",
"b 	c #ABABABABABAB",
"n 	c #414141417171",
"m 	c #303051517171",
"M 	c #ACACACACACAC",
"N 	c #AAAAAAAAAAAA",
"B 	c #ADADADADADAD",
"V 	c #000000008686",
"C 	c #717182827171",
"Z 	c #AEAEAEAEAEAE",
"A 	c #00000000BEBE",
"S 	c #00001010EFEF",
"D 	c #10101010EFEF",
"F 	c #000010104141",
"G 	c #868671717171",
"H 	c #B0B0B0B0B0B0",
"J 	c #20201010EFEF",
"K 	c #30302020EFEF",
"L 	c #101010103030",
"P 	c #DFDFDFDFCFCF",
"I 	c #DFDFEFEFDFDF",
"U 	c #EFEFDFDFEFEF",
"Y 	c #AFAFAFAFAFAF",
"T 	c #000000003030",
"R 	c #10102020EFEF",
"E 	c #20201010AEAE",
"W 	c #515141414141",
"Q 	c #717171716161",
"! 	c #868692928686",
"~ 	c #CFCFCFCFCFCF",
"^ 	c #B2B2B2B2B2B2",
"/ 	c #929292929292",
"( 	c #20202020EFEF",
") 	c #20203030EFEF",
"_ 	c #101020201010",
"` 	c #414141414141",
"' 	c #303030303030",
"] 	c #616161615151",
"[ 	c #515161615151",
"{ 	c #B1B1B1B1B1B1",
"} 	c #30303030EFEF",
"| 	c #51514141EFEF",
" .	c #41415151EFEF",
"..	c #000010100000",
"X.	c #000010101010",
"o.	c #9696A2A2EFEF",
"O.	c #101051512020",
"+.	c #101041412020",
"@.	c #DFDFDFDFDFDF",
"#.	c #B4B4B4B4B4B4",
"$.	c #51515151EFEF",
"%.	c #61617171EFEF",
"&.	c #71718282EFEF",
"*.	c #9E9E9292EFEF",
"=.	c #AEAEAEAEEFEF",
"-.	c #BEBEBEBEBEBE",
";.	c #969692929E9E",
":.	c #CFCFDFDFCFCF",
">.	c #B5B5B5B5B5B5",
",.	c #61616161EFEF",
"<.	c #71716161EFEF",
"1.	c #86867171EFEF",
"2.	c #96968282EFEF",
"3.	c #96969292EFEF",
"4.	c #AEAEBEBEEFEF",
"5.	c #CFCFBEBEEFEF",
"6.	c #9E9EA2A29696",
"7.	c #717171717171",
"8.	c #AEAEAEAE9E9E",
"9.	c #DFDFCFCFCFCF",
"0.	c #B3B3B3B3B3B3",
"q.	c #B6B6B6B6B6B6",
"w.	c #AEAEA2A2EFEF",
"e.	c #BEBEBEBEEFEF",
"r.	c #CFCFCFCFEFEF",
"t.	c #DFDFCFCFEFEF",
"y.	c #9E9EA2A29E9E",
"u.	c #B7B7B7B7B7B7",
"i.	c #51515151AEAE",
"p.	c #BEBEAEAEEFEF",
"a.	c #CFCFDFDFEFEF",
"s.	c #DFDFEFEFEFEF",
"d.	c #202030302020",
"f.	c #9E9EAEAE9E9E",
"g.	c #B9B9B9B9B9B9",
"h.	c #999999999999",
"j.	c #9E9EA2A2EFEF",
"k.	c #9E9EAEAEEFEF",
"l.	c #BEBECFCFEFEF",
"z.	c #DFDFDFDFEFEF",
"x.	c #303020203030",
"c.	c #414141415151",
"v.	c #9E9EA2A2AEAE",
"b.	c #B8B8B8B8B8B8",
"n.	c #AEAEA2A2AEAE",
"m.	c #BBBBBBBBBBBB",
"M.	c #9696A2A29696",
"N.	c #616171716161",
"B.	c #303041413030",
"V.	c #202020203030",
"C.	c #BCBCBCBCBCBC",
"Z.	c #515141415151",
"A.	c #303030302020",
"S.	c #BABABABABABA",
"D.	c #BDBDBDBDBDBD",
"F.	c #868682828686",
"G.	c #868671718686",
"H.	c #414130303030",
"J.	c #414151514141",
"K.	c #BFBFBFBFBFBF",
"L.	c #C0C0C0C0C0C0",
"P.	c #C2C2C2C2C2C2",
"I.	c #C3C3C3C3C3C3",
"U.	c #C1C1C1C1C1C1",
"Y.	c #C4C4C4C4C4C4",
"T.	c #C5C5C5C5C5C5",
"  . X o o O + @ # $ % & * = - ; : > , < 1 1 2 3 4 5 6 6 7 8 9 0 q ",
". X o w O + @ # $ & & * = - ; > > < < 1 e 2 3 5 5 6 r 7 8 9 0 q t ",
"X y o O O @ # $ u u u u u u u u u u u u u u u u u 6 7 7 9 0 i q p ",
"o o O + @ # $ % u a a a a a a a a a a a a a a a u u 8 9 0 q q p s ",
"w O + @ # $ & & u a a a a a d a d d d d d f g a u a u 0 q t p s h ",
"O O @ # $ % & j u a a a a a a a a a a a a a k a u a a u q p p h l ",
"+ @ # $ % & * = u a a a a a d d z g g g g k g a u u u u u s h l x ",
"@ # $ & & * = - u a a a a a a a a a a a a a a a a a a a u h l x c ",
"# $ % & j = - ; u a a a a a a a a a a a a a a a a a a a u l x v c ",
"$ % & * = - ; : u a a a a a a a a a a a a a a a a a a a u u v c b ",
"& & * = - u > > u a a a a a a a a n m m m n n n m m m a u u c b M ",
"& j = - ; u u u u a a a a a a a a a a a a a a a a a a a u u N M B ",
"* = - ; : > u u V u C a a a a a a a a a a a a a a a a a u u M B Z ",
"= - ; > > < u u u A S D F u u u u u u u u a u u G u a a u u B Z H ",
"- ; : > , < u u u u D J K L P I U a a a a a a a a a a a u u Z Y H ",
"; : > < < 1 e u T R J E W Q ! Z ~ u a a a a a a a a a a u u Y H ^ ",
": > , < / 1 2 u D ( ) _ ` u ' u ] u a u G u a [ a a a a u u H { ^ ",
"> , < 1 1 u R ( } |  .u ..X._ u o.u O.+.@.I a a a a a a u u { ^ #.",
"< < 1 e 2 3 u u | $.%.&.u u *.=.=.u -.;.-.:.a a a a a a u u ^ #.>.",
"< / 1 2 3 4 u u $.,.<.1.2.3.=.4.5.u 6.7.8.9.a a a a a a u u 0.#.q.",
"1 1 2 3 4 5 u u u u 2.*.w.=.e.r.t.u ....y.u [ [ [ u a a u u #.q.u.",
"e 2 3 5 5 6 u u u u i.w.p.e.a.s.a u d.` f.9.a a a a a a u u q.u.g.",
"2 3 4 5 h.6 7 7 u j.k.4.l.r.z.a a u x.c.v.:.a a a a a a u u u.b.g.",
"3 4 5 6 6 7 u 3.j.=.4.l.z.U a a a u x.c.n.~ a a a a a a u u b.g.m.",
"5 5 6 r 7 8 u u u Z M.N.B.' x.V.d.d.V.c.v.:.a a a a a a u u g.m.C.",
"5 h.6 7 7 9 u u u ! 7.Z.u u A.u ' u ' u u 9.[ u u a a a u u S.m.D.",
"6 6 7 8 9 0 u u u F.G.G x.u 7.u H.x.H.u J.u u [ a a a a u u m.D.-.",
"r 7 8 9 0 q u u u ~ 9.~ 9.~ ~ ~ ~ 9.~ :.@.U a a a a a a u u D.-.K.",
"7 7 9 0 i q p u u u u u u u u u u u u u u u u u u u u u u u D.K.L.",
"8 9 0 q q p s h l x u u u u u u u u u u u u u u u u u u u u K.L.P.",
"9 0 q t p s h l x c c b M B Z H H ^ ^ #.>.q.u.g.g.m.C.D.-.K.L.P.I.",
"0 i q p p h l x v c N M B Z Y H { ^ 0.#.q.u.b.g.S.m.D.D.K.L.U.P.Y.",
"q q p s h l x v c b M B Z Y H ^ ^ #.#.q.u.b.g.m.m.D.-.K.L.P.P.Y.T."};

static char *KeyPress[] = {
"48 48 151 2",
"  	c None",
". 	c #30C24D346185",
"X 	c #71C6A289BEFB",
"o 	c #AEBAAAAABEFB",
"O 	c #5965555569A6",
"+ 	c #71C669A68617",
"@ 	c #79E771C69658",
"# 	c #96588617AEBA",
"$ 	c #AEBADF7DFFFF",
"% 	c #FFFFFFFFFFFF",
"& 	c #965892489658",
"* 	c #C71BC71BC71B",
"= 	c #8E388A288E38",
"- 	c #BEFBBAEABEFB",
"; 	c #CF3CDB6CCF3C",
": 	c #CF3CD34CC71B",
"> 	c #E79DFFFFD75C",
", 	c #00000C3028A2",
"< 	c #082000001861",
"1 	c #861782078617",
"2 	c #69A669A669A6",
"3 	c #71C675D671C6",
"4 	c #D75CDB6CCF3C",
"5 	c #20811C712081",
"6 	c #38E338E34924",
"7 	c #B6DAB2CAB6DA",
"8 	c #30C22CB238E3",
"9 	c #28A2249230C2",
"0 	c #A699AAAAA699",
"q 	c #492445145144",
"w 	c #96588A28A699",
"e 	c #618565956185",
"r 	c #D75CE79DCF3C",
"t 	c #9E799E799E79",
"y 	c #79E779E78E38",
"u 	c #AEBAAAAAAEBA",
"i 	c #2081208128A2",
"p 	c #6185596571C6",
"a 	c #F7DEFBEEF7DE",
"s 	c #79E775D68E38",
"d 	c #F7DEF7DEF7DE",
"f 	c #5965596569A6",
"g 	c #69A6659579E7",
"h 	c #61855D7571C6",
"j 	c #F7DEF3CEF7DE",
"k 	c #69A669A679E7",
"l 	c #28A2249228A2",
"z 	c #71C66DB68617",
"x 	c #EFBEEFBEF7DE",
"c 	c #69A66DB669A6",
"v 	c #28A228A230C2",
"b 	c #79E771C68E38",
"n 	c #86177DF79658",
"m 	c #30C230C24103",
"M 	c #BEFBBEFBBEFB",
"N 	c #28A22CB230C2",
"B 	c #861779E79658",
"V 	c #79E771C68617",
"C 	c #8E388207A699",
"Z 	c #082000001040",
"A 	c #38E334D34103",
"S 	c #FFFFFBEEFFFF",
"D 	c #CF3CDF7DCF3C",
"F 	c #30C22CB230C2",
"G 	c #8E388A289E79",
"H 	c #8E3886179E79",
"J 	c #492441035144",
"K 	c #8E387DF7A699",
"L 	c #492449245965",
"P 	c #51444D346185",
"I 	c #71C671C671C6",
"U 	c #30C230C238E3",
"Y 	c #96589248A699",
"T 	c #9E799658AEBA",
"R 	c #96588E38A699",
"E 	c #96588A289E79",
"W 	c #69A6659571C6",
"Q 	c #71C66DB68E38",
"! 	c #514451446185",
"~ 	c #28A228A238E3",
"^ 	c #AEBAA699B6DA",
"/ 	c #6185596569A6",
"( 	c #69A6618579E7",
") 	c #71C6C71BFFFF",
"_ 	c #30C234D338E3",
"` 	c #9E799A69AEBA",
"' 	c #A6999E79B6DA",
"] 	c #514451445965",
"[ 	c #71C66DB679E7",
"{ 	c #79E775D68617",
"} 	c #61855D7579E7",
"| 	c #861779E79E79",
" .	c #69A6618571C6",
"..	c #000000000000",
"X.	c #38E334D338E3",
"o.	c #A699A289B6DA",
"O.	c #AEBAA289B6DA",
"+.	c #596555556185",
"@.	c #861779E7A699",
"#.	c #AEBAA699BEFB",
"$.	c #86177DF78E38",
"%.	c #61855D7569A6",
"&.	c #86177DF7A699",
"*.	c #71C669A68E38",
"=.	c #71C671C679E7",
"-.	c #79E779E78617",
";.	c #69A665958617",
":.	c #96588A28AEBA",
">.	c #6185618569A6",
",.	c #71C671C68617",
"<.	c #49244D345144",
"1.	c #861782079658",
"2.	c #B6DAA699D75C",
"3.	c #00002CB25144",
"4.	c #38E338E34103",
"5.	c #410341034924",
"6.	c #8E3882079658",
"7.	c #000038E36185",
"8.	c #186114511861",
"9.	c #410345144924",
"0.	c #41033CF34103",
"q.	c #596559656185",
"w.	c #CF3CBEFBF7DE",
"e.	c #A6999A69B6DA",
"r.	c #69A669A671C6",
"t.	c #9E799658A699",
"y.	c #A6999E79AEBA",
"u.	c #186171C6A699",
"i.	c #B6DAB2CABEFB",
"p.	c #BEFBB6DAC71B",
"a.	c #B6DAB2CAC71B",
"s.	c #D75CD34CD75C",
"d.	c #D75CD75CD75C",
"f.	c #28A2249238E3",
"g.	c #410338E35144",
"h.	c #20811C7128A2",
"j.	c #28A2208138E3",
"k.	c #1861104028A2",
"l.	c #1861145128A2",
"z.	c #28A2208130C2",
"x.	c #10400C302081",
"c.	c #20811C7130C2",
"v.	c #2081186130C2",
"b.	c #082004101861",
"n.	c #104008202081",
"m.	c #AEBAA289CF3C",
"M.	c #1861186128A2",
"N.	c #492441035965",
"B.	c #38E330C24924",
"V.	c #D75CC71BFFFF",
"C.	c #410341035144",
"                                                                                                ",
"                                                                      . . .                     ",
"                                                                    . . . . . .                 ",
"                                                                  . . X . . . . .               ",
"                o O O O O O O + + @ @ @ @ # # # # # # @ @ @ + + . . X X $ . . . . .             ",
"              o O O O O O O O O O O O O O O O O O O O O O O O . . X X $ $ $ . . . .             ",
"            o o O O O O O O O O O O O O O O O O O O O O O O . . X X $ $ $ X X . . . .           ",
"          o % o O O O O O O & * % % % * = O O O O O O O O . . X X $ $ $ X X . . . . .           ",
"O O O O O o % o O O O O O - % % ; : ; > % - O O O O O O . . X X $ $ $ X X . . , , . o O o O O O ",
"O < < < < % % o O O O O 1 % ; 2 O O 2 3 4 % 1 O O O O . . X X $ $ $ X X . . , , 5 O 6 < < < < O ",
"O < < < O % % o O O O O - % = O O O O O 1 > 7 2 O O . . X X $ $ $ X X . . , , 8 O O O 9 < < < O ",
"O < < < o % % o O O O O : % 1 O O O O O 2 0 & 2 O . . X X $ $ $ X X . . , , 5 # O 6 O q < < < O ",
"O < < < % o % o O O O O 7 > ; 2 O O O O O O O O . . X X $ $ $ X X . . , , 5 O # O 6 O 6 9 < < O ",
"O < < O % w % o O O O O e ; > > r * t 3 2 2 O . . X X $ $ $ X X . . , , 5 O O # O 9 6 O 6 < < O ",
"O < < o % y % o O O O O 2 e t : % % % % % u . . X X $ $ $ X X . . , , 5 O O O # O < 6 O 6 < < O ",
"O < < % o y % o O O O O O O O O O 1 0 ; > . . X X $ $ $ X X . . , , i p O O O # O < 9 6 O 9 < O ",
"O < O a o s d o O O O O O O O O O O f O . . X X $ $ $ X X . . , , i g g h p f # O < < 6 O 6 < O ",
"O < o j w k a o O O O 1 % u 2 O O O O . . X X $ $ $ X X . . , , l z z z + g O # O < < 9 6 O < O ",
"O < % o s k x o O O O e % r c O O O . . X X $ $ $ X X . . , , v s s s s b n O # O < < 9 m O < O ",
"O < % o k s j o O O O O - % M 2 O O . X X $ $ $ X X . . , , N n n n n n B V O C O < Z < A O < O ",
"O < S w k y a o O O O O e D % % M . . X $ $ $ X X . . , , F G G G H H H n n J K L < < < 9 P < O ",
"O < a y k w % o O O O O O I 0 M M . X X $ X X X . . , , U Y T T Y R E H W z O Q ! Z < < 9 ~ < J ",
"O < ^ s k w % o O O O O / h ( g . . X ) X X . . . , , _ ` ' ' ' T R ] [ [ { } | P < Z < < ~ < O ",
"O < ' k s o S o O O O O p  .g g . X ) X X . . ...., X.' o.O.O.` +.[ [ [ { k ( @.Q < < Z < 9 < O ",
"O < y k w o % o p O O / h g k . . X ) X . . ....X.X.o.#.#.^ $.%.[  .[ { s n ( &.*.< Z < < ~ < O ",
"O < s k T o % o ( O O p  .g z . X ) X . . ....X.o.O.#.O.] { W [ W [ =.-.$.g ;.K :.Z < < Z ~ < O ",
"O < k s R o % o g O O h g z . . ) X X . .._ X.O.#.O.%.k >.%.[ W [ [ { { $.@.;.K # < Z < < ~ < O ",
"O < k s R o % o + / p  .z ,.. X ) X . .._ ' #.o.<.] +.] +.W W [ k ,.{ $.1.| + K 2.< < < < ~ < O ",
"O < s B R o % o z h h z z 3.X ) X . .._ ' Y +.<.4.5.<.] +.>.[ [ { { 1.$.6.| *.# 2.< < < < ~ < O ",
"O < s 6.O.o % o z h ,.z ,.7.) X . ..W k 8.9.N 4.0.5.] ] q.[ { 1.$.E E ` ` # *.# w.< < < < ~ < O ",
"O < w e.#.o % o z  .g b b ) ) . ..r.4...X.8.X.4.X.<.q.W [ $.t.y.o.^ #.#.` # *.o w.< < < < ~ < O ",
"O < w O.#.o % o z h B ,.3.) . ........4.8.5.X.] q.W $.R T ' #.o #.#.#.o.' # :.o % < < < < ~ < O ",
"O < o #.o o o % k  .h b u.3.........4...[ ,.R Y T ` o.#.o o o o o o #.' w w :.% o < < < < ~ < O ",
"O < o o o o o % o g  .,.H H ` O.#.o o o #.#.#.o o o o o o o o o o #.o.w ' w o % o < < < < ~ < O ",
"O < o o o o Y o % % O ^ ` o i.p.a.o o o o o o o o o o o o o o o o o w o w d % o O < < < < ~ < O ",
"O < o o o Y Y O O o % % s.s.d.d.% % % % % % % % % % % % % % % % % % % d S o o O f.< < < < ~ < O ",
"O < o o o Y 1.O g.h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < ~ < O ",
"O < o O.` Y k O g.h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < j.< < < < ~ < O ",
"O < o ' R Y O g.g.h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < < k.f.l.< < < ~ < } ",
"O < o ' Y 1.O g.g.h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < < k.z.k.< < < ~ < } ",
"O < o o Y k O g.~ h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < < x.c.v.< < < ~ < C ",
"O < o Y 1.k O g.~ h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < < k.c.c.l.b.< ~ < C ",
"O < o Y 1.k O g.~ h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < < k.c.c.k.n.< ~ < C ",
"O < o Y k O O g.~ h.< < < < < < < < < < < < < < < < < < < < < < < < < < < < l.l.v.v.l.n.< ~ < m.",
"O < Y 1.k O O g.~ i < < b.j.n.b.< < < < < < < < < < < < < < < < < < < < < < l.l.l.v.l.< < ~ < m.",
"O < Y 1.k O g.g.~ c.< < n.M.M.x.b.< < < < < < < < < < < < < < < < < < < b.n.l.l.l.c.j.< < ~ < m.",
"O < 1.k O O N.B.f.c.< < b.l.c.v.k.l.b.< < < < < < < < < < < < < < < < < b.l.c.l.l.j.f.l.< ~ < V.",
"O < 1.k O O C.B.f.c.< < b.l.c.c.v.c.l.l.l.b.b.< < < < < < < < < < < < < < x.l.l.l.f.f.l.< < < V."};

static char * Gear_xpm[] = {
"48 48 57 1",
" 	c None",
".	c #8E388A288E38",
"X	c #596559655965",
"o	c #208120812081",
"O	c #A699A289A699",
"+	c #618561856185",
"@	c #38E338E338E3",
"#	c #38E330C238E3",
"$	c #514451445144",
"%	c #861782078617",
"&	c #71C671C671C6",
"*	c #492449244924",
"=	c #104010401040",
"-	c #71C669A671C6",
";	c #186118611861",
":	c #965892489658",
">	c #186110401040",
",	c #BEFBBAEABEFB",
"<	c #CF3CCB2BCF3C",
"1	c #F7DEF3CEF7DE",
"2	c #FFFFFBEEFFFF",
"3	c #D75CD34CD75C",
"4	c #69A669A669A6",
"5	c #EFBEEBADEFBE",
"6	c #F7DEFBEEFFFF",
"7	c #30C230C230C2",
"8	c #E79DE38DE79D",
"9	c #9E799A699E79",
"0	c #514449244924",
"q	c #DF7DDB6CDF7D",
"w	c #410341034103",
"e	c #D75CD34CCF3C",
"r	c #BEFBBAEAC71B",
"t	c #8E3882078617",
"y	c #79E779E779E7",
"u	c #CF3CC30BC71B",
"i	c #C71BC30BC71B",
"p	c #BEFBC30BC71B",
"a	c #C71BBAEABEFB",
"s	c #28A228A228A2",
"d	c #28A230C230C2",
"f	c #AEBAAAAAAEBA",
"g	c #B6DAB2CAB6DA",
"h	c #AEBAB2CAB6DA",
"j	c #618559655965",
"k	c #96589A699E79",
"l	c #AEBAAAAAA699",
"z	c #9E79A289A699",
"x	c #8E388A289658",
"c	c #8E388A288617",
"v	c #38E3410338E3",
"b	c #082008200820",
"n	c #861779E779E7",
"m	c #410338E34103",
"M	c #69A661856185",
"N	c #410341034924",
"B	c #596551445965",
"                                                ",
"                  .Xo. O+@@##$%                 ",
"                &*===#-o=======;*:              ",
"               o====;;=========>;X              ",
"           ,%o====o$;=========;;=X              ",
"         <12%=====.234======;;===-              ",
"       ,5265<7====8552190=;;=====%              ",
"      q225588&===w28e<q52-;======;&             ",
"      3r5888qt===y23<<ui<+========;& &7o9       ",
"      OX88qqqq%%tp8<uiiia7=========sw;==w9      ",
"       d.qqqq33e<<<uiii,f;========;;====;-      ",
"    .7==O8q333<<<uiii,,,9;======;;=======o9     ",
"  gr%7=41q33e<<<uiia,,,gg%o==oy$;=========@     ",
"  526842q3e<<<uiii,,,,gghf:w7i2:;==========4    ",
"  2qq1283e<<<iii,,,,gghfffOOh2h9w=========;j    ",
" ,23q38e<<<uiip,,,gggffffOOO999k.s=======oX     ",
" <5333<<<<iii,,,,gghffflOOz999:::y;====;s%      ",
" 583e<<<iiia,,,gghffflOOO999::::..$;==;;=       ",
" ,O<<<uiip,,,ggghfffOOO9999::xx..c%*;;===v      ",
"  =Xgiiip,,,gghf94$$%O999k::xx..t%%X;====;9     ",
"   7=ir,,,gggff:@7so7$:9::xx..c%%47=======&     ",
"    w,,,,gghfff*7;===74::x..c%%%y7=========b=   ",
"    w,,gghhffl:7o=====&9...c%%nyys===========X  ",
"    :<gghfffOO%7;=====wg.c%%%yyyyw===========X  ",
"  g81ihffflOOO&7;=,9===9g%%%yyy&&$=========;sX  ",
" g15,hfflOOO99%7;0.s;b=w1%yyy&&&-4========o7*X  ",
" ,2hfffOOOz999:@m=h7sb==2.yy&&&-44Xso;==>o@*$X  ",
" g2,flOOO999k::$$=+O;b==ig&&&-444+++XXsosw0$*X  ",
"  1<lOO9999:::xyX7=sbb==.O&-444M+++XXX7#*$**o.  ",
"  qqOO999:::x..c9y======,f-44M+++XXX$$7w$*No&   ",
"  ,1O99k:::x..t%:37====$1%44+++jXXB$$$7**wo&    ",
"   299:::x..ct%%nO8X==Xqq4M+++XXX$$$$*s*mo.     ",
"   g7===*..c%%%yyyg6222,&+++XXXB$$$***s#=m      ",
"   O%%% oy%%%yyyy&&-::y+++jXXB$$$0N@m@o===*     ",
"        M*%nyyy&&&-444+++XXXB$$$0*@7oo;===b     ",
"         w&yy&&&-444+++XXXB$$$0**w7;======&     ",
"        iq&y&&--44M+++XXX$$$$***w7;======&      ",
"        5,&&&-444+++XXXB$$$0**wwws;=====&       ",
"        1&&-444M++jXXB$$$0***www@7o;===&        ",
"        ,wX44M+++XXXB$$$0**wwwm@@#7o>=&         ",
"         %sv++X@$XX$$$0**Nwwwm@@#77s;:          ",
"          .*o0oow;v$$***wwv7s@@77dso.           ",
"           O&s;  :@w**Nww7;;=;@7do;.            ",
"                  j@Nwwwmm====>sswO             ",
"                  jswwm@@m=====o%               ",
"                  4o@@@@@m;;=w%                 ",
"                   w###s;sM                     ",
"                                                "};

static char * FileManager_xpm[] = {
"48 48 64 1",
" 	c None",
".	c #E79DE38DEFBE",
"X	c #CF3CC71BCF3C",
"o	c #DF7DDB6CCF3C",
"O	c #8E388A28AEBA",
"+	c #9E799E79BEFB",
"@	c #E79DE38DDF7D",
"#	c #86179248A699",
"$	c #86178207A699",
"%	c #9E79BAEAB6DA",
"&	c #79E792489658",
"*	c #71C682079658",
"=	c #861782079658",
"-	c #79E779E7A699",
";	c #71C671C6A699",
":	c #71C671C69658",
">	c #9E798E388E38",
",	c #F7DEF3CEEFBE",
"<	c #69A682078E38",
"1	c #618571C68617",
"2	c #4924492469A6",
"3	c #28A234D32081",
"4	c #28A2208128A2",
"5	c #514459655965",
"6	c #618565958E38",
"7	c #000000000820",
"8	c #082008200000",
"9	c #082020811861",
"0	c #1861208128A2",
"q	c #186130C228A2",
"w	c #514441036185",
"e	c #082008200820",
"r	c #000000000000",
"t	c #186114511040",
"y	c #104020812081",
"u	c #61855D755965",
"i	c #492449245144",
"p	c #208108202081",
"a	c #28A220811861",
"s	c #186130C21861",
"d	c #5144514471C6",
"f	c #000008200820",
"g	c #514445144103",
"h	c #69A665956185",
"j	c #D75CC30B9658",
"k	c #410330C22081",
"l	c #D75CCF3CB6DA",
"z	c #208120814103",
"x	c #28A230C24103",
"c	c #186130C24103",
"v	c #30C238E34103",
"b	c #28A230C25144",
"n	c #410341035144",
"m	c #8E38820769A6",
"M	c #410341034103",
"N	c #861779E78617",
"B	c #28A245145144",
"V	c #410341036185",
"C	c #082008201861",
"Z	c #104014510820",
"A	c #410351446185",
"S	c #5144618571C6",
"D	c #514455558617",
"F	c #618561858617",
"                  ..X                           ",
"                .oO++oX                         ",
"             .@X+O#$$O%oX                       ",
"           ..%+OO&O&$&$#+o@                     ",
"         .@+#O#O#$$$*$$$=O+Xo                   ",
"      .@X+OOO#O&O-$-;-;*;-$#+@@                 ",
"    @@+OOO#O$O$$-$*-*;*:::*:$>+Xo               ",
"  ,oO#OOO#O#O&O-$*;*;*;<:1:<;*;123              ",
"  ,45>#$#$$$$$--*-*;*:::1616162787              ",
"  ,90q5#O&O-$-$*;*;*;<:1:1:1weeree              ",
"  ,ty0y4uO#$--*-::::::1616i7878pay              ",
"  ,y0q0s0id#$--*:<:1:1:12fefetasg>,             ",
"  ,0s4q4q4qih$*-*:1:16i7878paaa>jjkg@l          ",
"  ,qzqxqxxxq4iu--*:1weefeyay4>jjgagjokX  X@q    ",
"  ,4qzqz3xxxxx3iu:i7878ptaa>jjkakjjktt>.@>i7    ",
"  ,qxqxcxvbvbvbcnfefeyyaamjjk3gjjkyy>.@&2c0f    ",
"  .x3xxxvvvMvMnMv7ettaa>jjkkujjkttN.@>M0qz0e    ",
"  ,cxvxvbBMBnBnBVeCkC>jjk3hjlkaZ>.X&n000zc0f    ",
"  .xxxvMvMvMnnnVn7ekeh3kujjkytN.@>Mpy0y4qz07    ",
"  ,vbvbBnBnBVBVAVfCkCmCmj5ay>.@&n909090m53ze    ",
"  .MvMvnnnnnnwiwi7ekehehaaa.@>Mt9t9py0y3jg0e    ",
"  ,BnBnBVnVnVAVA2eCMtgCmCmCou9t9p9090q>lm30f    ",
"  .MBMnnnViwAwAw27ew=ieheheXit9p9m54>lmv00q7    ",
"  ,BnBViViVA2AdAdre9V*OyCmCo59090k>lmM0qxvze    ",
"  .nnnnViwAwAw2d2r8rrtA>3aeX5ty0y0y4y0qbvMqC    ",
"  .BVAVAVA2Ad2d2dreqCrCCu&4ou900zqxcxvbBVBze    ",
"  .VnVAwAwAd2d2ddr8M0zrreCuX5004qzxxxbBMnVqC    ",
"  @AAAdAdAdSd5dSDre9nBzq7rCouyzqxcbvbBBBVAzZ    ",
"  @wAw2d2d2dSuSDSr8rrtnxq4rX540zqxxbvMnVnw0t    ",
"  @AdAdAdSdSDSDSFrbr7rCqbvzouqzcxxbBbBVBb9t     ",
"  @w2d2dddSuSDSDS7vvnrrr04xXuzqzxbvMBVxpC0      ",
"  @5d5dSdSDSFSFDFfF-OvCr7r0ouqxcbvbBn9Cq        ",
"  @d2dddSuSDSDuFF7+:n4qzerrXuzxxvMv094          ",
"  @SdSDSDSFDFDF66e+AzcxcbxCoucbvb0tq            ",
"  @ddDSDSDSFFF1F1e%wqzqxxbvXuxxpCt3             ",
"  @SDSDDFDF6F6611e+Axcbvbvb<uqC9C9              ",
"  ldSDuFSFFF16161Z+2qzxbvMB0etCz9t              ",
"   qdDFD616161:1:Z+AxxbvbBnczxbA09              ",
"    yM1FF61616161t%wxbxbBMBVnVAwythN            ",
"     c0S6161:1;1;Z+AbvbBnBVBVAB9C9imN           ",
"      c4v6161::;:t+2xbvMBMnVi0yysviN&           ",
"        xqF1;1;<;9+AbBnBVBVqpe33nuN&            ",
"         csM1;:;:t%dxMBMnz9e3vMimN&             ",
"           3xS;-;9+5bBVc0eeMiiN&>               ",
"            ccn;-t+dvzytegMihNN                 ",
"              xcdy+vp9CMnihN=                   ",
"               3ytxteMMguNN>                    ",
"                usCsihNNO                       "};

static char * ColorPalette_xpm[] = {
"48 48 64 1",
" 	c None",
".	c #71C6F3CE8E38",
"X	c #8E38F3CE9658",
"o	c #A699F3CE9658",
"O	c #CF3CF3CE9E79",
"+	c #EFBEF3CE8E38",
"@	c #F7DEDB6C8E38",
"#	c #F7DED34C71C6",
"$	c #AEBAF3CEA699",
"%	c #DF7DF3CEA699",
"&	c #F7DEDB6C9E79",
"*	c #CF3CF3CEBEFB",
"=	c #F7DEDB6CAEBA",
"-	c #8E38F3CEB6DA",
";	c #B6DAF3CEBEFB",
":	c #EFBEF3CEB6DA",
">	c #9658F3CEBEFB",
",	c #F7DEBAEA9658",
"<	c #F7DED34CBEFB",
"1	c #CF3CF3CECF3C",
"2	c #9658F3CECF3C",
"3	c #EFBEF3CEC71B",
"4	c #F7DEBAEAAEBA",
"5	c #F7DEE38DCF3C",
"6	c #AEBAF3CED75C",
"7	c #DF7DF3CED75C",
"8	c #F7DEF3CEDF7D",
"9	c #F7DEBAEABEFB",
"0	c #8E38EBADEFBE",
"q	c #A699F3CEEFBE",
"w	c #BEFBF3CEE79D",
"e	c #DF7DF3CEE79D",
"r	c #F7DECB2BD75C",
"t	c #F7DEDB6CE79D",
"y	c #F7DE9A69A699",
"u	c #BEFBEBADF7DE",
"i	c #CF3CF3CEF7DE",
"p	c #EFBEEBADF7DE",
"a	c #000000000000",
"s	c #AEBADB6CF7DE",
"d	c #BEFBD34CF7DE",
"f	c #D75CDB6CF7DE",
"g	c #F7DEBAEAE79D",
"h	c #F7DEAAAAD75C",
"j	c #F7DE9A69CF3C",
"k	c #EFBED34CF7DE",
"l	c #9658D34CF7DE",
"z	c #F7DEBAEAF7DE",
"x	c #F7DE8207CF3C",
"c	c #DF7DC30BF7DE",
"v	c #8E38BAEAF7DE",
"b	c #A699B2CAF7DE",
"n	c #BEFBBAEAF7DE",
"m	c #F7DEA289E79D",
"M	c #DF7DB2CAF7DE",
"N	c #8617AAAAF7DE",
"B	c #EFBEA289F7DE",
"V	c #EFBE9248EFBE",
"C	c #B6DA9A69F7DE",
"Z	c #79E7A289F7DE",
"A	c #96588A28F7DE",
"S	c #E79D9A69F7DE",
"D	c #EFBE8207EFBE",
"F	c #71C68A28F7DE",
"                                                ",
"..........X.XXoXooooooOOOOOOOO+O++++++++@+@@@###",
"...X.X.....X.XXoX$o$o$oOOOOOOOO%O%+++++++&+@@###",
"X.X.X.o.XXXXXXoooo$oOoOOOOOO%O%+%+%+++++&@&@####",
".X.XXXXoXoXoX$X$$$$$$O$%O*O*O%O%%%%%+%+=+&@&@@##",
"X.XXX.o.oXoX$X$o$o$$O$OOOOOOOO%%%+%+%+&&&@@@@###",
".-X-X-Xoooo$o$$$$$$;$%O%O*O*O:%%%%%%+%+=&&&&@@##",
"-X-X-o-o$o>o$$$$$$%$%O%O*O*O:%:%%%%%=%=&&&@&@#,#",
"--------->->>>$>$;;%%%%******:::::%:%<%==&&&@@#,",
"------>->>>>;>;>;$%%%%**1*:*:::::%<%<%==&&@@@@,,",
"->->->-2-2>2>;>;;;;*%*%1*113*3:3:3:<%<%<=&&&@4@,",
">->->-2->>2>;;;;;;%%*%1*3*3:3:::::<%<=<=&@&@,@,,",
">>>>>2>222222;;;;*;**1*1131333:3:3:5<<===&&&@4,,",
">>>>>>2222;;;;*;*;**1*113133333:3:5<<<=&=&4&4,,,",
">2>2>6>62626;6;1;1***717173738333535<5<=&=&4&4,,",
"2>6>62626;6;1;1;1*7*717173738383535<=<===&4&4,,,",
"222226666666616111*11717777778353555<5<===&9&4,,",
"226266666666161111777177778783535555<<==9&444,,,",
"202q2q6w6w6w6w1w1w177e7e7e78788535555<<<=9494,4,",
"02q6q6w6w6w6w1e1e7e7e7e78788885555r5<<<=9494,,,,",
"000q0qqwwwwwwwwwweeeeeeee8e88t8t555r<<<<=9444,,y",
"00qqqqwwwwwwwweweeeeeeee8888t8t555r<<<<9994,4,yy",
"000q0qquwuwiwiwiwieeepeeepe88t855r5r<r<<9494,4,y",
"00qqqquwuwiwiwiwiepepeaaaaa8ttt5r5r<<<<9444,y,yy",
"0q0qqqquuiuiiiiiiiipppappaap8t5t5rrr<r<<9444,yyy",
"00sqsqduduuiuififippppappaa8pttrtrr<r<9994y4yyyy",
"000s0sqduduuuuififipipaaaaaptptt5trr<r<<99444yyy",
"00sqsqduduuuuififipippaaaaa8pttrtrr<r<<<94y4yyyy",
"000sqsqduduuiuiuiffpipppppppppttttrgrr<h<94j4yyy",
"00ssssdddduduufuffffpfkpppkpkttttrgrrrh994j4jyyy",
"000s0ssdsdddduuuuffffffppkpppktttgtgrgrh9h9j4jyy",
"lll0llsssssddddufdffkfkkkkkkkkktgtgrhrh9h9j9jyyy",
"0lll0lllsslssdsddddffffkkkkkkkkztzggrgrhhh9hjjyx",
"llllllllssssdsddddcfcfcfkkkkkkzgzggggrhhh9jjjyyy",
"lllllllllslssssdsddcdcfkfkkkkzkztzggrgrhhh9hjjyx",
"vlvlblblnsnsdndsddddcccfckckzzzgzgggghghhjhjxjxy",
"lvvvlbvblnbnnnnnndnddcdcfccckzczzzgzgggmhhhhjjxx",
"vvvvvvbbbbbbbnbnnnndMdMcccMcMczzzgzgmgmhmhjhjxxx",
"vvvvvvvbbbbnbnnnnbnddddcccccccczczzzgggmhmhhjjxx",
"vvvvvvbvbbbbbbbbbbndMdMcMcMcMczzzzzgmgmhmhjhjxxx",
"vNvvvvvvvbvbbbbbbbbndndMcMcMcMMzMzzBgBgmmVhVhjxx",
"NNNNvvNvCvCbCbCCCbCnnnMnMMMMMMBMBMBBBmmmVhjjjxxx",
"NZNvNNNNvNvCvCbCbCbCbCnMnMMMMBMBMBMBmBmmmVjVjxjx",
"ZZZZNZNNNNCNACCCCCCbCCCnSMSMBBBBBBBBSmSmVVDjxxxx",
"NZNZNNZNNNNNNCCCCCCCbCnCnSnSMBMBMBBBBBmSmVjVjxxx",
"ZZFZZZAZANANANACACCCCCCCSCSSSSBBBBSBSBSVVVDjDxxx",
"ZFZZZFZAZAZAAANACACCCCCCCSCSSSSBSVBSBSSSVDVDjDxx",
"FFFFFFFFAFAFAAAAAACCCCCCDCDSDSVBVVVVSSDVDDDDDxxx"};


static char *hammer[] = {
"48 47 66 1",
"  c Gray0",
". c #001830",
"X c #003000",
"o c #300000",
"O c #300030",
"+ c #303000",
"@ c Gray19",
"# c #306118",
"$ c #306161",
"% c #610000",
"& c #610030",
"* c #613000",
"= c #613030",
"- c #493061",
"; c #616100",
": c #616130",
"> c Gray38",
", c #30619e",
"< c #61619e",
"1 c #619a61",
"2 c #799a79",
"3 c #61cb9e",
"4 c #9e0000",
"5 c #9e0030",
"6 c #9e3000",
"7 c #9e3030",
"8 c #9e6100",
"9 c #9e7d18",
"0 c #9e6161",
"q c #cf3030",
"w c #ff3030",
"e c #cf3061",
"r c #ff3061",
"t c #cf6100",
"y c #cf6130",
"u c #ff6100",
"i c #ff6130",
"p c #9e619e",
"a c #9e9a30",
"s c #cf9a00",
"d c #cf9a30",
"f c #ff9a30",
"g c #cf9a61",
"h c #ff9a61",
"j c #cfcb30",
"k c #ffcb30",
"l c #cfcb61",
"z c #ffcb61",
"x c #fffb61",
"c c #9e9a9e",
"v c #bebebe",
"b c #9e9acf",
"n c #9ecb9e",
"m c #9ecbcf",
"M c #cf9a9e",
"N c #ff9a9e",
"B c #cf9acf",
"V c #cfcb9e",
"C c #ffcb9e",
"Z c #fffb9e",
"A c #cfcbcf",
"S c #cffbcf",
"D c #cffbff",
"F c #e7e3e7",
"G c #fffbff",
"H c None",
"HHHHHHHHHHHHHHHHHHHHHHH @HHHHHHHHHHHHHHHHHHHHHHH",
"HHHHHHHHHHHHHHHHHHHHHHHHHc @cHHHHHHHHHHHHHHHHHHH",
"HHHHHHHHHHHHHHHHHHHHHHHHHHHc >cHHHHHHHHHHHHHHHHH",
"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHc 2cHHH@HHHHHHHHHHH",
"cccccccccccccccccccccccccccHHHH cbH@nHHHHHHHHHHH",
"cGGGGGGGGGGGGGGGGGGGGGGGGG@cHHHH 3cGBHH$HHHHHHHH",
"cGGGGGGGGGGGGGGGGGGGGGGGGG+cHHHHH bcGcc>HHHHHHHH",
"cGGGGGGGGGGGGGGGGGGGGGGGGGomHHHHH> cbG>HHHHHHHHH",
"cGA>>ccG1p>A1p1A><cc1BGGGG+cHHHH>D> $nG-HHHHHHHH",
"cGGGGGGGGGGGGGGGGGGGGGGGGGobHHH>DGc$ >cG#HHHHHHH",
"cG1c>AA>c>cc>GccccV<cccnFG+cHH>GSb$ > >cG>HHHHHH",
"cGGGGGGGGGGGGGGGGGGGGGGGGGomH>GSb> HHH >cG$>->HH",
"cGGG<c1cBnAA>bn>BAc<GAGGGG>c>DSb$ HHHH> >>cGGc$H",
"cGGGGGGGGGGGGGGGGGGGGGGGGG4>DSb> HHHHHH ->cGGGc:",
"cGAcnpA02p$>2ccpnGGGGGGGG56GDb$ HHHHHHH >$cmcGG ",
"cGGGGGGGGGGGGGGGGGGGGGGG46rwc: cHHHHHHH# >$ccb H",
"cGA>A>cA>AVFA>>cc>BAc0S56rq4= cHHHHHHHHH  >,c HH",
"cGGGGGGGGGGGGGGGGGGGGG45ww64  HHHHHHHHHHH  > HHH",
"cGAp#p1p1p1>>0Dp>cSpn56iq56  HHHHHHHHHHHHH  HHHH",
"cGGGGGGGGGGGGGGGGGGG46rw64  HHHHHHHHHHHHHHHHHHHH",
"cGGGGGAA<c>c2AA>cAG5*wq56  2CCxCzzzzzzkzk HHHHHH",
"cGGGGGGGGGGGGGGGGG46rw46  O:jddddddatay96 HHHHHH",
"cG1cc>>cAmc>cc>cc5*ww76  <+9dhdhdddddyat: HHHHHH",
"cGGGGGGGGGGGGGGG64rw64  p1=9jdfjs8%*6y9y6 HHHHHH",
"cGApS>1pSp:<AcA56rw7%  <1p+9dkdyttst#=ya= HHHHHH",
"cGGGGGGGGGGGG465wq64  p1pGo8fdf9tkf*z6*y6oHHHHHH",
"cGGDA0mcnB>c%7wwi56  p1pGG+adkj6sf+zd6+y; HHHHHH",
"cGGGGGGGGGG64wwGw4  <1pGGG*9kff;t+zs6;+y6 HHHHHH",
"cGGGGGGGGG45ir%7Nr <2pGGGG+0skl6*zdt*4@a7 HHHHHH",
"cGGGGGGGG47qww6 4*p1pGGGGG+9zdfd=**%o+yt6XHHHHHH",
"c>>>=$>=&6wwGe6 O+*@+++++O*0zllfj7;*@dda*OHHHHHH",
"HcccmMc74ww74Nw 9999yay9ya9afkkdfdddtdty6 HHHHHH",
"HHHHHH45irq5 45Cjfkfjkkzjkkflzdhjdddddd99oHHHHHH",
"HHHHH47qwGw6   Zdfddzfkdzkhjkkddfdfdydys6 HHHHHH",
"HHHH47qw65Nw  HFddzfjzlzkzlzzgzflydddday*.HHHHHH",
"HHH47www5 65%HHxffjd8*6*dkkfkkdjt8**69s87 HHHHHH",
"HH%5wwGw*   HHHCgfdttyt*:yzljfgf8dts*:9y;oHHHHHH",
"H%4iw&6Nr  HHHHxfd8tfk*k6*jkhjf8ukf+z6*y* HHHHHH",
"%56ri5 44%HHHHHCdk*dj%jy8+zfjfl*sd*zs7+8=+HHHHHH",
"=6rq44   HHHHHHxgd6t4kd86ofjhdk*t*zs6*+t*oHHHHHH",
"%5476   HHHHHHHCdf;*kd86**lfjkg6*zd86*@9*@HHHHHH",
"H6 4   HHHHHHHHZddi*=**+*9fdzdfs=**%o*9t= HHHHHH",
"HH   %HHHHHHHHHZdfdl***%9klfddddd;**@989* HHHHHH",
"HHHHHHHHHHHHHHHCddfdfdkdkdfjfdfdysy88t98% HHHHHH",
"HHHHHHHHHHHHHHHFsddddhdldfdgdfdyd98y9987;.HHHHHH",
"HHHHHHHHHHHHHHHZy8yyy8y6y8787;6*687;666=* HHHHHH",
"HHHHHHHHHHHHHHH7*766******@o+o@+   o .    HHHHHH"
};

static char *FontA[] = {
"48 48 177 2",
"  	c None",
". 	c #208120811040",
"X 	c #EFBEA2898617",
"o 	c #CF3C82074103",
"O 	c #618530C21040",
"+ 	c #CF3CCF3CCF3C",
"@ 	c #CF3C92485144",
"# 	c #CF3C82075144",
"$ 	c #9658618530C2",
"% 	c #104010401040",
"& 	c #000010400000",
"* 	c #EFBEEFBEEFBE",
"= 	c #DF7D82075144",
"- 	c #30C220810000",
"; 	c #71C6618571C6",
": 	c #EFBEBEFBAEBA",
"> 	c #DF7D92485144",
", 	c #DF7D92486185",
"< 	c #71C641032081",
"1 	c #104000000000",
"2 	c #EFBE92486185",
"3 	c #AEBA71C630C2",
"4 	c #208110401040",
"5 	c #30C2514430C2",
"6 	c #EFBE924871C6",
"7 	c #DF7DA2896185",
"8 	c #514430C21040",
"9 	c #EFBEA2896185",
"0 	c #9E79618530C2",
"q 	c #104010400000",
"w 	c #EFBEA28971C6",
"e 	c #410320811040",
"r 	c #EFBEBEFB9E79",
"t 	c #71C651442081",
"y 	c #104000001040",
"u 	c #BEFB82075144",
"i 	c #30C220811040",
"p 	c #514461855144",
"a 	c #618530C22081",
"s 	c #BEFBCF3CBEFB",
"d 	c #BEFB82078617",
"f 	c #9E7971C630C2",
"g 	c #104020811040",
"h 	c #BEFB71C65144",
"j 	c #410330C22081",
"k 	c #EFBEA2899658",
"l 	c #DF7DA2895144",
"z 	c #410330C20000",
"x 	c #BEFBAEBABEFB",
"c 	c #5144410330C2",
"v 	c #208110402081",
"b 	c #AEBA92488617",
"n 	c #8617514430C2",
"m 	c #CF3C92486185",
"M 	c #71C641035144",
"N 	c #DF7DA28971C6",
"B 	c #BEFB82074103",
"V 	c #514461856185",
"C 	c #EFBECF3C9E79",
"Z 	c #861751444103",
"A 	c #104020812081",
"S 	c #DF7DA2899658",
"D 	c #618541032081",
"F 	c #000000000000",
"G 	c #CF3CCF3CDF7D",
"H 	c #9E7982078617",
"J 	c #AEBA61854103",
"K 	c #208110400000",
"L 	c #9E7971C64103",
"P 	c #30C230C24103",
"I 	c #DF7DAEBA9658",
"U 	c #BEFBBEFBCF3C",
"Y 	c #618530C230C2",
"T 	c #208100001040",
"R 	c #CF3CA2899E79",
"E 	c #861751442081",
"W 	c #CF3C82076185",
"Q 	c #71C6820771C6",
"! 	c #DF7DA2898617",
"~ 	c #861771C69658",
"^ 	c #71C6514430C2",
"/ 	c #CF3C92484103",
"( 	c #30C220812081",
") 	c #208120812081",
"_ 	c #9E7992489658",
"` 	c #DF7D82076185",
"' 	c #30C210401040",
"] 	c #9E7961854103",
"[ 	c #514441031040",
"{ 	c #BEFBAEBA9E79",
"} 	c #9658514430C2",
"| 	c #AEBA82074103",
" .	c #71C661856185",
"..	c #BEFB71C630C2",
"X.	c #EFBECF3CAEBA",
"o.	c #71C6410330C2",
"O.	c #EFBEAEBA9658",
"+.	c #861751441040",
"@.	c #965851441040",
"#.	c #965882078617",
"$.	c #CF3C71C64103",
"%.	c #BEFB820730C2",
"&.	c #AEBA618530C2",
"*.	c #618582078617",
"=.	c #30C2208130C2",
"-.	c #410351444103",
";.	c #861761851040",
":.	c #CF3CA2898617",
">.	c #BEFB71C64103",
",.	c #CF3C92488617",
"<.	c #BEFB924871C6",
"1.	c #CF3CA2899658",
"2.	c #CF3C92489658",
"3.	c #EFBEAEBA9E79",
"4.	c #965861852081",
"5.	c #BEFB92484103",
"6.	c #AEBA820730C2",
"7.	c #410330C21040",
"8.	c #861741032081",
"9.	c #9E7971C62081",
"0.	c #861792489E79",
"q.	c #BEFBA28971C6",
"w.	c #AEBA71C62081",
"e.	c #BEFB618530C2",
"r.	c #618541031040",
"t.	c #CF3CAEBA9658",
"y.	c #965851442081",
"u.	c #30C230C230C2",
"i.	c #AEBAAEBA9658",
"p.	c #9E7961852081",
"a.	c #861771C68617",
"s.	c #AEBA61852081",
"d.	c #514420811040",
"f.	c #71C651441040",
"g.	c #410310401040",
"h.	c #410320810000",
"j.	c #BEFBA2899658",
"k.	c #BEFB61852081",
"l.	c #8617A2899658",
"z.	c #861761852081",
"x.	c #514451445144",
"c.	c #BEFB92485144",
"v.	c #DF7DCF3CDF7D",
"b.	c #9E7971C61040",
"n.	c #514430C20000",
"m.	c #514441032081",
"M.	c #9E7961851040",
"N.	c #30C241034103",
"B.	c #BEFBAEBA9658",
"V.	c #30C230C21040",
"C.	c #5144514430C2",
"Z.	c #410330C24103",
"A.	c #208130C22081",
"S.	c #AEBAA2899658",
"D.	c #410341034103",
"F.	c #71C630C21040",
"G.	c #71C641031040",
"H.	c #861741031040",
"J.	c #4103410330C2",
"K.	c #DF7DAEBA9E79",
"L.	c #965861851040",
"P.	c #000020810000",
"I.	c #CF3CCF3CBEFB",
"U.	c #618530C25144",
"Y.	c #9E7992484103",
"T.	c #9E7951442081",
"R.	c #514430C230C2",
"E.	c #618551445144",
"W.	c #AEBAA28971C6",
"Q.	c #104010402081",
"!.	c #965882079658",
"~.	c #514441034103",
"^.	c #AEBA82079658",
"/.	c #AEBA92486185",
"(.	c #BEFBA2899E79",
").	c #BEFB92488617",
"_.	c #DF7DAEBAAEBA",
"                                        . X o O                                                 ",
"                                        + @ # $ %                                               ",
"                                      & * = @ # -                                               ",
"                                      ; : > , @ < &                                             ",
"                                    1 * , 2 > 2 3 4                                             ",
"                                    5 * 6 7 6 7 , 8                                             ",
"                                    * : 9 6 9 2 7 0 q                                           ",
"                                  & * w w w w 7 6 @ e                                           ",
"                                  * r 6 w 6 9 6 9 2 t y                                         ",
"                                & * X w w w w w 6 7 u i                                         ",
"                                p : w 6 w 6 9 6 9 2 , a                                         ",
"                                s w w w d w w 9 6 7 , f 4                                       ",
"                              g * 6 9 h j k 9 6 9 2 l = z                                       ",
"                              x : w w c v b w 9 6 7 , 7 n &                                     ",
"                            & * 9 6 m v . M N 6 7 2 , , B e                                     ",
"                            V C w 9 Z g A . S 7 6 7 , > , D F                                   ",
"                          1 G C 9 6 i v . v H 6 , 2 > , > J K                                   ",
"                          g * 7 2 L v . v g P I 2 , , > , @ 8                                   ",
"                          U r 2 7 Y g v g T   R > , > , @ = E %                 F F F F F F F   ",
"                        & * , > W . v g v &   Q ! > , @ > @ u i             F F F F F F F F F F ",
"                        ~ : > , ^ v . v %       I , > = @ = / < q           F F F F F F F F F F ",
"                      1 G : , @ ( g v ) y       _ m ` @ = @ # f '       F F F F F F F F F F F F ",
"                      p * , @ ] . v . v         . X @ = / = o o [       F F F F F F F F F F F F ",
"                      G : @ > j v . v %           { # @ # / # B } g F F F F F F F F F F F F F F ",
"                    g * o = | 4 . v . 1            .7 = o o o o ..e F F F F F F F F F F F F F F ",
"                    x X.# / o.. v g v               O./ # B # B o t y F F F F F F F F F F F F F ",
"                  & * o o o i v . v +.@.+.@.+.@.+.@.#.` o o B $.%.&.i F F F F F F F F F F F F F ",
"                  *.: B o $ v . =.-.+.+.E ;.+.+.E ;.+.:.o B o %.>.%.O & F F F F F F F F F F F F ",
"                1 * @ $.B ,.<.,.:.1.:.1.:.1.:.2.:.1.:.3.B $.%.$.%...4.4 F F F F F F F F F F F F ",
"                g * >.B o B o B o B # 5.# B # B o B o B o B >.%.>.6.3 7.F F F F F F F F F F F F ",
"                U : %.>.%.$.%.$.%.$.B $.B $.B o %.$.%.$.%.$.%.>.....3 8.q F F F F F F F F F F F ",
"              & * 6...f o.t ^ t o.t ^ t o.t ^ t o.t ^ t o.5.>.6...6...9.i F F F F F F F F F F F ",
"              0.q.....8.. v . v F       F F F F F F F F F ! ........w.e.r.y F F F F F F F F F   ",
"            1 * @ 3 ..j ) g v g       F F F F F F F F F F t...6...3 3 w.y.g F F F F F F F F F   ",
"            u.i.w.e.p.v . v . y     F F F F F F F F F F F a.B ..w.e.w.s.9.d.F F F F F F F F F   ",
"            U @ 3 w.< g ) i e F F F F F F F F F F F F F F F ! w.3 w.3 9.s.f.% F F F F F F F F   ",
"          g * s.w.s.i g.h.d.z F F F F F F F F F F F F F F F j.k.w.s.w.s.w.p.- F F F F F F F F   ",
"          l.@ 9.s.z.' 7.d.7.( F F F F F F F F F F F F F F F x.c.3 9.s.9.s.p.O & F F F F F F F   ",
"        1 v.w.s.b.a - d.n.O m.F F F F F F F F F F F F F F F F S w.s.s.s.M.s.+.' F F F F F F F   ",
"        N.B.p.b.p.V.8 7.8 [ D C.Z.A.F F F F F F F F F F F & ) S.3 9.s.M.p.p.p.[ D.A.F F F F F   ",
"        v.&.M.p.+.e n.O O F.G.H.t J.F F F F F F F F F F F K./ o m s.M.s.M.p.L.y.- e m.F F F F   ",
"      P.I.L.p.4.< 7.8 r.G.r.< t c g F F F F F F F F   F   I # B ! M.p.p.p.L.y.L.D 7.8 A.F F F   ",
"      U.Y.@.L.T.t O r.F.G.H.+.R.. 4 F F F F F F F       x.X o >.N T.M.T.L.T.L.y.+.O 8 a F F F   ",
"  g E.W.E ;.y.L.y.r.G.r.< f.c g Q.F F F F F F F F       !.7 # %.! L.p.L.y.L.y.;.E t r.r.j F F F ",
"~.^./.+.+.@.;.@.L.y.r.H.G.D 7.v F F F F F F F F F       (., @ , L.T.L.@.L.y.+.@.+.E f.F.r.% F F ",
").t 8.f.+.+.E ;.y.;.y.L.p.V.v F F F F F F F F F       F _.L.y.L.4.L.y.;.y.+.E +.E f.+.f.E [ F F ",
"D.@.+.+.+.@.+.+.+.@.+.+.+.v F F F F F F F           F F :.T.L.y.L.@.@.@.+.@.+.H.f.H.f.G.f.O F F ",
"F . v g v . v g v . v g v F F F F F F F           F F F F . v g v . v g v . v g v . v g v . F F "};

static char * BrushSplash_xpm[] = {
"48 48 65 1",
" 	c None",
".	c #F7DEA2899E79",
"X	c #F7DE38E34103",
"o	c #A69910400820",
"O	c #0000082028A2",
"+	c #000038E3D75C",
"@	c #000030C2CF3C",
"#	c #000028A2CF3C",
"$	c #082030C2EFBE",
"%	c #EFBE79E74924",
"&	c #AEBACB2BC71B",
"*	c #30C228A21861",
"=	c #000028A2B6DA",
"-	c #10401040BEFB",
";	c #F7DE28A21040",
":	c #A699A2899E79",
">	c #79E741031861",
",	c #000010404924",
"<	c #00002081AEBA",
"1	c #000020819658",
"2	c #F7DEDB6C8E38",
"3	c #208108201861",
"4	c #000018618E38",
"5	c #CF3C10400000",
"6	c #F7DE618538E3",
"7	c #596510400820",
"8	c #082018619E79",
"9	c #E79D38E30000",
"0	c #E79DA2895144",
"q	c #BEFB49240820",
"w	c #0000104079E7",
"e	c #28A200000820",
"r	c #208110404924",
"t	c #0000186171C6",
"y	c #79E710400000",
"u	c #965851445144",
"i	c #186130C24103",
"p	c #0820000028A2",
"a	c #000000000000",
"s	c #000018610820",
"d	c #DF7D38E31040",
"f	c #000008200820",
"g	c #F7DE79E70820",
"h	c #FFFF69A61040",
"j	c #CF3C51441040",
"k	c #FFFFEBADF7DE",
"l	c #D75CE38DEFBE",
"z	c #492459655144",
"x	c #410338E34103",
"c	c #EFBEAAAA30C2",
"v	c #EFBEEBADB6DA",
"b	c #EFBE59651040",
"n	c #514441034924",
"m	c #FFFFFBEEFFFF",
"M	c #F7DE92481040",
"N	c #DF7D69A60820",
"B	c #FFFF61850000",
"V	c #FFFFF3CEFFFF",
"C	c #EFBECB2B5144",
"Z	c #FFFFEBADD75C",
"A	c #DF7D28A20000",
"S	c #F7DE61850000",
"D	c #FFFF51440000",
"F	c #FFFF59650820",
"G	c #514451445144",
"                                                ",
" ..XoO+@+#@@@#@@$++++++++$+@@@@@@+++@++++$$$$#  ",
" %&.X*=--=@@@@@@+$@$$$$$$$$+@@@@#@$@$$$$$$++++  ",
" ;:&X>,#=<<1<####@@@@@$@$++$=<#=#@=@@@@@@+++$$  ",
" X%2.X34<<<<<==<#<#<@##@@@+@<<<<<<<<<=#=#+#+@@  ",
" 56%.6o3<111<<=#<<<<######@=<<<<-<<<#<###@-+<@  ",
" ;X%&.X781<884<111<1<1<1<##<<18<<<<<<<<<<=-=<#  ",
" 5960&%qO414448w811=1<1<1<<<1<<1<1<8<<<<<<-=<#  ",
" o5X6..Xe,w44rt44414111<1<111w1w114111<1<<-<<#  ",
" oq;;0.%53tttttt44t4444411w44444t44141111=-=1#  ",
" 7y5XX..X33,,w,t4ttrttt4t144444w8118<1<<<=8=<#  ",
" e7>9X0&6ye,,,,,rt,tttttt4448<18<<<<<#<#<#<=<#  ",
" e3y;Xu:&Xe,O,i,r,w,w,ri,rww88ww<11=8=-##11=8<  ",
" ee7o5X.:Xe3OOii,3*prii,rr,tw41w811111111w41w4  ",
" eee7o;X..uarpaO3arrsO*,rr,,rww4ww8w8414884148  ",
" e3eey;du>uipfOpO,3r,3ghjes,wrtrwt4t4t44wrrwrr  ",
" aeee7ouu&klapaOpef,3ullgye,,t,tww,wtwtw4ttttw  ",
" ffeee*u:lzxifpaOppaeckvgb3pO,,,,,,,rtr4rafffp  ",
" faa3s::ni&mlaaaafpO3M.lgh7OOOOOfffsfOOOOOffOp  ",
" eaa3*iOu&lllnaeafaOeNMvBNeOpafpappaOafpfpOp,p  ",
" aaarsai&&&kl&aaaeseOeBVg7efaOafaspss*u7OOp,fO  ",
" saaa*xnn&:lllxaafaOaaoVd7eafapOppperlmj3OappO  ",
" aeaas3xxu&&ll&aafspaa*Cjaafsaaaa3aOjmZgafppfO  ",
" aaaaf3*iu:&lllnaeaaOffCqa3aaaeafafaq&M9aafppa  ",
" faeeee3ix:&&Vm:ey7y7e72cye77773ea3eu.j7feeaap  ",
" e7yyyy7**n::lll*5j5jAA.cNoojd5A555;.Xy5oyyy77  ",
" AA9A9bq**nx:&lluoSgZN&C6cqyoNhDSBBN:quNb9d9jj  ",
" SFBhBFFj*i3:&lVl*;dFD.cM6%020vZZb0v%obS;FbFFB  ",
" SDgDSD;S***u::ll:yj;SMM%%Mc0CcZmCkCMk>ASBSgBD  ",
" FSSFdNc%ufir::lk&*>NBBBM%Mccc0000CCC2Z:o;9bS;  ",
" Bq2Bu%Zdyy3ii&&&neeGNB%%%cM0c0cC:CvC.Zm%ou0uN  ",
" DNcv:Z5oo777ixnae3>**hggh0cc.00cC2:2CkZv:vZ0q  ",
" Sd>v&Z;o7o7ssaf*3xr>iuM0.MCcVkC2CC20ZZZ2Z20yd  ",
" bB0clh7e5oy77*naxs>3n3SM6cc2Zu3C.CC&.vm.yoyd;  ",
" g;0C2ue>7yye6e*33*eu>*>6%0ck2q3.CCC&v2Zq55dFg  ",
" bSj%Z>yyo5yseue*fypoN**c%MCuo*X0C2:2ZZcy59qjS  ",
" bXhXc.gF3ooesxa*i337q3*>0ccM3>.2CCv&2gjy55jAd  ",
" hM;ju:Zv0>yy7Shhne>ie>yxM6:0C.2..2CZNq555AbDB  ",
" bD66:cccC7ygh:VV>>e7p7uiuC0ZNqC.mvN;A9ou99FFh  ",
" hDhSFN;F0&v2C.CFF*i**su>*0kF5o5juy5yoyA5;SBBB  ",
" bgFFhD%bSMM.ZcFBg.Z0k00kZcN5yoooydA;jAjhFBhhg  ",
" 9FDBFggNNN;d%%bS96%2%S;j5S55oy5jd5dN9SF;Bhggg  ",
" ;;NFBh;DF;BqdFS;DdA5A5oA5ooqq;N9BBhbhBB66gMMM  ",
" dbdDdDhSSSNb9;FgSd9q;uqAj;db;S9BFFBhDSSM6McMM  ",
" AA;9F;DBDSBB;SBBFFF9FDBFD99FhBSSSh66%%0ccccc.  ",
" b9D9ABAD9BDB9BFFBBFBFBFBBFBShShgF%%6%%MM:cc00  ",
"                                                ",
"                                                "};

static char *SuitcaseIcons[] = {
"32 32 252 2",
"   c #120b0d",
".  c #1d120f",
"X  c #17120d",
"o  c #191412",
"O  c #1d1214",
"+  c #1d1513",
"@  c #1c1813",
"#  c #1b1c18",
"$  c #090305",
"%  c #000926",
"&  c #001334",
"*  c #14293b",
"=  c #221513",
"-  c #231c16",
";  c #211f1c",
":  c #2a251e",
">  c #2b2322",
",  c #302623",
"<  c #32262d",
"1  c #342b2b",
"2  c #352a29",
"3  c #3e2f32",
"4  c #322c30",
"5  c #3c312b",
"6  c #35312a",
"7  c #3e3131",
"8  c #3f3036",
"9  c #3e3139",
"0  c #323e3c",
"q  c #000c4c",
"w  c #000e53",
"e  c #061c40",
"r  c #001458",
"t  c #18045e",
"y  c #001563",
"u  c #001c75",
"i  c #011f7d",
"p  c #1b3940",
"a  c #132756",
"s  c #012773",
"d  c #0b306e",
"f  c #122969",
"g  c #122973",
"h  c #16337f",
"j  c #253543",
"k  c #37505a",
"l  c #334a59",
"z  c #365269",
"x  c #42332e",
"c  c #4c392f",
"v  c #433334",
"b  c #473738",
"n  c #4e3439",
"m  c #4d3b36",
"M  c #4e3c39",
"N  c #403a38",
"B  c #543d35",
"V  c #533b39",
"C  c #583d38",
"Z  c #5b3d36",
"A  c #533f42",
"S  c #4d413b",
"D  c #53423d",
"F  c #5f4239",
"G  c #5a4137",
"H  c #424243",
"J  c #564740",
"K  c #5b4742",
"L  c #5e5851",
"P  c #404968",
"I  c #4e5d73",
"U  c #4a646d",
"Y  c #4d6a7b",
"T  c #634846",
"R  c #674a48",
"E  c #6b4f51",
"W  c #734c47",
"Q  c #754e45",
"!  c #744e49",
"~  c #745147",
"^  c #765149",
"/  c #78544d",
"(  c #765b5a",
")  c #7e5d56",
"_  c #7d5b54",
"`  c #7f5c58",
"'  c #765553",
"]  c #6d675f",
"[  c #76635a",
"{  c #7d6159",
"}  c #6e6769",
"|  c #6f6867",
" . c #6c6563",
".. c #716964",
"X. c #786660",
"o. c #786966",
"O. c #76706b",
"+. c #787975",
"@. c #022f91",
"#. c #173d8d",
"$. c #1f3891",
"%. c #203986",
"&. c #1646a0",
"*. c #2b4897",
"=. c #2d519c",
"-. c #304797",
";. c #3e509f",
":. c #234fa2",
">. c #354fa7",
",. c #3358bc",
"<. c #3d60a6",
"1. c #3a6bbb",
"2. c #506b80",
"3. c #58639a",
"4. c #547884",
"5. c #587a9f",
"6. c #4a7684",
"7. c #4362ad",
"8. c #4e67a9",
"9. c #496bb6",
"0. c #5e6fb0",
"q. c #5678a8",
"w. c #5d74b1",
"e. c #5777b6",
"r. c #777d84",
"t. c #616dae",
"y. c #606eb2",
"u. c #607ea2",
"i. c #6978ab",
"p. c #7071a7",
"a. c #5876c2",
"s. c #6478c7",
"d. c #7c8078",
"f. c #598298",
"g. c #5f87a8",
"h. c #618089",
"j. c #69889e",
"k. c #698995",
"l. c #7e8583",
"z. c #758e9c",
"x. c #6887a6",
"c. c #6995ae",
"v. c #788ea3",
"b. c #7291a6",
"n. c #7783ce",
"m. c #7b86d3",
"M. c #7a9dfb",
"N. c #7389e5",
"B. c #815b5a",
"V. c #805f57",
"C. c #826058",
"Z. c #81625a",
"A. c #87655d",
"S. c #84655c",
"D. c #89675f",
"F. c #88695f",
"G. c #926d5f",
"H. c #876764",
"J. c #886760",
"K. c #8c6761",
"L. c #8d6a61",
"P. c #8a6a61",
"I. c #82746d",
"U. c #847679",
"Y. c #897973",
"T. c #916762",
"R. c #946d60",
"E. c #946b6a",
"W. c #977768",
"Q. c #937b72",
"!. c #9a7d75",
"~. c #8077ab",
"^. c #9b7ab1",
"/. c #8d857e",
"(. c #9d8179",
"). c #ac8972",
"_. c #efa478",
"`. c #8c8c8e",
"'. c #89848a",
"]. c #868991",
"[. c #8c8c92",
"{. c #898694",
"}. c #8e948e",
"|. c #958c8d",
" X c #968c90",
".X c #949493",
"XX c #94919a",
"oX c #9a9f97",
"OX c #869497",
"+X c #838abb",
"@X c #8b9ca8",
"#X c #9a9ba4",
"$X c #9ca7ae",
"%X c #a38887",
"&X c #a49189",
"*X c #a29c95",
"=X c #aa9e9a",
"-X c #b38784",
";X c #a19fa6",
":X c #bba08e",
">X c #a8a3a5",
",X c #a2a8b4",
"<X c #bba4a0",
"1X c #bebebe",
"2X c Gray75",
"3X c Gray74",
"4X c #b7b8b7",
"5X c #8990c9",
"6X c #8690d7",
"7X c #a69fdd",
"8X c #a8accd",
"9X c #a1a9d8",
"0X c #a0b3c9",
"qX c #b2b9c6",
"wX c #b6baca",
"eX c #b8bbc5",
"rX c #b5bcd1",
"tX c #bfc1c2",
"yX c #b9c1db",
"uX c #c1978d",
"iX c #c99f94",
"pX c #c9b89e",
"aX c #d6a994",
"sX c #c0beb8",
"dX c #e0a784",
"fX c #e0bda5",
"gX c #d0c1bf",
"hX c Gray76",
"jX c #c2c3c3",
"kX c #c0c1c1",
"lX c #c5c6c6",
"zX c #cfcac4",
"xX c #cdcece",
"cX c #c9cccc",
"vX c #c7c8c7",
"bX c #ced1d1",
"nX c #d4c7c9",
"mX c #d4cac6",
"MX c #d0cfcf",
"NX c #d4cac9",
"BX c #dccecd",
"VX c #dacccc",
"CX c #d0c6c5",
"ZX c #d0cfd0",
"AX c #d6d8d9",
"SX c #e3dee3",
"DX c #e6e1e7",
"FX c #eee7e9",
"GX c #eee9e8",
"HX c #eae4e8",
"JX c #f0e9eb",
"KX c None",
"KXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKX",
"KXKXKXKXKXKXKXKXKXKXKXvXDXFXGXGXFXFXGXGXJXsXlXKXKXKXKXKXKXKXKXKX",
"KXKXKXKXKXKXKXKXKXKXbXsXb : , , : > : : 1 - `.KXKXKXKXKXKXKXKXKX",
"KXKXKXKXCXO. ...} L >XU.$ < , , < , , > m A @ O. .] | | ] } .. .",
"KXKXKXzXE.R T T E / <X+.o P.( ( ( ( ( ' H.D o T.B.E T T ' E.x X ",
"KXKXBXQ.Q.S.X.X.S.Q.%XQ.[ P.[ X.) o.[ [ I.F.[ (.W.I.[ { Y.m ; o ",
"KXDXmXgXnXVXBXBXBXnXCXNXBXBXBXBXBXBXBXBXVXBXBXNXmXVXBXSX|.  1 o ",
"KXSX^ W W ~ ! ! ~ W ~ ~ W ~ ! ! ~ W ! ! W ~ ! ! ~ W ^ / < > 1 @ ",
"KXDXC.) Z.Z.Z.V.) ) ) ) ) ) ) ) ) ) ) ) ) ) C.Z.Z.Z.Z.A.v : 6 . ",
"KXDXC.) B.Z._ V.G.G.G.G.G.R.R.R.R.T.R.R.T.W.A._ Z.B.Z.A.v , 5 + ",
"KXDXC.) C.Z./ mXyXqXrXrXwXwXqXqXwXwXwXqXqXcX^.c F.{ Z.A.9 , 6 @ ",
"KXDXC.) C.Z.^ zX@.s i u u y y y r w w q q y t B L.{ Z.A.7 < x O ",
"KXDXC.) B.Z.! mX&.p.~.*.$.%.-.7.h g g f f d % F P.B.Z.A.v , 7 + ",
"KXDXC.) Z.Z.~ mX,.,.7.>.t.y.-.=.=.=.#.w.*.#.& F P.Z.Z.A.v , x @ ",
"KXDXC.) B.Z.Q CXN.6Xn.9.5X9X7.9.9.0.>.8X;.:.e G L.` Z.A.7 1 v O ",
"KXDXC.) B.Z.Q NXM.6X7Xm.i.a.s.+Xe.w.8.e.7.1.a Z L.` Z.A.9 1 v @ ",
"KXDXC.) Z.Z.^ mXi.3.3.P : I 0.s.a.e.7.7.<.9.a Z P.Z.Z.A.7 2 b + ",
"KXDXC.) B.Z.! CXz l k z I U Y u.g.u.5.f.6.q.p Z P.B.Z.A.7 2 b + ",
"KXDXC.) C.Z.^ mXc.x.b.x.v.b.j.k.h.2.Y 4.4.6.* C L.{ Z.A.9 5 m - ",
"KXDXC.) C.Z.Q NX0X,X,X$XoX;XXX#XoX].'.OXz.j.j C L.{ Z.A.7 5 m = ",
"KXDXC.) B.Z.W nX@Xr.[..X|.`.XX.X}.`.|.[.].@X0 V L.B.Z.A.8 6 S - ",
"KXDXC.) Z.Z.^ mXr.| d.d.U.I./.*X*X.XoXoX.X>XH V L.Z.Z.A.8 5 S - ",
"KXDXC.) B.Z.! nX{.+.U.U.Y.!.%X%X&X-X=X=X:XpXS m L.` Z.A.7 7 D = ",
"KXDXC.) B.Z.! BX`.Q.W.!.W.).uXiXaX_.dXaXaXfXG M L.` Z.A.9 7 D - ",
"KXDXC.) Z.Z._  XK S G J S C D B D S B D M K # V P.Z.Z.A.3 5 K - ",
"KXDXC.) B.Z.B.C b n n M n M m n M n n m n M V ' A.B.Z.A.3 7 J = ",
"KXDXC.) Z.Z.Z.D.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.A.Z.C.Z.A.9 v x H ",
"KXJXK.A.D.J.D.D.J.A.D.A.D.J.A.D.J.A.D.A.D.J.D.D.J.D.K.L.v v N >X",
"KX#X. X O . o = . O = o O . o = . O = o O . o = . O = @   4 KXKX",
"KX`.+.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.r.4XKXKX",
"KXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKX",
"KXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKX"
};

static char *SuitcaseIconsOpen[] = {
"32 32 256 2",
"   c Gray0",
".  c #000100",
"X  c #000101",
"o  c #020502",
"O  c #09030f",
"+  c #060a09",
"@  c #050512",
"#  c #060a10",
"$  c #080510",
"%  c #090b12",
"&  c #1c1714",
"*  c #000c39",
"=  c #0d1e2b",
"-  c #0b1633",
";  c #1e1b25",
":  c #151f3c",
">  c #1e2c19",
",  c #1e212e",
"<  c #1c2a37",
"1  c #20150f",
"2  c #221614",
"3  c #231b19",
"4  c #221b14",
"5  c #291d26",
"6  c #2b231d",
"7  c #262119",
"8  c #262322",
"9  c #25222e",
"0  c #2c2623",
"q  c #2d2328",
"w  c #252634",
"e  c #252e35",
"r  c #372325",
"t  c #3b2526",
"y  c #3e2728",
"u  c #362b29",
"i  c #3b2c31",
"p  c #342936",
"a  c #3a3338",
"s  c #001351",
"d  c #001d5a",
"f  c #111e4f",
"g  c #001a67",
"h  c #183449",
"j  c #03236b",
"k  c #062876",
"l  c #0c3072",
"z  c #132d74",
"x  c #19367e",
"c  c #3d2d40",
"v  c #373543",
"b  c #263d4b",
"n  c #213664",
"m  c #243972",
"M  c #29424b",
"N  c #2c4253",
"B  c #3d414b",
"V  c #394645",
"C  c #344958",
"Z  c #284a7c",
"A  c #442d2c",
"S  c #412d27",
"D  c #452d32",
"F  c #45312c",
"G  c #423738",
"H  c #483737",
"J  c #513a3a",
"K  c #443c43",
"L  c #453c4a",
"P  c #4d413a",
"I  c #53443e",
"U  c #46484b",
"Y  c #4c4d5c",
"T  c #464758",
"R  c #564343",
"E  c #5a4b4a",
"W  c #594747",
"Q  c #554653",
"!  c #574a52",
"~  c #54475a",
"^  c #5d544b",
"/  c #5d5147",
"(  c #5b5655",
")  c #5a5954",
"_  c #5e5958",
"`  c #5b5959",
"'  c #585553",
"]  c #474b67",
"[  c #4e5563",
"{  c #5c4961",
"}  c #535163",
"|  c #585968",
" . c #5c5970",
".. c #42647d",
"X. c #654d4c",
"o. c #64544b",
"O. c #615544",
"+. c #6b5452",
"@. c #6d5b53",
"#. c #645d58",
"$. c #744f45",
"%. c #77544c",
"&. c #78594f",
"*. c #725b51",
"=. c #735c5b",
"-. c #7d5c52",
";. c #7b5d59",
":. c #785f60",
">. c #6a645e",
",. c #7c625b",
"<. c #666163",
"1. c #7c6b61",
"2. c #766f69",
"3. c #796e7f",
"4. c #7a706c",
"5. c #797777",
"6. c #122e80",
"7. c #183a86",
"8. c #082983",
"9. c #213b8e",
"0. c #1c4a9d",
"q. c #1649b0",
"w. c #28448d",
"e. c #274997",
"r. c #344b95",
"t. c #3658a9",
"y. c #3f5dbe",
"u. c #3b639e",
"i. c #3a67aa",
"p. c #3d64b7",
"a. c #46599d",
"s. c #436f8d",
"d. c #45669a",
"f. c #54799f",
"g. c #4371ac",
"h. c #5767a6",
"j. c #5d6fb1",
"k. c #547fa3",
"l. c #5475b5",
"z. c #646d8f",
"x. c #65699b",
"c. c #757e85",
"v. c #686ca5",
"b. c #6870a8",
"n. c #6476b7",
"m. c #7e7cad",
"M. c #786bb4",
"N. c #4173c5",
"B. c #5877c5",
"V. c #637ec4",
"C. c #52888f",
"Z. c #58879c",
"A. c #5681a4",
"S. c #5593a1",
"D. c #6a8089",
"F. c #618b9e",
"G. c #749095",
"H. c #638ba7",
"J. c #6b86b8",
"K. c #6a92a7",
"L. c #6183d7",
"P. c #7f88c8",
"I. c #7487c6",
"U. c #7181db",
"Y. c #805d4f",
"T. c #825d52",
"R. c #836055",
"E. c #85655c",
"W. c #836362",
"Q. c #846b66",
"!. c #8b6273",
"~. c #8c7773",
"^. c #a7765d",
"/. c #a67e68",
"(. c #80538d",
"). c #887b86",
"_. c #87837e",
"`. c #9c867c",
"'. c #a38176",
"]. c #8b868c",
"[. c #8c9799",
"{. c #9a8888",
"}. c #998a95",
"|. c #998b99",
" X c #938698",
".X c #91928b",
"XX c #9a969a",
"oX c #8f9faa",
"OX c #938bae",
"+X c #909da4",
"@X c #94a19f",
"#X c #93a8ae",
"$X c #a48b8d",
"%X c #a99a99",
"&X c #b19499",
"*X c #b19996",
"=X c #b19d92",
"-X c #b19c99",
";X c #a8a090",
":X c #b9a99e",
">X c #baa698",
",X c #bfb59c",
"<X c #ada6a7",
"1X c #aea9a3",
"2X c #aea4aa",
"3X c #b2acac",
"4X c #b9aaa4",
"5X c #bfa4a2",
"6X c #bebebe",
"7X c Gray75",
"8X c Gray74",
"9X c #bab9ba",
"0X c #b7b5b4",
"qX c #848ed8",
"wX c #8491c1",
"eX c #9399d3",
"rX c #8998e3",
"tX c #abb0de",
"yX c #a5a4e2",
"uX c #b3b0e1",
"iX c #bdc0c0",
"pX c #c5b19d",
"aX c #c6aba9",
"sX c #c5aea6",
"dX c #c4b1a3",
"fX c #c5b3a9",
"gX c #c3bbba",
"hX c #d8bebc",
"jX c #d7bbb9",
"kX c #c0bfc0",
"lX c #c2bbd0",
"zX c #c5bbe3",
"xX c #dcc1bf",
"cX c #e0c3be",
"vX c Gray76",
"bX c #c3c3c3",
"nX c #c0c1c1",
"mX c #c5c5c6",
"MX c #cccdcd",
"NX c Gray78",
"BX c #d3ccc9",
"VX c #d9cfc9",
"CX c #d4d3ce",
"ZX c #d5d5d6",
"AX c #cdc6ef",
"SX c #d8cefb",
"DX c #d6d1f0",
"FX c #e7d9db",
"GX c #e5dfe8",
"HX c #eee7e8",
"JX c #eee9e8",
"KX c #e7e8e2",
"LX c #f0e9eb",
"PX c #f2f1eb",
"IX c #fffffa",
"UX c None",
"UXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUX",
"UXUXUXUXUXUXUXUXUXUXUX3XFXHXJXJXHXHXJXJXLXgXmXUXUXUXUXUXUXUXUXUX",
"UXUXUXUXUXUXUXUXUXUXmX3XH 6 0 0 6 q 6 6 i 3 ].UXUXUXUXUXUXUXUXUX",
"UXUXUXUXgX0X].#.( E %X4.  3 2 2 2 1 2 & S D o >._ ^ _ _ ) <.>.XX",
"UXUXUXZXVXfXaXaXaX5XFX0X~.cXhXhXhXhXhXjXxX%X5.jXaXaXaXaXaX`.H u ",
"UXUXUXKXdX2.) ` ) ) ' ) _ ) ) ( ' ) ' ) ` _ #.` ) ` ' ' 4.VX0 7 ",
"UXUXUXJXO.    X % # O # $ $ # O # # O # $ $ # O # # O #   3XG 8 ",
"UXUXUXPX*.  o B Y T T T T T T Y T T T T T T ] | } | | | w 1XG 8 ",
"UXUXUXPX@.  . v  X X}.}.}.}.|.|.|.|.|.|.|.|.).T T T Y } 5 <XH 7 ",
"UXUXUXPX@.  . L DXh.j.b.v.v.x.x.x.x.x.x.x.b.] K :.Y Y [ ; <XH 8 ",
"UXUXUXPX*.    U tX7.w.k 8.j k z g d s s s d * 3.zX .U } , 1XI & ",
"UXUXUXPX+.  . K uXh.m.r.e.w.r.a.7.x 6.x z 7.f * j @ ~ } ; 2XR & ",
"UXUXUXPX*.    K AXy.p.t.wXeXt.t.i.t.e.wXr.0.h - l : 2XB 9 1XJ & ",
"UXUXUXPX*.    K SXqXeXB.I.P.g.j.l.n.h.eXd.t.n - z - [ p w 1XI & ",
"UXUXUXPX+.  . K SXrXrXI.z.V.U.wXl.l.h.g.p.N.Z : Z = b v 9 2XI & ",
"UXUXUXPX*.    U lXN C h > C a.l.l.l.g.i.u.i.m V Z.e M a w 1XI & ",
"UXUXUXIX=.    L AXs.f.f.K.K.F.K.K.H.Z.F.C.S.C N A.< M c 9 <XR & ",
"mX8X5.>.D 3 & i <.v U V L U B K V a a a a V e i U p M v w <XR & ",
"ZX{.$.%.;.E.E.R.&.-.T.T.-.Y.T.T.-.T.T.T.T.T.R.R.R.E.7 9 w 1XW 4 ",
"BX*.$.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.&.R.r % ; 2XE 2 ",
"BX$X*X*X&X=X*X*X=X&X*X*X&X=X*X*X=X&X*X*X&X=X*X*X>X1.q 8 , 1XE 4 ",
"BX-X4X4X4X:X:XdXpXdXdXdXdXdXdXdXdXfXdXdX4X:X4X4XfX1.7 i X 3XE 4 ",
"NX`.*.,.,.E.).T ~ ~ ~ ! Q Q ! Q ! ! Q Q 2.!.;.,.E.W.p G   3Xo.2 ",
"MXNX;.,.1.E.OXq.e.e.e.7.9.w.x k k j j g d.(.=.Q.W.W.i a + 0Xo.4 ",
"UXGXQ.*.,.&.!.!.rXyXqXa.h.L.B.P.n.J.I.t.0.M.J ,.,.Q.W F 2 5.X.0 ",
"UXZX%X/ +.+.O.%XJ.k.f...z.J.H.J.H.k.A.Z.A.#Xp X.@.=.W 6 i X u i ",
"UXUXCX@.o.X./ *.9X#XoX+X#X@X[.[.].c.G.G.D.G. .r +.#.o.5 i + 0 XX",
"UXUXNX4.P W / R _.XX).{.`.`.}.$X$X$X%X%X>X,XUXc I ^ X.F q 5 3XUX",
"UXUXZX3XJ R R J =.).:.Q.W.R.E.!.~.E.^./.'.'.;X{ J R W P 0 u UXUX",
"UXUXUXCXH y A A S t t t y y t t r r r r r r r S A A A F 4 2 UXUX",
"UXUXUXMX.X' _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ #.U XXUXUX",
"UXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUX"
};

static char * bullet_hole_xpm[] = {
"48 48 63 1",
" 	c None",
".	c #CF3CCB2BCF3C",
"X	c #EFBEEBADEFBE",
"o	c #D75CD34CD75C",
"O	c #514451445144",
"+	c #9E799A699E79",
"@	c #FFFFFBEEFFFF",
"#	c #E79DE38DE79D",
"$	c #082008200820",
"%	c #965892489658",
"&	c #A699A289A699",
"*	c #BEFBBAEABEFB",
"=	c #410341034103",
"-	c #861782078617",
";	c #8E388A288E38",
":	c #DF7DDB6CDF7D",
">	c #F7DEF3CEF7DE",
",	c #208120812081",
"<	c #000000000000",
"1	c #28A228A228A2",
"2	c #B6DAB2CAB6DA",
"3	c #30C230C230C2",
"4	c #596559655965",
"5	c #96589A699E79",
"6	c #71C671C671C6",
"7	c #69A669A669A6",
"8	c #618561856185",
"9	c #30C228A228A2",
"0	c #DF7DD34CDF7D",
"q	c #BEFBB2CABEFB",
"w	c #492449244924",
"e	c #104010401040",
"r	c #104010400820",
"t	c #8E3892489658",
"y	c #AEBAB2CAAEBA",
"u	c #9E7992489E79",
"i	c #186118611861",
"p	c #86178A288617",
"a	c #79E779E779E7",
"s	c #596559655144",
"d	c #C71BC30BC71B",
"f	c #F7DEFBEEFFFF",
"g	c #AEBAA289A699",
"h	c #208128A22081",
"j	c #E79DEBADE79D",
"k	c #28A230C230C2",
"l	c #38E338E338E3",
"z	c #FFFFF3CEF7DE",
"x	c #9E7992489658",
"c	c #79E771C671C6",
"v	c #EFBEE38DE79D",
"b	c #BEFBC30BC71B",
"n	c #A699A2899E79",
"m	c #C71BCB2BCF3C",
"M	c #492451445144",
"N	c #861779E78617",
"B	c #CF3CD34CCF3C",
"V	c #AEBAAAAAB6DA",
"C	c #A699A289AEBA",
"Z	c #D75CCB2BCF3C",
"A	c #F7DEF3CEEFBE",
"S	c #79E782078617",
"D	c #596551445144",
"                                                ",
"                .X                              ",
"                XoO+                            ",
"                @#O$%              &X %         ",
"               *@#%=$-            o@o$;         ",
"               :>:o%,<O          X@X%1          ",
"               XX: 2-3$,O4- +  5:@>>&=          ",
"               >:;-67-88=9,11 @@@#.0-=          ",
"               @qO4w1,13er$$,7ty u&.O3          ",
"              &@4e,,ie<<<<<<<<e4;p% =1          ",
"              o2=,r<<<<<<<<<<<<<=Oa%ew          ",
"        +5   o*,<<<<<<<<<<<<<<<<<,=7i8          ",
"        >+ws-21<<<<<<<<<<<<<<<<<<<e933+     do& ",
"       :@d%;8e<<<<<<<<<<<<<<<<<<<<<eO&#XXX@@@d; ",
"  X>:oo@* +8$<<<<<<<<<<<<<<<<<<<<<<<w5o>>f>Xg=  ",
"  o@@@@@2&6e<<<<<<<<<<<<<<<<<<<<<<<<h6dX#0Xjkw  ",
"  .@.#:d&-1<<<<<<<<<<<<<<<<<<<<<<<<<$Od>#.:%<%  ",
"   @..2&-l$<<<<<<<<<<<<<<<<<<<<<<<<<<l.z#.*l3   ",
"   ##2%6wi<<<<<<<<<<<<<<<<<<<<<<<<<<<hd>X*x$6   ",
"   .@+;63r<<<<<<<<<<<<<<<<<<<<<<<<<<<<6>Xd6i    ",
"    X*uck$<<<<<<<<<<<<<<<<<<<<<<<<<<<<3v#:lO    ",
"    b>n6l$<<<<<<<<<<<<<<<<<<<<<<<<<<<<,0:%<     ",
"     X*al$<<<<<<<<<<<<<<<<<<<<<<<<<<<<<m#13     ",
"     d>aM$<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*;$%     ",
"     2@26<<<<<<<<<<<<<<<<<<<<<<<<<<<<<eN$8      ",
"     X>&4$<<<<<<<<<<<<<<<<<<<<<<<<<<<<elO       ",
"    :@.;=e<<<<<<<<<<<<<<<<<<<<<<<<<<<<,ww       ",
"   *@X*73,<<<<<<<<<<<<<<<<<<<<<<<<<<<<11$       ",
"   :fo%7=i<<<<<<<<<<<<<<<<<<<<<<<<<<<<=a<7      ",
"   X>*uaw,<<<<<<<<<<<<<<<<<<<<<<<<<<<r :e=      ",
"   @>2awl,,<<<<<<<<<<<<<<<<<<<<<<<<<<8:Ba1      ",
"  .XV3e$ekw$<<<<<<<<<<<<<<<<<<<<<<<<1+>b11      ",
"  #d1eO;  6-r<<<<<<<<<<<<<<<<<<<<<<$7X>&l1      ",
"  X4,tC   ;>2$<<<<<<<<<<<<<<<<<<<<<=#@#&3=      ",
"  d,+      d@7h<<<<<<<<<<<<<<<<<<$wd@zoq41      ",
"  6-       o@&81e$<<<<<<<<<<<<<145:@>#.Zae6     ",
"           d>#x=1e<<<<<<<<<<<ia2#0A>#:ZZ2,=     ",
"           *XA*-==,i$<<<<<$l6*X@X0X#o.m..4<+    ",
"            X>d%784886M8-a% C.@@XX@>voZ:2ae8    ",
"           &#@dt;-SNux-&&6=3O2X@ --dXvZ %Oi=    ",
"           &d@0&+%;NDi<<<11$$6o*<<3    &x=$1    ",
"            q@v* &g8<lO-    8O:r<6              ",
"             j@o*2;kO        %6<8               ",
"             +X>Bd8i%          ;                ",
"              yXz.8i                            ",
"               gb@nr                            ",
"                ;a8<%                           ",
"                  &7-                           "};

/*******************************************************************************

			       public code
  
*******************************************************************************/

void
init_pixmaps (void)
/*
 *  Initialize builtin pixmaps.
 *
 *  No return value.
 *
 *  Side effects:
 *	global pixmap array 'p_array' is allocated and filled with all
 *	available pixmaps
 */
{
   char **pmap[] = {SuitcaseIconsOpen, SuitcaseIcons, bullet_hole_xpm,
		    BrushSplash_xpm, FontA, hammer, ColorPalette_xpm,
		    Gear_xpm, KeyPress, FileManager_xpm, disk_cap_up_xpm,
		    help_xpm, latex_xpm, folder_cap_up_xpm, undo_cap_up_xpm};
   unsigned n;
   
   p_array = Calloc (P_LAST, sizeof (pixmap_t));

   for (n = 0; n < P_LAST; n++)
   {
      p_array [n].pixmap = gdk_pixmap_create_from_xpm_d (main_window->window,
							 &p_array [n].mask,
							 NULL, pmap [n]);
      gdk_pixmap_ref (p_array [n].pixmap);
      gdk_bitmap_ref (p_array [n].mask);
   }
}

bool_t
write_bullethole (FILE *file)
/*
 *  Write contents of XPM 'bullet_hole_xpm' to stream 'FILE'.
 *
 *  Return value:
 *	TRUE on success
 */
{
   if (!file)
      return FALSE;
   else
   {
      unsigned n;

      fputs ("/* XPM */\nstatic char *Tile[] = {\n", file);
      for (n = 0; n < sizeof (bullet_hole_xpm) / sizeof (*bullet_hole_xpm); n++)
	 fprintf (file, "\"%s\",\n", bullet_hole_xpm [n]);
      fputs ("};\n", file);
      fclose (file);
      return TRUE;
   }
}
