.\" t
.\" @(#)WinList.1	2/2/98
.TH WinList 0.5 "Feb 2nd, 1998"
.UC
.SH NAME
WinList \- the AfterStep window list module
.SH SYNOPSIS
WinList is spawned by AfterStep, so no command line invocation will work.

.SH DESCRIPTION
The WinList module provides a widow list made up of buttons, each
corresponding to a window that AfterStep is managing.  Clicking on the buttons
with any of the three mouse buttons will either do a default action or
can be user configured.  Like the other modules, WinList only works
when AfterStep is used as the window manager.

.SH INITIALIZATION
During initialization, \fIWinList\fP will scan the
~/GNUstep/Library/AfterStep/winlist file to find the options that pertain to it.
These options are discussed in a later section.

.SH INVOCATION
WinList can be invoked by AfterStep during initialization by inserting the
line 'Module WinList' in the ~/GNUstep/Library/AfterStep/winlist file.

WinList can also be bound to a keystroke, mouse button, or menu option to
be invoked later, in this case using 'Transient' as an argument will cause
WinList to resemble the built in window list.

WinList must reside in a directory that is listed in the ModulePath option
of AfterStep for it to be executed by AfterStep.

.SH CONFIGURATION OPTIONS
The following options can be placed in the ~/GNUstep/Library/AfterStep/winlist
file :

.IP "*WinListGeometry \fI{+-}<X>x{+-}<Y>\fP"
Specifies the location and gravity of the WinList window.  At the current
time, size is not supported and WinList will resize itself as buttons are
added.  If the NoAnchor option is not specified then the windows gravity
corner will be anchored, and the window will grow in the opposite direction.
(i.e. If the geometry is specified -5-5, that is SoutEastGravity.  This will
cause the window to draw up and to the left as windows are added)

.IP "*WinListFont \fIfont\fP"
Specifies the font to be used for labeling the buttons.

.IP "*WinListFore \fIcolor\fP"
Specifies the color to use for the button names.

.IP "*WinListBack \fIcolor\fP"
Specifies the color for the buttons.

.IP "*WinListUseSkipList
Tells WinList to not show the windows that are listed on a WindowListSkip
line if the configuration file.

.IP "*WinListNoAnchor
By default, WinList will anchor the gravity corner so the window will grow
in the opposite direction.  This undoes that option.

.IP "*WinListUseIconNames
Tells WinList to use the icon name of the window instead of the full window
name.  This is useful to keep the width of the window small.

.IP "*WinListAction \fIaction response[,reponse...]\fP"
Tells WinList to do \fIresponse\fP when \fIaction\fP is done.  The
currently supported \fIaction\fPs are: Click1, Click2, Click3.  The currently
supported \fIresponse\fPs are any AfterStep built-in commands, including modules
and functions.

.IP "*WinListOrientation \fIdown|across\fP"
Will make a vertical or horizontal winlist.

.IP "*WinListMaxWidth \fIwidth in pixel\fP"
Sets either maxwidth for a vertical winlist or the actual width for an
horizontal "taskbar".

.IP "*WinListLeftJustify"
If used, will justify to left window titles (centering is default)

.SH SAMPLE CONFIGURATION
The following are excepts from a winlist file which describe WinList
initialization commands:

.nf
.sp
########
# Pop up the window list in tranient mode on button 3 press & hold

Mouse 3   R   A   Module "WinList" WinList Transient

########################## Window-Lister ###############################
*WinListBack DarkOliveGreen
*WinListFore PaleGoldenRod
*WinListFont -*-new century schoolbook-bold-r-*-*-*-120-*-*-*-*-*-*
*WinListAction Click1 Iconify -1,Raise
*WinListAction Click2 Iconify
*WinListAction Click3 Module "Ident" Ident
*WinListUseSkipList
*WinListUseIconNames
*WinListGeometry -50-85
#*WinListNoAnchor
*WinListMaxWidth 798
# down (vertical winlist) or across (horizontal titlebar) ?
*WinListOrientation across

.sp
.fi

.SH AUTHORS
Rene Fichter <ceezaer@cyberspace.org>

Mike Finger <mfinger@mermaid.micro.umn.edu>
