#!/bin/sh
#
# WWWOFFLE - World Wide Web Offline Explorer - Version 2.3.
#
# A Perl script to get audit information from the standard error output.
#
# Written by Andrew M. Bishop
#
# This file Copyright 1998 Andrew M. Bishop
# It may be distributed under the GNU Public License, version 2, or
# any higher version.  See section COPYING of the GNU Public license
# for conditions under which this file may be redistributed.
#

exec perl -x $0

exit 1

#!perl

%commands=("Online","-online",
           "Fetch","-fetch",
           "Offline","-offline",
           "In Autodial Mode","-autodial",
           "Re-Reading Configuration File","-config",
           "Purge","-purge",
           "Kill","-kill");

%modes=("-spool","S",
        "-fetch","F",
        "-real","R",
        "-autodial","A");

$time='';
%host=();
%ip=();
%mode=();
$url='';

while(<STDIN>)
  {
   if(/^wwwoffled.([0-9]+)/)
       {
        $pid=$1;

        if(/Timestamp: ([a-zA-Z0-9 :]+)/)
            {
             $time=$1;
             printf("T %s\n",$time);
            }
        elsif(/HTTP Proxy connection from ([^ ]+) .([0-9.]+)/)
            {
             $host=$1;
             $ip=$2;
            }
        elsif(/WWWOFFLE Connection from ([^ ]+) .([0-9.]+)/)
            {
             $host=$1;
             $ip=$2;
            }
        elsif(/Forked wwwoffles (-[a-z]+) .pid=([0-9]+)/)
            {
             $mode=$modes{$1};
             if($mode eq "F")
                 {
                  $host='';
                  $ip='';
                 }
             if($url{$2}) # The wwwoffles output was before the wwwoffled output.
                 {
                  $url=$url{$2}; $url{$2}='';
                  printf("%1s %16s %12s %s %s\n",$mode,$host,$ip,$url);
                 }
             else # The wwwoffled output is before the wwwoffles output.
                 {
                  $host{$2}=$host;
                  $ip{$2}=$ip;
                  $mode{$2}=$mode;
                 }
            }
        elsif(/WWWOFFLE (Online|Fetch|Offline|In Autodial Mode|Re-Reading Configuration File|Purge|Kill)\./)
            {
             $command=$commands{$1};
             printf("W %16s %12s WWWOFFLE %s\n",$host,$ip,$command);
            }
        elsif(/WWWOFFLE (Incorrect Password|Not a command|Unknown control command)/)
            {
             printf("W %16s %12s WWWOFFLE Bad Connection (%s)\n",$host,$ip,$1);
            }
       }
   elsif(/^wwwoffles.([0-9]+)/)
       {
        $pid=$1;

        if(/: URL=\'([^\']+)/)
            {
             $url=$1;
             if($mode{$pid}) # The wwwoffled output was before the wwwoffles output.
                 {
                  $host=$host{$pid}; $host{$pid}='';
                  $ip=$ip{$pid}; $ip{$pid}='';
                  $mode=$mode{$pid}; $mode{$pid}='';
                  printf("%1s %16s %12s %s %s\n",$mode,$host,$ip,$url);
                 }
             else # The wwwoffles output is before the wwwoffled output.
                 {
                  $url{$pid}=$url;
                 }
            }
       }
  }
