/* redir.c - Implement redirection */

#ifndef lint
char RCS_redir_c[] =
"$Id: redir.c,v 2.2 1998/08/11 17:37:09 caleishm Exp caleishm $  Produced by Chris Leishman & Trevor Cohn.  Ormond College student IT department, 1998.$\n";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "redir.h"
#include "config.h"
#include "utils.h"

#define HOST_BEGIN   "://"
#define HOST_LENGTH  3
#define PATH_BEGIN   "/"
#define MAX_PERC     100

enum { FOUND_MATCH, NOT_FOUND };

int  parse_tree(item *, char *, char *, char *, char *);
int  check(char *, char *, char *, item *);
void print_redir(str_list *, int);


/* External variable for the source host.  Used for logging. */

extern char *address;


/* Controlling function.  Breaks url into host and path, then searches 
   for matches */


void redirect(item *data, char *url)
{
	int  i, j, M = strlen(url);
	char *host, *path, *str;
#ifndef NOSAVESKIP
	static int *hb_skip = NULL;
	static int *pb_skip = NULL;


	/* Build skip table for host and path start defines, 
           but only on initialisation */

	if (hb_skip == NULL || pb_skip == NULL)
	{
		hb_skip = buildskip(HOST_BEGIN);
		pb_skip = buildskip(PATH_BEGIN);
	}
#endif


	/* Chop newline */

	if (url[M - 1] == EOLN) {
		url[M - 1] = EOS;
		M--;
	}

	str = strdup(url);

	/* Allows invalid url to be parsed */

#ifdef NOSAVESKIP
	if ((i = search(HOST_BEGIN, url)) == -1)
#else
	if ((i = search(HOST_BEGIN, url, hb_skip)) == -1)
#endif
		i = 0;
	else
		i += HOST_LENGTH;

#ifdef NOSAVESKIP
	if ((j = search(PATH_BEGIN, url + i)) == -1)
#else
	if ((j = search(PATH_BEGIN, url + i, pb_skip)) == -1)
#endif
		j = M - 1 - i;
	else
		str[i + j] = EOS;

	host = str + i;
	path = str + i + j + 1;

#ifdef DEBUG
	printf("--Url:  %s, Host: %s, Path: %s\n", url, host, path);
	printf("--Indices: i %d, j %d M %d\n", i, j, M);
#endif

	
	/* Search for match.  If none, then output original url. */

	if (parse_tree(data, host, path, url, NULL) == NOT_FOUND)
	{
#ifdef DEBUG
		printf("--Not found... allowing\n");
#endif
		putchar('\n');
	}


	/* Free temp string */

	free(str);
}


/* This function recurses through the data tree, searching for matches.
   If a match is found the appropriate url is output, otherwise NOT_FOUND
   is returned. */

int parse_tree(item *node, char *host, char *path, char *url, char *lfile)
{
	while (node != NULL)
	{
#ifdef DEBUG
		printf("--Checking, type %d, key %s\n", node->type,
		        (node->keys == NULL)?"null":node->keys->data);
#endif


		/* Check the keys in this node to see if this node applies. */
	
		if (check(url, host, path, node))
		{
			/* Got a new log file? */

			if (node->logfile != NULL) {
				lfile = node->logfile;
#ifdef DEBUG
				printf("Now logging to %s.\n", lfile);
#endif
			}

			/* an exempt? */
			if (node->type >= EXEMPT)
			{
#ifdef DEBUG
				printf("--Found exempt... returning\n");
#endif
				putchar('\n');
				return FOUND_MATCH;
			}
			else if (node->redirect != NULL)
			{
#ifdef DEBUG
				printf("--Applying redirects... returning\n");
#endif
				print_redir(node->redirect, node->random);
				addlog(lfile, 2, address, url);
				return FOUND_MATCH;
			}
			else
			{
				int i;

#ifdef DEBUG
				printf("--Recursing...\n");
#endif
				/* recurse subtree.. */

				i = parse_tree(node->subs, host, path, 
				                url, lfile);

				if (i == FOUND_MATCH)
					return i;

				/* ignore it */
			}
		}
#ifdef DEBUG
		printf("--Next one...\n");
#endif

		node = node->next;
	}

	return NOT_FOUND;
}


/* Check the keys in the node to see if it applies to the current url. */

int check(char *url, char *host, char *path, item *node)
{		
	int i;
	str_list *l = node->keys;

	if (l == NULL)
		return TRUE;

	while (l != NULL)
	{
#ifdef DEBUG
		printf("--Searching...\n");
#endif
		switch (node->type)
		{
			case CONTAINS:
			case EXEMPT:
#ifdef NOSAVESKIP
				i = search(l->data, url);
#else
				i = search(l->data, url, l->skip);
#endif
				break;
			case HOSTCONTAINS:
			case HOSTEXEMPT:
				if (*host != EOS)
#ifdef NOSAVESKIP
					i = search(l->data, host);
#else
					i = search(l->data, host, l->skip);
#endif
				else 
					i = -1;
				break;
			case PATHCONTAINS: 
			case PATHEXEMPT:
				if (*path != EOS)
#ifdef NOSAVESKIP
					i = search(l->data, path);
#else
					i = search(l->data, path, l->skip);
#endif
				else 
					i = -1;
				break;
			default:
				fprintf(stderr, "Invalid 'type' in config.\n");
				exit(1);
				break;
		}
#ifdef DEBUG
		printf("--Completed...\n");
#endif

		if (i != -1)
			return TRUE;

		l = l->next;
	}

	return FALSE;
}


/* This function output one of the redirection strings, randomly chossing 
   between them.  It also uses the random integer to determine wether to
   output the original url */

void print_redir(str_list *redir, int random)
{
	int total = 0, i, j;
	str_list *curr;

	if (redir == NULL)
		return;


	/* If randomness is not 100%, decide whether to return original url */
	if ((random < MAX_PERC) && (rand() % 100 > random)) {
#ifdef DEBUG
		printf("Randomly returning original url\n");
#endif
		putchar('\n');
		return;
	}

	/* Randomly choose a redirect */

	curr = redir;
	while(curr != NULL) {
		total++;
		curr = curr->next;
	}
	j = rand() % total;

#ifdef DEBUG
	printf("Total redirects = %d, choosing %d.\n", total, j+1);
#endif

	curr = redir;
	for(i=0; i<j; i++) {
		curr = curr->next;
	}

	puts(curr->data);
}
