/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.application.HTMLParsingException;

class HTMLTokenGenerator
extends FilterInputStream {
    public static final byte NULL_TOKEN = 0;
    public static final byte STRING_TOKEN = 1;
    public static final byte MARKER_BEGIN_TOKEN = 2;
    public static final byte MARKER_END_TOKEN = 3;
    public static final byte COMMENT_TOKEN = 4;
    static final byte LAST_TOKEN_TYPE = 4;
    static final int CHARACTER_COUNT_PER_ARRAY = 128;
    static final int CCPA_BIT_COUNT = 7;
    static final int CCPA_MASK = 127;
    static final int PARSING_NONE_STATE = 0;
    static final int PARSING_STRING_STATE = 1;
    static final int PARSING_MARKER_STATE = 2;
    static final int PARSING_COMMENT_STATE = 3;
    static final int PARSING_MARKER_OR_COMMENT_STATE = 4;
    static final int PARSING_END_COMMENT_ONE_STATE = 5;
    static final int PARSING_END_COMMENT_TWO_STATE = 6;
    private byte[][] input = new byte[1][];
    private int nextAvailableByteIndex;
    private int markedByteIndex;
    private int nextFreeByteSlotIndex;
    private int currentLineNumber;
    private int parserState;
    private int currentToken;
    private String currentTokenString;
    private String currentTokenAttributes;

    public HTMLTokenGenerator(InputStream in) {
        super(in);
        this.input[0] = new byte[128];
        this.nextAvailableByteIndex = 0;
        this.nextFreeByteSlotIndex = 0;
        this.currentLineNumber = 0;
        this.parserState = 0;
    }

    private final void markCurrentCharacter() {
        this.markedByteIndex = this.nextAvailableByteIndex;
    }

    private final void markPreviousCharacter() {
        this.markedByteIndex = this.nextAvailableByteIndex - 1;
    }

    private final void growInputBuffer() {
        byte[][] newInput = new byte[this.input.length + 1][];
        System.arraycopy(this.input, 0, newInput, 0, this.input.length);
        newInput[this.input.length] = new byte[128];
        this.input = newInput;
    }

    private final void readMoreCharacters() throws IOException {
        int length;
        int currentArrayIndex = this.nextFreeByteSlotIndex >> 7;
        if (currentArrayIndex >= this.input.length) {
            this.growInputBuffer();
        }
        if ((length = this.read(this.input[currentArrayIndex], this.nextFreeByteSlotIndex & 0x7F, 128 - (this.nextFreeByteSlotIndex & 0x7F))) != -1) {
            this.nextFreeByteSlotIndex += length;
        } else {
            return;
        }
        if (length < 128) {
            currentArrayIndex = this.nextFreeByteSlotIndex >> 7;
            if (currentArrayIndex >= this.input.length) {
                this.growInputBuffer();
            }
            if ((length = this.read(this.input[currentArrayIndex], this.nextFreeByteSlotIndex & 0x7F, 128 - (this.nextFreeByteSlotIndex & 0x7F))) != -1) {
                this.nextFreeByteSlotIndex += length;
            }
        }
    }

    private final boolean hasMoreCharacters() throws IOException {
        if (this.nextAvailableByteIndex < this.nextFreeByteSlotIndex) {
            return true;
        }
        this.readMoreCharacters();
        return this.nextAvailableByteIndex < this.nextFreeByteSlotIndex;
    }

    private final byte peekNextCharacter() throws IOException {
        byte result = 0;
        if (this.nextAvailableByteIndex >= this.nextFreeByteSlotIndex) {
            this.readMoreCharacters();
        }
        if (this.nextAvailableByteIndex < this.nextFreeByteSlotIndex) {
            result = this.input[this.nextAvailableByteIndex >> 7][this.nextAvailableByteIndex & 0x7F];
            ++this.nextAvailableByteIndex;
        }
        return result;
    }

    private final void rewindToMarkedCharacter() {
        this.nextAvailableByteIndex = this.markedByteIndex;
    }

    private final void deletePeekedCharacters() {
        this.markedByteIndex = -1;
        while (this.nextAvailableByteIndex >> 7 > 0) {
            byte[] tmp = this.input[0];
            int i = 0;
            int c = this.input.length - 1;
            while (i < c) {
                this.input[i] = this.input[i + 1];
                ++i;
            }
            this.input[this.input.length - 1] = tmp;
            this.nextAvailableByteIndex -= 128;
            this.nextFreeByteSlotIndex -= 128;
        }
    }

    private final void deletePeekedCharactersMinusOne() {
        this.markedByteIndex = -1;
        while (this.nextAvailableByteIndex - 1 >> 7 > 0) {
            byte[] tmp = this.input[0];
            int i = 0;
            int c = this.input.length - 1;
            while (i < c) {
                this.input[i] = this.input[i + 1];
                ++i;
            }
            this.input[this.input.length - 1] = tmp;
            this.nextAvailableByteIndex -= 128;
            this.nextFreeByteSlotIndex -= 128;
        }
    }

    private final byte[] getAndDeletePeekedCharacters() {
        int length = this.nextAvailableByteIndex - this.markedByteIndex;
        byte[] result = new byte[length];
        int i = this.markedByteIndex;
        int c = this.markedByteIndex + length;
        while (i < c) {
            result[i - this.markedByteIndex] = this.input[i >> 7][i & 0x7F];
            ++i;
        }
        this.deletePeekedCharacters();
        this.markedByteIndex = -1;
        return result;
    }

    private final byte[] getAndDeletePeekedCharactersMinusOne() {
        int length = this.nextAvailableByteIndex - this.markedByteIndex - 1;
        byte[] result = new byte[length];
        int i = this.markedByteIndex;
        int c = this.markedByteIndex + length;
        while (i < c) {
            result[i - this.markedByteIndex] = this.input[i >> 7][i & 0x7F];
            ++i;
        }
        this.deletePeekedCharactersMinusOne();
        this.markedByteIndex = -1;
        return result;
    }

    private final boolean isSpaceOrCR(byte b) {
        return b == 32 || b == 9 || b == 10 || b == 13;
    }

    private String attributes(byte[] bArray) throws HTMLParsingException {
        if (bArray.length == 0 || bArray[0] != 60 || bArray[bArray.length - 1] != 62) {
            this.syntaxError("Malformed marker");
        }
        int i = 1;
        int c = bArray.length;
        while (i < c && this.isSpaceOrCR(bArray[i])) {
            ++i;
        }
        while (i < c && !this.isSpaceOrCR(bArray[i])) {
            ++i;
        }
        while (i < c && this.isSpaceOrCR(bArray[i])) {
            ++i;
        }
        if (c - 1 - i > 0) {
            return new String(bArray, 0, i, c - 1 - i);
        }
        return "";
    }

    private String marker(byte[] bArray) throws HTMLParsingException {
        if (bArray.length == 0 || bArray[0] != 60 || bArray[bArray.length - 1] != 62) {
            this.syntaxError("Malformed marker");
        }
        int i = 1;
        int start = 1;
        int c = bArray.length;
        while (i < c && this.isSpaceOrCR(bArray[i])) {
            ++i;
            ++start;
        }
        if (bArray[i] == 47) {
            ++i;
            ++start;
        }
        while (i < c - 1 && !this.isSpaceOrCR(bArray[i])) {
            ++i;
        }
        return new String(bArray, 0, start, i - start).toUpperCase();
    }

    private boolean isMarkerBegin(byte[] bArray) throws HTMLParsingException {
        if (bArray.length == 0 || bArray[0] != 60 || bArray[bArray.length - 1] != 62) {
            this.syntaxError("Malformed marker");
        }
        int i = 1;
        int c = bArray.length;
        while (i < c && this.isSpaceOrCR(bArray[i])) {
            ++i;
        }
        return bArray[i] != 47;
    }

    private final void parseOneToken() throws HTMLParsingException, IOException {
        block14: while (this.currentToken == 0) {
            if (!this.hasMoreCharacters()) {
                if (this.parserState == 1 || this.markedByteIndex == -1) break;
                this.rewindToMarkedCharacter();
                break;
            }
            byte ch = this.peekNextCharacter();
            if (ch == 10) {
                ++this.currentLineNumber;
            }
            switch (this.parserState) {
                case 0: {
                    this.parserState = ch == 60 ? 4 : 1;
                    this.markPreviousCharacter();
                    break;
                }
                case 1: {
                    if (ch != 60) break;
                    this.currentToken = 1;
                    this.currentTokenAttributes = null;
                    this.currentTokenString = new String(this.getAndDeletePeekedCharactersMinusOne(), 0);
                    this.markPreviousCharacter();
                    this.parserState = 4;
                    break;
                }
                case 2: {
                    if (ch != 62) break;
                    byte[] allMarker = this.getAndDeletePeekedCharacters();
                    this.currentToken = this.isMarkerBegin(allMarker) ? 2 : 3;
                    this.currentTokenAttributes = this.attributes(allMarker);
                    this.currentTokenString = this.marker(allMarker);
                    this.parserState = 0;
                    break;
                }
                case 4: {
                    if (ch == 33) {
                        this.parserState = 3;
                        break;
                    }
                    this.parserState = 2;
                    break;
                }
                case 3: {
                    if (ch == 45) {
                        this.parserState = 5;
                        break;
                    }
                    if (ch != 62) break;
                    this.currentToken = 4;
                    this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                    this.currentTokenAttributes = null;
                    this.parserState = 0;
                    break;
                }
                case 5: {
                    if (ch == 45) {
                        this.parserState = 6;
                        break;
                    }
                    if (ch == 62) {
                        this.currentToken = 4;
                        this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                        this.currentTokenAttributes = null;
                        this.parserState = 0;
                        break;
                    }
                    this.parserState = 3;
                    break;
                }
                case 6: {
                    if (ch == 10 || ch == 13) continue block14;
                    if (ch == 62) {
                        this.currentToken = 4;
                        this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                        this.currentTokenAttributes = null;
                        this.parserState = 0;
                        break;
                    }
                    this.parserState = 3;
                    break;
                }
            }
        }
        if (this.currentToken == 0 && !this.hasMoreCharacters()) {
            switch (this.parserState) {
                case 1: {
                    this.currentToken = 1;
                    this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                    this.currentTokenAttributes = null;
                    this.parserState = 0;
                    return;
                }
                case 2: 
                case 4: {
                    this.parserState = 0;
                    this.syntaxError("Unterminated marker");
                    return;
                }
                default: {
                    this.parserState = 0;
                    this.syntaxError("Unterminated comment. Comment should end with -->");
                    return;
                }
                case 0: 
            }
        }
    }

    public final boolean hasMoreTokens() throws HTMLParsingException, IOException {
        if (this.currentToken != 0) {
            return true;
        }
        this.parseOneToken();
        return this.currentToken != 0;
    }

    public final int nextToken() throws HTMLParsingException, IOException {
        int result = 0;
        if (this.currentToken == 0) {
            this.parseOneToken();
        }
        if (this.currentToken != 0) {
            result = this.currentToken;
            this.currentToken = 0;
        }
        return result;
    }

    final int peekNextToken() throws HTMLParsingException, IOException {
        if (this.currentToken == 0) {
            this.parseOneToken();
        }
        return this.currentToken;
    }

    public final String stringForLastToken() {
        return this.currentTokenString;
    }

    public final String attributesForLastToken() {
        return this.currentTokenAttributes;
    }

    final int lineForLastToken() {
        return this.currentLineNumber + 1;
    }

    final void syntaxError(String description) throws HTMLParsingException {
        throw new HTMLParsingException(description, this.lineForLastToken());
    }
}

