/*
 * Run external editor for Arena.
 * editor.c   howcome 11/10/94
 */

/* History
 *  13-06-97 glkaup
 *    -Took care of many possible NULL pointers and allocated memory problems
 *     that appeared only with very large HTML buffers and file permission
 *     failures.
 *  02-02-97 QingLong
 *    -Added debugging traces
 */
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <X11/Xlib.h>

#include "arena.h"
#ifdef ARENA_DEBUG	/* QingLong.02-02-97 */
#  include "debug.h"
#endif
#include "defs.h"
#include "bridge.h"
#include "display.h"
#include "editor_i.h"
#include "editor.h"
#include "main.h"
#include "parsehtml.h"
#include "scrollbar.h"
#include "spawn.h"
#include "status.h"
#include "util.h"
#include "x11.h"

#include "HTUtils.h"	/* WWW general purpose macros */
#include "HTString.h"
#include "HTList.h"
#include "HTAccess.h"
#include "HTLib.h"


#ifndef MAIN


/* Create a temp file with the buffer we want to edit.
 * Return the filespec to our caller!  Caller needs to free the
 * allocated filespec memory!
 */
char *WriteBadFlagFile()
{
 char *p = CurrentDoc->content_buffer;     /* working copy of content_buffer */
 char *ep = p + CurrentDoc->loaded_length; /* Where is the NULL?             */
 char *tfile, *np;
 int fd, len;

 BadFlag *h;
 HTList *lp;

#ifdef ARENA_DEBUG
 char Iam[] = "WriteBadFlagFile";
#endif

 /* create the file to be used "temporarily" to dump the document to
  * so we can edit it!
  */
 tfile = Arena_MAlloc(MAX_PATH_LENGTH + 1, False);           /* FIXME */
 sprintf(tfile, "%seditor.%d.html",
   HTUserProfile_tmp(HTLib_userProfile()), (int)getpid());
#ifdef ARENA_DEBUG
 if (BADFLAG_TRACE) Arena_TracePrint(Iam, " Filespec %s\n", tfile);
#endif

 if ((fd = creat(tfile, S_IRUSR | S_IWUSR)) == -1)
   {
#ifdef ARENA_DEBUG
    if (BADFLAG_TRACE) Arena_TracePrint(Iam, " creat failed %s\n", tfile);
#endif
    return(NULL);
   }

 /* Now, walk the error flagging list... outputting document fragments followed
  * by error flags.  Then get the next document part... etc.
  * These objects are allocated and have allocated pointers within!  Do NOT
  * allow HTList_... stuff to Free the object.  Memory leaks galore!
  */
 lp = CurrentDoc->bad_flags;
 while ((h = (BadFlag*) HTList_nextObject(lp) ))
   {
     /* Pick up the buffer pointer of this error...
      * actually points to NEXT character AFTER the error point!
      * NEVER allow this pointer beyond the NULL char at the end of the buffer.
      */
    np = h->p;
    if (np > ep) np = ep;

    /* This is the length of the text segment from end of previous error
     * to the point of THIS error.  Basically we output the contents of
     * the buffer of this length, then the "error message".
     */
    len = np - p;

#ifdef ARENA_DEBUG
    if (BADFLAG_TRACE)
      {
       char *s = NULL;
       Arena_TracePrint(Iam, " ---------- Begin  Error ----------\n");
       Arena_TracePrint(Iam, " %s "POINTER_FORMAT"\n", h->error_text, np);
       if (len > 0) s = strndup(p, len);
       Arena_TracePrint(Iam, " %d bytes: \"%s\"\n", len, s ? s : "(null)");
       Arena_TracePrint(Iam, " ---------- End Of Error ----------\n\n");
       Free(s);
      }
#endif

    /* We have not MOVED forward in the buffer...
     * Maybe we are at the end... or we are reporting
     * more than one error at this location!  DO NOT output any text!
     */
    if (len > 0)
       write(fd, p, len);

    /* ALWAYS output the error message though...  */
    write(fd, "\n<!-- ", 6);
    write(fd, h->error_text, Arena_StrLen(h->error_text));
    write(fd, " -->\n", 5);

    /* Move our pointer ahead, but never past the end of the input buffer */
    p = np;
    if (p > ep) p = ep;
   } /* End ``while'' */


 /* Ok, output to the end of the document!
  * BUT, make sure we're not already there
  */
 if (Arena_StrLen(p) > 0 && *p != 0)
   write(fd, p, Arena_StrLen(p));

 /* since we are done with the bad_flags list for this document...
  * clean it up!  It will be "recreated" by _ReportError() during reparsing.
  */
 if (delete_Document_bad_flags(CurrentDoc))
   CurrentDoc->bad_flags = NULL;

#ifdef ARENA_DEBUG
 if (BADFLAG_TRACE) Arena_TracePrint(Iam, " Returning...\n");
#endif
 close(fd);
 return(tfile);
}

/* After editing the temporary file...
 * Allocate a NEW buffer, read the entire file into it...
 * Return it to caller?
 */
char *ReadBadFlagFile(char * f_name, int * r)
{
 int fd, l; 
 char *buf;
 struct stat s;

#ifdef ARENA_DEBUG
 char Iam[] = "ReadBadFlagFile";
#endif
 *r = 0;

 if ((fd = open(f_name, O_RDONLY)) == -1)
   {
#ifdef ARENA_DEBUG
    if (BADFLAG_TRACE)
      Arena_TracePrint(Iam, " Where did %s GO????\n", f_name);
#endif
    return NULL;
   }

 fstat(fd, &s);
 if (s.st_size > 0)
   {
    buf = (char *)Arena_MAlloc(s.st_size + 1, False);
    if (!buf)
      {
#ifdef ARENA_DEBUG
       if (BADFLAG_TRACE)
	 Arena_TracePrint(Iam, " Allocation failed %d bytes\n", s.st_size +1);
#endif
       return NULL;
      }
    l = read(fd, buf, s.st_size);
    buf[l] = 0;
    close(fd);

    if (l != s.st_size)
      {
#ifdef ARENA_DEBUG
       if (BADFLAG_TRACE)
	 Arena_TracePrint(Iam, " SIZE doen't match! %d %d\n", l, s.st_size);
#endif
       Free(buf);
       return NULL;
      }
    *r = l;   /* glk.20.9.97  YES... forget the NULL */
    return buf;
   }
 close(fd);
 return(NULL);
}

/* Run editor for current buffer!
 * First, create the temporary file to be edited...
 * Run the editor...
 * Get it back to Arena for our use!
 * If anyting fails, user will get back the original buffer!
 */
int ForkEditor(void)
{
 char *tmp_file, *cmd, *newbuf;
 int n_read, argc;
 char **argv;
 SPAWNChildInfo *ed = NULL;

#ifdef ARENA_DEBUG
 char Iam[] = "ForkEditor";
#endif

 if (!Editor) return EXIT_FAILURE;
 tmp_file = WriteBadFlagFile();
 if (!tmp_file)
   {
    Warn(_("Could not create temporary edit file"));
    return EXIT_FAILURE;
   }

 cmd = NULL;
 StrAllocCopy(cmd, Editor);
 StrAllocCat(cmd, " ");
 StrAllocCat(cmd, tmp_file);

#ifdef ARENA_DEBUG
 if (BADFLAG_TRACE) Arena_TracePrint(Iam, " forking off \"%s\"\n", cmd);
#endif

 /* Convert the commnd string just created to argc, argv style */
 argv = SpawnStringToRagged(cmd, &argc);
 if (argv == NULL || argc == 0) return EXIT_FAILURE;

 /* Spawn a child to do the editing of the document...
  * Allow Arena to continue response to user request...
  * BUT, only "basic" gui stuff
  */
 ed = SpawnVP(WAIT_GUI, KILL_ALWAYS, NULL, argv, NULL);
 if (ed == NULL)
   { 
    Free(cmd);
    unlink(tmp_file);
    Free(tmp_file);
#ifdef ARENA_DEBUG
    if (BADFLAG_TRACE) Arena_TracePrint(Iam, " system failed! \"%s\"\n", cmd);
#endif
    Warn(_("Could not find editor"));
    return EXIT_FAILURE;
   }
 Free(cmd);
 SpawnForgetChild(ed);

/* He came back!!!
 * Now create a NEW buffer for the file...
 * Check this file carefully... Verify sizes and correct length on input!
 * I'm not convinced that this is necessary, but rather than take it out,
 * I'll just let it do the checking.  glk 13-06-97 
 */
 newbuf = ReadBadFlagFile(tmp_file, &n_read);

 /* get rid of the temp file and maybe its emacs backup. */
 unlink(tmp_file);
 StrAllocCat(tmp_file, "~");
 unlink(tmp_file);
 Free(tmp_file);

 if (!newbuf)
   {
#ifdef ARENA_DEBUG
    if (BADFLAG_TRACE) Arena_TracePrint(Iam, " ReadBadFlagFile FAILED\n");
#endif
    Warn(_("Problems reading temporary file"));
    return EXIT_FAILURE;
   }

/* Cool!
 * Dump the OLD buffer... and return the NEW one!
 */
 Free(CurrentDoc->content_buffer);
 CurrentDoc->content_buffer = newbuf;
 CurrentDoc->loaded_length = n_read;
 return EXIT_SUCCESS;
}


/* Routine called from toolbar.c when the "Edit" button is clicked.
 * howcome 12/10/94: added support for external editing
 * glk     06-13-97: added "clean failure" of ForkEditor
 */
void EditCurrentBuffer(void)
{
#ifdef ARENA_DEBUG
  char Iam[] = "EditCurrentBuffer";
#endif

 if (!Editor)
   {
    Warn(_("No editor has been specified"));
    Beep();
    return;
   }

 /* Don't allow the editing of a "nofree" document */
 if (CurrentDoc->nofree != 0)
   {
#ifdef ARENA_DEBUG
    if (BADFLAG_TRACE) Arena_TracePrint(Iam, " CurrentDoc has nofree set\n");
#endif
    Warn(_("Cannot edit current document"));
    Beep();
    return;
   }

 /* Pass the editor the "buffer" of the CurrentDoc structure!
  * This will make it more obvious that we are using CurrentDoc buffer.
  * This pointer WILL change after the actual edit is done...
  */
 if (ForkEditor())
   {
#ifdef ARENA_DEBUG
    if (BADFLAG_TRACE) Arena_TracePrint(Iam, " ForkEditor failed!\n");
#endif
   }
 else
   {
    /* Fix up the buffer pointer used by the Display Code!  The display code
     * has "everything" in global storage.  As far as I can tell... buffer
     * is always equal to CD->content_buffer... but who knows!?
     */
    buffer = CurrentDoc->content_buffer;
    NewBuffer(CurrentDoc);
   }
}



#if 0 

/* internal editing! */


void FormDel(TextField *tf)
{
    int len3 = tf->used - (tf->e - tf->buffer);

    if (tf->b == tf->e)
        return;

/*    memmove(tf->b, tf->e, len);*/
    tf->used -= (tf->e - tf->b);
}


void FormAdd(TextField *tf)
{
    int newlen = tf->used + Arena_StrLen(tf->scratch);
    int len1 = tf->b - tf->buffer;
    int len2 = Arena_StrLen(tf->scratch);
    int len3 = tf->used - len1;

    if (newlen > (tf->length - 2)) {
        tf->length = newlen + 100;
        tf->buffer = (char *)realloc(tf->buffer, tf->length);
    }

    /* first move the part after insertion point forward */

    memmove(tf->b + len2, tf->b, len3);

    /* then, insert the scratchpad */

    memcpy(tf->buffer + len1, tf->scratch, len2);

    tf->b = tf->e = tf->buffer + len1 + len2;
    tf->scratch[0] = 0;
    tf->used = len1 + len2 + len3;
    tf->buffer[tf->used] = 0;

#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
    Arena_TracePrint("FormAdd", " %s\n", tf->buffer);
#endif
}

void FormUpdate(TextField *tf)
{
    char *p, *s;
#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
    Bool trace_not_yet_printed = True;
#endif

/*
#ifdef ARENA_DEBUG
    if (tf->scratch[0] != 0) { Arena_TracePrint("%s", tf->scratch); }
#endif
*/
    if (tf->e)
      {
       p = ARENA_Index(tf->e, '\r');
       if (p == NULL) p = tf->buffer + tf->used;

       s = strndup(tf->e, p - tf->e);

#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
       if (tf->scratch[0] != 0)
	 {
	  if (trace_not_yet_printed)
	    {
	     Arena_TracePrint("FormUpdate", " %s", s);
	     trace_not_yet_printed = False;
	    }
	 }
      }
    if (trace_not_yet_printed) Arena_TracePrint("FormUpdate", ")\n");
# else
      }
#endif
    return;
}



void FormEditChar(char c)
{
    int l;
    TextField *tf = focus->text_field;

#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
    Arena_TracePrint("FormEditChar", " %d %c\n", c, c);
#endif

    if (Arena_StrLen(tf->scratch) > (TEXT_FIELD_SCRATCH_LENGTH - 2)) {
        FormDel(tf);
        FormAdd(tf);
    }

    l = Arena_StrLen(tf->scratch);
    tf->scratch[l] = c;
    tf->scratch[l+1] = 0;

    switch (c) {
      case ' ':
      case '\r':
        FormAdd(tf);
        break;
      default:
    }

    FormUpdate(tf);

#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
    if (tf->buffer) Arena_TracePrint("FormEditChar", " %s\n", tf->buffer);
#endif
}


#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
void FormMoveCursor(int key)
{
 Arena_TracePrint("FormMoveCursor", " %d\n", key);
}
#endif

#endif /* 0 */

#endif /* #ifndef MAIN */

/* ------------------------------------------------- */

typedef int ENTRY_POINT;
#define MAX_CHAR_VALUE 255

ENTRY_POINT EditInitialize ()
{
    /*
    **
    **  Non-Reentrant initialisation routine. 
    **
    **  This must be called prior to performing any edit operations.
    */
    return True; /* janet: for compiler purposes only */



}

ENTRY_POINT EditTerminate ()
{
    /*
    **  Non-Reentrant termination routine. 
    **
    **  This must be called on termination.
    */

    return True; /* janet: for compiler purposes only */


}


void FreeEditBuffer(EditBuffer *eb)
{
    Free(eb);
}


    /*
    **  FUNCTIONAL DESCRIPTION:
    **
    **      An edit buffer structure is created and initialised.
    **
    **      If the input parameters line_break_characters and
    **      word_break_characters are given as NULL the defaults
    **      for ASCII text are used.
    */


ENTRY_POINT EditBufferCreate (
                int	width, 
                int 	height,
                char            *line_break_characters,
                char            *word_break_characters,
                char            *content,
                EditBuffer     **eb_out) 


/*
                int             (* writeahead_log) 
                                        (void *user_data, 
                                        edit_operation *operation),
                void            *user_data;
*/
{
    EditBuffer	*eb = NULL;
    int		i;
    char 	*bt;

/*
    ALLOCATE (edit_buffer, parent, &buffer);
    ALLOCATE_ARRAY (char, buffer, MAX_CHAR_VALUE, &buffer->word_break_table);
*/

    eb = (EditBuffer *)Arena_MAlloc(sizeof(EditBuffer), False);
    if (!eb) 
        return False;

    eb->paras = HTList_new();
    eb->width = width;
    eb->auto_break = True;
    eb->break_table_size = MAX_CHAR_VALUE;
    eb->break_table = (char *)Arena_MAlloc(MAX_CHAR_VALUE, False);
    if (!eb->break_table) {
        FreeEditBuffer(eb);
        return False;
    }

    bt = eb->break_table;

    /*
    **  Initialise the break table
    */ 
    for (i = 0; i < MAX_CHAR_VALUE; i++) {
        bt[i] = EDIT_CHARACTER_TYPE_NORMAL;
    }

    if (line_break_characters != NULL)
      {
       for (i = 0; line_break_characters[i] != 0; i++)
	 {
	  bt [(unsigned char)line_break_characters[i]] |= EDIT_CHARACTER_TYPE_PARA_BREAK;
	 }
      }
    else
      {
       bt['\n'] |= EDIT_CHARACTER_TYPE_PARA_BREAK;
      }

    if (word_break_characters != NULL)
      {
       for (i = 0; word_break_characters[i] != 0; i++)
	 {
	  bt[(unsigned char)word_break_characters[i]] |= EDIT_CHARACTER_TYPE_WORD_BREAK;
	 }
      }
    else
      {
       bt[' '] |= EDIT_CHARACTER_TYPE_WORD_BREAK;
       bt['\t'] |= EDIT_CHARACTER_TYPE_WORD_BREAK;
      }

    if (content)
      {
        char *p = content;
        char *old_p = content;

        while (*p)
	  {
           if (bt[(unsigned char)(*p)] & EDIT_CHARACTER_TYPE_PARA_BREAK)
	     {
	      int len;
	      EditParagraph *ep = NULL;

	      ep = (EditParagraph *)Arena_MAlloc(sizeof(EditParagraph), False);

                if (!ep) {
                    FreeEditBuffer(eb);
                    return False;
                }

                len = p - old_p;

                ep->buffer = (char*)Arena_MAlloc(len + EXTRA_LENGTH, False);
                if (! ep->buffer) {
                    FreeEditBuffer(eb);
                    return False;
                }

                strncpy(ep->buffer, old_p, len);
                ep->buffer[len] = '\0';
                ep->buffer_used = len;
                ep->buffer_size = len + EXTRA_LENGTH;
                ep->width = width;
                ep->height = height;

#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
                Arena_TracePrint("EditBufferCreate",
				 " new para: \"%s\"\n",
				 ep->buffer);
#endif
                HTList_addObject(eb->paras, ep);
                old_p = p + 1;

            }
	   else
	     if (bt[(unsigned char)(*p)] & EDIT_CHARACTER_TYPE_WORD_BREAK)
	       {
                /* add new word break */
	       }
	   p++;
	  }
      }

    *eb_out = eb;
    return True;
}

ENTRY_POINT EditViewCreate (
                EditBuffer	*buffer,
                int		width,
                int		height,
                int		row, 
                int		column,

                /* font structure ??? for time being fixed ! */
/*
                int (*display_line) (
                        void *user_data, EditLine *line),
                int (*display_cursor) (
                        void *user_data),
                int (*display_scroll) (
                        void *user_data),
*/
                EditView       **view_out)
{
    EditView *ev;

    if (!buffer)
        return False;

    ev = (EditView*)Arena_MAlloc(sizeof(EditView), False);

    if (!ev)
        return False;

    ev->width = width;
    ev->height = height;
    ev->main_buffer = buffer;
    ev->cursor_row = 0;
    ev->cursor_column = 0;
    ev->cursor_x = 0;
    ev->cursor_y = 0;
    /* janet 24/07/95: to have function return a value: added 'return True' */
    return True;
}

#if 0
ENTRY_POINT edit_delete_object (
                edit_object     *object         /* Object to be deleted */
                ) 
{
    /*
    **  Determine the type of the structure then call appropriate destroy
    **  routine
    */
}


/*
**  Routines to initialize the text in a buffer
*/

ENTRY_POINT EditBufferInputOpen (
                EditBuffer     *buffer) 
{
    /*
    **  FUNCTIONAL DESCRIPTION:
    **
    **      An 
    */

}

ENTRY_POINT EditBufferInputAdd (EditBuffer *buffer, char *block, int length) 
{
    /*
    **  FUNCTIONAL DESCRIPTION:
    **
    **      
    */

}

ENTRY_POINT EditBufferInputClose (
                EditBuffer *buffer) 
{

}

ENTRY_POINT EditBufferOutput (EditBuffer *buffer, HTStream *stream) 
{

}


ENTRY_POINT EditCursorMove (
                EditView               *view, 
                edit_cursor_movement    mode, 
                edit_cursor_unit        unit,
                int 			x,
                int	         	y,
                ) 
{
    /*
    **  Moves the editing cursor in the specified view. The display window
    **  is adjusted acordingly.
    **
    **  The cursor may be moved in either absolute or relative modes.
    **  
    **  Pixel coordinates may only be specified in absolute mode however?
    */
/*    
    if (!view)
        return False;

    switch (unit) {
      case edit_cursor_unit_character:
        if (mode == edit_cursor_movement_relative) {
            view->cursor_column += x;
            if (view->cursor_column < 0)
                view->cursor_column = 0;
            else if (view->cursor_column > HTList_count(view->main_buffer->)

            view->cursor_row += y;
        }

        break;
      default:
    }
*/
}

ENTRY_POINT EditCoordinatesConvert (
                EditView		*view, 
                int			input_unit,
                int			input_row,
                int			input_colum,
                int			output_unit,
                int			*output_row,
                int			*outpu_colum
                ) 
{
    /*
    **  Converts from one type of coordinates to another, valid input
    **  and output units are :
    **
    **          pixels -> character
    **          character -> pixels
    */





}


ENTRY_POINT EditCursorMark (EditView *view) 
{



}



ENTRY_POINT EditViewSet (
                EditView               *view,
                edit_pixels             pixel_row,
                edit_pixels             pixel_colum,
                edit_pixels             pixel_width,
                edit_pixels             pixel_height,
                void *user_data
                ) 
{
    /*
    **  Sets the viewport of a window.
    **  
    **  If any parameter is specified as -1 the previous value is used.
    */


}

ENTRY_POINT EditBufferCut (
                EditView       *view,
                EditBuffer     *destination
                ) 
{


}

ENTRY_POINT EditBufferCopy (
                EditView       *view,
                EditBuffer     *destination
                ) 
{

}

ENTRY_POINT EditBufferPaste (
                EditView       *view,
                EditBuffer     *source
                ) 
{

}

ENTRY_POINT EditBufferInsert (
                EditView	*view,      /* edit view to be affected */
                char		*string,    /* characters to insert */
                int		length      /* if >= 0 length of string
                                            else string is null terminated */
                ) 
{

}

#endif /* #if 0 */


#ifdef MAIN

main()
{
    EditBuffer *eb;

    EditBufferCreate(10, 10, NULL, NULL, "A test\nFor now\n", &eb);

}

#endif
