/*** analog 3.0      http://www.statslab.cam.ac.uk/~sret1/analog/  ***/

/*** utils.c; lots of little functions to do odd little things ***/

#include "analhea2.h"

extern char *commandname;

void my_exit(int status) {
#ifdef MAC_EVENTS
  MacFini();
#endif
#ifdef WIN32
  Win32Cleanup();
#endif
  exit(status);
}

char *strtoupper(char *n) {
  char *c;
  for (c = n; *c != '\0'; c++)
    if (islower(*c))  /* this is needed to stop const char *n crashing */
      *c = toupper(*c);
  return(n);
}

logical strcaseeq(char *s, char *t) {
  for ( ; toupper(*s) == toupper(*t) && *s != '\0'; s++, t++)
    ;
  if (toupper(*s) != toupper(*t))
    return(FALSE);
  else
    return(TRUE);
}

#ifdef NOSTRCMP
int my_strcmp(char *s, char *t) {
  for ( ; *s == *t && *s != '\0'; s++, t++)
    ;
  if (*s < *t)
    return(-1);
  else if (*s > *t)
    return(1);
  else
    return(0);
}
#endif

unsigned int chrn(char *s, char c) {  /* no. of occurrences of c in s */
  int n = 0;
  while (*(s++) != '\0') {
    if (*s == c)
      n++;
  }
  return(n);
}

unsigned int log10i(unsigned int i) {
  int j;

  for (j = 0; i >= 10; i /= 10)
    j++;
  return(j);
}

unsigned int log10x(double d) {
  int j;

  for (j = 0; d >= 10; d /= 10)
    j++;
  return(j);
}

unsigned int findbmult(double d) {
  int j;

  for (j = 0; d >= 1000000; d /= 1024)
    j++;
  return(j);
}

unsigned long arraymaxl(unsigned long *x, unsigned int size) {
  unsigned long y;
  unsigned int i;

  y = 0;
  for (i = 0; i < size; i++)
    y = MAX(y, x[i]);
  return(y);
}

double arraymaxd(double *x, unsigned int size) {
  double y;       /* assuming doubles in x all positive */
  unsigned int i;

  y = 0.0;
  for (i = 0; i < size; i++)
    y = MAX(y, x[i]);
  return(y);
}

size_t arraymaxlen(char **s, unsigned int size, choice outstyle) {
  unsigned int i;
  size_t y = 0;

  for (i = 0; i < size; i++)
    y = MAX(htmlstrlen(s[i], outstyle), y);
  return(y);
}

void prettyprintf(FILE *outf, unsigned int pagewidth, char *s, va_list ap) {
  /* NB Calling function must call mprintf with pagewidth = 0 after message. */
  char m[255];  /* longer than any message we want to produce */
  static unsigned int col = 0;
  static logical spacedone = FALSE;
  char *m1, *m2;

  if (pagewidth == 0) {
    (void)putc('\n', outf);
    col = 0;
    spacedone = FALSE;
    return;
  }
  (void)vsprintf(m, s, ap);
  for (m1 = m, m2 = m; *m1 != '\0'; m2++) {
    if (*m2 == ' ' || *m2 == '\0' || *m2 == '\n') {
      if ((m2 - m1) + col > pagewidth && (*m1 == ' ' || spacedone)) {
	(void)fputs("\n  ", outf);
	if (*m1 == ' ')
	  m1++;
	spacedone = FALSE;
	col = 1;
      }
      while (m1 < m2) {
	(void)putc(*m1, outf);
	spacedone = (*(m1++) == ' ');
	col++;
      }
      if (*m1 == '\n') {
	(void)fputs("\n  ", outf);
	m1++;
	spacedone = FALSE;
	col = 2;
      }
    }
  }
}

void mprintf(FILE *outf, unsigned int pagewidth, char *s, ...) {
  /* wrapper to prettyprintf(): see note there */
  va_list ap;

  va_start(ap, s);
  prettyprintf(outf, pagewidth, s, ap);
  va_end(ap);
}

void warn(char c, char *s, ...) {
  extern char *warn_args;
  extern logical anywarns, errmess;

  va_list ap;

  if (strchr(warn_args, toupper(c)) != NULL) {
    va_start(ap, s);
    mprintf(stderr, 78, "%s: Warning %c: ", commandname, c);
    prettyprintf(stderr, 78, s, ap);
    mprintf(stderr, 0, NULL);
    if (!errmess) {
      (void)fputs("  (For help on all errors and warnings,", stderr);
      (void)fputs(" see docs/errors.html)\n", stderr);
      errmess = TRUE;
    }
    va_end(ap);
    anywarns = TRUE;
  }
}

void error(char *s, ...) {
  extern logical anywarns, errmess;
  va_list ap;

  va_start(ap, s);
  mprintf(stderr, 78, "%s: Fatal error: ", commandname);
  prettyprintf(stderr, 78, s, ap);
  mprintf(stderr, 78, ": exiting");
  mprintf(stderr, 0, NULL);
  if (!errmess) {
    (void)fputs("  (For help on all errors and warnings,", stderr);
    (void)fputs(" see docs/errors.html)\n", stderr);
    errmess = TRUE;
  }
  va_end(ap);
  anywarns = TRUE;

  my_exit(EXIT_FAILURE);
}

void debug(char c, char *s, ...) {
  extern char *debug_args;
  extern logical anywarns;
  va_list ap;

  if (strchr(debug_args, toupper(c)) != NULL) {
    va_start(ap, s);
    (void)fprintf(stderr, "%c: ", c);
    (void)vfprintf(stderr, s, ap);
    (void)fputc('\n', stderr);
    va_end(ap);
    anywarns = TRUE;
  }
}

void *xmalloc(size_t size) {
  /* the same as malloc, only checks for out of memory */
  void *answer;

  if ((answer = malloc(size)) == NULL)
    error("Ran out of memory: cannot continue");

  return(answer);
}

void *xrealloc(void *ptr, size_t size) {

  if (ptr == NULL)  /* Some broken systems don't allow realloc(NULL, ...) */
    ptr = malloc(size);
  else
    ptr = realloc(ptr, size);
  if (ptr == NULL)
    error("Ran out of memory: cannot continue");

  return(ptr);
}

void *submalloc(Memman *m, size_t size) {
  Mmlist *l;
  /* so memmans are initialised with curr_pos, first = NULL & alignment set */

  size = ((size + m -> alignment - 1) / m -> alignment) * m -> alignment;
  if (m -> curr_pos != NULL &&
      (size_t)((char *)(m -> block_end) - (char *)(m -> next_pos)) >= size)
    m -> curr_pos = m -> next_pos;
  else {
    m -> curr_pos = xmalloc(BLOCKSIZE);
    m -> block_end = (void *)((char *)(m -> curr_pos) + BLOCKSIZE);
    if (m -> first == NULL) {  /* initialisation only */
      m -> first = (Mmlist *)xmalloc(sizeof(Mmlist));
      m -> first -> pos = m -> curr_pos;
      m -> first -> next = NULL;
      m -> last = m -> first;
    }
    else {
      l = (Mmlist *)xmalloc(sizeof(Mmlist));
      l -> pos = m -> curr_pos;
      l -> next = NULL;
      m -> last -> next = l;
      TO_NEXT(m -> last);
    }
  }
  m -> next_pos = (void *)((char *)(m -> curr_pos) + size);
  return(m -> curr_pos);
}

void freemm(Memman *m) {
  Mmlist *p;

  for (p = m -> first; p != NULL; TO_NEXT(p))
    free(p -> pos);
}

logical wildmatch(char *s, char *p) {  /* match string s against pattern p */

  char *ss, *pp;

  /* First match head portions */
  while ((*s == *p || *p == '?') && *s != '\0' && *p != '*') {
    s++;        /* *p != '\0' is covered by (*s == *p) && (*s != '\0') */
    p++;
  }
  /* Unless we've reached a pattern *, we've finished now */
  if (*p != '*') {
    if (*s == '\0' && *p == '\0')
      return(TRUE);
    else
      return(FALSE);
  }
  /* Otherwise, match the tail portions. This is purely for speed reasons,
     so that patterns with only one star don't have to go through the loop
     below. */
  ss = strchr(s, '\0');
  pp = strchr(p, '\0');
  while ((*ss == *pp || *pp == '?') && ss >= s && *pp != '*') {
    ss--;       /* pp != p is covered because *p == '*' */
    pp--;
  }
  /* Again, we might have finished now */
  if (pp == p)
    return(TRUE);
  else if (*pp != '*')
    return(FALSE);
  /* this leaves only the difficult case, where p contains >= 2 *'s. Try and
     match ANY tail substring of s against the bit of the pattern after the
     first * (or consec. *'s) (reducing *'s in p, guaranteeing termination).
     Choose to match tail portion each time (cheap), rather than insert null
     bytes into s and p (wouldn't work with const strings). */
  for (p++; *p == '*' && p != pp; p++)
    ;
  if (p == pp)
    return(TRUE);  /* there was really only one *, disguised as several */
  if (ss < s)
    return(FALSE);
  for ( ; *s != '\0'; s++) {
    if (wildmatch(s, p))
      return(TRUE);
  }
  return(FALSE);
}

logical genwildmatch(char *s, char *s2, char *p) {
  /* Exactly the same as wildmatch, except with doubly delimited strings */
  char *ss, *pp;

  while ((*s == *p || *p == '?') && s < s2 && *p != '*' && *p != '\0') {
    s++;
    p++;
  }
  if (*p != '*') {
    if (s == s2 && *p == '\0')
      return(TRUE);
    else
      return(FALSE);
  }
  ss = strchr(s, '\0');
  pp = strchr(p, '\0');
  while ((*ss == *pp || *pp == '?') && ss >= s && *pp != '*') {
    ss--;
    pp--;
  }
  if (pp == p)
    return(TRUE);
  else if (*pp != '*')
    return(FALSE);
  for (p++; *p == '*' && p != pp; p++)
    ;
  if (p == pp)
    return(TRUE);
  if (ss < s)
    return(FALSE);
  for ( ; s < s2; s++) {
    if (genwildmatch(s, s2, p))
      return(TRUE);
  }
  return(FALSE);
}

logical included(char *name, logical ispage, Include *listhead) {
  Include *lp;   /* This would be more efficient searching backwards, */
  logical ans;   /* but it's only 0.5% of program time as is. */

  if (listhead == NULL)
    return(TRUE);
  else if (listhead -> in == TRUE)
    ans = FALSE;
  else
    ans = TRUE;

  for (lp = listhead; lp != NULL; TO_NEXT(lp)) {
    if (STREQ(lp -> name, "pages")) {
      if (ispage)
	ans = lp -> in;
    }
    else if (wildmatch(name, lp -> name))
      ans = lp -> in;
  }

  return(ans);
}

logical pageq(char *name, Include *ispagehead, choice type) {
  char *c;
  logical ans;

  if (type == ITEM_FILE) {
    if ((c = strchr(name, '?')) != NULL) {
      *c = '\0';
      ans = (choice)included(name, FALSE, ispagehead);
      *c = '?';
    }
    else
      ans = (choice)included(name, FALSE, ispagehead);
  }
  else
    ans = FALSE;
  return(ans);
}
