.\" Copyright 1993, 1996 Scott D. Heavner (sdh@po.cwru.edu)
.\" May be distributed under the GNU General Public License
.TH LDE 8 "23 September 1996" "Linux 2.0" "Linux Programmer's Manual"
.SH NAME
lde \- a curses based file system viewer/editor for Linux
.SH SYNOPSIS
.B "lde
device
.SH DESCRIPTION

.B lde
supports the three most popular file systems under Linux at the time
of its inception: ext2fs, minix, and xiafs.  It also has minimal
support for msdos FAT file systems and a nofs system in which case
.B lde 
will function as a binary editor.
.B lde
will attempt to automatically detect the file system present on the
device or file when it is started, if it does not recognize the file
system present on the device, it will default to nofs.

.B lde
allows you to view and edit disk blocks in hex or ASCII mode, view a
block that contains directory entries in a readable fashion, and view
and edit formatted inodes.
.B lde
is a great help when recovering deleted files (see doc/UNERASE
included with the
.B lde
distribution for more info). 

The device parameter is a required option for
.B lde.
If omitted, it will print a warning and refuse to start.  The
default mode for
.B lde
is to use a curses interface; this can be overriden by some of the
options listed below.

.SH OPTIONS
.TP
.B \-a, --all
Indicates that searches should be performed on the entire disk.
If
.B \-a
is not specified, only data zones which are marked not in use will be
searched.
.TP
.B \-\-append
Always append data to existing recovery file.  If file does not exist,
create new file.
.TP
.B \-b (\-\-block) block_number
Format a single block as hex and dump it to standard output.  Specify
.B \-N
to dump more than one block.
.TP
.B  \-B block_number
Format all blocks after specifed block_number as hex and dump 
to standard output.  You can use
.B \-N
to specify the number of blocks to display.
.TP
.B \-\-blanked\-indirects
Linux <= 2.0.33 blanks all the indirect blocks when truncating an
inode.  The inode still knows where the 1x/2x/3x indirect blocks are,
but they're full of zeros.  This was a quick hack that works to
restore small (>12k <~500k) unfragmented files.  It can be toggled via
the flags menu in the curses interface.
.TP
.B \-d block_number
Dump a block's data to standard out as unformatted binary data, ( like
.B cat
and faster than
.B dd
).  Specify
.B \-N
to dump more than one block.
.TP
.B \-D block_number
Dump all blocks after block_number to standard out as unformatted
binary data.  You can use
.B \-N
to specify the number of blocks to dump.
.TP
.B \-f, \-\-file recovery_file_name
Signal lde that we want to recover an inode to a file and specify its
name.  You should specify the inode number to be recovered with the
.B \-i
option.
.TP
.B \-g, \-\-grep
This option was designed to work with grep output.  Grep a 
file for lost data, pipe it through awk to yield just byte
offsets where the desired string lies.
.B lde
will then find the block corresponding to the desired offset
and try to find an inode which references this block.  A sample script
is included with the
.B lde
distribution (crash_recovery/grep-inode).
.TP
.B \-h, \-\-help
Display extended help.
.TP
.B \-i (\-\-inode) inode_number
Format and dump a single inode to standard output.  Specify
.B \-N
to dump more than one inode.
.TP
.B \-I inode_number
Format and dump all inodes after inode_number to standard output. 
You can use
.B \-N
to specify the number of inodes to display.
.TP
.B \-\-indirects
Search the filesystem for blocks that looks like indirect
blocks.
.TP
.B \-\-ilookup
When searching, if we find a match, activate this flag to
lookup the inode which contains the matched block.  It might be
easier and faster to do this with paper and use lde to interactively
lookup only the blocks which have a high probability of being 
the one you want.
.B \-\-ilookup
can also be used if the
.B \-B
or
.B \-b
option is specified to try to find an inode reference for the specifed
blocks.  When using
.B \-B
you may want to specify
.B \-N
also.
.TP
.B \-L \-\-length
Sets search string length (when using
.B \-T
with a filename).
.TP
.B \-N \-\-limit
Sets the number of blocks to display when using inode or block dumps.
If unspecified, default is to the end of the
filesystem (
.B \-I
.B \-B
.B \-D
) or a single block (
.B \-i
.B \-b
.B \-d
).

.B \-N
can also be used to specify a block to begin/resume searching at.  If
unspecified in this usage, it defaults to the first data zone.
.TP
.B \-O \-\-offset
Sets search string offset (when using
.B \-T
with a filename).  The first byte in the template file is 0.  When
searching for matches, the block will be examined starting at this
offset.
.TP
.B \-p, \-r, \-\-paranoid, \-\-safe, \-\-read\-only
Open the device read only.  Once set, this cannot be toggled from within the
program.
.TP
.B \-q, \-\-quiet
Turn off bell.
.TP
.B \-\-recoverable
When searching, check that any inodes found contain a deleted file
that may be recovered.
.B \-\-ilookup
must also be activated for this option to have any effect.
If no blocks are marked used by another inode, "recovery possible"
will be printed.  If blocks are used by another file "recovery NOT
possible" will be printed to the screen.  You may still be able to get
some data back even when it reports that recovery is not possible.  To
get an idea of how many blocks are in use, you will have to check its
recoverablilty from lde via its curses interface (see Recover mode
below).
.RS
.br

If
.B \-\-recoverable
is used with
.B \-I 1
, it will check all the deleted inodes to see if they can be recovered.
The deletion time of the inode will be printed to the screen if it is
recoverable.
.RE
.TP
.B \-\-scrubxiafs
Clobbers the xiafs magic number.  This is stored on the very first
block of the file system which is usually reserved for boot code
(xiafs does reserve 512 bytes for booting).  If you make another file
system on a device which once housed an xiafs, lde will always
autodetect xiafs (other progs may do the same).  As of v2.2alpha4, 
.B lde
will check block 1, then block 0, so it is not a problem any more.
.B \-\-unscrubxiafs
will reverse the changes.
.TP
.B \-S string
Search disk for data (of questionable usefulness).  This was more for searching for a
specific type of file (which is now easier with
.B \-T
) rather than file data.  To search for data or strings, use the
\-\-grep option.
If you insist on using
.B \-S
which might be prudent occasionally, The offset of the string
must be specified with
.B \-O
, and
each block will only be inspected at that offset. If
.B \-O
is not specified, then 0 is assumed and the string must lie at the
start of a block.
You can also specify the block to begin/resume searching from with
.B \-N
which defaults to the first data zone.
.TP
.B \-t fstype
Override the auto-detect. fstype = {no, minix, xiafs,
ext2fs, msdos}
.TP
.B \-T type
Search disk for data. This will search the start of each block
for numbers found in /etc/magic for certain types of files,
currently supported types are {gz, tgz, script}.  
.RS
.br

.B Note:
type tgz only
finds tar files that were created with gnu tar using its cfz options.
Use gz to find tar files that were compressed after creation (or
through a pipe?).
.br

If you specify a filename after the
.B \-T
option, it will read in the first block of the file and search the 
filesystem for something which matches it exactly.  This may be useful for
finding deleted copies of files (i.e. you've found version 1.0, but
deleted version 1.5 and now want to recover it) or with the 
.B \-L
and
.B \-O
options, you can pick off a few bytes and search for magic numbers in
a certain file type.  When using the filename option, you really
should specify 
.B \-L
and
.B \-O
or they will default to BLOCKSIZE and 0.
You can also specify the block to begin/resume searching from with
.B \-N
which defaults to the first data zone.
.RE
.TP
.B \-V, \-\-version
Display version information.
.TP
.B \-w, \-\-write
Allow writes to the disk.


.SH CURSES INTERFACE
The 
.B lde
main screen displays the file system's superblock in the workspace
window.  The header window will be the same for all modes and
indicates the program name and version, the device, the current
selected inode, and the current selected block.  There are also nine
digits (and some extra characters shifted-12456 on an American
keyboard, sorry I skip '#' which is reserved for another function)
"0123456789!@$%^" which indicate the status of a bogus inode which can
be used for file recovery.  A digit means the inode block entry has
not been filled yet, a minus sign indicates that it has been filled.

While displaying the superblock, you can use the following keys
which are valid in most modes:
.RS 
.TP
.B b
to enter block mode
.TP
.B d
display the directory contents of the current inode or block
.TP
.B f
menu of runtime flags
.TP
.B i 
to enter inode mode 
.TP
.B r
to enter recover mode
.TP
.B s
return to super block mode ( only valid from other modes )
.TP
.B q
to quit
.TP
.B v
view the error/warning log
.TP
.B ^L
to repaint the screen
.TP
.B ^O
display menu of valid choices ( also
.B F2
)
.TP
.B F1
display help screen ( also
.B M\-h
or
.B ?
)
.RE

I have tried to implement cursor motion modes similar to both vi and
emacs (M = meta key, ^ = control key, ESC is recognized as the meta
key, M-ESC is recognized occasionally as ESC \-\- to exit menus).

.RS
.br
		vi	 emacs
.br
 UP		k	  ^P
.br
DOWN		j	  ^N
.br
LEFT		h	  ^B
.br
RIGHT	l	  ^F
.br
PG_UP	^U	  M-v
.br
PG_DN	^D	  ^V
.RE
.TP

.B Inode mode:

Once in inode mode, the current inode will be displayed in the
workspace window.  

.RS
.TP
.B PG_DOWN
Make next inode the current inode.
.TP
.B PG_UP
Make previous inode the current inode.
.TP
.B arrows
Move cursor to different fields of inode.  Up and left go back one
field, down or right will go to the next field.
.TP
.B 0123456789!@#$%^
Add corresponding block entry from this inode to the recovery list.
.TP
.B B
Switch to block mode, examining block under cursor.
.TP
.B b
Switch to block mode, examining current block (displayed in status
line).
.TP
.B c
Copy inode to inode copy buffer.
.TP
.B e
Edit inode information.  Use the cursor to select the field you
want to edit, then hit
.B RET ^M ^J
or
.B e
and a line will pop up at the bottom of the screen, enter the new
value here.  Entering a blank line will leave the value unchanged. 

Dates can be entered in any format other than the one displayed on
the screen.  The year must be kept near the month and day.  Use formats
like "24SEP96 10:00:01" or "10:00:01 Sep 24, 1996".  "12/24/96" will
probably default to the American interpretation MM/DD/YY.  I did not
write the date parser, so I don't want to hear any complaints about it.
.TP
.B p
Paste inode from inode copy buffer.
.TP
.B r
Switch to recover mode.
.TP
.B R
Switch to recover mode, copy current inode block information into 
recovery inode.
.TP
.B #
This will prompt the user to enter a number and it will then make
that the current inode.  The number may be entered as hexadecimal 
(leading 'x', '0x', or '$'), octal (leading '\'), or decimal.
.TP
.B M-b
View inode in its raw block format.
.RE

.B Block Mode:

In block mode, the current block will be displayed in hexadecimal and
ASCII.  The numbers along the left hand side of the screen are
hexadecimal offsets from the beginning of the block.  As much
of the block as possible will be displayed.  If the block is marked
unused, the central row of ':' will spell out NOT USED.

.RS
.TP
.B PG_DOWN
Display next chunk of this block.
.TP
.B PG_UP
Display previous chunk of this block.
.TP
.B +
Make next block the current block.
.TP
.B \-
Make previous block the current block.
.TP
.B arrow
Move cursor.
.TP
.B b
View block under cursor.
.B lde
will interpret the byte under the
cursor as the start of a block pointer (as if it were part of an indirect block).
This will be a two byte pointer for the minix file system, four bytes for 
ext2fs and xiafs.
.TP
.B B
Interpret blocks under cursor as a block pointer and make it the
current block.
.TP
.B c
Copy block to copy buffer.
.TP
.B d
Dump block as a directory (see directory popup description below).
.TP
.B e
Edit the data in hex or ascii mode.  
.B TAB
(
.IR ^I )
switches between hex and ascii editing.  While in hex edit, the keys
.B A\-F
and
.B 0123456789
will not perform their lde functions, but are used to enter new data.
In ascii edit, most keys (chars 32\-126) are used to enter new data.
Characters outside this range must be entered in hex mode, they will
be displayed on the ASCII display as a period.

Editing will exit on write block (
.B ^W
) or a command which goes to another block or leaves block mode.
To discard your changes and re\-read the block use
.B ^A 
or view another block and come back.  You will always
be prompted [Yes/Discard changes/Continue edit] before a write occurs.
Select
.B y
to save the block to disk,
.B d
to discard your changes and re\-read the data from disk, or
.B c
if you made a mistake and want to go back and make some more changes
before saving this block.   

It is probably a good idea to
.IR "unmount the file system before you do any writes to it" .
My guess is that
bad things will happen if you try to write the inode/block tables while
someone else is using the filesystem.
.TP
.B I
View inode under cursor.  
.B lde
will interpret the byte under the
cursor as the start of an inode pointer (as if it were part of an directory
entry).
This will be a two byte pointer for the minix file system, four bytes for 
ext2fs and xiafs.
.TP
.B n, p
Next/previous block in file.  If the displayed file is
indexed by the current inode, you can step to the next or previous block
in the chain.
.TP
.B p
Paste block from copy buffer.
.TP
.B w
Write the current block to the recovery file.
.TP
.B 0123456789!@#$%^
tag this block to be recovered.  Under Minix, this will display
nine blocks which represent the block pointers in an inode.  0\-6 are
direct blocks, 7 is the indirect block, and 8 is the double indirect
block.  One day there may be an option for more direct blocks to make
recovery easier.  When a block is tagged, the status line will reflect
this.  To untag a block, go to recover mode and set the block's
pointer to zero.
.TP
.B #
This will prompt the user to enter a block number.  The numbers may
be entered in the same format described in inode mode (decimal, hex,
or octal).
.TP
.B ^R
Look up inode which references this block.
.RE

.B Recover Mode:

In recover mode, the tagged blocks are displayed and may be edited by
hand.  When they are correct the user can dump the file.  The user is 
prompted for a filename which can be 80 chars, the default file is
"./RECOVER.file".

.RS
.TP
.B 0123456789!@#$%^
Will prompt the user to enter a numeric value for the specified
block index.  The format of the input should be the same as that
described in inode mode.
.TP
.B c
Check that all the blocks marked for recovery are unused.  Complete
recovery will be impossible if any blocks are reported in use, but you
might be able to salvage a large chunk of your file.
.TP
.B r
Write out the recovered file.
.TP
.B u
Unmark all blocks.  The recovery inode will be filled with zeroes.
.RE

.B Directory View

Accessable from inode and block mode.  In block mode, it formats the
current block as a directory entry with no syntax checking (i.e. it
might not really be a directory block).  In inode mode, it uses the
block pointers to determine what to display.  You can use the up and
down arrow keys to scroll the display if there are too many entries to
display at once.

.TP
.B d
If the cursor is on a directory, it will follow the link and
display that directory. Use
.B D
to do the same and set the current inode to the new directory inode.
.TP
.B i
Set the current inode to the inode under the cursor.
.TP
.B I
Set the current inode and immediately view it in inode mode.
.TP
.B n, p
Next/previous block in directory.  If the directory being viewed is
indexed by the current inode, you can step to the next or previous block
in the chain.
.RE

.SH EXAMPLES (command line)

lde -I 1 -N 10 /dev/hda1
.RS
.br
Display inodes 1-10 on the screen.
.RE

lde -b 34 /dev/hda1 | more
.RS
.br
Display block 34 on the screen (formatted in hex and ascii).
.RE

lde -D 100 -N 51 /dev/hda1 > MyOuput
.RS
.br
Cat blocks 100-150 to stdout (binary data), 
which is equivalent to

dd if=/dev/hda1 of=MyOutput bs=1024 count=51 skip=100
.RE

lde -I 1 --recoverable /dev/hda5
.RS
.br
Display all inodes on /dev/hda5 which have been deleted, but can be
recovered.
.RE

lde -I 1 --recoverable /dev/hda5 | grep "Sep 23"
.RS
.br
Display all inodes on /dev/hda5 which have been deleted today 
September 23, but can be recovered.  The date format is that of
.BR ctime (3):
.RS

"Wed Jun 30 21:49:08 1993"
.RE

.B Note:
the day will have a leading space if is less than 10.
.RE

lde -b 100 --ilookup /dev/hda1
.RS
.br
Find first inode that references block 100 on /dev/hda1 (to search for
multiple occurances, use the curses interface).
.RE

lde --paranoid -T tgz --ilookup --recoverable /dev/hda5
.RS
.br
Find all tgz files which have been deleted, display possible inodes
and check if it is possible to recover the files, open the file system
read only while searching.
.RE

See docs/UNERASE included with the lde distribution for more examples
and instructions for the best way to go about restoring files.

.SH "SEE ALSO"
.BR fsck (8),
.BR fsck.minix (8),
.BR e2fsck (8),
.BR xfsck (8),
.BR debugfs (8)
.SH AUTHOR
Scott D. Heavner (sdh@po.cwru.edu)
