#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <string.h>
#include <sys/errno.h>
#include <curses.h>

#include "lcd.h"
#include "curses_drv.h"
#include "drv_base.h"
#include "mode.h"

//////////////////////////////////////////////////////////////////////////
////////////////////// For Curses Terminal Output ////////////////////////
//////////////////////////////////////////////////////////////////////////

static char icon_char = '@';


int curses_drv_init(char *device) 
{
  // Init curses...
  initscr();
  cbreak();
  noecho();
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);

  curses_drv_clear();

  lcd.wid = 20;
  lcd.hgt = 4;
  lcd.cellwid = 5;
  lcd.cellhgt = 8;
  
  // Override output functions...
  lcd.clear = curses_drv_clear;
  lcd.string = curses_drv_string;
  lcd.chr = curses_drv_chr;
  lcd.vbar = curses_drv_vbar;
  lcd.hbar = curses_drv_hbar;
  
  lcd.init = curses_drv_init;
  lcd.close = curses_drv_close;
  lcd.icon = curses_drv_icon;
  lcd.flush_box = curses_drv_flush_box;
  lcd.draw_frame = curses_drv_draw_frame;

  // Change the character used for padding the title bars...
  PAD = '#';
  // Change the character used for "..."
  ELLIPSIS = '~';
  
  return 200;  // 200 is arbitrary.  (must be 1 or more)
}

void curses_drv_close() 
{
  // Close curses
  clear();
  move(0,0);
  refresh();
  endwin();

  drv_base_close();
  
}

/////////////////////////////////////////////////////////////////
// Clears the LCD screen
//
void curses_drv_clear() 
{
  clear();
  
}


/////////////////////////////////////////////////////////////////
// Prints a string on the lcd display, at position (x,y).  The
// upper-left is (1,1), and the lower right should be (20,4).
//
void curses_drv_string(int x, int y, char string[]) 
{
  mvaddstr(y-1, x-1, string);
}

/////////////////////////////////////////////////////////////////
// Prints a character on the lcd display, at position (x,y).  The
// upper-left is (1,1), and the lower right should be (20,4).
//
void curses_drv_chr(int x, int y, char c) 
{
  if(c == 0) c = icon_char;

  mvaddch(y-1, x-1, c);
}


/////////////////////////////////////////////////////////////////
// Draws a vertical bar; erases entire column onscreen.
//
void curses_drv_vbar(int x, int len) 
{
  char map[]="_.,,ooO8";  
  
  int y;
  for(y=lcd.hgt; y > 0 && len>0; y--)
    {
      if(len >= lcd.cellhgt) lcd.chr(x, y, '8');
      else lcd.chr(x, y, map[len-1]);

      len -= lcd.cellhgt;
    }

//  move(4-len/lcd.cellhgt, x-1);
//  vline(0, len/lcd.cellhgt);
  
}

/////////////////////////////////////////////////////////////////
// Draws a horizontal bar to the right.
//
void curses_drv_hbar(int x, int y, int len) 
{
  for(; x<lcd.wid && len>0; x++)
    {
      if(len>=lcd.cellwid)
	lcd.chr(x, y, '=');
      else
	lcd.chr(x, y, '-');
      
      len -= lcd.cellwid;
    }

  
  
//  move(y-1, x-1);
//  hline(0, len/lcd.cellwid);
}


/////////////////////////////////////////////////////////////////
// Sets character 0 to an icon...
//
void curses_drv_icon(int which, char dest)
{
  if(dest == 0)
    switch(which)
    {
      case 0: icon_char = '+';  break;
      case 1: icon_char = '*';  break;
      default: icon_char = '#'; break;
    }
  
}

void curses_drv_flush_box(int lft, int top, int rgt, int bot)
{
  lcd.flush();
}


void curses_drv_draw_frame(char *dat)
{
//  border(0, 0, 0, 0,  0, 0, lcd.wid+1, lcd.hgt+1);
  
  refresh();

}

