/*
 * chvt.c - aeb - 940227 - Change virtual terminal
 */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/vt.h>

#include <lct/local.h>
#include <lct/utils.h>
#include <lct/console.h>

int main(int argc, char *argv[]) 
{
  int fd, num;
  
  if (argc != 2) 
    {
      fprintf(stderr, "Usage: %s vt_number\n",
	      strip_path(argv[0]));
      exit(1);
    }
  if (-1 == (fd = get_console_fd(NULL))) exit (1);
  
  num = atoi(argv[1]);
  if (ioctl(fd,VT_ACTIVATE,num)) 
    {
      perror("chvt: VT_ACTIVATE");
      exit(1);
    }
  if (ioctl(fd,VT_WAITACTIVE,num)) 
    {
      perror("VT_WAITACTIVE");
      exit(1);
    }
  exit(0);
}
