/*
 * call: setkeycode scancode keycode ...
 *  (where scancode is either xx or e0xx, given in hexadecimal,
 *   and keycode is given in decimal)
 *
 * aeb, 941108
 */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/kd.h>

#include <lct/local.h>
#include <lct/utils.h>
#include <lct/console.h>

char* progname;

void usage() 
{
  fprintf(stderr,
	  "Usage: %s scancode keycode ...\n"
	  " (where scancode is either xx or e0xx, given in hexadecimal,\n"
	  "  and keycode is given in decimal)\n", progname);
}

void main(int argc, char **argv) 
{
  char *ep;
  int fd, sc;
  struct kbkeycode a;
  
  progname = strip_path(argv[0]);
  
  if (argc % 2 != 1)
      badusage("even number of arguments expected");
  if (-1 == (fd = get_console_fd(NULL)))
      exit (1);

  while (argc > 2) 
    {
      a.keycode = atoi(argv[2]);
      a.scancode = sc = strtol(argv[1], &ep, 16);
      if (*ep)
	  badusage("error reading scancode");
      if (a.scancode > 127) 
	{
	  a.scancode -= 0xe000;
	  a.scancode += 128;
	}
      if (a.scancode > 255 || a.keycode > 127)
	  badusage("code outside bounds");
      if (ioctl(fd,KDSETKEYCODE,&a)) 
	{
	  perror("KDSETKEYCODE");
	  fprintf(stderr, "failed to set scancode %x to keycode %d\n",
		  sc, a.keycode);
	  exit(1);
	}
      argc -= 2;
      argv += 2;
    }
  exit(0);
}
