;; $Id: dblink.dsl 1.1 1998/05/13 17:30:21 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= LINKS AND ANCHORS ==========================

(element link
  (let* ((endterm (attribute-string (normalize "endterm")))
	 (linkend (attribute-string (normalize "linkend")))
	 (target  (if endterm
		      (element-with-id endterm)
		      (element-with-id linkend))))
    (if (node-list-empty? target)
	(if endterm
	    (literal "LINK ENDTERM POINTS TO NON-EXISTANT ID: " endterm)
	    (process-children))
	(if endterm
	    (make link 
	      destination: (node-list-address (element-with-id endterm))
	      (with-mode xref-endterm-mode (process-element-with-id endterm)))
	    (make link 
	      destination: (node-list-address (element-with-id linkend))
	      (process-children))))))

(element olink ($charseq$))
(element ulink ($charseq$))

(element footnoteref 
  (process-element-with-id (attribute-string (normalize "linkend"))))

(element anchor (empty-sosofo))
(element beginpage (empty-sosofo))

;; ======================================================================

(element xref
  (let* ((endterm (attribute-string (normalize "endterm")))
	 (linkend (attribute-string (normalize "linkend")))
	 (target  (element-with-id linkend)))
    (if (node-list-empty? target)
	(literal "[xref to non-existent element '" linkend "']")
	(if endterm
	    (if (node-list-empty? (element-with-id endterm))
		(literal "[xref endterm to non-existent element '" endterm "']")
		(make link 
		  destination: (node-list-address (element-with-id endterm))
		  (with-mode xref-endterm-mode 
		    (process-element-with-id endterm))))
	    (make link 
	      destination: (node-list-address target)
	      (if (attribute-string (normalize "xreflabel") target)
		  (xreflabel-sosofo (attribute-string (normalize "xreflabel") target))
		  (auto-xref target)))))))

(mode xref-endterm-mode
  (default
    (make sequence
      font-posture: 'italic
      (process-children-trim))))

(define (xreflabel-sosofo xreflabel)
  (make sequence
    font-posture: 'italic
    (literal xreflabel)))

;; ======================================================================

;; Returns the title of the element as a sosofo, italicized for xref.
;;
(define (element-title-xref-sosofo nd)
  (make sequence
    font-posture: 'italic
    (element-title-sosofo nd)))

(mode xref-title-mode
  (element title
    (process-children-trim))

  (element refname
    (process-children-trim))

  (element refentrytitle
    (process-children-trim))
)


;; ======================================================================

(define (element-page-number-sosofo target)
  (with-mode pageno-mode
	(process-node-list target)))

(mode pageno-mode
  (default
    (current-node-page-number-sosofo)))

;; ======================================================================

