;; $Id: dbblock.dsl 1.11 1998/08/28 17:04:36 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(element revhistory ($book-revhistory$))

(element highlights ($block-container$))

(element blockquote
  (make paragraph
	font-size: (* %bf-size% %smaller-size-factor%)
	line-spacing: (* %bf-size% %line-spacing-factor%
			 %smaller-size-factor%)
	space-before: %para-sep%
	start-indent: (+ (inherited-start-indent) 1em)
	end-indent: 1em
	(process-children)))

(element epigraph ($block-container$))

(element attribution ($paragraph$))

(element para ($paragraph$))
(element simpara ($paragraph$))

(element formalpara ($para-container$))

(element (formalpara title) ($runinhead$))
(element (formalpara para) (make sequence (process-children)))

(element sidebar ($semiformal-object$))
(element (sidebar title) (empty-sosofo))

(element abstract (process-children))

(element (abstract para) 
  (make paragraph
    use: para-style
    space-before: %para-sep%
    space-after: %para-sep%
    start-indent: %body-start-indent%
    (process-children-trim)))

(element authorblurb ($block-container$))

(define ($inline-object$)
  (process-children))

(define ($informal-object$)
  (make display-group
    start-indent: (+ %block-start-indent% (inherited-start-indent))
    space-before: %block-sep%
    space-after: %block-sep%
    (process-children)))

(define ($formal-object$)
  (make sequence
    (with-mode formal-object-title-mode
      (process-node-list (select-elements (children (current-node)) (normalize "title"))))
    (make paragraph
      use: para-style
      font-weight: 'bold
      space-before: 0pt
      space-after: %block-sep%
      start-indent: (+ %block-start-indent% (inherited-start-indent))
      (process-children))))

(define ($semiformal-object$)
  (if (node-list-empty? (select-elements (children (current-node)) (normalize "title")))
      ($informal-object$)
      ($formal-object$)))

(mode formal-object-title-mode
  (element title
    (let* ((object (parent (current-node)))
	   (nsep   (gentext-label-title-sep (gi object))))
      (make paragraph
	use: para-style
	font-weight: 'bold
	space-before: %block-sep%
	space-after: %para-sep%
	start-indent: (+ %block-start-indent% (inherited-start-indent))
	keep-with-next?: #t
	(literal (gentext-element-name object))
	(if (string=? (element-label object) "")
	    (literal nsep)
	    (literal " " (element-label object) nsep))
	(process-children))))
)

(element example ($formal-object$))

(element (example title) (empty-sosofo)) ; don't show caption below example
(element informalexample ($informal-object$))

(element (figure title) (empty-sosofo)) ; don't show caption below figure

(element figure ($formal-object$))

(element informaltable ($informal-object$))

(element table 
  ;; can't be a "formal-object" because it requires special handling for
  ;; the PGWIDE attribute
  (let* ((nsep   (gentext-label-title-sep (gi)))
	 (pgwide (attribute-string (normalize "pgwide")))
	 (indent (lambda () (if (not (equal? pgwide "1"))
				(+ %block-start-indent% 
				   (inherited-start-indent))
				%cals-pgwide-start-indent%))))
    (make sequence
      (make paragraph
	use: para-style
	font-weight: 'bold
	space-before: %block-sep%
	space-after: %para-sep%
	start-indent: (indent)
	keep-with-next?: #t
	(literal (gentext-element-name (current-node)))
	(if (string=? (element-label) "")
	    (literal nsep)
	    (literal " " (element-label) nsep))
	(element-title-sosofo))
      (make paragraph
	use: para-style
	font-weight: 'bold
	space-before: 0pt
	space-after: %block-sep%
	start-indent: (indent)
	(process-children)))))

(element (table title) (empty-sosofo))

;; ======================================================================
;; Handle footnotes in the body...

(define %footnote-field-width% 1.6em)
(define %footnote-number-restarts% #t)
(define %footnote-endnote-break% #f)

(define (footnote-number footnote)
  (if %footnote-number-restarts%
      (format-number (component-child-number footnote 
					     (component-element-list)) 
		     "1")
      (format-number (component-child-number footnote 
					     (list (normalize "book")))
		     "1")))

(element footnote 
  ($ss-seq$ + (literal (footnote-number (current-node)))))

(define (non-table-footnotes footnotenl)
  (let loop ((nl footnotenl) (result (empty-node-list)))
    (if (node-list-empty? nl)
	result
	(if (has-ancestor-member? (node-list-first nl) 
				  ($table-element-list$))
	    (loop (node-list-rest nl) 
		  result)
	    (loop (node-list-rest nl)
		  (node-list result (node-list-first nl)))))))

(define (make-endnote-header)
  (let ((headsize (if (equal? (gi) (normalize "refentry"))
		      (HSIZE 2)
		      (HSIZE 3)))
	(indent   (lambda () (if (equal? (gi) (normalize "refentry"))
				 %body-start-indent%
				 0pt))))
    (make paragraph
      break-before: %footnote-endnote-break%
      font-family-name: %title-font-family%
      font-weight: 'bold
      font-size: headsize
      line-spacing: (* headsize %line-spacing-factor%)
      space-before: (* headsize %head-before-factor%)
      space-after: (* headsize %head-after-factor%)
      start-indent: (indent)
      quadding: 'start
      keep-with-next?: #t
      (literal (gentext-endnotes)))))

(define (make-endnotes)
  (let* ((allfootnotes (select-elements (descendants (current-node)) 
					(normalize "footnote")))
	 (footnotes    (non-table-footnotes allfootnotes)))
    (if (node-list-empty? footnotes) 
	(empty-sosofo)
	(if (or (equal? (gi (current-node)) (normalize "reference"))
		(equal? (gi (current-node)) (normalize "part")))
	    (empty-sosofo) ;; Each RefEntry/Component does its own...
	    (make sequence
	      (make-endnote-header)
	      (with-mode endnote-mode
		(process-node-list footnotes)))))))

(mode endnote-mode
  (element footnote
    (make sequence
      start-indent: %body-start-indent%
      (process-children)))

  (element (footnote para)
    (let ((fnnum  (footnote-number (parent (current-node)))))
      (if (= (child-number) 1)
	  (make paragraph
	    use: para-style
	    space-before: %para-sep%
	    start-indent: (+ (inherited-start-indent) %footnote-field-width%)
	    first-line-start-indent: (- %footnote-field-width%)
	    (make line-field
	      field-width: %footnote-field-width%
	      (literal fnnum 
		       (gentext-label-title-sep (normalize "footnote"))))
	    (process-children-trim))
	  (make paragraph
	    use: para-style
	    start-indent: (+ (inherited-start-indent) %footnote-field-width%)
	    space-before: %para-sep%
	    (process-children-trim))))))

;; ======================================================================
;; Handle table footnotes

(define (table-footnote-number footnote)
  (format-number (component-child-number footnote 
					 ($table-element-list$)) "a"))

(element (entry footnote)
  ($ss-seq$ + (literal (table-footnote-number (current-node)))))

(element (entry para footnote)
  ($ss-seq$ + (literal (table-footnote-number (current-node)))))

(define (make-table-endnote-header)
  (make paragraph
    font-family-name: %body-font-family%
    font-weight: 'medium
    font-size: %bf-size%
    start-indent: 0pt
    quadding: 'start
    (literal (gentext-table-endnotes))))

(define (make-table-endnotes)
  (let* ((footnotes (select-elements (descendants (current-node)) 
				     (normalize "footnote")))
	 (headsize (HSIZE 3))
	 (tgroup (ancestor-member (current-node) (list (normalize "tgroup"))))
	 (cols   (string->number (attribute-string (normalize "cols") tgroup))))
    (if (node-list-empty? footnotes) 
	(empty-sosofo)
	(make table-row
	  (make table-cell
	    n-columns-spanned: cols
	    cell-before-row-margin: %cals-cell-before-row-margin%
	    cell-after-row-margin: %cals-cell-after-row-margin%
	    cell-before-column-margin: %cals-cell-before-column-margin%
	    cell-after-column-margin: %cals-cell-after-column-margin%
	    start-indent: %cals-cell-content-start-indent%
	    end-indent: %cals-cell-content-end-indent%
	    (make-table-endnote-header)
	    (with-mode table-footnote-mode
	      (process-node-list footnotes)))))))

(mode table-footnote-mode
  (element footnote
    (process-children))

  (element (footnote para)
    (let ((fnnum (table-footnote-number (parent (current-node)))))
      (if (= (child-number) 1)
	  (make paragraph
	    use: para-style
	    start-indent: %footnote-field-width%
	    first-line-start-indent: (- %footnote-field-width%)
	    (make line-field
	      field-width: %footnote-field-width%
	      (literal fnnum 
		       (gentext-label-title-sep (normalize "footnote"))))
	    (process-children-trim))
	  (make paragraph
	    use: para-style
	    start-indent: %footnote-field-width%
	    (process-children-trim))))))

