;; $Id: dbadmon.dsl 1.2 1998/05/13 17:32:25 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================ ADMONITIONS =============================

(define ($admonition$)
  (let ((titles (select-elements (children (current-node)) (normalize "title"))))
    (make element gi: "BLOCKQUOTE"
	  attributes: (list
		       (list "CLASS" (gi)))
	  (process-children))))
;;	  (if (not (node-list-empty? titles))
;;	      (make element gi: "P"
;;		    (make element gi: "B"
;;			  (with-mode title-mode
;;			    (process-first-descendant "TITLE"))))
;;	      (empty-sosofo))
;;	  (process-children))))

(define ($admonpara$)
  (let* ((title     (select-elements 
		     (children (parent (current-node))) (normalize "title")))
	 (has-title (not (node-list-empty? title)))
	 (adm-title (if has-title 
			(make sequence
			  (with-mode xref-title-mode
			    (process-node-list (node-list-first title)))
			  (literal (gentext-label-title-sep 
				    (gi (parent (current-node))))))
			(literal
			 (gentext-element-name 
			  (gi (parent (current-node))))
			 (gentext-label-title-sep 
			  (gi (parent (current-node))))))))
    (make element gi: "P"
	  (if (= (child-number) 1)
	      (make element gi: "B"
		    adm-title)
	      (empty-sosofo))
	  (process-children))))

(element important ($admonition$))
(element (important title) (empty-sosofo))
(element (important para) ($admonpara$))
(element (important simpara) ($admonpara$))
(element note ($admonition$))
(element (note title) (empty-sosofo))
(element (note para) ($admonpara$))
(element (note simpara) ($admonpara$))
(element tip ($admonition$))
(element (tip title) (empty-sosofo))
(element (tip para) ($admonpara$))
(element (tip simpara) ($admonpara$))

;; perils are given special treatment by generating a centered title
;;   and throwing a box around them
;;
(define ($peril$)
  (let* ((title     (select-elements 
		     (children (current-node)) (normalize "title")))
	 (has-title (not (node-list-empty? title)))
	 (adm-title (if has-title 
			(make sequence
			  (with-mode xref-title-mode
			    (process-node-list (node-list-first title))))
			(literal
			 (gentext-element-name 
			  (gi (current-node)))))))
    (make element gi: "TABLE"
	  attributes: (list
		       (list "CLASS" (gi))
		       (list "BORDER" "1")
		       (list "WIDTH" "100%"))
	  (make element gi: "TR"
		(make element gi: "TD"
		      attributes: (list
				   (list "ALIGN" "CENTER"))
		      (make element gi: "B"
			    adm-title)))
	  (make element gi: "TR"
		(make element gi: "TD"
		      attributes: (list
				   (list "ALIGN" "LEFT"))
		      (process-children))))))

(element caution ($peril$))
(element warning ($peril$))
(element (caution title) (empty-sosofo))
(element (warning title) (empty-sosofo))
