#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <proplist.h>

#include "../src/wsconfig.h"

char *ProgName;

static char *options[] = {
	"AppExit",
	"AppStart",
	"Hide",
	"Iconify",
	"Maximize",
	"UnMaximize",
	"Shade",
	"Startup",
	"UnHide",
	"DeIconify",
	"UnShade",
	"UserDefined",
	NULL
};

char* defaultsPathForDomain(char *domain)
{
    char path[1024];
    char *gspath, *tmp;

    gspath = getenv("GNUSTEP_USER_ROOT");
    if (gspath) {
	strcpy(path, gspath);
	strcat(path, "/");
    } else {
	char *home;
	
	home = getenv("HOME");
	if (!home) {
	    printf("%s:could not get HOME environment variable!\n", ProgName);
	    exit(0);
	}
	strcpy(path, home);
	strcat(path, "/GNUstep/");
    }
    strcat(path, DEFAULTS_DIR);
    strcat(path, "/");
    strcat(path, domain);

    tmp = malloc(strlen(path)+2);
    strcpy(tmp, path);
    return tmp;
}


int main(int argc, char **argv) {
	proplist_t prop, style, key, val;
	char *path, *style_file = NULL;
	int i;


	ProgName = argv[0];
	
	if(argc > 2) {
		printf("usage: %s [<style file>]\n\r",ProgName);
		exit(1);
	} else if (argc > 0){
		style_file = argv[1];
	}
	
	path = defaultsPathForDomain(CFG_DOMAIN);
	
	if((prop=PLGetProplistWithPath(path)) == NULL) {
		printf("%s:could not load WindowMaker configuration file \"%s\".\n",ProgName,path);
		exit(1);
	}
	
	style = PLMakeDictionaryFromEntries(NULL,NULL,NULL);
	
	
	for(i=0;options[i]!=NULL;i++) {
		key = PLMakeString(options[i]);
		val = PLGetDictionaryEntry(prop,key);
		if(val) 
			PLInsertDictionaryEntry(style,key,val);
	}

	
	if(style_file) {
		PLSetFilename(style,PLMakeString(style_file));
		PLSave(style,YES);
	} else {
		puts(PLGetDescriptionIndent(style,0));
	}
	
	PLRelease(prop);
	return 1;
}
