/*
 *  defines for mixer
 */

#ifdef __DRIVER_STRU__

#define MIX_MIC         0
#define MIX_LINE        1
#define MIX_CD          2
#define MIX_GF1         3
#define MIX_PCM         4
#define MIX_PCM1	5
#define MIX_GAIN        6
#define MIX_MASTER      7
#define MIX_GF1_MASTER	8
#define MIX_LOOPBACK	9
#define MIX_EFFECTS	10
#define MIX_LAST        (MIX_EFFECTS+1)

#define MIX_MUTE_LEFT	1
#define MIX_MUTE_RIGHT	2
#define MIX_MUTE	(MIX_MUTE_LEFT|MIX_MUTE_RIGHT)

struct GUS_STRU_MIX {
  short mute;		/* 0 = mute on (see MIX_MUTE_??) */
  short left;
  short right;
};

struct GUS_STRU_MIXER {
  struct GUS_STRU_MIX curr[ MIX_LAST ];
  unsigned char mix_ctrl_reg;
  short codec_mute_output;
  short soft_volume_level;	/* 0 - 127 */
  short pcm_volume_level_left;	/* 0 - 127 */
  short pcm_volume_level_right;	/* 0 - 127 */
  short effect_volume_level;	/* 0 - 127 */
  unsigned int mix_devs;
  unsigned int mix_stereo_devs;
  unsigned int mix_rec_devs;
  unsigned int mix_rec_src;
};

#endif /* __DRIVER_STRU__ */
