/*
 *  Instrument configuration header file...
 *  Copyright (c) 1997 by Jaroslav Kysela <perex@jcu.cz>.
 */

/* defines */

#define GUS_ICFG_SOURCE_AUTO	"auto"

#define GUS_ICFG_PTR_NONE	0
#define GUS_ICFG_PTR_GF1PATHS	1
#define GUS_ICFG_PTR_IWFILES	2
#define GUS_ICFG_PTR_INSTRUMENTS 3
#define GUS_ICFG_PTR_GROUPS	4

#define GUS_ICFG_IT_NONE	0x0000
#define GUS_ICFG_IT_ALIAS	0x0001
#define GUS_ICFG_IT_GF1_PATCH	0x0002
#define GUS_ICFG_IT_IW_FILE	0x0003
#define GUS_ICFG_IT_COUNT	3

#define GUS_ICFG_IWF_DOWNLOAD	0x0001
#define GUS_ICFG_IWF_LOCK	GUS_ICFG_IWF_DOWNLOAD
#define GUS_ICFG_IWF_ROM	0x0002
#define GUS_ICFG_IWF_TEMP	0x0004

#define GUS_ICFG_IF_NONE	0x0000
#define GUS_ICFG_IF_DISABLE	0x0001
#define GUS_ICFG_IF_8BIT	0x0002

#define GUS_ICFG_PF_NONE	0x0000
#define GUS_ICFG_PF_8BIT	0x0001
#define GUS_ICFG_PF_WHOLE	0x0002
#define GUS_ICFG_PF_FFFF_WHOLE	GUS_ICFG_PF_WHOLE

#define GUS_ICFG_CHIP_NONE	0x0000
#define GUS_ICFG_CHIP_UART	0x0001
#define GUS_ICFG_CHIP_GF1	0x0002
#define GUS_ICFG_CHIP_INTERWAVE	0x0003

#define GUS_ICFG_INFO_SOURCE	0x0000
#define GUS_ICFG_INFO_PRELOAD	0x0001
#define GUS_ICFG_INFO_EXTERNAL	0x0002

#define GUS_ICFG_GROUP_MELODIC	0x0000
#define GUS_ICFG_GROUP_DRUMS	0x0001

/* configuration structures */

struct gus_icfg_gf1path {
  unsigned short directory;
  unsigned char *path;
  struct gus_icfg_gf1path *next;
};

struct gus_icfg_iwfile {
  unsigned short flags;
  unsigned short number;
  int handle;
  union {
    struct {
      unsigned char *name;
      unsigned char *data;
    } file;
    struct {
      unsigned short bank;
      unsigned short file;
      unsigned char *name;
    } rom;
  } data;
  struct gus_icfg_iwfile *next;
};

struct gus_icfg_instrument {
  unsigned char *name;
  unsigned int number;
  unsigned short type;
  unsigned short flags;
  signed short voices;
  union {
    struct {
      unsigned short bank;
      unsigned short prog;
    } alias;
    struct {
      unsigned short directory;
      unsigned char *filename;
      unsigned char exclusion;
      unsigned short exclusion_group;
    } patch;
    struct {
      unsigned short file;
      unsigned char bank;
      unsigned char prog;
    } iwfile;
  } data;
  struct gus_icfg_instrument *next;
}; 

struct gus_icfg_group_range {
  unsigned short bank;
  unsigned short min, max;
  struct gus_icfg_group_range *next;
};

struct gus_icfg_group {
  int number;
  int type;
  char *name;
  struct gus_icfg_group_range *first;
  struct gus_icfg_group *next;
};

struct gus_icfg_preload_download {
  unsigned short bank;
  unsigned short min, max;
  struct gus_icfg_preload_download *next;
};

struct gus_icfg_preload_alias {
  unsigned short bank;
  unsigned short min, max;
  unsigned short dest_bank;
  unsigned short dest_prog;
  struct gus_icfg_preload_alias *next;
};

struct gus_icfg_preload_format {
  unsigned short type;		/* see to GUS_ICFG_IT_XXXX constants */
  unsigned short flags;		/* see to GUS_ICFG_PF_XXXX constants */
  struct gus_icfg_preload_download *downloads;
  struct gus_icfg_preload_alias *aliases;
  union {
#if 0
    struct {
    } patch;
#endif
    struct {
      unsigned short file;
    } iwrom;
    struct {
      unsigned short file;
    } iwfile;
  } data;
  struct gus_icfg_preload_format *next;
};

struct gus_icfg_preload {
  unsigned char *name;
  struct gus_icfg_preload_format *formats;
  struct gus_icfg_preload *next;
};

struct gus_icfg_info {
  unsigned short type;
  char *name;
  char *description;
  char **options;
  struct gus_icfg_info *next;
};

/* --- */

struct gus_icfg_open {
  int version;		/* currently 11 */
  char *filename;
  int card;		/* 0-7 */
  int gus_fd;		/* -1 -> database access only */
  int gus_access;	/* -1 -> database access only */
  int device;
  int emulation; 
  int chip;		/* database access -> chip info */
  void *privatedata;	/* for example pointer to this */
  void (*error)( void *privatedata, int device, int warning, char *filename, int line, char *format, va_list va );
  int (*memory_alloc)( void *privatedata, int device, gus_instrument_t *instrument );
  int (*memory_test)( void *privatedata, int device, unsigned int instrument );
};

/* configuration functions */

void gus_icfg_free_gf1path( struct gus_icfg_gf1path *pgf1path );
void gus_icfg_free_iwfile( struct gus_icfg_iwfile *piwfile );
void gus_icfg_free_instrument( struct gus_icfg_instrument *pinstrument );
void gus_icfg_free_group_range( struct gus_icfg_group_range *prange );
void gus_icfg_free_group( struct gus_icfg_group *pgroup );
void gus_icfg_free_preload_download( struct gus_icfg_preload_download *pdownload );
void gus_icfg_free_preload_alias( struct gus_icfg_preload_alias *paliases );
void gus_icfg_free_preload_format( struct gus_icfg_preload_format *pformat );
void gus_icfg_free_preload( struct gus_icfg_preload *ppreload );
void gus_icfg_free_info( struct gus_icfg_info *pinfo );

int gus_icfg_open( void **handle, struct gus_icfg_open *icfg );
int gus_icfg_close( void *handle );
void *gus_icfg_handle( int device );
void *gus_icfg_ptrget( void *handle, int ptrtype );
int gus_icfg_emulation_set( void *handle, int emul );
int gus_icfg_emulation_get( void *handle );
int gus_icfg_info( void *handle, struct gus_icfg_info **info );
int gus_icfg_load( void *handle, char *source, char *options );
int gus_icfg_preload( void *handle, char *source, char *options );
int gus_icfg_download( void *handle, unsigned int instrument );
void gus_icfg_unload( void *handle );
