#include <stdio.h>
#include <libgus.h>
#include <assert.h>

#define DEVICE	( device -> device )

void main()
{
  int i;
  gus_midi_device_t *device;

  if ( gus_midi_open_intelligent( GUS_MIDI_OUT, NULL, 2048, 0 ) < 0 )
    {
      printf( "open error: %s\n", gus_midi_error );
      return;
    }
  device = gus_midi_output_devices();
  assert( device );
#if 1
  for ( i = 0; i < 128; i++ )
    {
      printf( "Instrument %i: ", i ); fflush( stdout );
      gus_midi_reset();
      if ( device -> cap & GUS_MIDI_CAP_MEMORY )
        {
          gus_midi_memory_reset( DEVICE );
          gus_midi_preload_program( DEVICE, &i, 1 );
        }
      gus_midi_timer_base( 100 );
      gus_midi_timer_tempo( 100 );
      gus_midi_timer_start();
      gus_midi_program_change( DEVICE, 0, i );
      gus_midi_note_on( DEVICE, 0, 60, 128 );
      gus_midi_wait( 200 );
      gus_midi_note_off( DEVICE, 0, 60, 128 );
      gus_midi_wait( 200 );
      gus_midi_flush();
      gus_midi_timer_stop();
      printf( "done\n" );
    }
#endif
#if 0
  getchar();
#endif
  gus_midi_close();
}
