.Dd July 11, 1994
.Dt MIDIDEVICE N
.Os
.Sh NAME
.Nm mididevice
.Nd "tclmidi command to create a MIDI device and modify the configuration"
.Sh SYNOPSIS
.Nm
DeviceName
.Op midithru value
.Op slave MasterDevID
.Op channel_on ChannelList
.Op channel_off ChannelList
.Br
.Nm
DevID
.Op close
.Op midithru Op value
.Op slave MasterDevID
.Op channel_on Op ChannelList
.Op channel_off Op ChannelList
.Br
.Nm
.Sh DESCRIPTION
.Nm
is a
.Xr tclmidi 1
command that
creates a MIDI device and allows you to modify the configuration of
an existing device if
.Nm tclmidi
was built with device support.
A device driver for some MIDI interfaces is included with this
release for the following architectures:
.Bl -item -offset indent -compact
.It
BSD/OS
.It
Linux
.It
FreeBSD
.It
SVR4
.El
The first form of
.Nm
is used when the device is created for the first time.
The second form is used once the device has been created.
.Pp
The first parameter is the device identifier.
In the first case, it should be a path name for the device.
Something like,
.Pa /dev/midi0 .
In the second form it is a device identifier returned from a call
to the first form.
In the third form,
.Nm
returns a
.Dq 1
or
.Dq 0 .
A
.Dq 1
is returned if
.Nm tclmidi
was built with MIDI device support
and a
.Dq 0
is returned if it does not have device support.
.Pp
The remaining arguments are parameters or commands that can be used
to query or modify the device configuration.
.Bl -tag -width channel_off
.It close
This command can only be used once a device has been created by
the first form of this command.
It closes the device.
Once the device has been closed, it cannot be used again until it
is reopened by a call to the first form of the
.Nm
command.
.It midithru
Without a value, this command returns the status of midithru.
It will return
.Dq on
if midithru is enabled, and
.Dq off
if it is disabled.
If a value is specified is should be a boolean value from one of,
.Dq on ,
.Dq yes ,
.Dq 1 ,
.Dq off ,
.Dq no
or
.Dq 0 .
The device will be conigured to the specified value.
.It slave
This command allows the device to be made a slave to another.
When a device is a slave, it will be synchronized to the master.
It will not begin playing until the master device does and will
stay in time with the master.
Each device can only have one master, but a master device can
have any number of slaves.
The MasterDevID is the device ID of the master device as returned
from a call to the first form of
.Nm .
The slave feature is useful if you want to play a MIDI song that
has more than 16 channels, and you have multiple hardware MIDI
interfaces.
.It channel_on
Without an argument, this command returns the current list of all
channels that are active.
With an argument, it will add a list of channels to the current
active list.
The active list is a list off all channels that will receive events.
If a channel is inactive, any events on it will be masked.
By default, all channels are active.
.It channel_off
This is similar to the channel_on option, but returns a list off
all channels that are inactive.
If an argument is specified, it will remove a list of channels from
the current active list.
.El
.Sh RETURN VALUES
In the first form, 
.Nm
returns a device ID that can be used in later calls to
.Nm
or calls to other functions that deal with the MIDI interface.
In the second form it returns values according to the options
specified.
See the list above for details.
In the third case,
.Nm
returns a
.Dq 1
or
.Dq 0
depending if
.Nm tclmidi
was built with device support or not.
.Sh SEE ALSO
.Xr tclmidi 1 ,
.Xr midifeature n ,
.Xr midiplay n ,
.Xr midirecord n ,
.Xr midistop n ,
.Xr midiwait n
.Sh AUTHOR
Mike Durian - durian@boogie.com
