/*==============================================================================

  $Id: drv_raw.c,v 1.6 1998/09/20 21:45:16 miod Exp $

  Mikmod driver for output to a file called MUSIC.RAW

==============================================================================*/

/*
	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <mikmod.h>

static	int rawout=-1;
#define RAWBUFFERSIZE 8192
static	SBYTE RAW_DMABUF[RAWBUFFERSIZE];

BOOL RAW_IsThere(void)
{
	return 1;
}

BOOL RAW_Init(void)
{
	if((rawout=open("music.raw",O_RDWR|O_TRUNC|O_CREAT,S_IREAD|S_IWRITE))<0) {
		_mm_errno=MMERR_OPENING_FILE;
		return 1;
	}
	md_mode|=DMODE_SOFT_MUSIC|DMODE_SOFT_SNDFX;

	if(VC_Init()) {
		return 1;
	}
	return 0;
}

void RAW_Exit(void)
{
	VC_Exit();
	if (rawout>=0) {
		close(rawout);
		rawout=-1;
	}
}

void RAW_Update(void)
{
	write(rawout,RAW_DMABUF,VC_WriteBytes(RAW_DMABUF,RAWBUFFERSIZE));
}

BOOL RAW_Reset(void)
{
	return 0;
}

MDRIVER drv_raw={
	NULL,
	"music.raw file",
	"RAW [music.raw] file output driver v1.1",
	0,255,
	RAW_IsThere,
	VC_SampleLoad,
	VC_SampleUnload,
	VC_SampleSpace,
	VC_SampleLength,
	RAW_Init,
	RAW_Exit,
	RAW_Reset,
	VC_SetNumVoices,
	VC_PlayStart,
	VC_PlayStop,
	RAW_Update,
	VC_VoiceSetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceSetPanning,
	VC_VoicePlay,
	VC_VoiceStop,
	VC_VoiceStopped,
	VC_VoiceReleaseSustain,
	VC_VoiceGetPosition,
	VC_VoiceRealVolume
};

