/* lowlevel.c
 * Contains functions for manipulating the radio card through either
 * the kernel interface or direct port i/o
 */

/* (c) 1998 by Keith Wesolowski (wesolows@cs.unr.edu) 

 * Portions of the direct i/o routines are (c)1996 Thomas Lehmann,
 * Gideon LaGrange, and/or Franz Brinkman.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */ 

#include "gradio.h" 
#include <unistd.h>

#ifndef NO_KERNEL
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/types.h>
#include <linux/videodev.h>
#endif /* NO_KERNEL */

extern radio_status gr_stat;

/* Determine and return the appropriate frequency multiplier for
   the first tuner on the open video device with handle FD. */
double gradio_get_freq_fact (int fd)
{
#ifndef NO_KERNEL
	struct video_tuner tuner;
	tuner.tuner = 0;
	if (ioctl (fd, VIDIOCGTUNER, &tuner) < 0)
	    return .016;
	if ((tuner.flags & VIDEO_TUNER_LOW) == 0)
	    return .016;
#endif /* NO_KERNEL */
	return 16;
}

int gradio_setfreq (int fr)
{
    if (fr > GR_FREQ_MAX)
	fr = GR_FREQ_MAX;
    if (fr < GR_FREQ_MIN)
	fr = GR_FREQ_MIN;

    gr_stat.muted = FALSE;
	
    if (gr_stat.interface == GR_IF_KERNEL) {
#ifndef NO_KERNEL
	struct video_tuner v;
	int fd = open (DEV_NAME, O_RDONLY);
	unsigned long xl_freq = (unsigned long)(fr*gradio_get_freq_fact(fd)
						+ 0.5);
	v.tuner = 0;
	ioctl (fd, VIDIOCSFREQ, &xl_freq);
	ioctl (fd, VIDIOCGTUNER, &v);
	close (fd);
	gr_stat.tuned = (v.signal != 0);
#endif /* NO_KERNEL */
	return (gr_stat.freq = fr);
    } else {
	unsigned long int bits;
	int i, mask;
	
	bits = (long unsigned int)((fr/25) + 10486188);
	mask = 1;
	for( i=0; i<24; ++i ) {
	    if (( bits & mask) == 0 ) {
		gradio_write_card (gr_stat.port, 0x1);
		gradio_write_card (gr_stat.port, 0x1);
		gradio_write_card (gr_stat.port, 0x3);
		gradio_write_card (gr_stat.port, 0x3);
	    } else {
		gradio_write_card (gr_stat.port, 0x5);
		gradio_write_card (gr_stat.port, 0x5);
		gradio_write_card (gr_stat.port, 0x7);
		gradio_write_card (gr_stat.port, 0x7);
	    }
	    mask *= 2;
	}
	gradio_write_card (gr_stat.port, 0xf8);
	usleep (150000);
	gr_stat.tuned = (gradio_read_card (gr_stat.port) == 0xfd) ? TRUE : FALSE;
	gradio_write_card (gr_stat.port, 0x00);
	gradio_write_card (gr_stat.port, 0xc8);
    }    
    return (gr_stat.freq = fr);
}

int gradio_setvol (int lvl)
{
    if (lvl > GR_VOL_MAX)
	lvl = GR_VOL_MAX;
    if (lvl < GR_VOL_MIN)
	lvl = GR_VOL_MIN;

    if (gr_stat.interface == GR_IF_KERNEL) {
#ifndef NO_KERNEL
	struct video_audio va;
	int fd = open (DEV_NAME, O_RDONLY);
	va.flags = VIDEO_AUDIO_VOLUME;
	va.audio = 0;
	va.volume = lvl * (65535/(GR_VOL_MAX-GR_VOL_MIN));
	ioctl (fd, VIDIOCSAUDIO, &va);
	close (fd);
#endif /* NO_KERNEL */
	return (gr_stat.vol = lvl);
    } else {
	if (lvl == gr_stat.vol)
	    return lvl;
	if (lvl > gr_stat.vol) {
	    int i;
	    for (i=0; i<(lvl-gr_stat.vol); i++) {
		gradio_write_card (gr_stat.port, 0x88); 
		usleep (100000);
		gradio_write_card (gr_stat.port, 0xc8);
	    }
	    return (gr_stat.vol = lvl);
	}
	if (lvl < gr_stat.vol) {
	    int i;
	    for (i=0; i<(gr_stat.vol-lvl); i++) {
		gradio_write_card (gr_stat.port, 0x48);
		usleep (100000);
		gradio_write_card (gr_stat.port, 0xc8);
	    }
	    return (gr_stat.vol = lvl);
	}
	return gr_stat.vol;
    }
}

void gradio_mute (int state)
{
    if (gr_stat.interface == GR_IF_KERNEL) {
#ifndef NO_KERNEL
	if (state == TRUE) {
	    struct video_audio va;
	    int fd = open (DEV_NAME, O_RDONLY);
	    va.flags = VIDEO_AUDIO_MUTE;
	    va.audio = 0;
	    ioctl (fd, VIDIOCSAUDIO, &va);
	    close (fd);
   	    gr_stat.muted = TRUE;
	} else {
	    int temp = gr_stat.vol;
	    gr_stat.vol = 0;
	    gradio_setvol (temp);
	    gr_stat.vol = temp;
	    gr_stat.muted = FALSE;
	}
#endif
    } else {
	if (state == TRUE) {
	    gradio_write_card (gr_stat.port, 0);
	    gradio_write_card (gr_stat.port, 0);
	    gr_stat.muted = TRUE;
	} else {
	    gradio_write_card (gr_stat.port, 0);
	    gradio_write_card (gr_stat.port, 0xc8);
	    gr_stat.muted = FALSE;
	}
    }
}
