
/* Extended Module Player - drivers/oss_mix.c
 * Copyright (C) 1997 Claudio Matsuoka and Hipolito Carraro Jr
 *
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See docs/COPYING
 * for more information.
 * 
 * Hacked by Isaac Richards to support eMusic.
 */

#include "config.h"

#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "xmpi.h"
#include "driver.h"
#include "mixer.h"

extern char *mixer_buffer;

static void bufdump(void);
static void shutdown(void);
static void flush(void);
static int init(struct drv_config *);
static void setaudio(struct drv_config *);

static void dummy()
{
}


static char *help[] =
{
   NULL
};


struct xmp_drv_info drv_emusic =
{
   "emusic",			/* driver ID */
   "eMusic Audio",		/* driver description */
   help,			/* help */
   init,			/* init */
   shutdown,			/* shutdown */
   smix_numvoices,		/* numvoices */
   smix_voicepos,		/* voicepos */
   smix_echoback,		/* echoback */
   smix_setpatch,		/* setpatch */
   smix_setvol,			/* setvol */
   smix_setnote,		/* setnote */
   smix_setpan,			/* setpan */
   smix_setbend,		/* setbend */
   dummy,			/* starttimer */
   flush,			/* stoptimer */
   dummy,			/* reset */
   bufdump,			/* bufdump */
   dummy,			/* bufwipe */
   dummy,			/* clearmem */
   dummy,			/* sync */
   smix_writepatch,		/* writepatch */
   smix_getmsg,			/* getmsg */
   NULL
};

static int do_sync = 1;

static void setaudio(struct drv_config *cfg)
{
   int sig = 0, big = 0, six = 0;

   if (cfg->fmt & MIX_16BIT)
      six = 1;
   if (cfg->fmt & MIX_SIGNED)
      sig = 1;
   if (cfg->fmt & MIX_BIGENDIAN)
      big = 1;
   setup_audio(cfg->rate, cfg->mode - 1, sig, big, six);
}


static int init(struct drv_config *cfg)
{
   if (cfg->nbuf < 2)
      cfg->nbuf = 2;
   cfg->fmt &= 0xffff;
   setaudio(cfg);
   smix_init(cfg);
   return 1;
}


/* Build and write one tick (one PAL frame or 1/50 s in standard vblank
 * timed mods) of audio data to the output device.
 */
static void bufdump()
{
   int i;

   for (i = smix_mixer(); i -= audio_play(mixer_buffer, i););
}


static void shutdown()
{
   smix_close();
   /*   close_audio(); */
}


static void flush()
{
   if (!do_sync)
      return;
/*    flush_audio(); */
}
